**Tarnhelm’s Tome of Wonder**

**SRD**

Version 1.01 SRD Version

Copyright © 2021 Randall S Stukey

All art is CC0 or in the public domain unless otherwise noted.

Some art is from Pixabay, from Wikimedia Commons, and from Comicbookplus.com.

Copy Shops: The author and publisher grants permission for the owner of this
file to print copies for their personal use.

*Tarnhelm’s Tome of Wonder* is a revised and expanded version of *Tarnhelm’s
Terrible Tome* (published 2013)*.*

.
=

<br><br><br><br>Preface
=======================

I started playing tabletop RPGs in 1975 when I picked up a new game in with
three small digest-sized booklets in a brown box and the game’s first supplement
at my favorite hobby shop. The game looked fascinating: you played a single
character in a fantasy land. I immediately started designing my own world and
dungeon so I could run a game for my friends to see if it was as much fun as it
looked to be.

As I was setting things up, I noticed lots of places where the guidelines either
were not clear and places where I thought of things that needed to be added or
things I thought should be done differently. Like I did for any other game I
might referee, I started writing these clarifications and ideas down in a
loose-leaf notebook.

I have been expanding and rewriting the “rules” for this and many other
roleplaying games ever since. After all, the rules need to fit the campaign I am
running, the players in my campaign, and my own sensibilities. I certainly do
not believe in forcing my vision of the campaign setting to fit the rules as
written nor do I believe in forcing players to play in a way neither they nor I
find fun just because I paid money for a rulebook.

For example, my main fantasy campaign world – the one I started working on in
1975—has all sorts of things that those original rules did not cover: ancient
technology, characters who suffered mutations from exploring still radioactive
sites with that ancient technology, characters going through gates into other
worlds (WWII, Mars, various comic book universes, etc.) and sometimes bringing
people from those worlds back to the campaign world, alien visitations, etc. To
fill in the blanks, I would make my own rules or adapt those from other early
RPGs – as needed. As new fantasy games were published, we did not stop the
campaign and start over with the rules of the new game, we just added what we
liked from the new game to our campaign. Some might call the result a
Frankenstein monster, but it worked well for us back then and still does today.
When I run an Original Edition campaign, we still use many of these rules. While
they have been modified, rewritten, and in some cases replaced with something
better (or even just less copyright violating) over the years, their origins are
still recognizable to people who playing in my campaign back in the 1970s.

In 2014, I wrote an Original Edition supplement – *Tarnhelm’s Terrible Tome* –
with some of the rules mods I use. Unfortunately, instead of just giving the
rules as options, I tried present them like they were a complete system to
substitute in. This was a silly idea, but I was trying to follow the pattern of
the supplements to the Original Edition.

Seven years later, I’m trying again with this volume – *Tarnhelm’s Tome of
Wonder: An Original Edition Toolkit*. This new version doesn’t try to provide a
unified revision of the major systems, but a toolkit full of options that can be
added to Original Edition games by their Referees to create their own version of
the Original Edition that suits the needs of their campaign and players without
having to homebrew them all by themselves.

This tome is full of options – some of them mutually exclusive as they provide
different ways of doing basically the same thing -- for the Referee to select
from to use as written or as a starting point for homebrewed material that
better fits their needs.

Section I provides many optional rules and systems for character creation,
classes, combat, magic, psionics, and more. Section II covers the “endgame”
where PCs run their own domains and provides two systems: one simple and one
more complex. Rules for mass combat are here as well. Section III has more
monsters (mythos monsters and human cultists) and guidelines for NPC adventuring
groups. Section IV provides new treasures, including some designed for use with
some of the optional rules in Section I. Section V talks about “hazards” for
both dungeons and wilderness areas. Section VI provides two different system for
mutations – one simple, one complex – although mainly intended for Referees to
mutate monsters, these rules can work for mutated player characters. Section VII
gives a selection of comic book style superpowers designed to work with the
Original Edition. While brief, experimental rules for superpowered PCs are
included this section is really for the Referee to model comic book superheroes
should the PCs ever encounter any. Section VII gives some simple rules for
firearms of different eras. Finally, Section IX provides random tables for the
Referee.

Referees should remember to be selective in what they use from this book. Adding
rules from *Tarnhelm’s Tome of Wonder* (or any other source) to a campaign
willy-nilly is more likely to result in disaster than it is likely to result in
a wonderful experience at the table. Most of the author’s campaigns only add a
handful of these options rules, with the composition of that handful carefully
selected to meet the needs of the specific campaign.

Randall Stukey  
March 2021

<br><br><br>Section I:<br>Optional Rules
========================================

Introduction
------------

Original Edition rules are easy for the referee to modify to fit the needs of
their campaign or the needs of their group of players. This section lists a
number of optional rules and replacement systems that the editor has used (or
has seen used successfully) in various 0e campaigns over the years. These
optional rules can be ignored completely or used/modified by the referee as need
for their campaign. If nothing else, they show a few of the myriad ways that
these rules may be modified.

Referees thinking of using some of these optional rules should think carefully
about the effect they will have on their campaign before introducing the rule
just as they would any rules, they “homebrew”. Remember that the fact that an
optional rule worked in one of the editor’s campaigns, does not mean it will
work well in your current campaign. Finally, the editor does not advise using
all of these optional rules in a single campaign. While some would fit well in
to just about any campaign, others will only fit well into specific types of
campaigns. Some of these optional rules cover the same “subject” and would make
little sense used together.

Experience Modifier
-------------------

Several Optional Rules make use of an Experience Modifier as a method of
modifying character advancement (or help balance more powerful abilities
introduced in some optional rules). Using this “Experience Modifier System” is
easy. Add up the Experience Modifiers – if any – from the optional rules that
apply to the character. Add this total to 100%. When a character is given his
experience points for a session of play, the character’s total Experience
Modifier is applied to those assigned experience give the total experience
points actually earned by the character.

Examples: The following optional rules with experience modifiers are being used
in a campaign: Advantages and Disadvantages, Variant Classes, and Psionics.

Elena’s character is a Fighter with the Low Self-Esteem disadvantage (a +5%
Experience Modifier). This character has a total Experience Modifier of 105%
(100% plus the +5% Experience Modifier). If this character is assigned 500 XP by
the Referee at the end of a session, Elena adds 525 XP (105% of 500) to her
character’s total XP.

Jack’s character is a Cavalier (-10% Experience Modifier) with the Danger Sense
advantage (-10% Experience Modifier) and the Unlucky disadvantage (+15%
Experience Modifier) who – in a rare bit of luck – is psionic and has the
potential to manifest 6 psionic abilities (-18% Experience Modifier). The
character’s total Experience modifier is 77% (100% -10% -10% +15% -18% = 77%).
If this character is assigned 500 XP by the Referee at the end of a session,
Jack adds 385 XP (77% of 500) to his character’s total XP.

Optional Character Creation Rules
---------------------------------

### Advantages and Disadvantages

Many players like to have characters that are mechanically different from other
characters of their class. Backgrounds help provide this, but some campaigns may
need more. Characters in such campaigns may be created with advantages and
disadvantages that adjust the character’s Experience Base. All advantages and
disadvantages selected for a specific character must be approved by the Referee
as suitable the campaign, the style of play, and the specific character. Things
that any character should be able to try to do with at least some chance of
success should never be allowed as advantages. The following are example
advantages and disadvantages that may be used. These are only examples., The
Referee should remove the ones listed that do not fit the campaign or style of
play and/or add new ones tailored to the campaign.

#### Sample Advantages

The following special abilities increase a character’s abilities and powers at
the cost of decreasing the number of experience points a character receives from
a session of play.

*Alchemy:* Alchemists can create potions with the effect of Magic-User spells.
With access to water, ingredients (50 gp per use per Spell Level), an alchemical
recipe for the potion, and a successful roll of 1d20 + INT Bonus vs. a Target
Number of 10 + (2 x Spell Level), an Alchemist can create potions for spells of
a Spell Level up to 1/4 the Alchemist's Level (round up). Potions take 60
minutes per spell level to brew. These potions can be used up to 24 hours after
their creation; creating a potion with no expiration adds (1 x Spell Level) to
the TN. Each potion after the first created in a day adds +2 to the TN. An
Alchemist with access to a scroll with a magic user spell may create an
alchemical recipe from the scroll with one month of work per level of the spell.
Experience Modifier of -25%.

*Ambidextrous:* Characters are normally considered to be right or left-handed.
Ambidextrous characters can use both hands equally well, even at the same time.
Experience Modifier of -5%.

*Danger Sense:* The character has a sixth sense for danger. For an Experience
Modifier of -10%, he can never be surprised.

*Direction Sense:* For an Experience Modifier of -5%, a character always knows
which direction is which (e.g., which way is north). For an Experience Modifier
of -10%, a character not only always knows which direction is which but can
always retrace his path (e.g., return the way he came in in a maze).

*Former Magic-User Apprentice:* The character began training as a Magic-User but
did not complete it. The character has the Magic-User special abilities (Magic
Dart and Minor Magic from the rules later in this section) but at a cost of 1 HP
per use. He can create the needed wand, but doing so takes a full week instead
of a few hours. If the ritual rules are used, the character can cast first and
second level spells as rituals provided he has a readable written copy of the
spell ritual. Experience Base modifier of -25%.

*Herbalism:* Herbalists are familiar with the magical methods of selecting and
preparing herbal elixirs, poultices, etc. with the effects of Clerical healing
spells (effect level is listed in parenthesis): Cure Light Wounds (1), Remove
Disease (2), Cure Serious Wounds (3), Cure Critical Wounds (4), and Neutralize
Poison (5). Successful creation requires access to water, ingredients (50 gp per
use per effect level), and a successful roll of 1d20 + WIS bonus vs. a Target
Number of 10 + (2 x Effect Level). Effects equal to 1/2 the herbalist’s level
(round up) can be created. Herbal creations may be used up to 24 hours after
creation. Herbal creations affecting disease or poison must be created for a
specific disease or poison. Experience Rank modifier of -15%.

*Photographic Memory:* For an Experience Modifier of -5%, a character may
remember details most would forget on a successful INT roll. For an Experience
Rank modifier of -15%, a character can remember everything with true
photographic detail on a successful INT roll.

#### Sample Disadvantages

The following major hindrances to a character increase the number of experience
points a character earns from a session of play.

*Frail:* Character is unhealthy and weak of frame, subtracting 1 from the number
of hit points gained at each level (minimum gain 0). Experience modifier of +5%.

*Hunted by Enemies:* The character is hunted by some powerful person or group
who want to do them ill. The Experience Modifier is the total of the modifier
for the hunter’s power and how often the enemy has a hand in the character’s
adventures. Power: slightly more powerful than character +0%; much more powerful
+2%; extremely powerful +4%. Frequency: 20% of game sessions +1%; 40% of game
sessions +5%; 60% of game sessions +10%.

*Low Self-Esteem:* Character has little self-confidence or self-worth, taking a
-3 penalty on ability rolls or saving throws (-1 penalty on D6 skill rolls)
where this would be a factor. Experience modifier of +5%.

*Meager Fortitude:* Character is sickly and weak of stomach, taking a -3 penalty
on ability rolls or saving throws (-1 penalty on D6 skill rolls) where this
would be a factor. Experience Modifier of +5%.

*Noncombatant:* Character is relatively inept at melee combat; take a -2 penalty
on all melee attack rolls. Experience Modifier of +5%.

*Phobia:* The character has a fear so strong it can overwhelm him. Mild phobias
can be temporarily overcome with a WIS roll. Severe phobias cannot be overcome.
The Experience Modifier is determined by how common the object of the fear is
and the severity. Type of fear: Rare object/situation: +1%; Uncommon
object/situation: +5%; Common object/situation: +10%. Severity of Fear: Mild
Fear: 1x; Severe fear: 2x.

*Poor Reflexes:* Character zigs when he should zag, taking a -3 penalty on
ability rolls or saving throws (-1 penalty on D6 skill rolls) where this would
be a factor. Experience Modifier of +5%.

*Shaky:* Character is relatively poor at ranged combat, taking a -2 penalty on
all ranged attack rolls. Experience Modifier of +5%.

*Unlucky:* Your character just has bad luck, usually at the worst possible time.
The Referee will arbitrarily make something go wrong for the character each game
session. This bad luck cannot kill the character outright, but just about
anything else goes. Experience Rank modifier of +15.

*Unreactive:* Character is slow to react to danger, taking a -4 penalty on
initiative checks and increasing the character’s change of being surprised by 1.
Experience Modifier of +5%.

*Vow:* Your character has sworn an oath to do or not do something. The
Experience Rank modifier is based on the amount of inconvenience the Referee
thinks it will cause the character during an average game session. Characters
who break their vow during a session receive no XP for the session. Minor
inconvenience: +5%; Major inconvenience: +10%; Great inconvenience: +15%.

*Vulnerable:* Character is not good at defending himself, taking a -1 penalty to
Armor Class. Experience modifier of +5%.

*Weak Will*: Character is highly suggestible and easily duped; taking a -3
penalty on ability rolls or saving throws (-1 penalty on D6 skill rolls) where
this would be a factor. Experience Modifier of -5%.

*Notes for the Referee:* Referees should think carefully before allowing
Advantages and Disadvantages into their game. While they can be a great way to
create a special character, they can be a pain in play. This is especially true
for disadvantages like “Hunted by Enemies” that actually create more work for
the Referee. If you decide to allow them, you need to carefully look over
characters that use them to be sure that those taken make sense for the player’s
character concept and aren’t just being used to min-max the character.

### Allegiance

A character may have up to three allegiances, listed in order from most
important to least important. These allegiances are indications of what the
character values in life, and may encompass people, organizations, or ideals. A
character may have no allegiances (being either a free spirit or a lone wolf) or
may change allegiances as he or she goes through life. Also, just because the
character fits into a certain category of people doesn't mean the character has
to have that category as an allegiance.

If the character acts in a way that is detrimental to his or her allegiance, the
Referee may choose to strip the character of that allegiance (and all its
benefits) and assign an allegiance more suitable to those actions.

**Pledging Allegiance:** A character's allegiance can take the form of loyalty
to a person, to an organization, to a belief system, to a nation, or to an
ethical or moral philosophy. In general, a character can discard an allegiance
at any time, but may only gain a new allegiance after attaining a new level.

Having an allegiance implies having sufficient intelligence and wisdom to make a
moral or ethical choice. As a result, a character must have Intelligence and
Wisdom scores of 3 or higher in order to select allegiances.

Allegiances include, but are not limited to, the following examples.

*Person or Group:* This includes a leader or superior, a family, a group of
linked individuals (such as a band of adventurers or a cell of secret agents),
or a discrete unit within a larger organization (such as members of the
character's squad or platoon, or individuals whose safety the character is
responsible for).

*Organization:* This may be a company or corporation, a gathering of like-minded
individuals, a fraternal brotherhood, a secret society, a branch of the armed
forces, a local, state, or national government, a university, an employer, or an
otherwise established authority.

*Nation:* This may or may not be the nation that the character currently resides
in. It may be where the individual was born, or where the character resides
after emigrating to a new home.

*Belief System:* This is usually a particular faith or religion, but can also be
a specific philosophy or school of thought. Belief systems could also include
political beliefs or philosophical outlooks.

*Ethical Philosophy:* This describes how one feels about order, as represented
by law and chaos. An individual with a lawful outlook tends to tell the truth,
keep his or her word, respect authority, and honor tradition, and he or she
expects others to do likewise. An individual with a chaotic outlook tends to
follow his or her instincts and whims, favor new ideas and experiences, and
behave in a subjective and open manner in dealings with others.

*Moral Philosophy:* This describes one's attitude toward others, as represented
by good and evil. An individual with a good allegiance tends to protect innocent
life. This belief implies altruism, respect for life, and a concern for the
dignity of other creatures. An evil allegiance shows a willingness to hurt,
oppress, and kill others, and to debase or destroy innocent life.

**Allegiances and Influence:** An allegiance can create an empathic bond with
others of the same allegiance. With the Referee's permission, the character
gains a +2 circumstance bonus on Charisma-based skill checks when dealing with
someone of the same allegiance-as long as the character has had some interaction
with the other character to discover the connections and bring the bonus into
play.

*Referee Notes:* Allegiance is an expansion/enhancement of Alignment. If you
choose to use this optional rule in your campaign, characters who do not take an
Ethical Philosophy should be considered Neutral for purposes of standard
Alignment (spell effects, magic items, etc.). This optional rule is somewhat
more complex than the standard alignment rules but may enhance the
verisimilitude many campaign worlds.

### Alternative Advancement System

Characters gain levels by completing adventures. After completing a total number
of adventures as shown on the chart below, the character progresses to the
appropriate level. Characters who have no modifications under optional rules
with Experience Modifiers have a total Experience Modifier of 100% and use the
96%-105% column.

Example: Elena’s Fighter and Jack’s Cavalier have completed 4 adventures and are
currently both 2nd level.

Elena’s character is a Fighter with the Low Self-Esteem disadvantage (a +5%
Experience Modifier). This character has a total Experience Modifier of 105%
(100% plus the +5% Experience Modifier). Elena’s character needs to complete one
more adventure to reach 3rd level.

Jack’s character is a Cavalier (-10% Experience Modifier) with the Danger Sense
advantage (-10% Experience Modifier) and the Unlucky disadvantage (+15%
Experience Modifier) who – in a rare bit of luck – is psionic and has the
potential to manifest 6 psionic abilities (-18% Experience Modifier). The
character’s total Experience modifier is 77% (100% -10% -10% +15% -18% = 77%).
Jack’s character needs to complete three more adventures to reach 3rd level.

**Alternative Advancement**

|           | Total Adventures by Total Experience Modifier |               |              |                 |                 |                 |                 |                 |
|-----------|-----------------------------------------------|---------------|--------------|-----------------|-----------------|-----------------|-----------------|-----------------|
|           |                                               | **106%-115%** | **96%-105%** | **86%-**        | **76%-**        | **66%-**        | **56%-**        | **45%-**        |
| **Level** | **116%+**                                     |               |              | **95%**         | **85%**         | **75%**         | **65%**         | **55%**         |
| 1         | 0                                             | 0             | 0            | 0               | 0               | 0               | 0               | 0               |
| 2         | 1                                             | 2             | 2            | 2               | 3               | 3               | 4               | 4               |
| 3         | 3                                             | 4             | 5            | 6               | 7               | 8               | 9               | 10              |
| 4         | 7                                             | 8             | 9            | 10              | 12              | 13              | 15              | 16              |
| 5         | 11                                            | 13            | 14           | 16              | 18              | 20              | 22              | 24              |
| 6         | 16                                            | 19            | 20           | 22              | 25              | 27              | 30              | 32              |
| 7         | 21                                            | 25            | 27           | 30              | 33              | 36              | 39              | 42              |
| 8         | 27                                            | 34            | 35           | 39              | 42              | 47              | 50              | 54              |
| 9         | 34                                            | 41            | 44           | 48              | 53              | 59              | 64              | 69              |
| 10        | 42                                            | 50            | 54           | 59              | 65              | 72              | 78              | 84              |
| 11        | 51                                            | 60            | 65           | 71              | 78              | 86              | 94              | 101             |
| 12        | 60                                            | 72            | 77           | 85              | 93              | 102             | 111             | 120             |

*Notes for the Referee:* This alternate advancement system does away with most
of the bookkeeping and the calculation associated with using experience points.
Some people find tracking XP tedious and/or error-prone. However, this alternate
system also prevents “windfall advancement” if a party is lucky enough to
somehow acquire a very large number of experience points in one session –
whether this is good or bad is infinitely debatable. There is one case where
this alternate system is definitely a great choice – a campaign that does not
revolve around treasure finding.

### Attributes

Instead of rolling 3d6 and assigning the result to an attribute in order, one of
the following methods may be used.

**Roll 3d6 and Assign**: Roll 3d6 and the player may assign the result to an
attribute of their choice.

**Roll 3d6 Six Times and Assign:** Roll 3d6 six times recording each result. The
player may then assign each result to an attribute of their choice.

**Roll 4d6 in Order:** Roll 4d6 then drop the lowest die, totaling the remaining
3 dice, assign the result to the next attribute in order.

**Roll 4d6 and Assign:** Roll 4d6 then drop the lowest die, totaling the
remaining 3 dice. The player may assign the result to an attribute of their
choice.

**Roll 4d6 Six Times and Assign:** Roll 4d6 then drop the lowest die, totaling
the remaining 3 dice. Do this six times recording each result. The player may
assign each result to an attribute of their choice.

**Roll 2d6+6 In Order:** Roll 2d6, Total the 2 dice and add 6 to the result,
then assign the result to the next attribute in order.

**Roll 2d6+6 and Assign:** Roll 2d6, Total the 2 dice and add 6 to the result.
The player may assign the result to an attribute of their choice.

**Roll 2d6+6 Six Times and Assign:** Roll 2d6, Total the 2 dice and add 6 to the
result. Do this six times recording each result. The player may assign each
result to an attribute of their choice.

**Point Buy (Average):** Characters have 63 attribute points. Assign these
points to the character’s attributes with a minimum of 3 and a maximum of 18 in
each stat.

**Point Buy (Heroic):** Characters have 75 attribute points. Assign these points
to the character’s stats with a minimum of 3 and a maximum of 18 in each stat.

*Notes for the Referee:* These optional methods of determining character
attributes tend to produce characters with higher than average attributes and/or
more “optimized” attributes. Consider the effects on your campaign carefully
before replacing the standard stat roll method with one of these. Remember also
that high and low stats have less effect on the character’s abilities in
*Delving Deeper Brown Box* than they do in many games.

### Background and Talents

Unlike many modern games, the Original Edition does not include character
skills. Instead, players are expected to think like adventurers, tell the
referee what their characters are doing and the Referee decides if it will
succeed in the situation, taking into account the characters’ classes and
backgrounds. If the referee decides a random success chance is truly needed,
they may resolve the situation with a roll of their choice. The two most common
methods of rolling for success are:

-   **Roll under a Referee-Selected Attribute:** The referee asks the player to
    roll a D20 against one of the character’s attributes, perhaps with a referee
    assigned modifier to the die roll. If the die (adjusted) die roll is under
    the character’s attribute, the action succeeds. A natural roll of 20- always
    fails. Otherwise, it fails. This system makes having good attribute scores
    much more important than the designers of the original game probably
    intended.

-   **Roll 6+ on a D6**: As the rules already give a 1-in-6 or a 2-in-6 chance
    of doing things like detecting secret doors, it is easy to just use this
    system whenever a random change of success is needed. While the Referee can
    add modifiers to the die roll according to circumstances, a natural roll of
    1 always fails.

For those referees who really want a skill system, it is fairly easy to add a
simple skill-like system on top of either of these methods of rolling for
randomly determining success or failure.

#### Background

Characters should select, with the approval of the Referee, a background that
represents their race, culture, and their previous (non-adventuring)
training/experience. The selection of a character’s background is as important
as the selection of a class as a character’s background gives the character a
broad base of skills and knowledge. Note that a background is a few words, not
an essay detailing the character’s history.

The Referee will consider the character's background just as he would the
character's class when deciding if a character will succeed with an action. For
example, a character with an “Human (Holy Panamon Imperium) Engineer” background
should have a much better chance of damming a creek or building a bridge over it
than a character with a “Courtier” background – and an even better chance if
that creek is in the territory of the Holy Panamon Imperium where the character
knows more about the terrain and likely has contacts who could help. Having an
appropriate Background is generally worth a modifier if Referee decides a
success roll is required.

Races and cultures are generally limited to those the Referee has defined for
the campaign.

For the prior training/experience part of a character’s background, anything
that fits the campaign setting may be selected. For example: A few possibilities
include: acrobat, alchemist, animal trainer, architect, aristocratic noble,
assassin, chef, con-woman, desert nomad, goblin exterminator, hunted outlaw,
knight errant, priest, refugee, scout, shaman, shepherd, soldier, spy, temple
acolyte, thief, torturer, traveling martial arts pupil, tribal healer, tunnel
scout, wandering minstrel, poet, and so on. This part of a character’s
background need not be related to the PCs class, e.g. a player who creates a
deeply religious fighter skilled in the arts of vision interpretation,
divination and oration might pick 'Prophet' as a background. Backgrounds may not
duplicate a class.

Players should discuss their background ideas with their Referee to both to be
sure it will be a good fit for both the campaign setting and the group’s play
style as well as to be sure the player and the Referee are both on the same
general page as to what skills and knowledge the background provides the
character. For example, if a player picked a “knight” background, the Referee
might be thinking “knight of the round table” while the player is thinking
“knight templar.”

#### Talents

At level 2 (and every 2 levels thereafter), characters may select one narrow
area of skill where they are better than average: something they are “Good at.”
This talent should be either something directly related to their class or
background -- or something they have spent game time and/or money learning. If
the player wishes (and the Referee approves), instead of selecting a new talent,
a talent the character is already “Good at” be improved to “Expert at” at a
later even-numbered level and a talent the character is “Expert at” may be
improved a final time to “Master at” at yet a later even-numbered level. The
Referee will consider the character's talents just as he would the character's
class and background when deciding if a character will succeed with an action.

If the Referee calls for a roll to determine the success of an action, having an
appropriate talent with allow a modifier to the die roll that increases the
character’s change of success.

-   **Roll under a Referee-Selected Attribute System:** An appropriate “Good at”
    subtracts 2 from the die roll, an “Expert at” subtracts 4 from the die roll,
    and a “Master at” subtracts 6.

-   **Roll 6+ on a d6 System:** An appropriate “Good at” adds +1, to the die
    roll, an “Expert at” adds +2 to the die roll, an a “Master at” adds +3 to
    the die roll.

**Option:** The Referee may allow new characters to start the game with one to
three talents strongly related to their background at the “Good at” level.

*Notes for the Referee:* Many players used to more “new school” styles of play
want rules-based, mechanical ways to customize their characters. Talents provide
a way to do this that does not add much complexity nor restrict characters from
trying to do things anyone should be able to try because they failed to select
some special mechanical customization feat or skill. Even if you do not desire
to use skills in your game, having players select a background for their
character can be helpful in defining the character both to the player and the
referee. As referee, you should consider the character’s background just like
you do the character’s class when determining when something the character does
succeeds, fails, or should be determined by a random roll.

### Class Special Abilities

#### Cleric Special Abilities

All Clerics have the following special abilities. The cleric must have a holy
symbol of his religion in hand to use these abilities.

*Minor Divination* - A cleric may spend 10 minutes in prayer asking his deity
whether or not a specific action would have generally good or generally bad
results *from the deity’s point of view*. The cleric will have vague feeling of
rightness or wrongness. A cleric may do this at most 1 per day (+1 additional
time per day every 5 levels).

*Minor Healing Prayers* - Immediately after combat, a cleric may touch the
wounds and pray over a being injured in that combat. This costs the cleric 1 HP
and will restore 1d3-1 hit points. This may only be done once per being per
combat and takes one minute per being.

*Smite* - A cleric may imbue his normal weapon with holy power allowing it to
hit monsters that normally require silver or even magical weapons to hit.
Spending 1 HP before making the attack roll will allow hitting monsters that
require silver (or other special non-magical) weapons to hit. Spending 2HP
before making the attack roll will allow hitting monsters that require magical
weapons to hit.

*Notes for the Referee:* While the Cleric has a good mix of combat and magical
abilities, these special abilities add some nice minor powers. The Smite ability
is particularly useful as it means that no party with a cleric will ever be
caught fighting a creature they cannot possibly hit due to lack of special
weapon types.

#### Fighter Special Abilities

Fighters may select one special ability from this list at levels 3 and at level
6. (Optional: for high powered campaigns, allow fighters to select one ability
at levels 3, 6, 9, 12, etc.) Each fighter special ability may only be selected
once.

*Accuracy* - A fighter with this special ability rolls a 1d6+2 for damage
(instead of 1d6) with thrown or missile weapons.

*Berserker Rage* – A fighter with this special ability may go into a berserker
rage when in combat. During a berserker rage, the always fighter attacks the
nearest foe (determine randomly if multiple foes in range). His ferocity doubles
his fighter bonus to his attack roll and his damage. To break off combat (before
all foes are dead) the berserk fighter must make a save versus death (-1 for
every opponent still standing) in order to break off from fighting. Each round
the fighter is berserker costs him 2 hp, subtracted immediately after the
berserker rage ends. A berserk fighter cannot use any combat stunts nor the Find
Weakness, Leadership, or Tactical Expertise fighter special abilities.

*Brutal Attack* – A fighter with this special ability rolls a 1d6+2 for damage
(instead of 1d6) with melee weapons.

*Cleave* - After a fighter with this special ability kills an opponent, he may
immediately make another attack against any still-standing foe. The maximum
number of attacks he can make in one round is equal to his level.

*Dodging* - When not wearing armor, a fighter with this special ability may add
1/2 his level plus 1 for every point of dexterity above 15 to his AC.

*Find Weakness* - When attacking an unaware opponent, a fighter with this
special ability may ignore any AC bonus the opponent has due to armor worn (that
is, treat the opponent as AC 9 [10]). He is hitting at his opponent’s weak,
exposed areas.

*Leadership* - A fighter with his special ability has a number of Leadership
Points per day equal to his level plus one for every charisma point above 13.
These leadership points are like bonus HP for the whole party - useable at the
fighter’s discretion. For example - James the Mage has 2 HP left and takes 12
damage, which would knock him unconscious and reduce his STR by 10. John the
fighter has 15 leadership points, so he lets his leadership absorb the blow
rather than let James suffer a major injury. The fighter has only 3 leadership
points left, but the James still has 2 HP and is still standing.

*Tactical Expertise* – A fighter with this special ability has a number of
Tactics Points per day equal to his level plus one for every point of
intelligence above 13. These points are spent directly before the attack roll of
anyone in the fighter’s party, giving a +1 per point spent. Tactics Points can
also be spent before any enemy’s attack roll, giving a -1 per point spent.

*Unarmed Combat* - A fighter with this special ability does 1d6 damage with his
bare hands (instead of the standard 1d2 bare handed damage).

*Notes for the Referee:* Some people feel that the Fighter class is too weak at
higher levels compared to the Magic-User and Cleric. These special abilities
allow limited mechanical customization of Fighters without greatly increasing
their power or making the game more complex to play or Referee. Nevertheless,
they do increase the power of the Fighter so the Referee needs to carefully
consider the needs of her players and her campaign before deciding to use these
supplemental rules, especially if the option allowing fighters to select one
special ability every three levels is used.

#### Magic-User Special Abilities

All Magic-Users have the following special abilities. All require the use of a
special wand hand-made by the magic-user.

*Create Handmade Wand* - A Magic-User knows how to create the handmade wand
required for Magic-User special abilities. The wand must be made by the
Magic-User using it to function. Creating the wand requires a knife, a living
tree to cut the wand from, and 12 minus the Magic-User's level hours (minimum of
1 hour) of uninterrupted time.

*Magic Dart* - A Magic-User can shoot a 1d6-1 dart of magic energy from the tip
of their handmade wand once per round provided no other action is taken. They
must roll to hit the target normally. Range: short 60; medium 120; long 180.
Usable once per round if no other action taken. No saving throw is allowed.
Requires pointing a handmade wand at the target and saying a command word. The
visible effects (type of dart: metal, fire, ice, lightning, etc.) can be
whatever the Magic-User desires; note that these visual effects not affect
damage, they only add color to the ability.

*Minor Magic* - Magic-Users can cast minor "everyday/non-combat" magic at will.
Attempting something the Referee considers abusive fails and causes the
magic-users wand to explode (doing 1d6 backfire damage to the magic-user unless
a WIL save is made). Usable once per round if no other action taken. Requires
waving a handmade wand is a pattern and saying a command word or phrase.

Some examples: Light a candle or pipe with a flame from the fingertip. Dust
things – at first level a minor magic spell might be needed for each shelf or
piece of furniture, while at third level a single spell might dust a room and at
sixth level might dust the entire floor of a house or tower. Tie or untie a
knot. Float coins from the magic-users coin purse to a merchant's hand.

*Notes for the Referee:* Some people feel that the Magic-User class is too weak
and uninteresting to play at lower levels. These special abilities add some
magical flavor to the Magic-User without really increasing the power of the
class. The Magic Dart ability is no worse than letting a magic-user use a sling
(a fairly common house rule), but it has a more magical feel. Minor Magic lets a
Magic-User use magic for minor mundane tasks which is fun but generally has no
effect on the game except, perhaps, to impress peasants and the like. Note the
1d6-1 damage a magic dart can be either 1 to 5 points or 0 to 5 points at the
Referee’s option.

### Goals and Personality Traits

The alignment system is a simple way to handle character “personalities” at a
very simple level. While alignment is suitable for many types of campaigns, a
more flexible system is needed for others. If this system is used, the Referee
will “enforce” it with Experience Point bonuses for using the character’s goals
and traits in play.

Character Goals: In order to individual characters, each player must select four
goals from the list below and arrange them in order of importance to the
character from first to fourth. Goals not on the list may be selected with prior
Referee approval. The Referee may award bonus XP for goal achievements during a
session. Characters can also earn points by helping their friends (fellow PCS
and associated NPCS) achieve their goals, so long as their friends goals do not
clash with their own goals. Players may change a goal or change the order of
their goals during a campaign with Referee approval.

Suggested Goals: (The player must select a particular aspect to stress for those
marked with an asterisk)

| Furtherance of Scholarly Studies\* | History, linguistics, literature, etc.                                               |
|------------------------------------|--------------------------------------------------------------------------------------|
| Furtherance of Art\*               | Music, architecture, crafts, etc.                                                    |
| Furtherance of Science\*           | Astrology, engineering, etc.                                                         |
| Wealth                             | Accumulation of treasure or other wealth                                             |
| Earthly Pleasures                  | Wine, women/men, drugs, etc.                                                         |
| Romance                            | True love                                                                            |
| Power over Others                  | Political, religious, in criminal underworld, etc.                                   |
| Fame                               | Personal renown far and wide                                                         |
| Rank\*                             | On social scale or in institution like religion or military                          |
| Preservation of the Status Quo     | Prevention of change (in government, religion, social system, etc.)                  |
| Preservation of Nature             |                                                                                      |
| Preservation of Order              | Prevention of breakdown of law and order                                             |
| Comradeship                        | Establishment and maintenance of friendships                                         |
| Risk Tasking                       | Taking physical. financial, or spiritual risks                                       |
| Commercial Business                | Setting up and running profitable businesses                                         |
| Collecting\*                       | Jewelry, antiques, weapons. Etc. (for pleasure of ownership, not for actual use)     |
| Religious Service                  | Serving religions and Gods                                                           |
| Battle Glory                       | Winning renown in battle                                                             |
| Image Cultivation                  | Adopting a distinctive appearance and style to impress others                        |
| Freedom                            | Preservation of individual freedoms                                                  |
| Chivalry                           | Mercy, fairness, compassion                                                          |
| Honor                              | Duty to liege, family, friends, or own dignity                                       |
| Mystic Power                       | Finding spells, magic items, etc. for own use                                        |
| Patriotism                         | Acting in country’s best interest                                                    |
| Discovery                          | Bringing new knowledge to own civilization                                           |
| Experience Wonders                 | Travelling through strange lands, other planes, etc.                                 |
| Intrigue                           | Political/Social secret scheming and plotting                                        |
| Materialism                        | Spending money on displays of wealth: manors, castles, useless expensive items, etc. |
| Welfare of Others                  |                                                                                      |
| Responsibility                     | Desire to carry out duties, take care of charges, etc.                               |
| Expansion of Civilization          | Into new lands, etc.                                                                 |
| Wanton Destruction                 | Desire to destroy things for the pleasure of destroying                              |
| Cruelty                            | Desire to cause pain in others                                                       |
| Persecution of Evil                | “Evil” as defined by your culture or religion                                        |
| Competition                        | Desire to compete for competition’s sake                                             |
| Personal Feats                     | The “do it because it’s there” spirit                                                |
| Creation\*                         | Make magic items, works of art, etc.                                                 |
| Self-Discipline                    | Controlling one’s behavior and emotions                                              |
| Trickery\*                         | Thwarting authority, playing practical jokes, etc.                                   |

**Character Personality Traits:** In order to further individualize characters,
players must select three of the following Personality Traits for their
character. Personality Traits other than those listed may be used with prior
Referee approval. Players should be careful not to select traits that they are
not interested in playing or that strongly conflict with their goals or religion
(unless that is what the player wants). Players should also try to avoid
selecting conflicting Personal Traits for their characters. If such traits are
selected (for example, the first two on the list below), the negative trait
(passion for drink, in this case) is applied to the character while the positive
trait is directed toward the behavior of others – which tends to make the
character a hypocrite.

**Suggested Personality Traits:**

-   True passion for alcoholic beverages

-   Disapproves of drunken ways

-   True passion for gambling

-   Disapproves of gambling

-   Enjoy a good public brawl and will start one given a good reason

-   Disapproves of public brawling

-   True passion for members of the opposite sex

-   Disapproves of lewd and/or flirtatious behavior

-   Braggart who exaggerates his/her deeds

-   Modest about own deeds and disapproves of bragging

-   Gourmet who will not tolerate poor cuisine

-   Glutton who will eat just about anything and think it great

-   Rather crude and rough manners

-   Excellent manners, cannot tolerate bad manners

-   Will lie when it suits his/her needs

-   Truthful character who does not tolerate falsehood

-   Grasping and greedy

-   Miserly and begrudges spending money

-   Spendthrift whose money never lasts long

-   Tends to forgive (or forget) personal insults and injuries

-   Tends not to forgive or forget personal insults and injuries, and always
    tries to get even – sometime

-   Social snob who demands due respect from his/her social inferiors

-   Social egalitarian that places little worth in social class differences when
    a person has shown his/her worth

-   Character will not kill except in self-defense (and only after all else has
    been tried and has failed)

-   Sexist who belittles the abilities of the opposite sex.

-   Mild prejudice against a specific race or class (belittles their abilities)

-   Overconfident of own abilities

-   Little confidence in own abilities

-   Always optimistic

-   Always pessimistic

*Notes for the Referee:* Alignment (especially with the optional vices and
virtues) is enough for many campaigns, but the systems here provide much finer
control over character personality for those who what the fine control
accompanied by mechanical effects that benefit a player who plays in character
and penalize a player who does not.

### Heroic Characters

The Original Edition is designed for “Swords & Sorcery” style zero to hero where
characters start off as average people and grow to powerful characters – if they
can manage to survive. Some Referees may desire to a more high fantasy approach
where characters may still start off as farm boys, but they are special from the
start. While they are virtually unknown in the campaign setting, they have a
natural talent for adventure and special qualities and a destiny that calls them
to be “High Fantasy” heroes.

Heroic Characters possess a Heroic Constitution, Perception, Destiny, Ferocity,
and extra Heroic abilities.

**Heroic Constitution:** Heroic characters start with 12 hit points. When they
roll their hit dice, they add 12 to the result. For example, a first level
fighter who rolls 5 on his 1d6+1 hit dice wound actually have 17 hit points. If
the optional Hit Point and Wound Points rules are in use, Heroic characters have
a minimum of 15 Wound Points and each three points (instead of the standard two)
of Wound damage a Heroic character has suffered gives a -1 to all attack,
success, saving, and similar rolls.

**Heroic Perception:** A group of Heroic characters automatically have the
Initiative in combat unless they have been surprised (in which case the surprise
round does not happen but the ambushers have Initiative for the first combat
round.

**Heroic Destiny:** Each Heroic Character starts with a Referee determined
number of Destiny Points. For purposes of example, we will assume all heroic
characters have 5 points of Destiny. When a Heroic character wound die (for any
reason), the character loses a point of destiny and by some miracle (determined
by the Referee) is not dead. (The character could but grievously injured,
captured, etc., but they survive.)

**Heroic Ferocity:** When fighting enemies of equal or lesser hit dice, the
Heroic character can roll a Ferocity die representing their mighty hewing,
punching, kicking, biting, object-hurling, and other assorted fisticuffs or
short-ranged combat spells delivered toward an enemy that does not clearly
outclass them in skill. This is a separate die that can be rolled once per
round. This die always does damage regardless of the hit roll, so it is best to
use a die of some different color than the others so it can be easily
identified. Fighters roll 1D6+2 for their Ferocity die, clerics, thieves, and
other non-strictly-martial classes roll ld6, and magic-users and similar
sorcerous classes roll ld6-1.

The damage from a Ferocity die can only be inflicted on foes with equal or fewer
hit dice than the hero- more experienced enemies are just too canny to be maimed
without a focused attack. The exception is the Ferocity die of Heroic
Magic-Users. Their eldritch bolts can harm any foe, even one of greater hit
dice.

A hero character who wishes to do something other than make an attack roll in a
round can still roll their Ferocity die against any foes within reach,
representing the murder they might be wreaking incidental to their other
activities.

**Heroic Abilities**: A Heroic Fighter always hits any creature they are
attacking of equal or lower level, assuming that it is possible for them to hit
the creature at all. The effects of the spells of a Heroic Magic-User or a
Heroic Cleric are calculated as if the character were two levels higher than
their actual level. A Heroic Thief performs thieving skills (including backstab)
as if they were three levels higher than their actual level.

*Notes for the Referee*: If your campaign tends more to high fantasy than swords
and sorcery, this optional rule will allow PCs that are more likely to survive
and are more “heroic fantasy caliber” If you use this rule, you will probably
want to have major enemies (dark lords, etc.) created as heroic characters. If
the powers granted by this rule seem too much, you can always remove any that
you wish to create the power level you need for the campaign.

### Psychic Gifts

Characters have a single psychic gift which may manifest at some point in the
character’s character. When a character gains a level (including gaining first
level at character creation), roll a D20, if the result is equal to or less than
the character’s new level, the character’s psychic gift manifests. When the gift
manifests, roll a d20 to determine the gift randomly on the Psychic Gift table
below.

**Using a Psychic Gift:** Whenever a character with a psychic gift attempts to
use their ability they must roll a saving throw. If that saving throw is
successful, the character is able to use their psychic gift. Psychic gifts grant
bonuses or special abilities in specific situations and have a specific duration
which are listed in each individual description. Attempting to activate a
psychic gift is considered an action, whether successful or not, if done during
combat – though it cannot be interrupted. If a character fails in their attempt
to use a psychic talent, they cannot attempt to use it again for twenty four
hours. A character may also not have more than one psychic talent active at any
given time. All saving throws made regarding psychic talents are considered to
be saving throws vs. spells and staffs. This includes activating and resisting
psychic talents, where applicable.

**Psychic Gift Table**

| D20 | Psychic Gift            |
|-----|-------------------------|
| 1   | Accelerate Healing      |
| 2   | Amplify Hearing         |
| 3   | Calm Animal             |
| 4   | Charming Aura           |
| 5   | Danger Sense            |
| 6   | Dark Vision             |
| 7   | Detect Deception        |
| 8   | Direction Sense         |
| 9   | Project Thoughts        |
| 10  | Read Thoughts           |
| 11  | Regulate Metabolism     |
| 12  | Regulate Breathing      |
| 13  | Sense Evil              |
| 14  | Sense Extraplanar Being |
| 15  | Sense Life              |
| 16  | Sharpen Vision          |
| 17  | Stasis                  |
| 18  | Strengthen Resolve      |
| 19  | Unnerve Target          |
| 20  | Roll twice              |

**Accelerate Healing:** The character gains no additional benefit from magical
healing, but instead character's natural healing rate is doubled for the next
twenty-four hours. Duration**:** 24 hours.

**Amplify Hearing:** The character is able to hear even faint noises with
particular clarity. Characters who have a “Hear Noise” or similar ability may
roll twice when using this ability and take the more favorable of the two rolls.
Characters who do not have the “Hear Noise” ability are instead able to hear
faint noises on a 1-3 on 1d6. Duration: 1 Hour.

**Calm Animal:** Whenever the character encounters a natural beast that is
hostile, they may active this ability in an attempt to calm the creature, though
it may only be used to target a single creature. The target must make a saving
throw vs. spells or immediately cease being hostile towards the character. While
not friendly, it regards them with a benign disinterest for the duration of this
psychic talent. Duration: 10 Minutes.

**Charming Aura**: The character is able to project an aura of charm and
amiability if they successfully activate this ability. Once activated, the
character using this ability receives a +2 bonus to all reaction or social rolls
made when interacting with NPCs who speak a shared language and are able to
communicate with the character. This is not a *Charm Person* or magical effect
and if the character is caught acting in an obviously hostile or antagonistic
manner the benefits of this talent immediately end. Duration: 1 Hour.

**Danger Sense:** The character has a kind of sixth sense making them aware of
danger a split second before it strikes. When this ability is active the
character can only be surprised on a 1 on 1d6, regardless of any stealth
measures taken by an opponent. This ability only applies to danger to the
individual character, and not to his allies or those nearby. Duration: 1 Hour.

**Dark Vision:** Once active, the character can see perfectly, even in pitch
darkness. They can, however, still be blinded and suffer the normal penalties
associated with that condition if they are rendered blind. Duration: 1 Hour.

*Detect Deception:* This ability allows the character to sense when an
individual is knowingly deceiving them. Once active, the character has a 1-4 on
1d6 chance of detecting when anyone within 60' of them is attempting to lie to
or deceive them. Duration: 10 Minutes.

**Direction Sense:** The character who successfully activates this talent can
immediately sense which direction is North as well as sense their distance from
the ground, whether above or below it. Duration: Instant.

**Project Thoughts:** A character who successfully activates this ability may
send a brief mental message to the mind of any intelligent creature within 360
feet. They do not need to see the target to use this ability, though they do
need to have a general sense of their location. This message cannot be more than
one sentence and comes into the target's mind as the character's voice speaking
to them. Duration: 1 Round.

**Read Thoughts:** The character is able to read the surface thoughts of a
single target within 60 feet if they successfully use this ability. They must be
able to see the target. If the character and the target do not speak the same
language then the character only gets a vague sense of the target's mental state
and intentions. Duration: 1 Round.

**Regulate Metabolism:** The character is able to regulate their body to such a
degree that while this ability is active they suffer no penalties from lack of
food or water. They also receive a +1 to all saving throws made to resist poison
while Regulate Metabolism is active. Once this ability wears off, the character
immediately suffers all the effects that would be applicable from a lack of food
and water. A character who would die from such things immediately drops dead
when they reach that point, even if this talent is active. Duration: 24 Hours

**Regulate Breathing:** Once activated the character can hold his breath for the
duration of this ability. This means they do not risk drowning, nor can they be
affected by gas, odors, or poisons which must be inhaled to be effective.
Duration: 1 Hour.

**Sense Evil:** When activated the character is able to detect the presence of
any evil characters or items which are enchanted through evil sorcery within 120
feet. They do not know the nature of the evil detected, only that it is present
and mildly unnerving. Duration: Instant.

**Sense Extraplanar Being:** When activated the character is able to detect the
presence of any extraplanar beings within 120 feet. This includes any such
beings which are masquerading in other forms or concealed. They do not know the
nature of these creatures, nor to what plane they are aligned – only that they
are present. Duration: Instant.

**Sense Life:** The character is able to detect the presence of any living
creature within 120 feet. This does not include plant life and only detects
mundane insects when they are present in vast quantities. Duration: Instant.

**Sharpen Vision:** When active, the character is able to see twice as far as
normal. In addition, they receive +1 to all “to hit” rolls with ranged weapons.
Duration: 1 Hour.

**Stasis:** The character enters a deep meditative state when this talent is
activated. To the casual observer they will appear dead in this coma-like
condition. However, while in stasis they do not need food or water to survive,
though as soon as they exit the condition they immediately need to consume a
day's worth of food and water. A character who suffers damage while in stasis is
immediately awakened, though he is not otherwise aware of his surroundings.
Duration: 1 Week.

**Strengthen Resolve:** The character steals his mind against fear and doubt.
Once this talent is active, the character receives a +4 bonus to resist all
mind-influencing spells, such as Confusion or Feeblemind. Duration: 1 Hour.

**Unnerve Target:** By projecting an aura of menace, the character is able to
sow fear and doubt in a single target's mind. The target of this ability suffers
a -1 penalty to all attacks against the character and a -1 penalty to all saving
throws made to resist spells cast by the character as terror gnaws at them from
their subconscious mind. Duration: 5 Rounds.

*Notes for the Referee:* This is a simple way to allow special mental abilities
into the game without having to deal with complex rules for psionics. There are
many ways to modify this. For example, fighters (and other non-spellcasting
classes, if any) might automatically get their gift at first level or only
certain classes might be able to manifest psychic gifts at all.

### Sanity Attribute

If used, Sanity is rolled just as other attributes in the game. Sanity (SAN)
mainly comes into play when faced by intrusions into your mind or particularly
horrible sights or revelations. If the referee requests a SAN check, roll 1d20.
If the result is greater than or equal to your current SAN score, subtract half
the amount by which you failed from your SAN score, rounded up, and roll on the
following table:

**Sanity Loss**

| D6 | Effect of Sanity Loss                                                                                                                               |
|----|-----------------------------------------------------------------------------------------------------------------------------------------------------|
| 1  | Affected as if by a *Fear* spell for (d6 1-2: 1 turn 3: 2 turns 4: 3 turns 5: 1 hour 6: 1d8 rounds)                                                 |
| 2  | Affected as if by a *Confusion* spell for (d6 1-3: 1d10 rounds 4: 1d6 turns 5: 1d6 hours 6: One full day)                                           |
| 3  | Catatonic with despair (cannot attack, speak, or cast spells and must be led around by allies) for (d6 1-2: 1 round 3-4: 1 turn 5: 1 day 6: 1 week) |
| 4  | Afflicted with horrible maniacal laughter making it impossible to attack or cast spells for 1d4 rounds                                              |
| 5  | Faints out of shock for 2d6 rounds                                                                                                                  |
| 6  | Going to be okay, but noticeably shaken up                                                                                                          |

SAN can be restored, although never over the amount a character initially had,
at a rate equal to the character's WIS bonus (minimum of 1) per full week of
rest in a safe, relaxing environment. If a character's SAN ever dips below 3,
they are permanently insane and likely to either become a threat to themselves
or others or retire from the adventuring life altogether to battle their
personal demons.

*Notes for the Referee:* Sanity is generally only included in campaigns which
feature eldritch horrors whose mere existence can warp the mind.

### Virtues and Vices

Players select six traits from the lists below for their character, at least two
virtues and two vices must be selected as no character is perfect. Players can
select virtues and vices not on the list with Referee approval.

Players are expected to role play their virtues and vices when they would come
into play. However, while they should be apparent in the character’s everyday
personality, they need not dominate it to the extent the character becomes a
caricature.

**Virtues and Vices**

| Virtues       | Vices         |
|---------------|---------------|
| Academic      | Arrogant      |
| Austere       | Bigoted       |
| Bold          | Capricious    |
| Cheerful      | Cowardly      |
| Compassionate | Egoistical    |
| Courageous    | Fearful       |
| Daring        | Hateful       |
| Determined    | Hidebound     |
| Fair          | Impulsive     |
| Faithful      | Insensitive   |
| Friendly      | Lazy          |
| Generous      | Manipulative  |
| Gregarious    | Miserly       |
| Honest        | Petty         |
| Hopeful       | Power Hungry  |
| Industrious   | Rude          |
| Just          | Self-Centered |
| Kind          | Spendthrift   |
| Patriotic     | Stubborn      |
| Thoughtful    | Thoughtless   |
| Thrifty       | Vengeful      |

Optional Classes
----------------

### The Mnemonic Mage

The Mnemonic Mage is a variant magic-user class based on the mages in Jack
Vance’s early Dying Earth stories. While 0e magic-users were very loosely based
on the same thing, the Mnemonic Mage class tries to be a bit closer to the
original source material while still using the standard magic-user spell lists.

The Mnemonic Mage is a mysterious figure, a student of ancient arcane powers
lost to the modern world. Like the standard magic-user, a Mnemonic Mage is
usually cloaked in robes woven with mystical symbols and can be devastating
opponents. Also like the standard magic-user, they are usually physically weaker
than other adventuring classes, and are untrained in the use of armor and
weapons. Unlike a magic-user, a Mnemonic Mage casts spells by forcibly
impressing ancient incantations into their mind which must retain them by sheer
mental force. They cast magic by releasing the spell from their mind. The spell
fades from their mind and takes effect in the world. While a normal person would
go mad from trying to retain even one or two weak mnemonic spells in their mind,
a high level Mnemonic Mage can hold 6 or more powerful spells in their mind at
one time. Compared to a standard magic-user, a Mnemonic Mage has fewer spells
available to cast, but they tend to be more powerful.

**Prime Attribute:** Intelligence, 13+ (+5% experience bonus)  
**Hit Dice:** As Magic-User  
**Armor/Shield Permitted:** None  
**Weapons Permitted:** Dagger, staff, and darts (or by class)  
**Race**: Only elves and humans may become Mnemonic Mages.

#### Mnemonic Mage Class Abilities

**Spell Memorization:** A Mnemonic Mage has a number of memory slots to hold
spells equal to his level plus one. A first level Mnemonic Mage therefore has 2
memory slots while a tenth level Mnemonic Mage would have 11 memory spells. A
Mnemonic Mage memorizes spells by reading them in his spell book and forcing
them into his mind. The amount of time and effort this takes depends on the
class of the spell. Each class of spell requires a different number of memory
slots to hold the spell and takes a specific amount of time to memorize. If the
Hit Point Powered Magic rules are in use memorizing a spell also costs the hit
points listed in the HP Cost to Memorize column. This column is ignored if these
optional rules are not in use.

| Spell Class        | Memory Slots | Time to Memorize\* | HP Cost to Memorize |
|--------------------|--------------|--------------------|---------------------|
| Cantrip\*\*        | 0            | 5 minutes          | 1 HP                |
| Minor              | 1            | 10 minutes         | 2 HP                |
| Lesser             | 2            | 20 minutes         | 4 HP                |
| Greater            | 3            | 30 minutes         | 8 HP                |
| Extraordinary      | 6            | 60 minutes         | 11 HP               |
| Most Extraordinary | 12           | 120 minutes        | 15 HP               |

\* A Mnemonic Mage must spend at least one hour of time studying his spell books
to memorize any spells. Therefore, while it only takes 10 minutes to force a
single minor spell into memory, if that is the only spell the Mnemonic Mage
wishes to memorize, it still takes him one hour to do so.

\*\* The Cantrip spell is special. While it takes no memory slots, a Mnemonic
Mage can only hold a number of Cantrip spells in memory equal to his
Intelligence. The Cantrip spell is known by all Mnemonic Mages and casting the
Cantrip spell has the effect of either one use of the Minor Magic or Arcane
Blast magic-user special ability. A handmade wand is not required.

*Spell Lists:* The Minor spell class includes spells from the first and second
level magic-user spell list. The Lesser spell class includes spells from the
third and fourth level magic-user spell list. The Greater spell class includes
spells from the fifth and sixth level magic-user spell list. The Extraordinary
spell class includes spells from the seventh and eighth level magic-user spell
list. The Most Extraordinary spell class includes spells from the ninth level
magic-user spell list.

*Spell Books:* A Mnemonic Mage can only memorize spells he has personally
studied and copied into his spell books. If he is copying the spell from the
books of another Mnemonic Mage, it only takes one week to study and copy the
spell. If he is trying to add a spell from a standard magic-user’s books or
scrolls, he must study the spell and try to convert it to mnemonic form before
he can copy it into his spell book. This conversion process takes the Time to
Memorize (in days instead of minutes) and requires a successful D20 + INT bonus
roll against a DF equal to 10 plus the spell level of the magic-user spell being
converted. If successful, the new mnemonic form of the spell can be studied and
copied into the Mnemonic Mage’s spell book in the usual manner. If unsuccessful,
the Mnemonic Mage can try again once he has gained at least one level.

First level Mnemonic Mages start with a spell book holding the Cantrip spell and
3 minor spells, 2 lesser spells, and 1 greater spell. The player may select two
of the minor spells from those the Referee allows were available to the mage
during his apprenticeship, the others are selected by the Referee by whatever
method he wishes.

10% of the Magic-User scrolls and spell books found as random treasure should
contain spells in mnemonic form. These items are useless to a standard
magic-user.

**Spell Casting**: To cast a memorized spell, all the Mnemonic Mage needs to do
is to recite it. This releases the spell from his memory and causes it to take
effect. Once cast, the spell is no longer in memory. A Mnemonic Mage cannot cast
spells through ritual magic although he may perform special rituals (that do not
duplicate spells) through ritual magic.

**Memory and Lore:** Due to the training required to hold spells in memory a
Mnemonic Mage can set easily memorize long passages of speech or written text.
As they must study ancient history and civilizations, they are storehouses of
historical information, and can often identify legendary and magic items that
appear in old tales.

**Saving Throw Bonus:** If using the single saving throw system from S&W,
Mnemonic Mages gain a bonus of +2 on all saving throw rolls against spells,
including spells from magic wands and staffs.

**Mage’s Tower (11th):** While a Mnemonic Mage often builds a stronghold for
himself or herself to house their libraries and laboratories very early in their
career, at 11th level, a Mnemonic Mage gains the title of “Mage”. At this point,
assuming they have a stronghold, they will begin to attract a mixed bag of
mercenaries, strange servants (some with odd abilities and deformities), and
even a few monsters, perhaps. This motley crew will swear fealty to them and
serve them with whatever loyalty the Mage can inspire.

**Mnemonic Mage Advancement**

| Level | **Experience Points Required for Level** | **Hit Dice** | **Fighting Capability** | **Memory Slots** |
|-------|------------------------------------------|--------------|-------------------------|------------------|
| 1     | 0                                        | 1            | Man                     | 2                |
| 2     | 2,500                                    | 1+1          | Man + 1                 | 3                |
| 3     | 5,000                                    | 2            | 2 Men                   | 4                |
| 4     | 10,000                                   | 2+1          | 2 Men + 1               | 5                |
| 5     | 20,000                                   | 3            | 3 Men                   | 6                |
| 6     | 35,000                                   | 3+1          | 3 Men + 1               | 7                |
| 7     | 50,000                                   | 4            | Hero - 1                | 8                |
| 8     | 75,000                                   | 5            | Hero                    | 9                |
| 9     | 100,000                                  | 6+1          | Hero + 1                | 10               |
| 10    | 200,000                                  | 7            | Wizard                  | 11               |
| 11    | 300,000                                  | 8+1          | Wizard                  | 12               |
| 12    | 400,000                                  | 8+2          | Wizard                  | 13               |
| 13    | 500,000                                  | 8+3          | Wizard                  | 14               |
| 14    | 600,000                                  | 8+4          | Wizard + 1              | 15               |
| 15    | 700,000                                  | 9+1          | Wizard + 2              | 16               |
| 16    | 800,000                                  | 9+2          | Wizard + 2              | 17               |

### The Paladin

Paladins are a “subclass"/special type of Fighter. In order to become a Paladin,
a Fighter must be Lawful and have a Charisma of 17 or higher. Any Chaotic act
will result in the revocation of the Paladin's status; he will thereafter be a
normal Fighter with no special powers.

Note that a Paladin remains a Fighter for all purposes; other than the
alterations described on this section, they perform in all ways just like normal
Fighters.

#### Powers of the Paladin

**Lay on Hands:** A Paladin may heal up to 2 hit points of damage per level of
ability, and one disease for each five levels he or she has attained. Either or
both of these powers may be performed once per day.

**Immune to Disease:** Paladins are immune to all forms of disease.

**Protected:** All of a Paladin's saving throws are made at a bonus of +2.

**Challenge Evil:** A Paladin of the 8th level or higher can detect evil at will
at a range of 6", and can cast the spell dispel evil at will merely by
proclaiming it.

**Holy Sword:** When a Paladin wields a special magic item called a Holy Sword,
it nullifies all magic within its 1" radius circle of protection. When rolling
for magic items on the sword table of Book 2 of the Original Edition consider a
roll of 82 as indicating a Holy Sword +5. Also consider the Sword of Sharpness
and Vorpal Sword as being Holy Swords for this purpose. As you might expect, the
same Lawful- only alignment restriction applies to a "plain" Holy Sword +5 as
applies to these two other swords.

**Paladin's Steed:** Each Paladin may acquire a specially gifted steed, as
described below. If a Paladin's steed is slain, he or she may not obtain another
such steed for a period of 10 years.

#### Restrictions of Paladinhood

**Poverty:** A Paladin may never have more than four magical weapons, one suit
of magical armor, one magic shield, nor more than four other magic items. All
treasure earned in excess of a Paladin's needs must be given away to proper
religious orders or perhaps other charitable institutions. When a Paladin builds
a stronghold, he or she may spend no more than 200,000 gold pieces to do so, and
may employ no more than 200 troops in defense of it. A Paladin may choose to
remain in the service of a Lawful king or religious leader instead of building a
stronghold, if that seems a more effective way to promote the spread of Law.

**Association:** Paladins will never willing associate with Chaotic characters.

#### Paladin’s Steed (Horse, Heavy, Special)

*AC:* 5 [14]

*HD:* 5+1 (19 hp)

*Attacks:* hooves (2d8) or bite (1d3)

*Move:* 180 feet

*Morale:* 12

*Special:* Highly intelligent, Lawful

A Paladin's Steed appears to be just a particularly fine example of a heavy
warhorse. However, they are very intelligent and loyal. A Paladin's Steed need
never roll a morale check, but will always act in accordance with its master's
wishes (so long as he remains a faithful Paladin in good standing) or in defense
of its master or of Law in general if its master is unavailable or unable to
give it orders.

If for any reason the Paladin loses his or her status, the steed will no longer
serve its former master in any way and will seek to flee as soon as possible.

*Notes for the Referee:* In the Original Edition a Paladin wasn’t a class but a
special type of Fighter. This optional rule adds this type of Paladin to the
game. With these rules, there is no way for a Fighter who loses Paladin status
to ever regain it. If you choose to allow a “fallen paladin” to attempt to
regain their status, it should probably require a great quest or the like.

### The Specialist

Specialists are unique characters that have special knowledge or skills thar can
be useful on adventures. In some cases, they cannot to anything that any
character could not try to do, they just have a better (generally much better)
chance of success due to their knowledge and training. There are two subtypes of
Specialists: Action Specialists and Scholarly Specialists. Action Specialists
can wear light or medium armor, use shields, use any weapon, and fight as a
cleric. Scholarly Specialists can wear light armor, use any weapon, and fight as
a Magic-User.

Specialists should take a background that covers the area they wish to
specialize in. Action Specialists begin the game with 5 talents related to their
area of specialization: two at the “Expert at” level and three at the “Good at”
level. Scholarly Specialists begin the game with 7 talents related to their area
of specialization: one at the “Master at” level, two at the “Expert at” level,
and four at the “Good at” level.

**Specialist Advancement**

|                                                                            | **Experience** |          | **Saving Throw Versus** |           |                   |            |            |
|----------------------------------------------------------------------------|----------------|----------|-------------------------|-----------|-------------------|------------|------------|
| **Thief**                                                                  | **Points**     | **Hit**  |                         | **Wands** | **Paralysis**     | **Breath** |            |
| **Level**                                                                  | **Required**   | **Dice** | **Poison**              | **Rays**  | **Petrification** | **Weapon** | **Spells** |
| 1                                                                          | 0              | 1        | 13                      | 14        | 13                | 15         | 16         |
| 2                                                                          | 1,250          | 1+1      | 12                      | 14        | 12                | 14         | 15         |
| 3                                                                          | 2,500          | 2        | 12                      | 14        | 12                | 14         | 15         |
| 4                                                                          | 5,000          | 2+2      | 11                      | 11        | 11                | 13         | 14         |
| 5                                                                          | 10,000         | 3+1      | 11                      | 11        | 11                | 13         | 14         |
| 6                                                                          | 20,000         | 4        | 10                      | 11        | 10                | 12         | 13         |
| 7                                                                          | 40,000         | 4+1      | 10                      | 11        | 10                | 12         | 13         |
| 8                                                                          | 70,000         | 5        | 9                       | 8         | 9                 | 11         | 12         |
| 9                                                                          | 120,000        | 5+2      | 9                       | 8         | 9                 | 11         | 12         |
| 10                                                                         | 180,000        | 6+1      | 8                       | 8         | 8                 | 10         | 11         |
| 11                                                                         | 240,000        | 7        | 8                       | 8         | 8                 | 10         | 11         |
| 12                                                                         | 300,000        | 7+1      | 7                       | 5         | 7                 | 9          | 10         |
| A specialist requires 120,000 experience points per level beyond the 12th. |                |          |                         |           |                   |            |            |
| A specialist adds one hit die per four levels beyond the 11th.             |                |          |                         |           |                   |            |            |

*Notes for the Referee:* A campaign that includes the Specialist class must also
use the optional Background and Talents rules found in this section. The
Specialist class could easily be used for a thief or a ranger. Remember that a
specialist normally cannot do anything any other character class could not try
to do; they are just far better than the average character at tasks that clearly
fall within their area of specialization. For example, anyone can try to disarm
a mechanical trap, but a mechanician specialist should be much more likely to
succeed and probably has something like Expert at “Mechanical Traps” to further
Increase their chances of success. The referee will probably need to work with
the player to ensure that both the player and the referee are on the same page
as to what the character’s specialization actually covers and that the initial
talents selected both match the specialization and are likely to be useful in
the campaign. The Specialist class is particularly useful in campaigns set in
non-standard settings (e.g., the Renaissance era or sword and planet).

### Variant Classes

The referee may allow some, all or none of the variant classes listed below in
their campaign. Each variant class functions very similar to one of the standard
classes. This determines whether or not a class can be used by a non-human
character and the experience point advancement table for the class. Note:
Optional classes have an *Experience Modifier* of -10% unless otherwise noted.

*Acrobats* master feats of daring do. They function exactly as thieves; except
they receive a -1 to their AC every level and use the Saving Throws of clerics.
Acrobats may not wear armor or use shields.

*Assassins* are professional killers. They may attempt a Death Attack once per
day in any situation where they could otherwise backstab. If the attack is
successful, the target must make a saving throw or die. They otherwise function
exactly like thieves.

*Bards* are wandering performers and minstrels. They function exactly as
thieves; except they may cast Charm Person and Detect Magic once per day. Once
per combat they may sing an inspiring song, granting all allies +1 to all attack
rolls for 5 rounds.

*Cavaliers* are mounted warriors. They function exactly as fighters; except they
gain a +2 to any Saving Throw when mounted on a horse and gain +1 to-hit and
damage with lances.

*Druids* worship nature. They may track foes in a wilderness environment with a
3+ on d6 and may cast Charm Person as a 1st level spell, though only on animals.
They can only wear leather armor, but otherwise function as Clerics.

*Illusionist:* Magical tricksters. They can cast a limited number of Magic-user
Spells as a Magic-user of one level lower. Spells castable are limited to: Charm
Person, Light, Color Spray, Phantasm, Invisibility, Dispel Magic and Illusion
(3rd Level, as Phantasm but continues for 1d6 minutes after Illusionist stops
concentrating on it). Otherwise, they function as thieves.

**Monks** are wandering mystics. They function exactly as clerics except they
receive a -1 to their AC per level and may make unarmed attacks which inflict
1d6 points of damage, which increases by +1 per level. Monks may not wear armor
or use shields.

*Necromancers* master dark magical arts. They function as magic-users, but may
also Turn Undead as if they were a Cleric. They gain control of any undead
turned for 5 rounds.

*Paladins* are holy warriors that function exactly as fighters, except they may
also cast spells (to a maximum of third level spells) as if they were a Cleric
of one level lower than their Paladin level. Experience Modifier: -20%.

*Rangers* are skilled woodsmen that function exactly as fighters, except they
can track foes in wilderness environments with a 3+ on a D6, or a 5+ on a d6 in
dungeon or urban environments. They receive +1 to damage against goblin-kind,
ogres, trolls, and giants. They can only wear leather or chain armor.

*Sage:* Scholar of the arcane and esoteric. On a roll of 6+ on a d6 a sage can
learn an interesting fact about an object, person, location, etc. For every day
spent researching the object, person, location, etc., the sage gets a +1 to the
roll. A roll of ‘1’ always means a failure. They can also learn and cast spells
from the Cleric Spell List as if they were magic-user spells of two spell levels
higher (e.g., a first level clerical spell could be learned as a third level
magic-user spell). Otherwise, they function as magic-users. Experience Modifier:
-30%.

*Swashbucklers* are dashing swordsmen. They function exactly like thieves, but
attack as a fighter when wielding a melee weapon.

*Technicians* are advanced technologies experts. They may use advanced
technological equipment without making a Save to get them to work. Otherwise,
they function as thieves.

*Notes for the Referee:* Your campaign and/or your players may need a little
more variety in character classes. These variant classes are relatively simple
modifications to the core classes, providing variety in a small package. You
will probably want to carefully select which of the above variant classes you
allow in your campaign. Feel free to create your own variant classes along these
lines if your campaign needs them.

Optional Combat Rules
---------------------

### Action-Type Initiative

Roll initiative on a d6 for each side at the start of each round, the same as
usual.

**Talkers** act first. This is any sort of attempt to negotiate, threaten, issue
orders, or whatever, but either way represents a significant enough
communication to remain the focus of your action during the round.

**Doers** act next. This represents any sort of miscellaneous action, including
things like a thief attempting to pick a lock, a spellcaster beginning the
incantation for a spell (more on this in a moment), searching through your
backpack for a healing potion, et cetera.

**Movers** act third. This is when manoeuvring happens, as well as any attempts
at fleeing an altercation.

**Fighters** act last. At this point resolve any attacks, including special ones
like tripping. This is a caster's last chance to declare where she's aiming her
spell for the round.  
Lastly, any spells cast during the round are resolved. If the spell has a
specific duration, its duration is counted down from this point, not from the
beginning of the round.

During any phase, a character can choose instead of taking their action to react
to another action by taking an action of their own, so long as the action
belongs to the same or an earlier phase; but only if she has not yet acted. This
represents that character's action for the round. If your side has initiative,
then your reaction can, if you so choose, take place before the triggering
action is resolved-- for instance explaining to an ally why banging on a glass
tank full of acid is a bad idea, cravenly begging for mercy from an attacker, or
even retreating from an attacker before he can hit you! If your side does not
have initiative, you can still react, but only after the triggering action is
resolved.

*Notes for the Referee:* This alternative to the standard “strike rank” system
is borrowed from a game about a time-travelling police box. It encourages
players (and Referee ran intelligent NPCs) to play smart instead of immediately
resorting to attack. It can result in very different encounters from what more
action-oriented players may expect.

### Armor for Everyone

All character classes can wear armor; however, wearing armor has negative
effects on the abilities of some classes.

*Base Armor Class:* Each class has a base armor class that is in effect anytime
the character is conscious and not tied up to the point they can't move at all.
This base armor class takes into account the character's combat training which
allows him to dodge and parry blows.

-   Fighter -- Base AC of 5 [14]

-   Cleric -- Base AC of 7 [12]

-   Thief -- Base AC of 8 [11]

-   Magic-User -- Base AC of 9 [10]

Any character that is unconscious or heavily restrained has a Base AC of 9 [10].

*Armor:* Armor subtracts from the character's Base AC when worn. Armor may have
side effects for some classes.

Light Armor: -1 to AC. Magic-Users and Illusionists cannot cast their highest
level of spells known while wearing Light Armor.

Medium Armor: -2 to AC. Magic-Users and Illusionists cannot cast their two
highest levels of spells known while wearing Medium Armor. Thief abilities are
halved while wearing Medium Armor.

Heavy Armor: -3 to AC. Magic-Users and Illusionists cannot cast their three
highest levels of spells known while wearing Heavy Armor. Thief abilities are
unusable while wearing Heavy Armor.

Shield: -1 to AC, only when character is conscious and mobile. Magic-Users
cannot cast their highest level of spells known when using a shield -- if they
are using a shield and armor the shield adds 1 to the levels of spells they
cannot use. Note that a magic-user requires at least one hand free to cast
spells.

*Examples*: An unarmored average fighting man is AC 5 [14]. The same fighting
man in plate armor and using a shield would be AC 1 [18].

An unarmored 10th level wizard would be AC 9 [10] and could cast spells
normally. If that tenth level wizard wears chainmail, she would be AC 7 [12] but
would not be able to cast any of her 4th or 5th level spells. A 1st through 4th
level magic user wearing chainmail would not be able to cast any spells at all.

*Notes for the Referee:* One thing that really seems to sit wrong with some
players in early editions are the armor limitations on classes. Some players
really want their magic-users to wield swords and wear armor. This optional
armor system allows this while still trying to maintain the balance between
classes.

### Black Powder Weapons

In some campaign settings, early black powder firearms may be available. Black
powder weapons have the potential to cause a lot of damage, if the maximum is
rolled on a black powder weapon’s damage die (for example, 8 for a pistol), roll
again and add the new result to the total. Keep rolling as long as the maximum
is rolled. A black powder weapon can only be fired once before it has to be
reloaded, which takes an entire round.

| **Weapons** | **Range** | **Cost** | **Damage** |
|-------------|-----------|----------|------------|
| Pistol      | 30ft      | 200gp    | 1d8        |
| Musket      | 200ft     | 500gp    | 1d10       |

Notes for the Referee: Black powder can be considered an alchemical or even
magical substance in a campaign setting if the Referee desires. Adding black
powder weapons will not unbalance a campaign, but it will certainly change the
feel of a campaign setting, especially if such weapons are common. For more
complete (and complex) rules on firearms, see the Section on Firearms.

### Climbing on Enemies

Instead of attempting to grapple with an enemy much larger than herself, a
character may choose to attempt to climb up its body. While you are clinging to
your opponent, you get a +2 bonus to all attacks made against it, and in most
cases the only attack it can safely make against you is to attempt to shake or
throw you off. In this event, make a reflex save to hang on. If you fail, you
take falling damage appropriate to the height you fell from or distance you were
thrown. At the Referee's option, particularly huge monsters might offer a larger
bonus in exchange for additional climbing. Large enough monsters that are
possessed of hands, tentacles or other highly dextrous structures, might instead
be able to grab and squeeze a creature that attempts to climb them, dealing an
appropriate amount of automatic damage.

*Notes for the Referee:* This is a version of a popular optional rule on old
school blogs. It’s a fun alternative to grappling.

### Combat Stance

Any character able to act may select a combat stance. Any character who has not
announced their combat stance before initiative is rolled automatically selects
“Standard.” Combat Stances (and their effects) are:

-   *Full Defense* (Attack: no attack possible; AC: +2 bonus, +4 bonus with
    shield, +6 bonus with large shield; Strike: -5),

-   *Active Defense* (Attack: -2 penalty; AC: +1 bonus, +2 with shield; Strike:
    -2),

-   *Standard* (Attack: Normal; AC: Normal: Strike: normal),

-   *Active Attack* (Attack: +1 bonus; AC: -1 penalty; Strike: +1), and

-   *Full Attack* (Attack: +2 bonus; AC: -2 penalty; Strike: +2). S

Spell casters casting a spell cannot select the Full Defense or Active Defense
Stance. The Stance Strike modifier is optional (and can only be used if the
optional Strike Speed Initiative rules are used).

### Combat Stunts (Simple)

At a cost of 1 hit point, Fighter, cleric, and Thief classes may adjust their
armor bonuses, attack bonus, damage done, etc. for an attack to create a combat
stunt. For each -1 a character takes, he may take a +1 in another area. A
Fighter may take up to 2 plus Level/3 (round up) in penalties on a single attack
roll. A Cleric or Thief may take up to his level/3 (round up) in penalties on a
single attack roll.

For example, a 5th level fighter (maximum combat stunt penalties of -4) might
want to do a great blow causing 4 points extra damage in exchange for reducing
his AC until his next action and reducing his chance to hit with the attack. For
example, +4 to damage, -2 to AC and -2 to hit would balance the bonuses and
penalties.

*Notes for the Referee:* This can make combat more interesting at little cost in
complexity. If you use this system, you should require the player to describe
what his character is doing and deny any combat stunts that do not make sense in
the situation (no tripping a gelatinous cube, for example) or whose bonuses and
penalties do not match up well to the player’s description of the stunt. If
characters are allowed this option, some intelligent opponents (including some
monsters) may use these combat stunts at your option.

### Combat Stunts (Complex)

Fighters may modify their basic attack in the following ways by spending HPs: 1
hp + 2hp for each effect.

Hinder - inflict an extra 1d6 as a penalty until next turn

Cleave - hit all adjacent enemies, roll separate damage

Aid - give a 1d6 bonus any one character's to hit or AC this round

Extra Die - roll an extra damage die (can't be used with Aid or Hinder)

Effect - some extra effect like knocking the target back or disarming them. The
target gets a saving throw.

The maximum number of hit points a Fighter can spend on stunts for a single
attack is ((Level/2, round up) x 2) +1. That is 3hp at levels 1 and 2, 5hp at
levels 3 and 4, 7hp at levels 5 and 6, etc. – with an absolute maximum equal to
the Fighter’s STR.

Example: A fighter of level 3 or higher can spend 5hp to hit all the kobolds
surrounding him with double damage (Cleave, Extra Die).

Example: A Fighter can spend 3hp to make a distracting attack that gives another
named member of his party +1d6 to hit the same opponent (Aid).

Example: A fighter can spend 3 hp to knock the goblin off balance, giving him a
-1d6 AC penalty (Hinder).

Example: A fighter of level 10 or higher could knock his opponent back, giving
three named members of his party a +1d6 each to hit that same opponent, and
reducing the opponent’s AC by 1d6 (Effect, Aid x 3, Hinder).

If the Combat Stunts (Simple) rules are in use, Fighters may also adjust their
bonuses as allowed under those rules as part of a complex combat stunt at no
additional cost in hit points.

*Notes for the Referee:* This can make combat more interesting for fighters, but
a relatively large cost in complexity. If you use this system, you should
require the player to describe what his character is doing and deny any combat
stunts that do not make sense in the situation (no tripping a gelatinous cube,
for example) or whose bonuses and penalties do not match up well to the player’s
description of the stunt. If characters are allowed this option, some
intelligent opponents (including some monsters) may use these combat stunts at
your option.

### Critical Hits and Misses

#### Critical Hits

A natural 20 that would otherwise hit is automatically a critical hit doing
maximum damage and doing a number of body points damage equal to the number of
damage dice rolled (normally 1). Most monsters do not have body points, so a
critical hit will do maximum damage plus a normal damage roll to them and cause
them to lose their next attack.

*Option:* Fighting Men (only) do a critical hit on a natural roll of 19 or 20
that would otherwise hit.

**Critical Hit Special Effects (optional):** When a Fighter (or a monster, at
the Referee’s option) has selected the Active Attack or Full Attack combat
stance for a round and scores a critical hit in melee combat during that round,
one of the following special effects may be imposed at the attacker’s option:

-   *Trip*: Target is knocked prone.

-   *Disarm*: Target's weapon or shield is knocked away in a random direction a
    number of feet equal to half the damage you dealt.

-   *Reposition*: Force your target to move to a new location of your choice, up
    to a number of feet equal to half the damage you dealt (plus attacker’s STR
    bonus). Attacker may move with target if attacker desires.

-   *Shield Slam*: If wielding a shield, bludgeon your target with it, dealing
    damage as a shield bash. Target is then forced back from you a number of
    feet equal to half the damage dealt by the original attack (plus the
    attacker’s STR bonus).

-   *Disorient*: Blow leaves your opponent off-guard. Until the end of his next
    turn, target is confused.

-   *Hinder*: Target is briefly slowed, reducing his speed to five feet until
    the end of his next turn.

If the movement effect of Reposition or Shield Slam would force the target over
a cliff, into a pool of dangerous liquid, or the like, the target gets a save to
stop safely at the edge.

#### Critical Misses

A natural roll of 1 is a critical miss. Unless the optional rule below is used,
the only effect of a critical miss is that the attack always fails, regardless
of modifiers.

**Critical Miss Special Effects (optional):** When a Fighter (or a monster, at
the Referee’s option) has selected the Active Defense or Full Defense combat
stance for a round and an enemy attacking him during that round rolls a natural
1 on their attack roll, one of the following special effects may be imposed at
the defender’s option:

-   *Counterattack*: You make a melee attack against your attacker. This is in
    addition to any other attacks you might make during the round.

-   *Disengage*: You dart away from your attacker, moving up to your movement,
    but you cannot engage another by doing so.

-   *Blind*: You spit, throw sand, or otherwise attack your enemy's eyes. Until
    the end of the next round, he is blinded.

-   *Redirect Attack*: Your opponent's attack automatically strikes another
    creature of your choice within reach of your enemy’s weapon.

-   *Feint*: You quickly feign an attack against your foe. Until the end of his
    next turn, your enemy has a negative modifier equal to your level to all
    actions.

-   *Steal*: You pluck a small unprotected item--usually no more cumbersome than
    a weighty coin purse--from your foe.

*Notes for the Referee:* If you want to make critical hits more interesting,
these rules will do it. These rules deliberately avoid “fumbles” as people
dropping their weapons, accidently hitting others, etc. 5% of the time is silly
and unrealistic. The Critical Miss rule allows a fighter who chooses to fight
defensively to force a “fumble-like” special effect on an opponent who rolls a
natural 1 as his attack roll, Note, however, that these rules may interact
strangely at times with other optional rules like Combat Stunts and Feats of
Might. As Referee you will have to adjudicate any conflicts or unbelievable
effects. This optional rule also increases combat complexity.

### Feats of Might

All Fighters (and at the Referee's option, certain martially-inclined
intelligent enemies) may, if they so choose, when making an attack declare that
they wish to attempt a specific Feat of Might. To determine if you were able to
perform the feat, at the same time as you roll to attack, roll the same kind of
die as your weapon's damage (so a d6, by default). Add any enchantment bonus the
weapon has, plus your STR modifier if it's a medium or heavy weapon or your DEX
modifier if it's a light or ranged weapon. This increases by an additional +1 at
4th level and every four levels thereafter. If the attack hit *and* the result
is equal to or greater than the highest possible result on the die (so 6, by
default) the feat is successful. Whether or not the feat was successful, you
still also roll damage if the attack hit.

The following are examples of suitable effects for a successful feat:

Trip: Target is knocked prone.

Disarm: Target's weapon or shield is knocked away in a random direction a number
of feet equal to half the damage you dealt.

Reposition: Force your target to move to a new location of your choice, up to a
number of feet equal to half the damage you dealt (plus attacker’s STR bonus).
Attacker may move with target if attacker desires.

Shield Slam: If wielding a shield, bludgeon your target with it, dealing damage
as a shield bash. Target is then forced back from you a number of feet equal to
half the damage dealt by the original attack (plus the attacker’s STR bonus).

Disorient: Blow leaves your opponent off-guard. Until the end of his next turn,
target is confused.

Hinder: Target is briefly slowed, reducing his speed to five feet until the end
of his next turn.

Blind: You spit, throw sand, or otherwise attack your enemy's eyes. Until the
end of the next round, he is blinded.

Feint: You quickly feign an attack against your foe. Until the end of his next
turn, your enemy has a negative modifier equal to your level to all actions.

If the movement effect of Reposition or Shield Slam would force the target over
a cliff, into a pool of dangerous liquid, or the like, the target gets a Reflex
save to stop safely at the edge.

Example: Emma is playing Lillith, a 5th-level Fighter, who is embroiled in
combat with a vicious owlbear. When her turn comes, Emma declares that she wants
to attempt a Feat in order to Hinder the beast. Lilith is armed with a +1
Scimitar, which is a medium weapon, and has 16 STR. To see if her Feat is
successful, at the same time she rolls her usual 1d20 to hit, she also rolls 1d6
(the amount of damage a medium weapon deals) and to that 1d6 she adds +1 for the
enchantment of the weapon, +1 from her STR bonus, and +1 for being a 5th-level
fighter (this is the same Fighting Class bonus she adds to attack and damage),
or +3 altogether. Since the highest possible result 1d6 can show is 6, if Emma's
feat roll is a 3 or better *and the attack hits*, then she can apply the hinder
effect in addition to rolling damage normally.

*Notes for the Referee:* This system can make combat more interesting at the
cost of more complexity. If you use this system, you should deny any use of a
Feat of Strength and Skill that does not make sense in the situation. If
fighters are allowed this option, some fighter opponents (including some
intelligent monsters) may use these rules at your option.

### Mobs

Inexperienced adventurers are challenged by individual soldiers. The more
experienced ones need to be challenged by whole battalions. Instead of putting 5
opponents of 1 HD each to face a character, the Referee can combine these 5
enemies into a single mob. This makes them more challenging and makes combat
more manageable. When doing this, the mob is considered to be a creature with HD
equal to the combined number of HD of its member. All other statistics remain
the same, including number of attacks and damage. The mob has as many HP as the
combined value of HP of its members. The damage suffered by the mob is applied
individually to one member at a time. This way, as the individuals die, the mob
becomes weaker. The Referee can likewise join two weakened mobs to make a
stronger one.

*Notes for the Referee:* This is a simple way to handle mobs of opponents. The
mob has the hit roll of a multi-die monster but only does the damage of a single
individual (simulating the combat effects of trying to fight off a large number
at the same time). As individuals of the mob are eliminated, the mob’s
effectiveness in combat decreases (it’s hit dice go down). It is quite abstract,
however.

### Overwhelming Opponents

Each attacker beyond the first against the same target in the same round adds +1
to their attack rolls for each attacker before them. So, a second attack on the
same target in the same round by a party member or monster would be at +1, a
third attack at +2, etc.

Notes for the Referee: This allows multiple creatures to wear down a more
powerful target by overwhelming the target with many attackers. It adds a bit
more realism to combat and allows large number of “nuisance” opponents to be a
real threat. If you opt to use this rule, remember that opponents that are not
within weapon reach of a target cannot attack. Therefore, you as Referee must
exercise common sense in applying this rule.

### Shield Wall

Characters have and can use shields in battle can form a shield wall. Forming a
shield wall grants each person in the wall (including hirelings) to
automatically lose initiative in exchange for an additional +1 to AC per
adjacent ally (so a max of +2) so long as they remain in formation.

*Notes for the Referee:* This is a defensive option that will not overpower your
games. It’s low complexity as well so it should not make combat more complex.

### Strike Speed Initiative

**Initiative:** Roll 1d20 for initiative for each side. The side with the higher
roll gets a +5 to strike speed for the round. Spell casters casting a spell must
declare the spell being cast and its target before initiative is rolled.

**Strike Speed:** Characters and monsters act in order of their strike speed
from high to low. Base Strike Speed is determined by their action type in the
table below. Characters/Monster add +5 to the Base Strike Speed if their side
has initiative. Fighters add one-half their level. Monsters add one-half their
hit dice, rounded down if the Referee classes them as fighters. (Ties in Strike
Speed are resolved by Character Level/Monster Hit Dice, with the higher acting
first.) The Strike modifier from a character’s combat stance is added if the
campaign uses that optional rule.

| Base Strike      | Weapon/Attack Action      |
| Speed            |                           |
|------------------|---------------------------|
| 1                | Read Scroll               |
| 2                | Cast Spell                |
| 3                | Short Length Weapon       |
| 4                | Medium Length Weapon      |
| 5                | Long Weapon               |
| 6                | Very Long Weapon          |
| 7                | Pole Arms                 |
| 8                | Missile Fire/Arcane Blast |
| 9                | Breath Weapon             |
| 10               | Glance                    |

*Notes for the Referee:* While some form of group initiative works better in
Original Edition games, this is a variation on an early version of individual
initiative that works fairly well.

### Weapon Damage by Class

Characters of any class can use any weapon. However, because of different levels
of training, the amount of damage a character can do with a given weapon varies
the type of weapon and the wielder’s class. The Weapon Damage Table below is
used instead of any other weapon damage given in the rules.

**Weapon Damage Table**

| **Class Type** | **Light Wpn** | **Medium Wpn** | **Heavy Wpn** |
|----------------|---------------|----------------|---------------|
| Fighter        | 1d6           | 1d8            | 1d10          |
| Cleric/Thief   | 1d4           | 1d6            | 1d8           |
| Magic-User     | 1d4           | 1d4\*          | 1d6\*\*       |

\*Magic-Users wielding a Quarterstaff using both hands do 1d6 damage.

\*\*Magic-Users wielding a heavy weapon do so at -1 to hit.

**Magic Weapons:** A character only benefits from a magical hit or damage bonus
on a weapon if the character’s class is able to use the weapon under the
standard class rules.

*Notes for the Referee:* In some campaign worlds the weapon restrictions on
classes make little sense. This optional rule allows any class to use any weapon
but limits the damage a weapon does based on the amount of “weapons training” a
class receives. A fighter wielding a two-handed sword will do more damage with
it than a magic-user will because fighters train with them and magic-users
don’t.

Optional Magic Rules
--------------------

### Acquiring Spells

Clerics have an obvious advantage over Magic-Users, in that, in theory, they
have access to any spell of any level which they can cast. However, note that
Clerics are limited in their spell selection based on their deity, faith or
ethos; for instance, a Cleric of the goddess of healing should not be surprised
that his or her deity refuses to grant reversed healing spells. If a Cleric
prays for a spell that is not allowed, the Referee may choose to grant the
character a different spell, or optionally (if the deity is angered) no spell at
all for that “slot.”

Magic-Users begin play knowing two spells, read magic plus one other (unless the
Referee grants more starting spells). Each time the character gains a level, he
or she gains the ability to cast more spells; in addition, approximately every
other level the Magic-User gains access to the next higher level spells (until
all levels are available). However, gaining the ability to cast these spells
does not necessarily mean the Magic-User instantly learns new spells.

Magic-Users may learn spells by being taught by another Magic-User, or by
studying another Magic-User's spellbook. If being taught, a spell can be learned
in a single day; researching another Magic-User's spellbook takes one day per
spell level. In either case, the spell learned must be transcribed into the
Magic-User's own spellbook, at a cost of 500 gp per spell level transcribed.

A Magic-User may add a new spell of any level he or she may cast at any point;
however, spells of higher levels may not be learned or added to the Magic-User's
spellbook. The Magic-User must find a teacher or acquire a reference work (such
as another Magic-User's spellbook or a scroll with the spell) in order to learn
new spells, and the cost of such is in addition to the costs given above. Often
a Magic-User will maintain a relationship with his or her original master, who
will teach the character new spells either for free or in return for services.
Sometimes two Magic-Users will agree to exchange known spells. In many cases the
only option available to a Magic-User will be to pay another Magic-User (often
an NPC) anywhere from 100 gp to 1000 gp per spell level in return for such
training.

*Notes for the Referee:* The Original Edition is relatively salient when it
comes to how spellcasters acquire spells. This optional rule provides one way to
handle this. The god piece costs are based on an “average” campaign. If these
costs seem too low (or too high) for your campaign, adjust them to fit your
campaign.

### Hit Point Powered Magic

#### Spell Knowledge

Magic-Users and Clerics can memorize and cast spells from their respective spell
lists up to the maximum spell level listed for their character level.
Magic-Users record spells they know in spell books. Clerics record spells they
know in prayer books.

Magic-Users start with Read Magic and 1d2 additional first level spells in their
spell book (which must be approved by the Referee) and can add more spells by
finding (or buying) them on scrolls or books and copying them into his spell
book.

Clerics start with 1d2 first spells in their prayer book (which must be approved
by the Referee) and can add more spells by finding (or buying) them on scrolls
or books and copying them into his prayer book.

A Magic-User can memorize up to Level + INT bonus spells and these spells can be
directly cast (others spells may be cast via a casting ritual). A Magic-User
requires his spell book and 1 hour of time to change the spells he has
memorized.

A Cleric can memorize up Level plus WIS bonus spells and these spells can be
directly cast (others spells may be cast via a casting ritual). A Cleric
requires his prayer book and 1 hour of prayer to change the spells he has
memorized.

Memorized spells are not forgotten when cast.

#### Direct Spell Casting

Casting memorized spells is direct spell casting. Memorized spells can be cast
very quickly, even in combat. Ritual magic allows a spellcaster to cast any
spell recorded in their spell books (even if not currently memorized) but
requires a time-consuming ritual lasting minutes or even hours.

**Casting Cost:** Direct casting a spell of any kind costs Hit Points. The cost
is 1 + the level of the spell being cast if the spell is cast with an implement
and 1 + twice the level of the spell being cast if the spell is cast without an
implement:

**HP Cost by Spell Level**

| **Spell Level**           | **1** | **2** | **3** | **4** | **5** | **6** |
|---------------------------|-------|-------|-------|-------|-------|-------|
| HP Cost with Implement    | 2     | 3     | 4     | 5     | 6     | 7     |
| HP Cost without Implement | 3     | 5     | 7     | 9     | 11    | 13    |

Although there are ways to reduce the cost of casting spells, the casting cost
cannot be reduced below 2 Hit Points.

**Signature Spells:** Both Magic-Users and Clerics select one ‘signature’ spell
per spell level from first upward that they prefer to use over any other. These
spells are easier to cast due to familiarity, costing 1 less HP to use.
Signature spells are always in memory and do not count against the number of
spells a caster can memorize.

**Implement Use:** Spells cast through an implement (a wand or staff for a
Magic-User, a holy symbol for a cleric) cost less to use. The implement must
either be a magic item or be made by the caster (12 hours, wood, and carving
tools needed). The implement must be undamaged and in the caster’s hand at the
time the spell is cast. If the Cleric Special Abilities and/or the Magic-User
Special Abilities optional rules are in use, the implements described therein
also count as implements for the purpose of this rule (and vice-versa).

**Combat Casting:** In combat, if a character is hit and takes damage (or other
effect that could interfere with spell casting like paralysis) before casting a
spell, the spell fizzles. The fizzled spell costs caster only 50% of the normal
HP casting cost of the spell and the caster loses his action for the round.

**Hit Point Recovery:** If the optional Hit Points and Wound Points rule is not
being used, Healing magic (potions, cure spells, etc.) will not restore hit
points spent on casting spells. Hit points spent to cast magic are instead
recovered by a full night’s rest.

#### Ritual Magic

Both Magic-Users and Clerics can perform ritual magic to cast spells of any
level (and other special rituals that might be found in old books or scrolls)
provided the caster has a written copy of the spell or ritual, any needed
materials (mainly required by special rituals), and the time and space needed to
perform the ritual.

**Performance Cost:** Ritual casting of a spell of a level the caster is able to
cast normally takes 1 minute per level of the spell being ritually cast. The HP
Casting Cost is equal to casting the spell with an implement (spell level + 1
HPs). Ritual casting of a spell of a level the caster is not yet able to cast
normally takes 15 minutes per level of the spell and costs 4 hit points per
level of the spell being ritually cast. Ritual casting of a special ritual takes
as long and costs as many HP as the ritual states (that is, the Referee assigns
these as needed when he creates the special ritual). Multiple casters may
participate in a casting a special ritual with the HP cost of casting divided
among them.

**Sacrifices (Optional):** One or more beings with human or better intelligence
may be sacrificed during ritual magic. Each sacrifice made adds 10 minutes to
the ritual and provides 10 plus the being’s level or hit dice in HP to power the
ritual. This amount is tripled if the being is truly a willing sacrifice. Some
special rituals may require the sacrifice of intelligent beings. The sacrifice
of intelligent beings is normally against the law in civilized societies.

#### Counterspells (Optional)

Magic-Users have the ability to disrupt other Magic-Users by attempting to
counter their spell. Casters can attempt to counter any type of Magic-User
spell; however, they get a -1 penalty when countering spells of a different type
than their own (if there are different types).

The moment that a spell is cast, any caster within range (10 feet per level) and
who has not yet acted that round may abandon their planned action to try to
counter the spell. In order to succeed the countering caster must make a save vs
spells at a cost of 3 + the level of the spell being countered in HP. Before
rolling they may choose to use their magical energies to improve their chances
of success: for each additional 2 HP spent, their roll gains a +1 bonus.

If a Magic-User was casting a spell and stops doing so to counter a spell, the
spell the Magic-User interrupted to counterspell costs the caster 50% of the
normal casting cost in HP.

#### Metamagic (Optional)

Magic-Users and Clerics may select one metamagic ability from this list at
levels 3 and 6. A spell with metamagic abilities applied is cast at a higher HP
cost: the standard HP cost for the spell plus the HP cost for all metamagic
being applied to the spell. The Referee has the final say as to what metamagic
effects do or do not make sense to use with a particular spell. Multiple
metamagic effects can be applied to a single spell; however, each metamagic
effect after the first adds an additional +1 to the HP cost of the spell.

*Empower Spell* - All variable, numeric effects of an empowered spell are
increased by one-half. Saving throws and opposed rolls are not affected, nor are
spells without random variables. An empowered spell adds +4 to the HP cost of
the base spell.

*Enlarge Spell* - You can alter a spell with a range of close, medium, or long
to increase its range by 100%. Spells whose ranges are not defined by distance,
as well as spells whose ranges are not close, medium, or long, are not affected.
An enlarged spell adds +2 to the HP cost of the base spell.

*Extend Spell* - An extended spell lasts twice as long as normal. A spell with a
duration of concentration, instantaneous, or permanent is not affected. An
extended spell adds +2 to the HP cost of the base spell.

*Widen Spell* - You can alter an area shaped spell to increase its area. Any
numeric measurements of the spell’s area increase by 100%. A widened spell adds
+6 to the HP cost of the base spell.

Many spells are greatly facilitated by the odd bit of eye of newt, bat guano and
sulphur, glass rods, holy incense or sacred mistletoe. Casting a spell with
material components in hand reduces the HP cost of a spell as much again as does
having an implement (to a minimum of 2).

#### Material Components (Optional)

Components for a 1st level spell cost 1 GP, for a 2nd level spell cost 5 GP, for
a 3rd level spell cost 10 GP, for a 4th level spell cost 25 GP, for a 5th level
spell cost 75 GP, and for a 6th level spell cost 250 GP. Some spells have
components that cost a lot more, while some have comparatively cheap ones, so
treat this amount as an abstracted average.

*Notes for the Referee:* Replacing the “Vancian” fire and forget magic system
with some form of spell point system (where spell casting characters have a
number of spell points and expend some of those spell points to cast a spell
instead of forgetting the spell when cast. Most of these systems actually
increase the power of spell casters. This system uses hit points for spell
points therefore stays much closer to the power level of spell casters in the
original rules. While this rule can be used alone, it works best if the optional
Hit Points and Wound Points rule is also used.

### Magical Research

#### General Rules for Research

At some point a Magic-User or Cleric may wish to start creating magic items or
inventing spells. This is termed magical research. For any research, Magic-User
must have a tower or laboratory, while a Cleric requires a properly consecrated
temple or church of his or her faith. In addition, there will be a cost for the
creation of each item, a minimum time required to create it, and a given chance
of success. If the roll fails, generally the time and money are wasted and the
procedure must be started again from the beginning; however, consult the
detailed rules below for exceptions.

*The Referee may want to make this roll in secret.* There are many situations
where the character (or the player) should not know whether the roll has
actually failed, or whether the Referee has decided the research is impossible
for the character. The Referee may decide to tell the player that the research
is impossible if the roll succeeds; if the roll is a failure, that is all the
player should be told.

In general, Clerics may only create magic items reproducing the effects of
Clerical spells; Clerics may also make enchanted weapons and armor, even those
sorts which they may not use themselves (since they may be creating weapons or
armor for other followers of their faith). Magic-Users may create any sort of
magic item except for those reproducing Clerical spells for which no equivalent
Magic-User spell exists.

Time spent doing magical research must be eight-hour workdays with interruptions
lasting no more than two days. Longer interruptions result in automatic failure
of the project.

The Referee may, if he or she so desires, grant Experience Points to characters
who successfully complete magical research. It is suggested that the rate of
such awards be 1 XP per 10 gp spent on the research. This award may be granted
for all research, or only for creation of magic items, or not at all if the
Referee prefers to emphasize adventuring for advancement purposes.

#### Spell Research

Researching new spells is the most common type of magical research. A Magic-User
may research a standard spell, removing the need for a teacher or reference;
alternately, a Cleric or Magic-User may research an entirely new spell. Of
course, no character may invent or research a spell of a level higher than he or
she can cast.

If the character is inventing a spell outright, the Referee must determine the
spell's level and judge whether or not the spell is possible “as is.” The
Referee does not have to tell the player whether the spell is possible, and in
fact this may be preferable.

The cost to research a spell is 1,000 gp per spell level for “standard” spells,
or 2,000 gp per spell level for newly invented spells; in either case, one week
is required per spell level to complete the research. The chance of success is
25%, plus 5% per level of the character, minus 10% per level of the spell; the
maximum chance of success is 95%

If the research roll is successful, the character may add the spell to his or
her spellbook (if a Magic-User) or may subsequently pray for the spell (if a
Cleric). On a failure, the money and time are spent to no avail. Clerics of the
same deity, faith or ethos may teach each other the prayers required to access
new spells; this takes one hour per spell level. The procedure to exchange
spells with other Magic-Users between Magic-Users is up to the Referee. (See the
Acquiring Spells optional rule for a suggestion).

As mentioned above, the Referee may decide that a proposed new spell is not
“correct” for his or her campaign; too powerful, too low in level, etc. Rather
than tell the player this, there are two strategies that may be used.

First, the Referee may decide to revise the spell. If the roll is a success, the
Referee then presents the player with a revised writeup of the spell, adjusted
however the Referee feels necessary for game balance purposes.

The alternative, more appropriate when the Referee believes the spell should be
higher level than the player character can cast, is to make the roll anyway. If
the roll fails, that is all the player needs to know; but if it succeeds, the
Referee should then show the player the revised version of the spell and explain
that the character may try again when he or she attains a high enough level to
cast it. In this case, the Referee may allow the character to reduce either the
time or the cost by half when the research is attempted again at the higher
level.

#### Magic Item Research

Any character who wishes to create magical items must know all (if any) spells
to be imbued in the item. Items that produce effects not matching any known
spell may require additional research (to devise the unknown spell) if the
Referee so desires.

Some magic items require one or more special components that cannot usually be
bought. Special components can only be used once on such a project. For example,
the Referee might require the skin of a displacer to create a cloak of
displacement, or red dragon saliva to create a wand of fireballs. Note that
there are specific rules for components under Other Magic Items, below.

Special component requirements are entirely at the option of the Referee, and
are usually employed to slow the creation of powerful magic items that might
tend to unbalance the campaign. It's also a good way to lead the spellcaster
(and his party) into dangerous adventures.

##### Chance of Success

Unless given differently below, the base chance of success creating a magic item
is 15% plus 5% per level of the spellcaster, plus the spellcaster's full
Intelligence (if a Magic-User) or Wisdom (if a Cleric). Thus, a 9th level
spellcaster with a 15 Intelligence has a base chance of 75%.

##### Spell Scrolls

A spellcaster may create a scroll containing any spell he or she has access to
(for a Magic-User, spells in his or her spellbook; for a Cleric, any spell the
character might successfully pray for). The cost is 100 gp per spell level, and
the time required is 1 day per spell level.

Reduce the chance of success based on the level of the spell being inscribed, at
a rate of -10% per level.

If the roll fails, the enchantment of the scroll has failed; however, if the
caster tries again to inscribe the same spell, either the cost or the time is
reduced by half (at the character's option).

##### Other Single-Use Items

Scrolls (other than spell scrolls), potions, and a few other items (such as the
rod of cancellation) are single-use items. These items may be created by
Magic-Users or Clerics of the 7th level or higher.

The chance of success is as given for scrolls, above, when the item being
created reproduces a known spell (or when the Referee decides a spell must be
created, as described above). For other types of items, the Referee should
assign a spell level as he or she sees fit, and the cost and time required is
doubled (making up for the spell research or knowledge required for
spell-reproducing items). The time required is one week plus one day per spell
level (or equivalent), and the cost to enchant the item is 50 gp per spell
level, per day.

Potions are a special case; the character creating a potion may create a large
batch, consisting of several doses, which may be bottled in separate vials or
combined in a larger flask. For each additional dose created at the same time,
reduce the chance of success by 5% and increase the time required by one day.
Note that increasing the time required will directly increase the cost. If the
roll to create the item fails, the entire batch is spoiled.

##### Permanent Magic Items

Creating permanent magic items (rings, weapons, wands, staves, and most
miscellaneous magic items) requires a Magic-User or Cleric of the 9th level or
higher.

When enchanting an item with multiple abilities, each ability of the item
requires a separate roll for success; the first failed roll ends the enchantment
process. Such an item will still perform the powers or effects already
successfully enchanted into it, but no further enchantment is possible.

Permanent magic items, including weapons (described in detail below), must be
created from high-quality items. The cost of such items will generally be ten
times the normal cost for such an item.

##### Enchanting Weapons

The base cost of enchanting a weapon or armor is 1,000 gp per point of bonus.
For weapons with two bonuses, divide the larger bonus in half (don't round) and
add the smaller bonus; thus, a sword +1, +3 vs. dragons would cost 2,500 gp to
enchant. Enchanting a weapon takes one week plus two days per point of bonus;
thus, the sword described would require twelve days to enchant.

Reduce the chance of success by 10% times the bonus; so, a sword +1 would reduce
the base chance 10%, while the sword +1, +3 vs. dragons described above would
reduce the base chance 25%. Further, the chance of success may be increased 25%
by doubling the cost and time required (this decision must be announced before
the roll is made).

For weapons having additional powers, combine the rules above with the rules for
creating permanent items. All enchantments must be applied in a single
enchantment “session.”

##### Other Magic Items

Magic items can have several features. Each feature added to a magic item
increases the cost and the time required, and decreases the chance of success.
The features are as follows:

**Creates a spell or spell-like effect**: This is the basic feature of all
non-weapon magic items. The base cost of this enchantment is 500 gp per spell
level; time required is five days plus two days per level. If the magic item has
multiple spell or spell-like effects, add the cost and time figures together.
The chance of success is reduced 5% per spell level.

**Has multiple charges**: This includes, of course, wands and staffs, but
several other magic items would also have charges. Each spell or spell-like
effect normally has a separate pool of charges (but see next). The table below
shows the various maximum charge levels and the associated cost, time and chance
adjustments:

| Charge Level | Cost per Charge | Charges per Day | Chance |
|--------------|-----------------|-----------------|--------|
| 2-3          | \+150 gp        | 1               | \- 5%  |
| 4-7          | \+125 gp        | 2               | \- 10% |
| 8-20         | \+100 gp        | 3               | \- 20% |
| 21-30        | \+75 gp         | 4               | \- 30% |

When using the table above, don't count the first charge for cost or time
purposes. Note that each separate pool of charges in the item must be figured
separately.

**Item can be recharged:** Figure the additional cost and time, and the penalty
to the chance of success, for rechargeable items as being exactly twice the
figures from the table above; so, creating a rechargeable item with 3 charges
costs 600 gp more rather than 300 gp more, and takes two days per charge (or
four extra days); the chance of success is lowered 10% rather than 5%.

**Item recharges itself:** Creating a self-recharging item is expensive; apply
the following adjustments to the charge cost, time and chance for items that
recharge automatically. Note that self-recharging items are never “rechargeable”
in that they may not be recharged other than by themselves.

| **Charging Rate** | **Cost** | **Time** | **Chance** |
|-------------------|----------|----------|------------|
| 1 per day         | x 3      | x 2      | \- 10%     |
| All per day       | x 5      | x 3      | \- 30%     |
| All per week      | x 4      | x 2      | \- 20%     |

  
**Charges are generic:** This means that all the effects of the item draw power
from the same pool of charges; most Magic-User staffs are in this category.
Items with generic charges are automatically rechargeable; don't apply the
normal adjustments for this feature. Instead, combine the normal costs for the
charge pools of each effect (which must all have the same number of charges),
and then divide the charge cost, time and chance adjustments by two. Thus, two
effects sharing one pool costs the same as a single effect with a single pool.

**Item may be used by any class:** By default, magic items may only be used by
the class that created them; so a wand of fireballs is normally usable only by
Magic-Users, or a staff of healing only by Clerics. This feature allows the item
to be used by any class of character, and involves assigning simple command
words and gestures to the item. Adding this feature costs 1,000 gp per effect.
Note that all the item's effects do not have to be covered; it is possible to
create an item where some effects may be used by any class, but other effects
may only be used by the creator's class.

**Item operates continuously or automatically:** This feature supersedes both
the charges and item use features. The item works whenever properly worn, or
activates automatically when required. A ring of fire resistance is a good
example; also, the ring of invisibility is in this category. Adding this feature
multiplies the final cost and time figures by five and applies a 40% penalty to
the chance of success.

Each feature above applied to a magic item will require a valuable, rare and/or
magical material to support the enchantment. For example, a wand of fireballs
has a spell effect that is powered by charges; these are two relatively ordinary
features, so the Magic-User creating the item proposes a rare wood for the shaft
and a 1,000 gp value ruby for the tip. The Referee may, of course, require
something more rare or valuable if the magic item is particularly powerful.

The base cost of a spell effect feature can be reduced by 25% by applying limits
to the ability. For example, a ring of charm dryad is an example of limited
charm person spell effect, which would qualify for the deduction. This does not
affect the chance of success or the time required.

Weapons which are to be enchanted with additional powers other than the normal
bonus require combining the standard weapon enchantment rules with the rules
given above. Perform the weapon enchantment first; if it is successful, then the
character enchanting the weapon must immediately (within two days, as previously
explained) begin the spell or spell-like power enchantment process. Failure of
the second procedure does not spoil the weapon enchantment.

##### Cursed Items

Some cursed items, such as cursed scrolls, are created that way specifically by
the spellcaster. The difficulty of creating such an item is roughly the same as
the difficulty of creating a spell scroll of **bestow curse**.

Other cursed magic items may be the result of a failed attempt to create a
useful item. The Referee must decide whether or not a failed research project
will actually create a cursed item.

*Notes for the Referee:* The Original Edition is provides limited guidance on
magical research. This optional rule provides one way to handle magic research.
The costs in time and gold are based on an “average” campaign. If these costs
seem too low (or too high) for your campaign, adjust them to fit your campaign.

### Mana Powered Magic

All spellcasters have a pool of mana points that they use to cast spells. The
maximum mana a character has is equal to the total levels of spell the caster
could memorize each day under the standard Original Edition rules. For example,
a 5th level magic-user would start the day with 11 mana points (4 x 1 for their
first level spells, 2 x 2 for their second level spells, and 1 x 3 for their
third level spell).

Spell-casters memorize spells as usual, but do not forget spells when cast.
Spells cost a number of mana points equal to their level to cast. Spells cannot
be cast if the spellcaster does not have enough mana remaining in their pool to
cat the spell. Optional: A spellcaster may cast a spell they know but do not
currently have memorized by spending double the mana points to cast the spell.
For example, casting a second level spell the caster knows but does not
currently have memorized would cost 4 points of mana (instead of the normal 2
points).

A full night’s rest will restore a caster’s mana pool to their mana maximum.
Interrupted sleep will only restore 50% of the caster’s mana maximum (round
down). Note that unused mana from the day before does not disappear so that if
our 5th level had 3 mana points left in their pool at the end of the day, but
their sleep was interrupted by an attack on their camp, the caster would regain
6 mana points giving him a total mana pool of 9 (instead of 11) the next
morning. Rest will never boost a character’s mana pool above their mana maximum.

Optional: Instead of calculating the mana maximum from the number and level of
spells the character can memorize, calculate the mana maximum by totaling up the
caster’s levels. For example, a third level magic-user would have a mana maximum
of 6 (1 + 2 + 3) while a fifth level cleric would have a mana maximum of 15 (1 +
2 + 3 + 4 + 5).

*Notes for the Referee:* Spell point systems have always been popular with a
certain segment of Players and Referees. Spell Point systems generally make
casters more powerful at lower levels and somewhat less powerful at higher
levels. This system is no exception. (For an exception, see the optional rule
for Hit Point Powered Magic.) This system is simple to use, however.

### Preparing Spells from Memory

Sometimes a Magic-User will want to prepare spells, but his or her spellbook may
be unavailable; this includes when the book has been destroyed or stolen as well
as times when the Magic-User has been captured or trapped. A Magic-User may only
use this procedure to prepare spells that they know (i.e., have been recorded in
their spell books).

A Magic-User can always prepare read magic from memory. Other spells require a
save vs spells with the spell level as a penalty on the die roll.

Success allows the Magic-User to prepare the spell, adding to their memory just
as if they were studying the spell in their spell books. Failure exhausts the
spell slot being prepared, just as if it had been successfully prepared and then
cast; so if a 5th level Magic-User attempts to prepare fireball from memory, and
fails, he or she will have no third level spells for the day.

Optional: A failure stresses the Magic-User’s mind. After two failures in a day,
the Magic-User may not attempt to prepare any more spells until they have rested
for a night.

*Notes for the Referee:* A Magic-User without spells is even weaker than normal.
This rule allows Magic-Users who does not have their spell books available to at
least attempt to prepare spells. It does not really increase the power of
Magic-Users. It just makes it harder to leave them completely without access to
spells.

### Spellcasting as a Skill

Magic-users, clerics and other spell casters don’t memorize spells and forget
them when they cast them. Instead, they select a number of spells, from their
available spells, equal to their Level +3 (note that if they have less available
spells than this, they are stuck with what they have, no spell can be selected
more than once). Note that a caster may not memorize a spell of a spell level he
could not cast at his level under the standard rules

Every time they wish to cast a selected spell, they must roll a D20, add their
attribute modifier (INT for magic-users, WIS for clerics) and one-half their
level (rounded up), against a Target Number of 10 + the level of the spell being
cast. If they equal or beat the Target Number the spell succeeds. If they roll
lower than the target number, the spell fails and they cannot cast that
particular spell again that day.

*Optional:* Add +1 to the casting roll for every full round spent casting the
spell, to a maximum bonus of the caster’s level.

*Notes for the Referee:* This optional rule makes spell casters less reliable as
casting spells will no longer be automatically successful, but so long as they
do successfully cast a spell, they will retain in in memory. If you use this
optional system, you may need to adjust the number of spells casters can
memorize to fit your campaign. The number in the rule works well in a campaign
where magic is not as common as it is in a campaign using the standard rules;
for example, a swords and sorcery setting.

### Common Magic (Sorcery)

Some campaigns may need weaker, but more common, magic. Such campaigns may
remove the Magic-User class and have a set percentage of intelligent being (of
some or all species) possess the power of sorcery. Such beings are known as
sorcerers. Assume all player characters and major NPCs are among those able to
do so. Common magic gives every sorcerer at these abilities: Sorcerous Casting,
Sorcerous Blast, and Sorcerous Dueling. If the Referee uses it in their
campaign, sorcerers will also have the Sorcerous Rituals ability.

Common Magic requires using the Mana Powered Magic Optional rule (using the
optional rule for calculating mana by totaling levels).

#### Sorcerous Casting

Sorcerers can cast minor "everyday/non-combat" spells at will. Basically, any
everyday thing someone could do mundanely that does not cause harm to another
being, a sorcerer can do with a minor magic spell. Attempting something the
Referee considers abusive fails and causes the sorcerer’s wand to explode (doing
1d6 backfire damage to the sorcerer unless a save vs spells is made). Usable
once per round if no other action taken. Requires waving a handmade wand. There
is normally no cost to cast magic, however, the Referee may rule that more
powerful effects cost 1 mana point per use.

Some examples: Light a candle or pipe with a flame from the wand tip. Dust
things – at first level a minor magic spell might be needed for each shelf or
piece of furniture, while at third level a single spell might dust a room and at
sixth level the magic-user's the entire floor of a house or tower. Tie or untie
a knot. Float coins from the magic-users coin purse to a merchant's hand. Open a
cabinet. Mix drinks. Dress/undress.

#### Sorcerous Blast

A sorcerer can shoot a dart of magic energy from the tip of their handmade wand
once per round provided no other action is taken. They must roll to hit the
target normally. Range: short 60; medium 120; long 180. Usable once per round if
no other action taken and does 1d6 damage if it hits. No saving throw is
allowed. Requires pointing a handmade wand at the target and costs 1 Mana point
per use. The visible effects can be whatever the sorcerer desires; note that
this does not affect damage, it only adds color to the ability.

#### Sorcerous Dueling

By forgoing their action on their turn, a sorcerer can engage another sorcerer
in a Sorcerous Duel.

On each of their turns, both combatants roll a d20 and add their level plus
their INT bonus - whoever scores higher wins that round. Each round costs the
combatants 1 mana point, and the winner of the round inflicts their level in HP
damage to their opponent. A draw roll means both neither opponent takes HP
damage. An opponent can leave a duel at any time, but takes the opponent's level
as damage (as though they had scored a successful hit) as they exit the duel.

Both players and Referees should make their descriptions vivid and entertaining
- but appropriate to the level of the combatants. A 1st-level PC and a Kobold
Shaman will be throwing sparks and stings at each other, while 10th-level PCs
and demigod wizards will have battles that look more like Rush album covers.

#### Sorcerous Rituals

A sorcerer may attempt to force magic to do his will on a large scale through a
magic ritual. The player will describe the desired results of the magic and the
Referee will work with the player to refine those desires into something that
will work in the campaign. They will then give the player the requirements that
must be met to perform the ritual.

Most rituals will require 2 or 3 (or more) of the following:

-   *Special Item:* An ancient tome, heavy tablet or delicate scroll is
    required, and the item will prove difficult to obtain. It is rare, held in a
    distant land, etc.

-   *Rare Ingredients:* An expedition is required to locate the necessary items
    to perform the magic.

-   *Permanent Focus:* The sorcerer must undertake ritual tattooing to
    permanently inscribe the details of the ritual on his or her person in runes

-   *Preparation Time:* The ritual will take at least 2d6 days of meditation,
    chanting, dancing, and other preparations just before the ritual is
    performed.

-   *Ritual Sacrifice:* An animal (of at least the size of a lamb) must be
    sacrificed during the ritual.

-   *Lunar Timing:* The spell may only be cast during a specific phase of the
    moon

-   *Personal Ordeal:* The sorcerer must fast for 2d6 days

-   *Wounds:* The sorcerer suffers their level in d6 damage when the ritual is
    cast.

If the ritual is extremely powerful (e.g., causing a “natural” disaster, a
terrible curse spanning generations, summoning a demon prince, etc.), the
Referee should also select 1 or 2 of the following requirements for the ritual:

-   *Ritual Sacrifice:* One or more sentient beings meeting specific
    requirements must be slaughtered in a specific way during the ritual

-   *The Stars are Right:* The ritual may only be performed when the necessary
    stars and planets are correctly aligned.

-   *Place of Power:* There is only one place known where this ritual may be
    performed.

-   *Horrific Wounds:* The sorcerer suffers twice their level in d6 damage when
    the ritual is performed.

-   *Multiple Rituals:* A series of rituals is required. Each ritual has its own
    requirements and must be performed in the correct order and at the correct
    times.

Once all the requirements are met, the ritual may be performed. A ritual will
take 2d6 hours to perform and any significant interruption will ruin it, causing
it to automatically fail. All sorcerers involved in the ritual must spend all
their mana at the start of the ritual to perform it. At the end of the ritual,
the sorcerer must make a successful save versus spells for the ritual to be
successful. Every additional sorcerer participating in the ritual (up to a
maximum of six) adds +1 to the roll. If the ritual fails, all sorcerers involved
in the ritual must save vs death or be incapacitated for 1d6 days.

Notes for the Referee: Common Magic is only useful for certain campaign
concepts, where magic is much more common (but much weaker) than what is normal
for an Original edition campaign. Allowing Sorcerous Rituals will increase the
power again, but Sorcerous Rituals are generally not immediately helpful and can
be costly in time and money to use (and those costs are completely under the
Referee’s control.

Optional General Rules
----------------------

### Action Points

All characters have 1 action point per character level. Actions points may be
used to simulate a heroic effort by a character or to simulate a lucky break.
Action Points recover 1 per day of total rest in safe surroundings.

*Heroic Effort:* Each action point spent on heroic effort allows the player to
roll a 1d6 and adjust any single die roll affecting the character or made as a
result of the character’s actions in the character’s favor by the amount rolled.
The action point must be expended before the die roll to be adjusted is made.

*Luck:* Spending one action point for luck will cause a minor bit of good luck
to come the character’s way. Spending two action points for good luck will cause
a major bit of good luck to come the character’s way. In both cases, the Referee
decides exactly what the good luck is, but it should be helpful in a minor/major
way to the character’s immediate situation.

*Shake Off Fatigue:* Recover half your lost hit points instantly. This counts as
an action.

*Strike Now:* The character can take his action right now instead of waiting for
his normal turn to act to come up. This cannot be used to cast a spell over 3rd
level.

*Try Again:* Spending two action points allows the character to try any roll
again that he has failed. The character must abide by the result of the second
roll even if it is worse than the first roll. This simulates the character
realizing he is failing and putting everything he has into turning failure into
success.

*Notes for the Referee:* Action points are a way for players to avoid or lessen
the effects of truly disastrous die rolls at critical points or to have
something lucky/helpful happen by “chance.” While some think they go against the
“let the dice fall where they may” old school attitude (and to some extent they
do), in reality they turn out to be just another very limited resource for
players to manage, which is a very old school thing. If your players complain
about bad rolls to the point they are annoyed with the game, adding action
points might be something to consider. You can reduce the number of action
points characters receive for less heroic campaigns (e.g., gain 1 action point
every 2nd level instead of every level).

### Aspects

Aspects are non-mechanical parts of a Character that a player wants to
mechanically influence the game. An epithet, quote, relationship, possession, or
anything else can be an Aspect. Characters start with one Aspect in the 1st
Level and gain an additional aspect every 3rd level (at level 4, 7 10, etc.).
For each Aspect, a player gets an Aspect Point (often measured with a poker chip
or other counter) at the beginning of each session. At any time during the
session, the player may invoke an Aspect prior to any die roll by describing how
it comes into play and spending an Aspect Point, thereby gaining a +4 to the
roll. The Referee may also invoke a Character's Aspect (called a “compel”) for a
-4 to the roll. The player may refuse a compel at the cost of one Aspect Point;
if the player accepts a compel, he gains one Aspect Point.

*Notes for the Referee:* Aspects are popular feature from another RPG. This rule
allows the limited use of aspects in Original Edition games without allowing
them to take over the game or to have the silly effects (for example, being
pitch black in the middle of the night has no effect on events unless someone
spends a point to invoke the “darkness” aspect as is true in some games which
use aspects).

### Attribute Throws

When a character attempts to do something not covered by a guideline in the
rules and which would not simply be automatically successful, the Referee may
ask the character to roll against the attribute the Referee decides the action
falls under. The player rolls a D20 and the action is successful if the roll is
less than or equal to the character’s attribute. The Referee may assign
modifiers to the roll.

Options:

-   For exceptionally difficult actions, the Referee may ask for a roll against
    one-half or even one-quarter of the attribute score (round up).

-   If the quality of success is important, the higher the roll (while still
    under the attribute value), the better quality the success. A roll exactly
    equal to the attribute is a critical success.

*Notes for the Referee*: While some do not like this method of determining
success (generally because attribute values can vary greatly from one character
to another), this method of determining success or failure of actions that do
not have any other resolution procedure has been used successfully in many
campaigns for many years. It is simple and easy to modify as needed.

### Avoiding Save-or-“Die”

There are a number of effects which cause the character to be taken out of play
permanently or for a long period of time unless a saving throw is made (e.g.,
instant death, turn to stone, etc.). If this standard rule seems too harsh, try
the following instead. If a character fails a save-or-“die” roll, the negative
effect happens immediately but it can be reversed if the character receives 5
minutes of careful care in a non-combat environment starting within a number of
minutes/melee rounds equal to the affected character’s STR stat. The Referee may
rule that certain issues still require further treatment within 24 hours or the
effect recurs (e.g., poison must still be neutralized) or may not be handled
this way at all.

*Notes for the Referee:* Like level drains, some groups simply abhor “save or
die/suck” effects. This rule will make them less severe without eliminating them
completely, however, while it makes it easier for the characters to survive it
also makes it easier for opponents to survive which may warp the “balance” of
some encounters in published old school adventures.

### Contest of Skills

A contest of skills is handled similar to combat, except the opponents aren’t
trying to kill one another; they are trying to defeat their opponent with their
skills. Like in a combat, opponents in a contest of skills make an initiative
roll for each round to determine who "attacks" first in the round. Instead of
making a roll of attack bonus vs. Armor Class, each contestant makes the
appropriate skill roll based on his class and background. If the attacker’s
result is equal or higher than the defender’s result, he causes “skill damage”
equal to 1d6 + stat bonus of the stat used by the skill. Skill Damage is removed
from a set of Contest Points. At the beginning of the contest, each contestant's
Contest Points which are set equal to the score of the stat used by the skill
plus the character's level. When a character’s Contest Points fall to 0 (zero)
or less, the contest of skills is over, and the loser is defeated (knocked
unconscious, humiliated, loses the bet, etc.). Contest Points cannot normally be
increased during a Contest of Skills – unless someone successfully cheats.

*Notes for the Referee:* This is a simple system that can be used to resolve
non-lethal competitions between characters (boxing matches, card games, poetry
writing contests, etc.) It plays fairly fast but usually takes more than a
single die roll for more suspense while taking into account differences in skill
and level between characters.

### Death and Dying

When a monster or minor NPC is reduced to zero hit points, they are dead. When a
player character or major NPC is reduced to zero hit points, they are
unconscious and are unable to act in any way. This is referred to as being “Out
of Action”. When the fight is over or they are out of danger, a character who
was taken out of action can roll on the Death and Dismemberment Table below to
see what happens to them. If they survive, they immediately gain 1d6 hit points.

If an out of action character receives healing magic before rolling on the table
below and the magic restores at least 1 hit point, the character no longer is
out of action and no long needs to roll on the Death and Dismemberment table
below.

**Death and Dismemberment Table**

| **D6** | **Result**                                          |
|--------|-----------------------------------------------------|
| 1      | KO’d -- Just knocked out.                           |
| 2      | Scar -- Just Knocked out and gains a new scar.      |
| 3      | Impaired -- -2 on all D20 rolls for 2d4 hours       |
| 4      | Injured -- -2 on all D20 rolls for 2d3 days         |
| 5      | Crippled – STR or DEX is permanently reduced by 1d3 |
| 6      | Killed – Character is dead.                         |

*Notes for the Referee*: This is a simple system for reducing the death rate of
characters while still having major consequences for dropping to zero hit
points. This system is much less complex than the Hit Points and Wound Points
optional rule. If characters are reduced to zero hit points without suffering
physical damage, the referee may choose to simply rule that they are just
knocked out without a roll on the Death and Dismemberment table.

### Deities and Divine Intervention

Characters will find it helpful to follow one of the gods. Although Clerics,
Druids, and Paladins have special access to the deities, other classes may
receive advice and assistance at times as well. A character may select any deity
(or pantheon in some campaigns) to follow from the campaign allowed by the
Referee.

**Divine Intervention:** Deities will occasionally assist their followers when
petitioned for aid. There is a chance of angering the deity and a strong
possibility that the deity will not deign to take an interest in mortal affairs
at that time. The petitioner may thus receive aid, suffer harm, or get no
response at all. Petitioning for divine intervention more often than once a week
results in automatic retribution.

Petitioning for divine intervention can be done at any time provided the
character is capable of thought. A d100 roll on the appropriate table using the
column for the characters level below will determine the result. Clerics add 5
to their level before consulting the chart.

**Greater Deity**

| **Result**   | **1-5** | **6-9** | **10-12** | **13-16** | **17+** |
|--------------|---------|---------|-----------|-----------|---------|
| Retribution  | 01-80   | 01-70   | 01-60     | 01-50     | 01-40   |
| No Effect    | 81-95   | 71-90   | 61-85     | 51-80     | 41-70   |
| Intervention | 96-00   | 91-00   | 86-00     | 81-00     | 71-00   |

**Major Deity**

| **Result**   | **1-5** | **6-9** | **10-12** | **13-16** | **17+** |
|--------------|---------|---------|-----------|-----------|---------|
| Retribution  | 01-70   | 01-60   | 01-40     | 01-30     | 01-20   |
| No Effect    | 81-90   | 61-80   | 41-70     | 31-60     | 21-50   |
| Intervention | 91-00   | 81-00   | 71-00     | 61-00     | 51-00   |

**Minor Deity**

| **Result**   | **1-5** | **6-9** | **10-12** | **13-16** | **17+** |
|--------------|---------|---------|-----------|-----------|---------|
| Retribution  | 01-60   | 01-40   | 01-30     | 01-20     | 01-15   |
| No Effect    | 61-85   | 41-75   | 31-65     | 11-55     | 16-45   |
| Intervention | 86-00   | 76-00   | 66-00     | 56-00     | 46-00   |

**Demi-God**

| **Result**   | **1-5** | **6-9** | **10-12** | **13-16** | **17+** |
|--------------|---------|---------|-----------|-----------|---------|
| Retribution  | 01-50   | 01-30   | 01-20     | 01-10     | 01-05   |
| No Effect    | 51-80   | 31-65   | 11-55     | 11-45     | 06-35   |
| Intervention | 81-00   | 66-00   | 56-00     | 46-00     | 36-00   |

Characters may make an offering to their deity before rolling for divine
intervention. All offerings musty be in the possession of the petitioner at the
time of the request (deities do not accept IOUs). This table lists the die roll
modifier for various types of offerings:

**Offering Modifiers**

| **Offering**                 | **Die Roll Modifier** |
|------------------------------|-----------------------|
| Treasure (1000gp)            | \+1                   |
| Each Potion                  | \+2                   |
| Magic Weapon/Armor           | \+Bonus               |
| Magic Scroll (per spell)     | \+2                   |
| Magic Ring, wand, or rod     | \+5                   |
| Magic Staff                  | \+10                  |
| Miscellaneous Magic item     | \+10                  |
| Minor Artifact               | \+15                  |
| Minor Artifact               | \+25                  |
| Accept Minor Quest           | \+10                  |
| Accept Major Quest           | \+20                  |
| Intelligent Being Sacrificed | \+Level or HD         |

Only evil deities accept the sacrifice of intelligent beings. A minor quest will
take 4 to 8 months. A major quest will take 1 to 3 years. The quest will be
imposed by the deity (and need not involve actual questing).

There is an additional modifier of -15 if the character does not regularly
donate at least 10% of income to the deity’s temple. Characters who ignore their
deity except when in need of help suffer a die roll modifier of -10 to -30 as
determined by the Referee.

If the result is intervention, the deity will do the minimum needed to answer
the request. For Demi-Gods, the maximum would be about the ability of a limited
wish spell. For Minor Deities, the maximum would be about the power of a single
wish spell. For Major Deities, the maximum would be about the about ability of
several wish spells. There is no effective limit for what Greater Deities can
do.

If the result is retribution, the petitioner takes his level in D6 of HP damage.

**Conversion (Optional):** Characters may not willingly change their allegiance
to another deity/pantheon except at a full temple of the new deity and then only
with a favorable reaction roll from the new deity’s priests (large donations to
the temple will give favorable modifications to the roll). Lay people accepted
by a new god must spend 1d4 weeks (at their own expense) at the temple learning
the basic rituals and dogma of their new faith before they can receive any
benefits from that faith. Clerics must spend 1d6 months (plus their level in
weeks) in such study before they can cast Clerical spells above 2nd level again.

**Spell Level Availability (Optional):** A character’s deity may limit the level
of spells the character may cast. If the character’s deity is a Demi-God, the
maximum level of Cleric Spells the character has access to is 3rd level. If the
character’s deity is a Minor Deity, the maximum level of Cleric Spells the
character has access to is 4th level. If the character’s deity is a Major or
Greater Deity, the maximum level of Cleric Spells the character has access to is
5th level. Spell slots for spells of a level the cleric cannot cast may be
filled by spells of a lower level which the cleric can cast.

**Special Spells by Deity (Optional):** Deities may not offer all of the
standard Cleric Spells to their clerics. They may simply not provide some of the
standard spells, substitute special spells for some of the standard spells, or
even add additional spells to the standard spells.

*Notes for the Referee:* Divine Intervention gives characters an expensive way
to try to get themselves out of extremely bad situations by paying for a
miracle. It doesn’t work all that often (especially for lower level characters),
but when it does it is often a memorable moment in the campaign. Note that
successful divine intervention need not be splashy and obviously “deities acting
in the world” if that is not suitable for the campaign. The spell options allow
easy customization of deities so that each deity has a somewhat unique list of
spells. The optional conversion rules make it easy to stop characters from
switching deities depending on their current needs.

### Disease

Diseases often come from monsters, such as mummies or giant rats, in which case
the chance of disease and its effects are described in the relevant creature
text. There are a few other instances where disease may be contracted that are
explained here.

First, plagues (such as the medieval bubonic plague or Black Death) may
occasionally spread across the countryside. A character who comes into contact
with plague will need to save against poison to avoid succumbing him- or
herself. If the character saves, any future saving throws against the same
disease will be made at +4. If he or she fails, then after an incubation period
of 2d8 days, he or she will suffer a penalty of -1d6 on all characteristics and
against all die rolls for the course of the disease, which lasts a further 2d8
days. If the disease duration roll was “8” then the character dies at the end of
this period, otherwise he or she recovers at the rate of 1 point less each day
until cured. Further saving throws against the same disease will be made at +4.

Second, certain wounds can become infected. This applies where the Referee feels
it appropriate, but generally where a character with an open wound engages in
high-risk activity such as exploring a sewer, a saving throw vs poison should be
required, or else the character will become infected. The effects of infection
in game terms are the same as plague, except that the onset time is measured in
hours rather than days.

*Notes for the Referee:* While disease from all sorts of things (e.g., wounds)
should be common in a realistic world, unless the campaign is extremely gritty
and grim disease should probably be much less common than in the real world.

### Encumbrance and Movement

A character’s movement rate is determined by how much gear he is carrying, or
how much he is encumbered. In the strictest sense, this should be determined by
adding up the weight of all the gear a character is carrying. Realistically, no
one keeps track of such things during a game. However, the Referee has the
authority to call an audit of a character’s inventory at any time, so players
should make sure that their character is carrying a reasonable amount of
equipment and that all of the equipment fits somewhere on the character or in a
pack. Worn items, such as cloaks, jewelry, backpacks, etc, do not themselves
count as items for encumbrance purposes. Carried sacks full of stuff count as an
oversized item. 100 coins count as one item.

| Character wearing chain armor\*                              | \+1 Point          |
|--------------------------------------------------------------|--------------------|
| Character wearing plate armor\*                              | \+2 Points         |
| Character is carrying 6 or more different items\*\* overall  | \+1 Point          |
| Character is carrying 11 or more different items\*\* overall | \+1 Point          |
| Character is carrying 16 or more different items\*\* overall | \+1 Point          |
| Character is carrying 21 or more different items\*\* overall | \+1 Point          |
| Character is carrying an oversized item                      | \+1 Point per item |

\* Armor only counts towards this category  
\*\* Multiple small items of the same type (spikes, arrows, etc) count as one
item for this purpose.

Worn clothing/armor/jewelry do not count for encumbrance purposes. All weapons
count as separate items. Very small single items do not count for encumbrance
purposes. Oversized items are counted separately.

Oversized items include great and other two-handed weapons, any item that
requires two hands to carry or is as tall as the carrying character.

| **Enc Points** | **Encumbrance**     | **Move Rate per turn** | **Move Rate Per Round Combat** | **Running per round** | **Miles per day** |
|----------------|---------------------|------------------------|--------------------------------|-----------------------|-------------------|
| 0 1            | Unencumbered        | 120’                   | 40’                            | 120’                  | 24                |
| 2              | Lightly Encumbered  | 90’                    | 30’                            | 90’                   | 18                |
| 3              | Heavily Encumbered  | 60’                    | 20’                            | 60’                   | 12                |
| 4              | Severely Encumbered | 30’                    | 10’                            | 30’                   | 6                 |
| 5 +            | Over encumbered     | 0’                     | 0’                             | 0’                    | 0                 |

For mounts, use the following: If an animal is pulling a cart or other vehicle,
the load of the vehicle (as per this scheme) is applied to the animal as well.
Multiple mounts pulling a vehicle divide the total encumbrance points between
them.

| For every human or dwarf riding the animal | \+5 Points (plus rider’s Enc level) |                        |                                |                       |                   |
|--------------------------------------------|-------------------------------------|------------------------|--------------------------------|-----------------------|-------------------|
| For every elf riding the animal            | \+4 Points (plus rider’s Enc level) |                        |                                |                       |                   |
| For every halfling riding the animal       | \+3 Points (plus rider’s Enc level) |                        |                                |                       |                   |
| Animal is wearing leather barding          | \+1 Point                           |                        |                                |                       |                   |
| Animal is wearing chain barding            | \+2 Points                          |                        |                                |                       |                   |
| Animal is wearing plate barding            | \+3 Points                          |                        |                                |                       |                   |
| Animal is pulling a vehicle                | \+5 Points per axle                 |                        |                                |                       |                   |
| Per 5 items the animal is carrying         | \+1 Point                           |                        |                                |                       |                   |
| A Teamster has packed the animal’s load    | \-5 Points                          |                        |                                |                       |                   |
| **Enc Points**                             | **Encumbrance**                     | **Move Rate per turn** | **Move Rate Per Round Combat** | **Running per round** | **Miles per day** |
| 0 – 10                                     | Unencumbered                        | 240’                   | 80’                            | 240’                  | 48                |
| 11 – 15                                    | Lightly Encumbered                  | 180’                   | 60’                            | 180’                  | 36                |
| 16 – 20                                    | Heavily Encumbered                  | 120’                   | 40’                            | 120’                  | 24                |
| 21 – 25                                    | Severely Encumbered                 | 60’                    | 20’                            | 60’                   | 12                |
| 26 +                                       | Over encumbered                     | 0’                     | 0’                             | 0’                    | 0                 |

Mules subtract five points from their encumbrance load but move at half the
listed speeds. Ponies move at the listed speeds but automatically start with 6
points of Encumbrance.

All per day travel distances include periodic rests. Characters apply their
Constitution modifier to their per-day travel distance on foot.

The movement rates shown on the table above are figured based on an 8 hour day
of travel on open road. The terrain type will alter the rate somewhat, as shown
on this table:

| **Terrain**              | **Adjustment** |
|--------------------------|----------------|
| Jungle, Mountains, Swamp | x 1/3          |
| Desert, Forest, Hills    | x ½            |
| Clear, Plains, Trail     | x 2/3          |
| Road                     | x 1            |

Bad weather also affects travel:

| **Condition**               | **Adjustment** |
|-----------------------------|----------------|
| High Winds or Precipitation | x ½            |
| Storm Conditions            | x 1/3          |

Characters may choose to perform a forced march, traveling 12 hours per day. If
this is done, add an additional 50% to the distance traveled. Each day of forced
march performed after the first inflicts 1d6 damage on the characters, and
inflicts this damage on animals from the first day. An animal that suffers 5 or
6 points of damage in this manner dies at the end of a day’s journey.

*Notes for the Referee*: Tracking encumbrance is an important part of the
Original Edition as current encumbrance determines movement speed and movement
speed in a major factor in exploration and running away. The Original Edition
encumbrance system is fiddly and is often handwaved or even ignored completely.
These optional rules are much less fiddly and don’t require an accountant to
track.

### Energy Drain

If the standard energy drain rule seems too harsh, try the following instead.
Each energy level drained subtracts one from any roll to which the character
would add his level (or his level/2). 1 point of energy drained is recovered
every L days where L is equal to the hit dice of the monster that drained the
energy level.

*Notes for the Referee:* Some groups loathe level draining to the point they
would rather lose a character than lose a level. These rules are somewhat less
harsh.

### Fame

A side-effect of adventuring is Fame: other people may recognize the character,
even if he would rather not be recognized. Fame is rated from 0 to 10.

*Gaining Fame:* All character start with a Fame (FAM) of 0 and FAM never goes
higher than 10. Each time a character goes on an adventure, the character adds 1
to his Adventure Total. When his Adventure Total is equal to (or greater than)
his current FAM +1, he rolls a d20 at the end of the adventure. If the roll is
higher than his current FAM, his FAM increases by 1 and his Adventure Total is
reset to zero.

*Using Fame:* Famous people might be recognized by others who see them, even if
they do not wish to be. When the Referee thinks a character might be recognized
by a stranger, he rolls a D20. If the result is less than or equal to the
character’s Fame, the stranger correctly recognizes the character. If the
character is disguised, the character will not be recognized. Characters who
wish to be recognized may drop their name or the like and force a Fame roll.

*Effects of Fame:* Reaction to being recognized will vary depending on what the
character has done. A mass murderer who is recognized will get a much different
reaction than the famous general who saved the country from invasion, for
example. If a character has been recognized, the Referee may adjust NPC
reactions accordingly.

*Notes for the Referee:* Fame is an abstract way to track how “important” player
characters are in the campaign. You may want to modify how Fame is gained and
used based on the needs of your campaign. NPCs can also be assigned Fame. If
characters recognize them, they should be told a bit about them as the NPC’s
fame means that his life is not as private as he might like.

### Feats

Feats are fairly unique special abilities that a character can use under
circumstances appropriate to the feat. There is no standard list of feats,
instead, players create feats for their character with the approval of the
Referee. Players and Referees should ensure that feats fit the character’s
class, background, and personality.

Fighters start with three feats and add another feat at levels 2, 4, 6, 8, etc.
Cleric and thief classes start with two feats and add another feat at levels 3,
5, 7, 9, etc. Magic Users start with two feats and add another feat at levels 3,
6, 9, 12, etc.

There are two standard types of feats. The Referee may create others or allow
feats that do not fit the standard on a case by case basis.

**Bonus Feats:** Bonus feats give a character a bonus equal to his level when
attempting certain actions under specific conditions. Use this template to
create a Bonus Feat:

Because I [describe some way that you are exceptional, have a cool bit of gear,
or are otherwise awesome], I get a bonus equal to my level when I [do something
that requires a roll] when [describe a circumstance].

Example Bonus Feats:

-   Because I am a smooth talker, I get a bonus equal to my level when I am
    trying to convince someone to help me when I’m in conversation with someone
    who is not hostile to me.

-   Because I am a famous duelist, I get a bonus equal to my level when I attack
    when engaged in a one-on-one swordfight with an audience.

-   Because I am an expert on lycanthropes, I get a damage bonus equal to my
    level when I attack a lycanthrope.

**Special Ability Feats:** Special ability feats allow a character to do
something cool or otherwise ignore the usual rules in some way. Use this
template to create a Special Ability Feat.

Because I [describe some way that you are exceptional, have a cool bit of gear,
or are otherwise awesome], once per game session I can [describe something cool
you can do].

Note: “once per game session” may be changed to some of similar rarity with the
permission of the Referee (see the third example below).

Example Special Ability Feats:

-   Because I am Well Connected in the Garvannic Empire, once per game session I
    can find a helpful ally in just the right place when I am in the Garvannic
    Empire.

-   Because I am always squirrelling away stuff I find, once per game session I
    may declare that I have an especially useful non-magical item that lets me
    easily bypass one obstacle.

-   Because I am a scholar, after researching a monster for one day per hit die,
    I know a way to defeat or constrain the monster without directly attacking
    it.

**Advanced Feats:** Referees may allow an advanced form of each feat which does
more when an Action Point is expended to power it. For example:

-   Because I am a famous duelist, I get a bonus equal to my level when I attack
    when engaged in a one-on-one swordfight with an audience. If I expend an
    action point to power this feat prior to the battle, even if I lose the
    fight the audience will consider me the “real winner” (because they think my
    opponent cheated, the fight was somehow fixed, etc.).

-   Because I am a smooth talker, I get a bonus equal to my level when I am
    trying to convince someone to help me when I’m in conversation with someone
    who is not hostile to me. If I expend an action point, my smooth spiel will
    even affect someone hostile to me.

The Referee has the final say as to whether a feat is acceptable in the game and
whether the current situation meets any situational requirements for a
particular feat.

*Notes for the Referee:* Feats are a popular (but often abused) method of
individualizing characters in modern versions of the world’s most popular
fantasy RPG. This optional rule module allows for this type of character
customization without long lists of feats. It also makes feats a definite extra
ability, not something one has to take to be allowed to do normal things any
character should be able to try to do. This system has been borrowed from
another popular game system. It adds some character customization at the expense
of additional complexity.

### Funerals & Tombs

The various gods of the dead look favorably upon a proper burial. Entombment in
a proper tomb with grave goods pleases him, and for this he grants a boon to the
deceased's heirs. In game terms, the true beneficiary of a fallen adventurer’s
heroic funeral is the player of the deceased character. His new character may
enter the game with experience points equal to 90% of the gold piece value of
money spent on the funeral and/or interred with his character (including the gp
value of any magic items interred). The new character should be a friend or
relation of the deceased, and is assumed to be guided and inspired by the spirit
of the slain.

A character can invest in building and furnishing a tomb during his life. This
was the custom of Pharaohs in ancient Egypt: The mighty lord would erect a
magnificent tomb (pyramid) during his reign in which to inter his embalmed
remains after his death. Such a burial would then ensure his heir ascended the
throne with the glory and might befitting a grand Pharaoh. In game terms, once
the character dies and safely sleeps in his tomb, the above rules apply to his
heir as well.

In campaigns using this optional rule, all members of cultures with such death
gods will hope/expect to be buried with at least some honors. The main effect of
this is that player characters will lose respect if they do not arrange funerals
for those who die in their employ. If a being’s body is completely destroyed or
cannot be recovered appropriate ceremonies and burial/entombment of goods will
still be expected, although the heir will only receive experience points worth
70% of the gold piece value of money spent on the funeral and/or interred with
his character (including the gp value of any magic items interred). However, the
heir will still receive 90% of the value of a tomb constructed for the character
during the character’s lifetime.

Should players abuse this rule by having their characters loot the tomb of a
deceased player character following his funeral (to get back the treasure they
interred therein), the curses and punishment of the gods of the dead will know
no bounds.

*Notes for the Referee:* This optional rule does several things. First, it takes
money and goods out of the campaign and rewards the characters (through their
heirs) for doing so. Second, it explains why there are all these ancient tombs
full of treasure in the land for the characters to find. Third, it allows a
player to start a new character when their previous one is killed with
experience points higher than 0.

### Hit Points and Wound Points

Replace the standard character damage and healing system with the following:

**Hit Points (HP)** Hit Points are an abstract measure of the amount of damage a
character can suffer before falling unconscious and taking severe injuries. If
Hit Points reach 0, the character is unconscious and begins to take severe
physical injury. Further damage, including any remaining points of damage the
attack that reduced hit points to zero, directly reduces Wound Points. Hit
Points represent stamina, luck, minor cuts and scrapes, etc. *Optional:* To
avoid confusion, “Hit Points” may be renamed “Fatigue Points.”

**Wound Points (WP)** All characters have Wound Points equal to their CON. If
Wound Points reach 0, the character is dead. Each two points of Wound damage an
Adventurer has suffered gives a -1 to all attack, success, saving, and similar
rolls. Except for important NPCs, monsters generally do not have Wound Points
and are therefore dead when their hit points reach zero.

*Critical Hits:* A natural attack roll of 20 (that would otherwise hit) is
automatically a critical doing maximum damage and doing a number of wound points
damage equal to the number of damage dice rolled (normally 1). Most monsters do
not have body points, so a critical hit will do maximum damage plus a normal
damage roll to them and cause them to lose their next attack.

*Recovering Hit Points:* All characters recover all hit points after six hours
of total rest. If a character has lost Body Points due to wounds, only 50% of
total hit points lost are recovered per six hours of rest.

*Healing Wound Point Damage:* Wound Points lost recover at a rate equal to the
character’s STR Bonus (minimum of 1 point regained) per full day of rest. If a
character with up to 50% Wound Point damage performs more than very light
activity or careful travel during a day, he has a 50% chance of losing an
additional Wound Point. If a character with more 50% of Wound Point damaged does
anything other than rest quietly in bed during a day, he has a 50% chance of
losing an additional Wound Point.

*Healing Magic:* Cure spells or their equivalent no longer affect hit points on
characters (but continue to do so on creatures who only have hit points). A Cure
Light Wounds (or equivalent) will cure 1d2+1 Wound Points. A Cure Serious Wounds
(or equivalent) will cure 3d2+3 Wound Points. In either case, 1 point will be
cured per 10 minutes of rest after the spell is cast (up to the maximum rolled),
if the rest in interrupted any remaining points of healing are lost.

*Spell Casting (Optional):* Casting a spell costs a spell caster hit points: 2
hit points to cast a spell of level 1 to 3, 2 hp to cast a spell of level 4 to
6, 3 hit points to cast a spell of level 7 or 8, and 5 hit points to cast a
spell of level 9. For 5 additional hit points, the caster may try to retrain the
spell in memory after casting it, doing so a successful save vs spells. Note:
The optional Hit Point Powered Magic rules are a replacement for this optional
rule.

*Bleeding (Optional):* A character who has been reduced to 0 hit points by
weapon or other trauma-related damage will eventually bleed out and die if their
wounds are not bound. A bleeding character must make a Save every minute or
suffer one body point of additional damage. Binding wounds takes 1 minute per
point of body damage taken, but no further bleeding rolls are needed (including
while the wounds are being bound). Any healing spell cast on a bleeding
character will effectively stop the bleeding.

*Second Wind (Optional):* Once per day, characters may regain 20% of their total
hit points (round up) by resting in a safe place for an hour while eating a
meal. This amount is reduced by 2 hp per point of body damage (to a minimum of 0
hp recovered).

*Monster Wound Points (Optional):* Wound Points should generally only be used
for player characters and important NPCs. However, if the Referee does not mind
the added complexity, monsters may have Wound Points as well. A monster’s Wound
Points are equal to twice the number of hit dice the monster has. This option is
not recommended as it adds a lot of almost pointless Referee bookkeeping to
every combat. If the Referee does not want to use this option, but still feels
that the addition of Wound Points gives player characters too much of an
advantage over monsters, the Referee may simply increase the hit points rolled
for monsters by the number of hit dice the monster has.

*Notes for the Referee:* The exact meaning and “realism” of hit points has been
an issue with some since the publication of the original game in 1974. This
optional system clearly distinguishes between actual wounds and other types of
damage and is also more “realistic” in that it provides negative effects for
actual wounds. However, it makes characters somewhat more capable as their hit
points are fully restored by a night’s sleep if they haven’t suffered any wound
damage. The optional monster wound points rule is not really recommended except
for Referees running adversarial campaigns.

### Insanity

Insanity is possible as a result of certain spells or monster attacks (or Sanity
loss if the optional Sanity Attribute rule is used). A character who becomes
insane will receive an insanity from the table below. The kind of insanity may
be decided by the Referee or rolled randomly.

| D100  | Insanity          |
|-------|-------------------|
| 01-06 | Agoraphobia       |
| 07-13 | Alcoholism        |
| 14-20 | Amnesia           |
| 21-26 | Anorexia          |
| 27-33 | Catatonia         |
| 34-40 | Claustrophobia    |
| 41-46 | Dementia          |
| 47-54 | Homicidal Mania   |
| 55-60 | Kleptomania       |
| 61-66 | Manic-Depressive  |
| 67-74 | Megalomania       |
| 75-80 | Paranoia          |
| 81-86 | Pathological Liar |
| 87-93 | Phobia            |
| 94-97 | Schizophrenia     |
| 98-00 | Suicidal Mania    |

**Agoraphobia**: The agoraphobic individual will not willingly venture outdoors
or into wide open spaces. If forced outside, the sufferer may (50%) become
violent.

**Alcoholism:** The alcoholic character requires strong drink every day, and may
become violent (50%) if this is denied. At least once a day, and every time
alcohol is available (such as when in the vicinity of a pub or tavern), the
character must have a drink. After drinking, there is a 3 in 6 chance that the
character will insist on a further drink. Such behavior will continue until the
character passes out.

**Amnesia**: Amnesia is most dangerous for spellcasters. Every time the
character attempts to cast a spell, there is a 50% chance that he or she will
find the spell gone from his or her memory, in which case it cannot be recalled
until the character memorizes it again. Special talents and proficiencies may
also be forgotten, although the character may re-roll to see if the talent or
proficiency is remembered each morning.

**Anorexia:** An anorexic character will refuse all forms of food or nourishment
and, if force fed, there is a 50% chance that he or she will induce vomiting.

**Catatonia:** The catatonic character loses volition and there is a 50% chance
that he or she will ignore any situation as irrelevant to him- or herself.

**Claustrophobia:** Particularly difficult in dungeons, claustrophobia is the
opposite of agoraphobia. The claustrophobic individual will not willingly
venture into enclosed spaces and will fight to escape them. If in an enclosed
space, there is a 50% chance that the sufferer will become violent. dementia:
The insane character loses 1d6 points each of intelligence, wisdom and charisma.

**Homicidal Mania**: The character has an insatiable urge to kill. The victim
must be of the same race as the insane character and normally (75%) of the
opposite gender. The must kill at least once a week until cured.

**Kleptomania:** The character has an insatiable urge to steal. The character
will take any opportunity to pocket a gem, coin or small magic item. If the
stolen objects are taken away from the character, there is a 50% chance that he
or she will become violent.

**Manic-Depressive:** During the manic phase (which lasts 2d6 days), the
character will become very excited about something—virtually anything will do.
The character will select a goal (which may be a very inappropriate one) and
focus totally on achieving it. Then there is an intermediary phase, which lasts
2d6 days, and a depressive phase, in which the character will always assume that
there is no chance of success. A depressive character will want to remain
indoors in a place of safety, and in bed if possible. The depressive phase lasts
2d6 days, followed by which there is another 2d6-day intermediary phase before
the cycle begins again.

**Megalomania:** The character will believe that he or she is the best—at
everything. He or she will demand to be leader of the party, will issue
peremptory orders to other party members, and there is a 50% chance that the
megalomaniac will become violent if these are not obeyed. Any suggestion that he
or she is not the leader and/or nor the best-qualified person for any particular
job will always result in violence from the megalomaniac.

**Paranoia:** Paranoia is very dangerous in adventuring situations. The paranoid
will believe that “they” are out to get him or her, and will suspect anyone and
everyone of working for “them”—particularly party members. The paranoid will
generally disobey orders and ignore suggestions on the assumption that they are
intended to cause the character harm. Eventually the character will flee his or
her group or normal social circle.

**Pathological Liar:** The pathological liar is concerned with deception, not
necessarily untruth. Thus, he or she is capable of telling the truth, but will
only normally do so if he or she will not be believed. Otherwise, the insane
character must respond to all questions with lies.

**Phobia:** The character suffers from a strong and completely irrational fear
of some substance, creature, or situation.

**Schizophrenia:** The character’s personality splits into 1d3 separate
personalities, each of which may have a different alignment or even class.
Typically, the personalities are not aware of each other.

**Suicidal Mania:** The character is driven to self-harm. He or she may never
flee from combat or any kind of dangerous situation. Faced with a pit or chasm,
the insane character must jump over it; faced with a chest, he or she must open
it; faced with an enemy, he or she must fight it, etc.

*Note for the Referee:* These guidelines are intended as a description of
insanity for gaming purposes. These descriptions are not accurate descriptions
of real world mental illnesses. The reality of mental illness is very different
to the discussion here. If a group in uncomfortable with specific insanities the
Referee should substitute something like the effects of a confusion, fear, or
feeblemind spell.

### Item Saving Throws

Items carried by characters or creatures may be damaged by various attack forms.
In general, if such a creature is not slain by the attack, its items should be
considered unharmed. Exceptions to this must be ruled upon by the referee; for
instance, a fire ball directed against a character with an unrolled scroll in
his or her hands should almost certainly destroy the scroll.

Items in the possession of characters or creatures slain by a powerful attack
may well be damaged or destroyed. Also, items not held by any character or
creatures, such as an open chest of treasure, might be subject to a variety of
destructive effects. In success cases, one of the following three methods may be
used to determine the effects on the affected items.

*Method 1:* Whenever characters (and NPCs) die from a particularly damaging
event, such as the fire breath of a dragon or the spell *fire ball,* all
ordinary possessions on a character’s body should be considered destroyed.
Magical items may not be destroyed, and are allowed saving throws of the
appropriate type for the attack based on the character’s saving throw. Items
that have bonuses will receive an equal bonus on the saving throw. For instance,
a +1 dagger receives a bonus of +1 to the roll.

*Method 2:* Make a roll in the kind of situation mentioned above, as well as in
situations when items are exposed to crushing damage (from falls), acid, or any
other event that could feasibly destroy them. The Referee will roll either 1d4
or 1d6, depending on the severity of the situation. Magic items have a chance of
surviving based on their relative power. For instance, a +2 shield would survive
on a roll of 1-2 on a d4 or d6. Items for which “pluses” do not apply can be
assigned a number between 1 and 3. Scrolls and potions may survive on a roll of
1 on a d4 or d6, a staff or wand may survive on a roll of 1-2; any other items
such as rings, rods, and other miscellaneous magical items are more durable and
survive on a roll of 1-3. If an item which has “pluses” is damaged, it may not
be destroyed outright, but may lose one “plus.” Thus, a +2 shield becomes a +1
shield on a failed saving throw roll.

The Referee should apply bonuses or penalties depending on the situation. If an
attempt is made to intentionally damage an item, there may be a penalty of 2 to
the roll. Bonuses may apply if an item is well protected. No penalty or bonus
should be more than 2.

Method 3: Cross-reference the principal or most vulnerable material the item is
made from against the type of attack, then roll a D20. If the number rolled is
equal to or greater than the number found on the table, the item has otherwise,
it is damaged or destroyed (at the Referee's option).

Jewelry damaged is usually reduced to 1d8 x 10% of its normal value; magic items
are almost always destroyed outright. Note also the detrimental effects of
destroying some magic items (the staff of power, for example, or even a simple
flask of oil if destroyed by fire).

| Material            | Fire | Cold | Lightning | Impact |
|---------------------|------|------|-----------|--------|
| Paper               | 19   | 2    | 16        | 4      |
| Fabric              | 16   | 2    | 12        | 3      |
| Glass               | 7    | 7    | 5         | 18     |
| Wood, Thin (Wand)   | 14   | 3    | 14        | 17     |
| Wood, Thick (Staff) | 11   | 2    | 11        | 14     |
| Metal, Soft         | 10   | 2    | 6         | 15     |
| Metal, Hard         | 14   | 2    | 2         | 8      |

Magic weapons or armor (and any other item having a "plus" value) add the lowest
applicable bonus to the die roll. For example, a Sword +1, +3 vs. Regenerators
adds just +1 to its saving throw. The referee may apply other adjustments,
either bonus or penalty, as he or she sees fit.

*Notes for the Referee:* These rules are optional because some players really
cannot stand the idea of losing a valuable item. Nevertheless, requiring item
saving throw really should be rolled – at a minimum -- when the character
carrying them is severely damaged by a method that likely would harm items.
However, the other end of the scale, requiring item saving throws very time that
anything happens that has even a remote chance of damaging an item is strongly
discouraged.

### Mooks (aka “Cannon Fodder”)

Sometimes a Referee may want to use a large number of monsters but not want to
carefully track each one. Mooks are “cannon fodder” monsters that have 1 hit
point per hit die, never make a saving throw, and always run away or surrender
if the battle is obviously going against them. Any hit from a PC or NPC (any
being with a class level) will likely kill a mook, therefore the Referee can
simply rule any mook hit is out-of-combat, either dead or unconscious. Mooks
cannot be told at a glance from normal (non-mook) monsters. Mooks make excellent
minions for powerful leaders as they are very effective against the normal
people in a campaign world even if they cannot stand long against PCs and NPCs
with class levels.

**Notes for the Referee**: This is a simple way to handle large groups of
monsters. Each monster has all its damage and special abilities and therefore is
still a large threat to normal people, they will just usually be knocked out of
combat with one blow for any being with a class level.

### Poison

This section describes different poisons that can be introduced into the
campaign. They are particularly important if the assassin class is in play, but
poisons can be used to make foes much more formidable or to add additional
dangers to dungeons through unlabeled and mysterious potions, or poisoned traps
and food.

#### Poison Basics

When a character takes damage from an attack with a poisoned weapon, touches an
item smeared with contact poison, consumes poisoned food or drink, or is
otherwise poisoned, he must make a saving throw versus poison. If he fails, he
dies or takes the poison’s damage. Even if he succeeds, he may face damage.

One dose of poison smeared on a weapon or some other object affects just a
single target. A poisoned weapon or object retains its venom until the weapon
scores a hit or the object is touched (unless the poison is wiped off before a
target comes in contact with it). Unless otherwise determined by Referee, any
poison smeared on an object or exposed to the elements in any way remains potent
until it is touched or used. Poisons are divided into four basic types according
to the method by which their effects are delivered, as follows.

*Contact (CT):* Touching poison necessitates a saving throw. It can be delivered
via a weapon or other physical attack. Even if the attack causes no physical
damage, the poison may affect the target. An object can be smeared with contact
poison as a trap.

*Ingested (IG):* Ingested poisons are virtually impossible to utilize in a
combat situation. It could be administered to an unconscious creature or someone
may be dupes into consuming something poisoned.

*Inhaled (IH):* Inhaled poisons are usually contained in fragile vials or
eggshells. They can be thrown as a ranged attack just as when throwing flasks of
oil. When it strikes a hard surface (or is struck hard), the container releases
its poison. One dose spreads to fill the volume of a 10’ cube. Each creature
within the area must make a saving throw. Holding one’s breath is ineffective
against inhaled poisons; they enter the body through the nasal membranes, tear
ducts, and other parts of the body.

*Injury (IN):* This poison must be delivered through a wound. If a creature does
not suffer damage from an attack, the poison does not affect it.

Traps that cause damage from weapons, needles, and the like sometimes contain
injury poisons.

The characteristics of poisons are summarized on the Poison Table. Terms on the
table are defined below.

*Class:* This is an abstract identifier for a specific poison. It does not
suggest anything about the ingredients, as any number of formulas might produce
similar effects.

*Type:* The poison’s method of delivery; contact (CT), ingested (IG), inhaled
(IH), or via an injury (IN).

*Save Adjustment:* Some poisons are weaker or stronger than others, and saving
throws are modified accordingly.

*Onset:* The amount of time it takes for the poison to take effect.

*Failed Save Damage:* The damage the character takes immediately upon failing
his saving throw against this poison.

*Save Damage:* The amount of hp damage the character suffers even if the save
versus poison succeeds.

*Price:* The cost in gp of one dose (one vial) of the poison. It is not possible
to use or apply poison in any quantity smaller than one dose. The purchase and
possession of poison is always illegal, and even in big cities it can be
obtained only from specialized, less than reputable sources.

#### Perils of Using Poison

A character has a 5% chance of exposing himself to a poison whenever he applies
it to a weapon or otherwise readies it for use. A character that rolls a natural
1 on an attack roll with a poisoned weapon must succeed in a DEX attribute check
or he poisons himself and must make a save versus poison. Assassins are trained
in the use of poisons and there is no chance an assassin will poison himself
when employing it in any way.

**Poison Table**

| **Class** | **Type** | **Save Adj.** | **Onset**    | **Failed Save Damage** | **Save Damage** | **Price** |
|-----------|----------|---------------|--------------|------------------------|-----------------|-----------|
| 1         | CT       | \+2           | 2d4 rounds   | 10                     | 0               | 20        |
| 2         | CT       | \+1           | 1d6+1 rounds | 20                     | 0               | 80        |
| 3         | CT       | \-            | 1d4 rounds   | 30                     | 10              | 800       |
| 4         | CT       | \-1           | 1d2 rounds   | 40                     | 15              | 2,000     |
| 5         | CT       | \-2           | 1 round      | death                  | 30              | 4,000     |
| 6         | IG       | \+4           | 2d4 rounds   | 20                     | 10              | 6         |
| 7         | IG       | \+3           | 1d4+1 rounds | 30                     | 15              | 35        |
| 8         | IG       | \+2           | 1d2 rounds   | 40                     | 20              | 220       |
| 9         | IG       | \+1           | 1 round      | death                  | 25              | 520       |
| 10        | IG       | \-            | 1d4 turns    | death                  | 30              | 1,200     |
| 11        | IH       | \+3           | 1d4 rounds   | 5                      | 0               | 5         |
| 12        | IH       | \+2           | 1d2 rounds   | 10                     | 5               | 25        |
| 13        | IH       | \+1           | 1 round      | 15                     | 7               | 35        |
| 14        | IH       | \-            | instant      | 20                     | 10              | 150       |
| 15        | IH       | \-1           | instant      | death                  | 15              | 1,200     |
| 16        | IN       | \+4           | 2d4+1 rounds | 15                     | 0               | 15        |
| 17        | IN       | \+3           | 1d3 rounds   | 25                     | 0               | 75        |
| 18        | IN       | \+2           | 1 round      | 35                     | 0               | 650       |
| 19        | IN       | \+1           | 1 round      | death                  | 0               | 1,700     |
| 20        | IN       | \-            | instant      | death                  | 10              | 2,500     |

There is a chance that a target in close proximity to poison will detect its
presence due to its appearance, smell, or taste, before it is significantly
contacted. The chance is related to the save adjustment of each poison. Poisons
with +4 have an 80% probability of detection; +3, 60%; +2, 40%, +1, 20%.

*Notes for the Referee:* These rules allow poison to be used in complex ways.
Most campaigns will not need this level of complexity, however, campaigns
revolving around assassins or the like might find the very useful.

### Potion Mixing

Referees may rule that it is dangerous to combine different potions. Potions are
considered “mixed” when they are literally mixed before being imbibed, or when
one potion is imbibed while another is in effect. It is entirely appropriate for
the Referee to put down a set of guidelines for certain potion combinations. For
instance, it might be ruled that combining any kind of *healing potion* is
always safe with any other potion. However, it may also be desirable to simply
use a random system to determine outcomes of mixing potions, since one might
assume that no two potions, even of the same type, have the exact same formula.
Refer to the table below when potions are mixed, or construct a similar table
more appropriate for your campaign.

**Potion Mixing Table**

| **D20** | **Potion Mixing Result**                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
|---------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| 01-02   | *Poisonous Brew:* The imbiber must roll a saving throw versus poison with a penalty from -1 to -4 (roll a d4) or die.                                                                                                                                                                                                                                                                                                                                                                                   |
| 03-04   | *Chemical Reaction:* The potions create a reaction within the body, causing internal chemical burns for 2d6 hp damage.                                                                                                                                                                                                                                                                                                                                                                                  |
| 05      | *Hideous Result:* The potions combine to alter the imbiber’s body in a horrible and permanent way. It could be mild, such as causing mottled skin, or terrible, such as a withered limb, melted eyes, or unusual growths, etc. Roll 1d6 to determine general severity: 1-2, mild; 3-4, moderate; 5-6, severe. Mild effects are usually only cosmetic, while moderate ones may impose some penalties to abilities, attack rolls, etc. Severe effects cause major crippling or profound body alterations. |
| 06-15   | *No Effect:* Both potions are rendered ineffective.                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| 16-18   | *Normal Effect:* Both potions function normally.                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| 19      | *Greater Effect:* One potion works 10%-100% more effectively (roll D100), while the other has no effect.                                                                                                                                                                                                                                                                                                                                                                                                |
| 20      | **Different Effect:** The potions combine to create an entirely new effect. This might mimic a different random potion at 150% normal efficiency, or a unique effect determined by Referee.                                                                                                                                                                                                                                                                                                             |

*Notes for the Referee:* These rules are designed to limit potion use. Most
campaigns do not have a real problem with excessive potion use and probably do
not need these rules.

### Property and Finance

Comparing the wages of common workers and the starting money for PCs makes it
obvious that the starting player character is already in a position of
privilege. That the character will then likely pursue further wealth, and indeed
such wealth is necessary to advance in level, makes it obvious that successful
characters in this game will become quite rich. What can characters do with all
that wealth?

#### Property

Owning property is a great way for characters to both spend, and invest, their
wealth. The prices given for property in the Equipment section are averages; the
Referee is of course free to create custom price lists for different locations
and conditions. At the very least, a place to store excess treasure will be
needed, as well as people to guard it and run things while the character is off
adventuring.

Owning property gives a character a stake in local politics and will lead to
many NPCs becoming involved in the character’s life.

Note that for the purpose of these rules being a landowner does not imply
rulership over anything other than the household staff. The complexities of
being a political power are beyond the scope of these rules (see The Domain Game
section for rulership), which assume characters are explorers and adventurers.

#### Upkeep

It costs 1gp per month per resident of the household for food and other
essential supplies.

A landowning character must pay d6% of the property’s value every year just for
simple maintenance. This will be increased by d10% if there is no accountant on
staff, and another d4% if there is no handyman or craftsman on the payroll.

A landowning character must pay d4+3% of the property’s value per year in taxes,
adding another d10% if an accountant is not on staff.

#### Investment

Another method of using (and hopefully growing!) wealth is investment. Merchant
houses importing and exporting goods, explorers looking for sponsors for their
latest expeditions, craftsmen looking for capital to open their own shop in town
– all of these give a character opportunity to invest and profit.

These rules will be handled abstractly, unless the Referee wants to be specific.
The player merely specifies how much the character wishes to invest and what
level of risk the investment involves. It is assumed that even if a character
owns a business, he will not be involved in the day to day operations, since the
character is an adventurer!

#### Yearly Return

A stable investment will grow d8-4% a year. A risky investment will grow d20-10%
a year. A wild investment will grow d100-50% a year.

Add +d4% if an accountant is on staff.

If the final growth is a positive number, the character will receive that much
money in cash, to be kept, spent, or reinvested as the character wishes. If the
final growth is a negative number, the character receives no money and the value
of the investment decreases.

These yearly return amounts “explode.” If the maximum number on the die is
rolled, roll again, adding the new number (without the modifier), and keep
rolling and adding as long as the maximum number is rolled. If the minimum
number is rolled, roll again, and subtract that number from the return (without
a modifier), and keep rolling and subtracting as long as the minimum number is
rolled.

Example 1: A character has 50,000sp invested in a Risky venture. On the yearly
roll, he rolls a 20, meaning a 10% gain (alas, no accountant). Because he rolled
a 20, he rolls again, and gets a 3. He adds this 3 to the original 10, totaling
a 13% gain. He earns 6,500sp!

Example 2: A character has 10,000sp invested in a Stable venture. On the yearly
roll, he rolls a 1, meaning a 3% loss (again, no accountant, the fool!). Because
he rolled a 1, he rolls again, and gets a 7. He subtracts that 7 from the
original 3, totaling a 10% loss. The character makes no money and his investment
loses 1,000sp in value.

A character may only freely withdraw his investment at the time of the yearly
return. Otherwise, there is a penalty of d6+4%.

All numbers include taxes due on the investment.

#### Bankruptcy

There is a chance that an investment will simply go bust during every given
year, and the character will lose every last copper he has in that investment.
The chances are:

| Stable Investment | 5%  |
|-------------------|-----|
| Risky Investment  | 10% |
| Wild Investment   | 25% |

*Notes for the Referee*: Characters often accumulate a lot of funds; these
optional rules give simple guidelines for characters buying property and/or
investing money. This gives characters something to do with their money rather
than just hoard it. Owning property or investing in businesses will also help
involve the character in society. Money earned from property and investments
should not normally count for experience.

### Psionics

Psionics are mental powers which aren’t magic but sometimes duplicate magical
abilities. If psionics are used in a campaign, any highly intelligent being has
a slight change of being psionic.

**Creating Psionic Characters:** Characters should check for psionics ability at
character creation. Roll a d20 and add the characters INT bonus. On a roll of 20
or higher, the character may opt to have psionics abilities that will manifest
as the character goes up levels. If the above roll is successful and the player
opts for the character for the character to have psionics, roll 2d6. The result
is the maximum number of psionic abilities the character will manifest. Each
ability a character can manifest adds -3 to the character Experience Modifier.
For example, a character who can manifest 8 psionic abilities adds -24% to his
Experience Modifier – which will increase the number of XP the character needs
to advance in character level.

**Manifesting Psionic Abilities:** At character creation and every time a
psionic character goes up a level, the character rolls to see if a new psionic
ability manifests. Roll 1d20 + INT bonus against a target number of (21 – the
maximum number of psionic abilities the character may manifest). On a successful
roll, the character manifests a new psionic ability. Roll on the Psionic Ability
Table below to determine the new ability. Reroll if the character already has
the ability rolled.

**Manifesting Psionic Attack and Defense Modes:** Psionic characters manifest
psionic attack and defense modes as they gain psionic abilities. Specific modes
manifest as the character manifests a specific number of abilities. See Psionic
Combat below for more information.

**Psionic Attack and Defense Modes Manifested**

| Number of Psionic Abilities Manifested | Attack Mode Manifested | Defense Mode Manifested |
|----------------------------------------|------------------------|-------------------------|
| 1                                      | Mind Thrust            | Thought Shield          |
| 2                                      |                        | Mind Blank              |
| 3                                      | Ego Whip               |                         |
| 4                                      |                        | Mental Barrier          |
| 5                                      | Psionic Blast          |                         |
| 6                                      |                        | Intellect Fortress      |
| 7                                      | Id Insinuation         |                         |
| 8                                      |                        | Tower of Iron Will      |
| 9                                      | Psychic Crush          |                         |

**Using Psionic Abilities:** Using a psionic ability is an action. Successful
use requires a 1d20 + INT Bonus + Level/2 versus the target number (TN) given in
the ability description. Certain abilities also cost HP (even if the attempt is
unsuccessful). The power of many psionic abilities is determined by the Ability
Level of the specific psionic ability. This is the number of levels the
character has possessed the specific ability. Simply recording the character’s
level when he gets the ability will make calculating this easy.

**Psionic Abilities:** The following psionic abilities may manifest. Which
abilities manifest should be determined randomly. The Referee is free to create
other abilities.

**Psionic Abilities**

| Roll | Psionic Ability     | Roll | Psionic Ability   |
|------|---------------------|------|-------------------|
| 1    | Animal Telepathy    | 13   | Etherealness      |
| 2    | Astral Projection   | 14   | Healing Trance    |
| 3    | Aura Alteration     | 15   | Invisibility      |
| 4    | Body Control        | 16   | Levitation        |
| 5    | Body Equilibrium    | 17   | Mind over Body    |
| 6    | Clairaudience       | 18   | Precognition      |
| 7    | Clairvoyance        | 19   | Psychic Surgery   |
| 8    | Dimension Door      | 20   | Shape Alteration  |
| 9    | Domination          | 21   | Telekinesis       |
| 10   | Empathic Projection | 22   | Telepathy         |
| 11   | Empathy             | 23   | Teleportation     |
| 12   | ESP                 | 24   | Suspend Animation |

*Animal Telepathy:* Character can establish 2-way mental communication with an
animal. TN is 12. HP Cost is 1 HP per minute. Level of communication depends on
the intelligence of the target. Does not require target to obey or be helpful.

*Astral Projection:* Character can enter a trance and project himself into the
Astral Plane. This works like the Astral Spell except that speed of travel and
other effects depend on Ability Level. TN is 15. HP Cost is 1 HP per 10 minutes.

*Aura Alteration:* Character can alter a target’s aura to either to disguise the
target’s alignment and level, or to remove a compulsion or charm. Disguise has a
TN of 15, costs 5 HP, lasts 10 minutes per Ability Level, can make the target
appear as any desired alignment and can modify the character’s apparent level by
up to Ability Level levels. Removing a charm, compulsion, or curse costs 10 HP
and grants the target another saving roll.

*Body Control:* Character can adjust his body to exist in unusual conditions
(extreme temperatures, hostile/destructive elements like poison gas, water,
acid, fire, lava, etc.).TN is 12 for unusual conditions like extreme
temperatures, 15 for hostile environments like underwater or lack of good air.
18 for extreme conditions like acids, lava, etc. Costs 1 HP per 10 minutes.
Maximum duration is Ability Level x 10 minutes. Reroll Ability check every hour.

*Body Equilibrium:* Character can adjust his body weight to correspond to the
surface he is walking on so as not to sink into water, mud, quicksand, etc. TN
is 12. Costs 1 HP per 10 minutes. Maximum duration is Ability Level x 10
minutes. Reroll Ability check every hour.

*Clairaudience:* Character can hear at a distance (30 feet + Ability Level x
10). TN is 12 (plus +2 for each foot of material between psionic and target
area). Costs 1 HP per minute.

*Clairvoyance:* Character can see at a distance (30 feet + Ability Level x 10).
TN is 12 (plus +2 for each foot of material between psionic and target area).
Costs 1 HP per minute.

*Dimension Door:* Character can teleport up to Ability Level x 20 feet. TN is 12
is target location visible, 15 otherwise. Costs 5 HP.

*Domination:* Character can force another to do their will. TN to establish is
15 + target’s level/hit dice. TN to maintain for another round is 15 + target’s
level/hit dice. Costs the target’s level/hit dice in HP per minute.

*Empathic Projection:* Character projects an emotional state upon targets. This
works similar to the Suggestion spell but is limited to suggesting emotions. TN
is 12 if touching a single target, 15 otherwise. Range: 30 feet + (Ability Level
x 10). Can affect up to Ability Level targets. HP Cost is 3 per target.

*Empathy:* Character senses the emotions/emotional needs of the target(s). TN is
15. Cost: 1 HP per minute if a single target, 3 HP per minute otherwise. Range:
30 feet + (Ability Level x 10).

*ESP:* Character can read the surface thoughts of the target. TN is 10 +
target’s level/hit dice. Cost: 1 HP per minute if touching target, 3 HP per
minute otherwise. Range: 30 feet + (Ability Level x 10). Searching for
specific/deeper thoughts adds 5 to the TN (+10 if the target is specifically
hiding them) and doubles the HP cost.

*Etherealness:* Character can alter his body vibrations to those of the Ethereal
Plane, but is only able to carry Ability Level \* Ability Level pounds of
material with him. TN is 12 + 1 per 20 pounds of weight carried. HP Cost: 1 HP
per 10 minutes.

*Healing Trance:* Character can go into a trance and heal damage they have taken
quickly. A maximum of one 1d6 hit points per Ability Level can be healed. TN is
10 + number of dice of hit points to be healed. Trance lasts a number of hours
equal to the dice to be healed, and 1 die is healed per hour of trance. HP Cost:
dice healed x 2. If the optional Wound Point rules are used, this power operates
as follows: Wound Points are healed instead of hit points. A maximum of one WP
per Ability Level can be healed. TN is 10 + number of WP to be healed. Trance
lasts a number of hours equal to the BP to be healed, and 1 BP is healed per
hour of trance. HP Cost: BP healed x 2

*Invisibility:* Character can turn invisible by making those in range not notice
the character. Character cannot attack and maintain invisibility. Range is
Ability Level x 10 feet. TN is 12 (or 15 if the targets are highly alert).

*Levitation:* Character can float in the air. DC to float is 12 and it costs 1
HP per minute. Character can ascend or descend Ability Level feet per minute by
making an ability check with a TN of 15. Character can move laterally Ability
Level feet per minute by making an ability check with a TN of 18.

*Mind over Body:* Character can suppress bodily needs like food, water, and
sleep for two days per Ability Level. Thereafter the character must spend an
equal number of days resting before this ability can be used again. No ability
check or HP cost.

*Precognition:* Character has a vague sense of the future. While using this
power the character cannot be surprised and adds his Ability Level/2 (round up)
to initiative, combat rolls, and any other d20 rolls where an ability to know
what might happen in the near future would be helpful. TN is 15 and the roll
must be made each minute the ability is used. HP cost is 5 HP per minute.

*Psychic Surgery:* Character and target go into a trance to heal target’s damage
quickly. Character must be touching target. A maximum of 1d6 hit points per
Ability Level can be healed. TN is 10 + number of dice of hit points to be
healed. Trance lasts a number of hours equal to the dice to be healed, and 1 die
is healed per hour of trance. HP Cost: dice healed x 2. If the optional Wound
Point rules are used, this power operates as follows: Wound Points are healed
instead of hit points. A maximum of one BP per Ability Level can be healed. TN
is 10 + number of BP to be healed. Trance last a number of hours equal to the BP
to be healed and 1 BP is healed per hour of trance. HP Cost: BP healed x 2.

*Shape Alteration:* Character can modify his appearance similar to the Polymorph
Self spell. TN is 12 to make minor changes to appearance (remaining same
species), 15 to make major changes (another species of similar size), and 18 to
make more extreme changes. Cost is per hour and is based on type of change: 3 HP
for minor changes, 8 HP for major changes, and 15 HP for extreme changes.
Maximum duration is Ability Level hours.

*Telekinesis:* Character can move objects up to Ability Level x Ability Level
pounds by mental power. TN is 12 (18 if precise control is needed). HP Cost is 3
HP per minute for slow movement, 8 per attack for combat speed movement.

*Telepathy:* Character can establish 2-way mental communication with an
intelligent target. TN is 12 if target is willing, 18 otherwise. HP Cost is 1 HP
per minute. 1 minute of telepathy allows an information exchange equal to 10
minutes of talking.

*Teleportation:* Character can teleport up to Ability Level \* 100 miles. TN is
12 if the target location is intimately known to character, 18 if the target
location is well known, and 24 if the target is only known from a clear
description. HP Cost is 15.

*Suspend Animation:* Character can virtually stop all body functions for a
predetermined amount of time. Maximum duration is Ability Level x Ability Level
weeks. Character will not change during this time. A number of days equal to the
number of weeks spend in suspended animation must pass before this ability can
be used again. No ability check or HP cost.

**Psionic Combat:** Only psionic characters that have manifested a psionic
attack ability can make a psionic attack. The Psionic Attack Roll is 1d20 + INT
bonus + number of psionic abilities manifested. The attack is successful if it
is higher than the target’s Psionic Armor Class (10 + INT bonus + armor bonuses
from a psionic defense mode).

Psionic attacks do psionic damage (see below for amounts). Tally psionic damage
separately. If the total psionic damage ever becomes greater than the
character’s current hit points, the character falls into a coma and remains in a
coma until he has more hit points than psionic damage points and makes a
successful save vs Paralysis (may be attempted once per hour). With a night’s
sleep, psionic damage “heals” 1d6 + twice the number of psionic abilities
manifested, if any.

*Psionic Defense Modes:* Defense modes increase the character’s psionic armor
class when in use. Only one mode can be in effect at one time. Thought Shield
costs 0 HP to use and gives a +1 bonus to the character’s psionic armor class.
Mind Blank costs 0 HP to use and gives a +2 bonus to the character’s psionic
armor class. Mental Barrier costs 0 HP to use and gives a +4 bonus to the
character’s psionic armor class. Intellect Fortress costs 2 HP to use and gives
a +4 bonus to the psionic armor class of the character and everyone within 10
feet. Tower of Iron Will costs 3 HP to use and gives a +6 bonus to the psionic
armor class of the character and everyone within 3 feet.

*Psionic Attack Modes:* Mind Thrust costs 1 HP to use and does 1d8 points of
psionic damage. Ego Whip costs 2 HP to use and does 2d6 points of psionic damage
and the target must make a save vs paralysis or be stunned for one minute.
Psionic Blast costs 4 HP to use and attacks everyone in a conic area in front of
the psionic doing 1d6 damage to everyone in the affected area, double damage to
those in short range (10'), half damage at long range (30'). One attack roll is
made and used against all possible targets. Id Insinuation costs 2 HP to use and
does 3d6 psionic damage and the target must save vs. Fear or be affected as a
fear spell for 1d6 rounds. Psychic Crush costs 5 HP to use and does 4d6 psionic
damage and 2d6 physical (HP) damage.

**Hit Point Recovery:** If the optional Hit Points and Wound Points rule is not
being used, Healing magic (potions, cure spells, etc.) will not restore hit
points spent on psionic abilities or psionic combat modes. Hit points spent to
use psionic abilities, psionic attack modes, and/or psionic defense modes are
instead recovered by a full night’s rest.

*Notes for the Referee:* Psionics were one of the least used and poorest
described abilities in 0e. While the 0e system can be made to work, it does not
work well. This psionics system therefore has been made to have similar
abilities and power levels to the 0e psionics system, but the implementation is
much different. Few campaigns will need psionics, but the system is here for
those (like one of the editor’s) that do. While this rule can be used alone, it
works best if the optional Hit Points and Wound Points rule is also used.

### Spirits

Spirits of many types occupy the spirit plane. These spirits can be summoned to
the material world and even bound by intelligent material beings. When a spirit
is encountered it will generally either attack or flee. If a spirit attacks, the
spirit rolls a d20 and adds its power. The material being makes a magic attack
roll. The higher roll wins and does the difference between the rolls in spirit
damage. Spirit damage reduces a spirit’s power, but just accumulates in a
physical being. If the spirit’s power reaches zero it loses the combat and may
be bound (if the defender wishes and knows how). If the material being takes a
total of 20 points of spirit damage from a specific spirit, it is unconscious
and may be possessed by the attacking spirit (becoming an NPC until the spirit
is exorcised).

Spirits have names, personalities, intelligence, power, and may have special
powers that they can manifest if they possess a body or are bound.

Intelligence: 2d6+6

Power: Weak: 2d6; Average: 2d6+6; Above Average: 2d6+12; Strong: 2d6+18;
Powerful: 2d6+24;

Languages: Spirits know one language for each point of intelligence above 10.

Powers: Spirits may have a number of supernatural powers that they can manifest
if they possess a body or can be forced to manifest on command if they are
bound. Some spirits may also take physical form to act as combatants in service
of their binder. If bound by a spell-caster, their Power points may be used by
their binder as HP to cast spells. They regenerate daily.

**Spirit Powers:**

| **D20 Roll** | **Number of Powers** |
|--------------|----------------------|
| 1-6          | 1 lesser             |
| 7-10         | 2 lesser             |
| 11-13        | 2 lesser, 1 greater  |
| 14-16        | 3 lesser             |
| 17-18        | 3 lesser, 1 greater  |
| 19           | 2 greater            |
| 20           | 3 greater            |

**Lesser Spirit Powers:**

| **D20 Roll** | **Power**                                      |
|--------------|------------------------------------------------|
| 1-2          | Charm Person 1/day                             |
| 3-4          | Crystal Ball 3/day                             |
| 5-6          | Cure Light Wounds 3/day                        |
| 7-8          | Inflict Light Wounds 3/day                     |
| 9-10         | Knock 1/day                                    |
| 11-12        | Light or Dark 1/day                            |
| 13-14        | Telekinesis, 10 pounds, 3/day                  |
| 15-16        | Purify or Putrefy Food and Drink 1/day         |
| 17           | Read Languages 3/day                           |
| 18           | Read Magic 3/day                               |
| 19           | Speak with Animals 3/day                       |
| 20           | Take physical form 1 hour/day; AC 7 [12], HD 2 |

**Greater Powers:**

| **d20 Roll** | **Power**                                                |
|--------------|----------------------------------------------------------|
| 1            | Animate Dead, 2d6 undead, 1/week                         |
| 2-3          | Contact Other Plane 1/week                               |
| 4            | Cure Serious Wounds 2/day                                |
| 5            | Dimensional Door 1/day                                   |
| 6            | Dispel Magic, 1/day                                      |
| 7-8          | Fly for 1 hour/day                                       |
| 9            | Hold monster 1/day                                       |
| 10           | Invisibility 1/day                                       |
| 11-12        | Levitate, 1 turn duration, 3/day                         |
| 13-14        | Phantasmal Force, 1/day                                  |
| 15           | Protection from Normal Missiles 1/day                    |
| 16-17        | Remove Curse 1/day                                       |
| 18-19        | Take physical form 1 hour/day; AC 5 [14], HD 5+2, Move 6 |
| 20           | Telekinesis, 100 pounds, 1/day                           |

**Ego Conflicts:** Each spirit will have an ego equal to its intelligence +1 for
every lesser power and +5 for every greater power. The Ego of a material being
is equal to its intelligence + charisma + level. A possessed being may try once
per day to throw out a possessing spirit, however, its ego for future attempts
falls by one for every unsuccessful attempt. Ego conflict is resolved by each
side rolling 1d20 and adding their Ego, higher result wins. If a bound spirit’s
ego is greater than his binder’s ego, the spirit may elect to restart spirit
combat in an attempt to break its binding.

**Binding Spirits:** Members of spell-casting classes automatically know how to
bind spirits they defeat in spirit combat once they reach 3rd level. Other
classes cannot bind spirits but may be given a spirit bound to an object by
another person. Binding a Spirit costs 15 HP and causes the spirit to invisibly
hover around the binder. Binding a spirit to an object requires a non-magical
item and costs 25 HP. A spirit bound to an item may be given to another person
as the spirit treats the owner of the item it is bound to as its binder. If the
item is severely damaged or destroyed, the spirit is freed. A spirit who is not
bound to an item is freed immediately upon his binder’s death.

*Notes for the Referee:* These rules are not appropriate for most campaigns;
however, they make campaigns set in certain types of primitive/limited magic
settings possible. Referees may also use these rules for humanoid monsters like
orcs and goblins. Referees should feel free to create their own tables of spirit
powers to reflect their campaign world.

### Usage Die

The Usage Die is an alternative method of tracking the number of a particular
item a character owns (e.g., arrows, torches, etc.). When such a resource is
used is used (or once the combat is over for weapons/ammo UD) you roll its Usage
Die, a result of 1-2 means the Usage Die for that item is downgraded to the next
smallest die:

UD20 -\>UD12 -\>UD10 -\>UD8 -\>UD6 -\>UD4

When a 1 or 2 is rolled on a UD4, this means the character only has 1 of the
resource left.

As a rule of thumb, the average number of uses for each UD is as follows: UD4
(2), UD6 (5), UD8 (9), UD10 (14), UD12 (20), UD20 (30). The referee can use this
information to assign a Usage Die to expendable items a character finds or buys.

*Notes for the Referee:* The Usage Die idea is popular in some modern revisions
of TSR editions because it “reduces bookkeeping”. The editor finds it just
substitutes tracking the current UD associated with each item for tracking the
number of each item remaining. It also requires adding a D12, a D10, a D8, and a
D4 to the types of dice required for players.

### Vision

The following kinds of vision are common for monsters and some demi-humans or
humanoids.

#### Infravision

*Infravision*, or infrared vision, is the capability to see in the infrared
spectrum of light. Creatures have varying ranges for this ability. Most
creatures have the ability to 60’, and this means their eyes are collecting
light much as any eyes do. These creatures can only distinguish differences in
heat levels, and it is not in fine detail. However, warm footprints may be
detected within 4 rounds of a creature’s passage. Further ranges indicate that
the eyes actually emit infrared light (and glow red) indicating the eyes are
seeing infrared light as it bounces back. This form of vision allows the viewer
much greater resolution. Note that if a heat-emitting light source is present,
infravision cannot function.

#### Ultraviolet Vision

Creatures with this ability can see the UV spectrum and will be able to see
objects that emit this type of energy. This spectrum includes high intensity
radiation. At night, this vision allows a character to see to a distance of
300’. Since this vision relies on heavy background radiation, it is not useful
underground unless there is a source of radiation for illumination. If a
creature has ordinary vision and *ultraviolet vision*, the *ultraviolet vision*
is only usable in darkness, and it takes 1 round to transition between each
form. Note that magical weapons shed energy that interferes with *ultraviolet
vision*, much like a fire source interferes with *infravision*.

#### Invisibility

The following guidelines can be used for ruling in situations where invisibility
is a factor. As a general rule, an invisible character or creature may be struck
with a -4 penalty to hit. In addition, invisible creatures receive a +4 to
saving throws in regard to effects in which knowing the victim’s location is a
factor. For instance, this bonus would not apply to poison, but it would apply
to effects from a staff.

It must be noted that a character under the effects of an *invisibility* spell
or similar effects is not rendered silent. In addition, an invisible character
may betray his presence through other senses, such as smell. To account for
various means of perception and alertness, the following optional chart can be
used to check the probability that a creature or higher level character detects
that an invisible creature is present. Note that this only gives knowledge of
the creature’s presence, and all normal penalties to hit apply. The roll should
be made every round. If successful, the creature is aware of the invisible being
from that point on.

**Chance to Notice Invisible Creatures**

| INT   | Level or Hit Dice |     |     |     |     |     |     |     |
|-------|-------------------|-----|-----|-----|-----|-----|-----|-----|
|       | 8                 | 9   | 10  | 11  | 12  | 13  | 14  | 15+ |
| 0-3   | \-                | \-  | \-  | \-  | \-  | 5%  | 10% | 15% |
| 4-5   | \-                | \-  | \-  | \-  | 5%  | 10% | 15% | 20% |
| 6-8   | \-                | \-  | \-  | 5%  | 10% | 15% | 20% | 25% |
| 9-12  | \-                | \-  | 5%  | 10% | 15% | 20% | 25% | 30% |
| 13-15 | \-                | 5%  | 15% | 25% | 35% | 45% | 55% | 65% |
| 16-17 | 5%                | 10% | 20% | 30% | 40% | 50% | 60% | 70% |
| 18    | 5%                | 15% | 25% | 35% | 45% | 55% | 65% | 75% |
| 19    | 10%               | 20% | 30% | 40% | 50% | 60% | 70% | 80% |
| 20    | 15%               | 25% | 35% | 45% | 55% | 65% | 75% | 85% |
| 21+   | 20%               | 30% | 40% | 50% | 60% | 70% | 80% | 90% |

*Notes for the Referee*: While these rules can be useful, they are somewhat
fiddly and the chance to notice invisible creatures system adds extra work to
each round an invisible creature is present for the referee.

<br><br><br>Section II:<br>The Domain Game
==========================================

Introduction
------------

The “domain game is the often forgotten “endgame of the Original Edition.
Perhaps it’s forgotten because there never were many guidelines for it in the
Original Edition. This section of *Tarnhelm’s Tome of Wonder* provides two sets
of guidelines for running domain level play Strongholds & Domains and Dominions)
– the first less complex than the other. Relatively simple guidelines for mass
combat are also included to handle the inevitable military conflicts between
domains.

Strongholds & Domains 
----------------------

### Strongholds

Strongholds allow characters to house their retainers, build military power, and
project control over an area of land. Strongholds are generally built from
scratch in unsettled regions, providing stability and protection to new
inhabitants. Characters may gain strongholds in other ways, such as being gifted
one from a local noble or repairing an old stronghold that has fallen into
disrepair; the costs of these methods should be less than building a new
stronghold, the exact cost will be determined by the Referee.

### Building A Stronghold

Players will design the stronghold that their character wishes to build. Each
story is about 10 feet tall. The construction costs for a stronghold are
determined by the material and square footage of the walls, floors, and roofs.
This cost includes typical features of construction like stairs, doors, and
windows. Special additions to strongholds, like libraries or laboratories, may
be added for additional cost. Building tall structures is more expensive than
normal; increase the cost of a building by 10% if any portion of it is taller
than 20 feet. Increase it by an additional 15% (for a total increase in price of
25%) if any portion is taller than 50 feet.

Walls are purchased in ten foot tall and ten foot wide sections. One foot thick
walls are solid material, while five foot and ten foot thick walls are earth and
rubble sandwiched by two one foot thick walls of the same material.

| **Walls**  | **1 ft Thick**  | **5 ft Thick** | **10 ft Thick** |
|------------|-----------------|----------------|-----------------|
| Max Height | 50 feet         | 80 feet        | 100 feet        |
| Wood       | 10 gp           | \-             | \-              |
| Brick      | 20 gp           | 60 gp          | \-              |
| Stone      | 30 gp           | 90 gp          | 180 gp          |

Flooring and Roofing material is bought in ten foot by ten foot areas. Having a
peaked roof or interesting feature doesn’t affect the cost so long as it covers
a 10 foot by ten foot area. Each floor of a stronghold needs flooring.

| **Material** | **Flooring** | **Roofing** |
|--------------|--------------|-------------|
| Thatch       | \-           | 10 gp       |
| Wood         | 10 gp        | 20 gp       |
| Slate        | 20 gp        | 40 gp       |

Special features have a flat cost for their construction. If there is a special
feature that you would like for a stronghold that is not listed here, talk to
your Referee about a reasonable cost for it. For features that have variable
lengths, the cost presented here is for 10 feet.

| **Special Feature**                    | **Cost** |
|----------------------------------------|----------|
| Bridge (10’ wide)                      | 20 gp    |
| Drawbridge (10’ wide)                  | 10 gp    |
| Earthen Rampart (10’ tall & 10’ thick) | 5 gp     |
| Laboratory                             | 500 gp   |
| Library                                | 500 gp   |
| Moat (20’ wide & 10’ deep)             | 10 gp    |
| Portcullis                             | 50 gp    |

The time it takes to build a stronghold is equal to the cost of the stronghold
in worker days. So, to build a stronghold that costs 10,000 gold pieces takes
one worker 10,000 days. Hiring multiple workers makes the work go by faster, one
hundred workers could finish the 10,000 gold piece stronghold in one hundred
days. Day laborers and workers who you hire to build strongholds are not
retainers. They are paid 1 to 5 shillings a day while they are working
(depending on the danger of the region). While constructing a stronghold you
need an engineer (a specialist retainer).

A stronghold, without a domain, can be extremely expensive. The monthly upkeep
for a stronghold is 1% of the cost of that stronghold in an uncivilized region
or 0.5% the cost of the stronghold in a civilized region. So, the 10,000 gold
piece stronghold has a monthly upkeep cost of 100 gold pieces in an uncivilized
region and 50 gold pieces in a civilized one. Strongholds are assumed to be
large enough to house any number of retainers. The Referee may limit this to a
reasonable number if it matters.

### Alternate Strongholds

Your character may not want to build a keep or castle, and instead prefer to
construct a temple, mage’s tower, or something else. In any case, the costs for
building these strongholds is the same as a normal stronghold but these
strongholds cannot assert control over a domain or levy troops from the local
populace. Although they may be more welcomed in civilized regions than a
fortress geared for warfare.

### Domains

A domain is a region that the characters control from their stronghold. To
establish a domain the characters must clear the land they wish to control, or
secure the fealty of any creatures living on that land. Land comes in two types,
civilized or uncivilized. Civilized land is already controlled by some entity,
like a government. To acquire a domain in civilized land the character will have
to either conquer the land, or swear fealty to the local ruler in exchange for
the land. In uncivilized lands there are no additional complications to
establishing domains; the characters simply need to go claim it and defend it.
The size of the domain that a stronghold can control is related to the
stronghold’s cost. The size of the domain is given in hexes; one hex is six
miles across and roughly contains 32 square miles of domain. For domains smaller
than a single hex a stronghold may be any size. If you want a domain larger than
twelve hexes you will need to build additional strongholds to control that
territory.

| **Stronghold Cost (gp)** | **Maximum Domain Size** |
|--------------------------|-------------------------|
| 1000 – 9999              | 1 hex                   |
| 10,000 - 24,999          | 3 hexes                 |
| 25,000 - 99,999          | 7 hexes                 |
| 100,000 +                | 12 hexes                |

### Initial Conditions

The initial conditions of your domain will affect how you can grow it. If you
are in an uncivilized area roll 3d6 × 10 per 32 square mile area (hex) to
determine the number of families living in the region when you first take it. If
you are in a civilized region roll 6d6 × 10 to determine the number of families
living there. The quality of the land you have claimed will also affect your
domain, roll 1d6+2. This is the amount of gold pieces that each family pays you
per month as land revenue; a nominal fee in exchange for the right to work on
the lands you control.

### Rights & Obligations

As the ruler of a domain, you are essentially a member of the nobility. If you
are beholden to another lord, you owe that lord fealty and they may tax you or
call upon you to accompany them to war with an appropriate number of troops.
Your lord has the right to use your lands to hunt and fish and you must house
them should they visit you. If you are the ultimate authority you are only
beholden to the set of duties that all lords adhere to (dependent on your
setting). You are responsible for the protection and development of your domain.
You also mete out justice in criminal and civil cases.

### Domain Growth

Every month news of a new domain will go out and immigrants will come looking
for a new life. In civilized regions the population of a new domain increases by
20% each month until the domain’s population capacity is reached. In uncivilized
regions the population of a new domain increases by 10% each month until the
domain’s population capacity is reached. Once the capacity is reached the
population will steady. If an uncivilized region’s population capacity is
reached, the character may invest 2000 gold pieces per hex into reforms to make
the region civilized, thus increasing the capacity. If a civilized region
reaches capacity the character can invest 10,000 gold pieces to begin an urban
settlement, increasing the population capacity.

### Domain Wealth & Capacity

A character with control over a domain collects money from the inhabitants equal
to the initial 1d6+2 rolled value (usually around 5 gold pieces per family per
month) as land revenue. Land revenue is a result of the inhabitants practicing
their trades or working the land. In civilized regions the character may charge
their inhabitants taxes for public services like roads, mills, and protection. A
tax of 1 gold piece per month per family is a low rate, 2 gold pieces per month
per family is average, and a tax of any more than that is oppressive.

A domain can only support so many people before it becomes overcrowded. In an
uncivilized region no more than 100 families can live within one hex. In a
civilized region no more than 200 families can live within one hex. If the
region has an urban settlement the capacity becomes 500 families. A character
may invest money into an urban settlement to increase its capacity. A hex may
only have one urban settlement, and it must be at least one hex from any others.

| **Total Urban Investment (gp)** | **Capacity**    |
|---------------------------------|-----------------|
| 25,000 - 74,999                 | 1000 families   |
| 75,000 - 199,999                | 5000 families   |
| 200,000 - 499,999               | 10,000 families |
| 500,000 +                       | 20,000 families |

### Domain Management

Once a character has a domain, they must spend all of their downtime managing
it. Every season (3 months) the Referee will assess the morale of the domain. So
long as the taxes are not oppressive and the character is dutifully defending
the people and enforcing the law the morale will remain content. If the
character mistreats their people the domain may rise up in revolt. If a
character has nobles under their power to whom they have granted fiefs of land,
mistreatment of these individuals can result in revolt even if the vast majority
of the inhabitants are living well. Natural disasters may occur during each
season which will incur costs to the domain rulers and lower the population.
Long term warfare causes unrest and lowers the population. Particularly long
term or violent warfare can cause an urban settlement to be destroyed or a
civilized region to revert to an uncivilized region. Domain rulers will probably
have to engage in politics with nearby powers and religious institutions which
can also be a source of unrest for a population.

### Garrisons & Levies

As the rulers of a domain, the characters are responsible for the defense of
their realm. A garrison is a force of professional soldiers that are paid for by
the characters and kept under arms at all times. Levies are common people
drafted into the army during times of war, still paid for by the characters.
Garrisons and levies do not count as retainers; the number of each that a
character may hire or control is not limited by their Charisma attribute score.

Garrison troops are not working the land and are a drain on local resources, the
number of troops a garrison can have is limited by the number of families within
the domain. The number of troops in a garrison cannot exceed 10 + 5% of the
population of the domain (measured in families). So, a domain with 80 families
can support a garrison of up to 14 people. Levies are short term (cannot be
under arms for more than a season) and can make up 25% of a population (measured
in families).

Dominions (Complex)
-------------------

High level characters in Original Edition games are assumed to rule some area of
land, be it a tower in the wilderness where a magic-user can research spells
undisturbed, lands a fighter clears out of the wild and entices people to come
and settle, a temple and its supporting lands where a high priest does the work
of her deity, or lands granted an NPC ruler for services rendered. In some
campaigns this may be a background activity that is handled abstractly by the
Referee and players (and these rules may not be used in detail). However, in
many campaigns ruling lands may be a central part of high level play and the
information and rules in this section will come into their own.

Even if these rules are not used for player lands, they will help Referees
design dynamic and interesting countries for players to explore and live in in
the campaign.

### Granted Lands

When characters have come to the attention of the rulers of their land, usually
by performing the sort of deeds that only heroes can manage, they may be granted
titles of nobility and land grants.

This will vary from campaign to campaign depending on the preferences of the
players and the Referee. As a rough guideline, it should happen when the party
are somewhere between 9th and 15th level—although some groups or some individual
players may wish their characters to continue the life of a travelling
adventurer rather than taking on the responsibility of ruling.

The area of land ruled by a noble (whether a player character or otherwise) is
called a *Dominion*. This applies whether or not the noble is given their title
by a ruler or the noble strikes out on their own and simply claims land and
assumes a title. A single dominion consists of a stronghold and all the
surrounding land that is ruled from and protected by the stronghold. If a ruler
had more than one stronghold (except for when one is simply a garrison) then
each one and its land is considered a separate dominion.

### Titles of Nobility

Although there may be local and cultural variations specific to parts of the
campaign setting, this chapter assumes that the following titles of nobility are
in use (in ascending order of rank).

**Knight:** A knight is the lowest title of nobility. A grant of knighthood does
not come with a dominion, and a knight does not normally rule such land. The
children of nobles of all non-royal blood are normally knighted as a matter of
course when they come of age, receiving a greater title when (or if) they gain
their inheritance.

The title “Knight” applies to both sexes, although it is not used in the name of
the noble. Instead, male knights are referred to as “Sir (Name)” and female
knights are referred to as “Dame (Name)”. Male knights are addressed as “Sir”
and female knights are addressed as “Ma’am”.

**Baron:** A grant of Barony comes with a single dominion. It is the lowest form
of landed nobility, and may be granted by a count or higher. A baron is granted
a single domain, which is called a barony.

The title “Baron (Name)” is used for male barons, and “Baroness (Name)” is used
for female barons. Male barons are addressed as “Your Lordship”, and female
barons are addressed as “Your Ladyship”.

**Viscount:** If a baron is granted a second dominion, or conquers a second
dominion belonging to their ruler’s enemy and adds it to their ruler’s country,
they will likely be granted the title of viscount. This title and all higher
titles may only be granted by a duke or higher. The viscount may rule directly
from one of the strongholds and allow an allied baron to rule the other, or may
remain at court and allow allied barons to rule both their dominions.

A viscount who is granted more dominions by their ruler or who gains them by
expanding into unclaimed land remains a viscount. Viscount is therefore the
highest possible title for (non-royal) nobility who are yet to prove themselves
as war leaders.

The title “Lord (Name)” is used for male viscounts, and “Lady (Name)” is used
for female viscounts. Male viscounts are addressed as “Your Lordship” and female
viscounts are addressed as “Your Ladyship”.

**Count:** A viscount who conquers a third dominion belonging to one of their
ruler’s enemies and adds it to their ruler’s country will be granted the title
of count. A count will therefore rule at least three dominions, at least one of
which was won by military conquest. Note that the “enemy” may not necessarily be
a human country—but a distinction is made between the military capture of a
domain formerly ruled by an organized goblin nation, and the annexing by an
adventuring party of terrain formerly populated by a few sparse orc tribes, for
example. The dominions ruled by a count are collectively referred to as a
county.

Like a viscount, a count may delegate the rule of some or all of their dominions
to barons, and may remain at court. A count may grant the title of baron,
although etiquette demands that this is normally not done without at least
checking with the king or queen first.

The title “Count (Name) of (County)” is used for male counts, and the title
“Countess (Name) of (County)” is used for female counts. Male counts are
addressed as “Your Lordship” and female counts are referred to as “Your
Ladyship”.

**Marquis:** A count who continues to add dominions to their ruler’s lands
(either by conquest or expansion into unclaimed land) may be given the title of
Marquis. Although a marquis has greater station and influence at court than a
“mere” count, there is little practical difference between the two.

The title “The Marquis of (County)” is used for male marquises and the title
“The Marquise of (County)” is used for female marquises. Male marquises are
addressed as “Your Lordship” and female marquises are addressed as “Your
Ladyship”.

**Duke:** The highest rank of non-royal nobility is the Duke. The title of duke
is granted to marquises who have served their ruler well and continued to add
dominions to their rule. The collected dominions of a duke are referred to as a
“duchy”. It is rare (but not unheard of) for a duke to actually reside in one of
the strongholds in their duchy. Dukes normally stay at court except in times of
war or emergency. A duke may grant any lesser title (assuming the candidate has
achieved the necessary status), although etiquette demands that the king or
queen be informed before such grants happen.

The title “The Duke of (Duchy)” is used for male dukes, and “The Duchess of
(Duchy)” is used for female dukes. Both male and female dukes are addressed as
“Your Grace”.

**Archduke:** The title of Archduke is given to members of the royal family who
are also dukes. Some archdukes may by minor royalty who were originally granted
baronies and have genuinely worked to gain their dominions, but others may be
princes or other high ranking royals who have been granted archdukedoms for
reasons of nepotism rather than ability.

While archdukes appointed via royal fiat do technically have the status and
responsibility that their position entails, they are often not taken seriously
and are sidelined when it comes to important councils of war and so forth.
However, it can be dangerous to underestimate them completely. After all, they
are close relatives of the king or queen, and do have their ears; as well as an
array of lesser nobles (and their armies) at their disposal.

It is possible (although rare) for someone to first become a duke and then be
adopted into the royal family to become an archduke. On very rare occasions,
this will happen to an enemy duke who “defects” from their former ruler bringing
their lands with them. Such defections cause much political turbulence, and can
often be the start of major wars.

The title “The Duke of (Duchy)” is used for male archdukes, and “The Duchess of
(Duchy)” is used for female archdukes. Both male and female archdukes are
addressed as “Your Grace”.

**Prince:** A prince is the child of a king or queen (or emperor), or the child
of a crown prince or imperial prince. This may be by birth, or it may be by
adoption—such as the adoption that turns a duke into an archduke.

A prince will always be at least a baron, although in many cases their title is
a technicality and no actual domains are ruled. However, many rulers encourage
their offspring to go out and actively rule—partly to keep them occupied and
reduce internecine squabbling, and partly to “toughen them up” and get them used
to responsibility.

A prince may not appoint lesser nobles unless entitled to do so by their own
rank of nobility. The collective dominion held by a prince is called a
principality.

The title “Prince (Name) is used for male princes, and “Princess (Name)” is used
for female princes. Both male and female princes are addressed as “Your
Highness”.

**Crown Prince:** A crown prince is a prince who is the heir to the throne. A
crown prince is almost always a prince by birth. Only if a king or queen is
childless would it be possible to adopt someone as crown prince without causing
outright rebellion amongst nobility.

Although it would seem that crown princes would be the most pampered of princes,
the opposite is true. Because of their future responsibilities

they tend to have the most preparation—and are therefore the most likely to work
their way up from barony rather than just have higher titles awarded to them.

Being a crown prince is a risky business, since there are often many other
potential heirs keen to see one fail or die, as well as foreign powers keen to
cause internal strife.

The title “Crown Prince (Name) is used for male princes, and “Crown Princess
(Name)” is used for female princes, although occasionally (depending on the
rules of succession in the country in question) only princes of one sex will be
eligible to be crown princes. Both male and female crown princes are addressed
as “Your Royal Highness”.

**Imperial Prince:** An imperial prince is a prince who is the heir to an
empire. An imperial prince is almost always a prince by birth. Only if an
emperor or empress is childless would it be possible to adopt someone as an
imperial prince without causing outright rebellion amongst nobility.

Like crown princes, imperial princes tend to be active nobles. Because of their
future responsibilities they tend to have the most preparation—and are therefore
the most likely to work their way up from barony rather than just have higher
titles awarded to them.

Being an imperial prince is even more dangerous than being a crown prince, since
there are often many more interested parties keen to see one fail or die.

The title “Imperial Prince (Name) is used for male princes, and “Imperial
Princess (Name)” is used for female princes, although occasionally (depending on
the rules of succession in the empire in question) only princes of one sex will
be eligible to be imperial princes. Both male and female imperial princes are
addressed as “Your Imperial Highness”.

**King:** A king is the ruler of an entire country. The title is passed down in
a hereditary manner, and therefore the only way to become a king (if one is not
already heir to a throne) is to declare yourself the king of an area and get
away with it by having enough military and political support.

In some countries, being the spouse of a king or queen makes one a king or queen
yourself. This depends upon the rules of succession for the country in question.

In theory, a king has absolute power over their country. In practice, however,
the king is reliant on the income and military might provided by their nobles;
and it therefore is a foolish king indeed that does not take advice from those
nobles.

The title “King (Name)” is used for male kings, and the tile “Queen (Name)” is
used for female kings. Both male and female kings are addressed as “Your
Majesty”.

**Emperor:** An emperor is the king of a country that has taken over (and had
surrender to it) one or more other countries; but rather than simply expand to
cover the whole area, the countries that have been taken over are allowed to
remain autonomous (although sometimes their kings are deposed and replaced with
more friendly kings). These countries become client countries as part of a
larger empire, and the king of the country that is doing the taking over becomes
the emperor of the entire empire.

The heirs of an emperor will take on the title of emperor themselves without
necessarily taking over more countries than the founder of the empire did.

The kings of the client countries mostly run their states as before, although
they may have policies dictated by the emperor—particularly foreign policies,
and they may have to pay a yearly tribute to the emperor.

Depending on the size of the tribute and the policies imposed, the empire may be
seen as a useful and benevolent thing to have (especially if it brings peace
between previously antagonistic countries that have now become client states),
or it may be seen as an oppressive force that the client countries would
overthrow if they could.

In many cases, client countries lose control of their armies and find them
replaced by a single “Imperial Army” which is paid by—and loyal to—the empire.

Empires have a tendency to be too big to be stable, and rarely last more than
three or four generations before disintegrating; although the disintegration
often causes utter chaos and anarchy and the former kingdoms that made up the
empire rarely survive the break up.

The title “Emperor (Name)” is used for male emperors, and “Empress (Name)” is
used for female emperors. Both male and female emperors are addressed as “Your
Imperial Majesty”.

### Rogue States

Of course, it is entirely possible for player character (or non-player
character) to ignore this whole hierarchy and simply claim some area of
wilderness and proclaim themselves the ruler of it using whatever title they
feel like. Depending on the location they choose and the title they adopt, this
may be met with anything from indifference to derision to downright hostility by
other local rulers.

While it may be attractive to not have a ruler to pay salt tax to, the
independent dominion runs the constant risk of While some lucky
independents—usually those in the most isolated areas away from other states—are
able to grow from a single stronghold to a whole country, the vast majority soon
become part of a neighboring country; either by being taken over militarily or
by the political expedient of the independent ruler accepting a title of
nobility from the royalty of a nearby country and swearing allegiance to that
country in order to avoid a war they cannot win.

And, of course, some simply disappear; struck by plague or famine or worse.

However, claiming wilderness and declaring oneself to be an independent ruler is
always an option for a particularly desperate or adventurous character who
wishes to own a dominion without having to impress someone else enough to grant
them one.

### Building a Stronghold

No dominion can survive without a stronghold of some sort. The stronghold
provides not only an administrative center for the dominion, but also a secure
place to store the dominion’s wealth and to retreat to in times of war.

The area of land covered by a dominion is measured in *Fiefs*. A single fief is
an area of about 12 miles radius. If using hex maps, this translates to a single
24-mile hex that contains the stronghold, or a cluster of nine 8-mile hexes.

Usually, a dominion will consist of a single fief, with the stronghold roughly
in the center so that no point is too far away for easy access.

A large stronghold with several external troop garrisons can increase the
effective dominion to anything up to seven fiefs (one containing the stronghold
and another six surrounding it). However, the increased travel time needed for
either troops to get from the stronghold to an outlying village or for the
villagers from that village trying to seek refuge in the stronghold limits the
maximum size of the dominion to no larger than this.

If someone wishes to clear out more land and enlarge their dominion beyond this
size then they must build another stronghold to protect the newly cleared
land—and this then becomes the center of a second dominion.

Before a stronghold can be built, the surrounding area must first be cleared of
monsters that would threaten the builders. This job is ideally suited to
adventuring parties.

Once the area is clear, the stronghold itself can be designed and built. The
building costs (in both money and time) for the different components of a
stronghold are listed in Section 9.

#### Terrain & Resources

In order to determine the resources available to a dominion, the terrain of each
fief must be determined.

If you are using 24-mile hexes, this is straightforward, as a single map hex
will equal a single fief. If you are using 8-mile hexes or maps without hexes
then you will have to classify each fief according to its predominant terrain
type.

Each fief is classified as either *Civilized*, *Borderlands* or *Wilderness*,
according to the Dominion Fief Classification table below, depending on the
terrain type of the fief and how close it is to a major city or to other
civilized fiefs. Note that the other civilized fiefs don’t necessarily need to
belong to the same dominion or even the same country, as long as there are trade
links between them and the fief in question (which will usually be the case,
barring embargoes).

**Dominion Fief Classification Table**

| Terrain Type                                                                                                                                                                                                                                                   | Within 144 miles of a city | More than 144 miles from a city but within 72 miles of a Civilized fief | Not near a city or Civilized fief |
|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------------------------|-------------------------------------------------------------------------|-----------------------------------|
| Barren Lands                                                                                                                                                                                                                                                   | Borderlands                | Wilderness                                                              | Wilderness                        |
| Clear\*                                                                                                                                                                                                                                                        | Civilized                  | Borderlands                                                             | Wilderness                        |
| Desert                                                                                                                                                                                                                                                         | Borderlands\*\*\*\*        | Wilderness                                                              | Wilderness                        |
| Forest\*\*                                                                                                                                                                                                                                                     | Civilized                  | Borderlands                                                             | Wilderness                        |
| Grasslands\*                                                                                                                                                                                                                                                   | Civilized                  | Borderlands                                                             | Wilderness                        |
| Hills\*                                                                                                                                                                                                                                                        | Civilized                  | Borderlands                                                             | Wilderness                        |
| Jungle\*\*                                                                                                                                                                                                                                                     | Borderlands                | Wilderness                                                              | Wilderness                        |
| Mountains\*\*\*                                                                                                                                                                                                                                                | Borderlands                | Wilderness                                                              | Wilderness                        |
| Ocean                                                                                                                                                                                                                                                          | Wilderness                 | Wilderness                                                              | Wilderness                        |
| Settled                                                                                                                                                                                                                                                        | Civilized                  | Civilized                                                               | Borderlands                       |
| Swamp                                                                                                                                                                                                                                                          | Borderlands                | Wilderness                                                              | Wilderness                        |
| Woods\*                                                                                                                                                                                                                                                        | Civilized                  | Borderlands                                                             | Wilderness                        |
| \*Fiefs of this type can become Settled if populated by anyone.                                                                                                                                                                                                |                            |                                                                         |                                   |
| \*\*Fiefs of this type can become Settled if populated by elves                                                                                                                                                                                                |                            |                                                                         |                                   |
| \*\*\*Fiefs of this type can become Settled if populated by dwarves                                                                                                                                                                                            |                            |                                                                         |                                   |
| \*\*\*\*Fiefs containing oases are considered to be Civilized                                                                                                                                                                                                  |                            |                                                                         |                                   |

This civilization level of the fief determines both the number of families that
will be attracted to settle the area when the stronghold is built and also the
maximum number of families that the fief can support. See the Civilization Level
Table for details.

**Civilization Levels Table**

| Level       | Settling Families | Max Families |
|-------------|-------------------|--------------|
| Wilderness  | 1d10x10           | 1,500        |
| Borderlands | 2d6x100           | 3,000        |
| Civilized   | 1d10x500          | 6,000        |

#### Settled Terrain

Any *Clear*, *Forest*, *Grasslands, Hills* or *Woods* fief that is has over
1,000 families living in it is considered to be of terrain type *Settled* rather
than its basic terrain type.

*Mountains* fiefs with over 1,000 families become *Settled* only if populated by
dwarves, and *Forest* and *Jungle* fiefs with over 1,000 families become
*Settled* only if populated by elves.

This has two effects. Firstly, settled terrain uses different columns on
wilderness encounter tables than other terrain types (see *Chapter 12: Into the
Wilderness* for details about wilderness encounters). Secondly, the change to
settled terrain may change the civilization level of the fief, with a
corresponding increase in the maximum number of families that the fief can
contain.

The change in civilization level of the fief may have a knock-on effect on other
nearby fiefs, since they may now be within 72 miles (three 24-mile hexes or nine
8-mile hexes) of a civilized fief.

*Example: One of Lady Katrina’s dominions consists of a castle and its fief. The
entire area is Mountains, and is well away from other civilized lands. When the
castle is first built, the fief is therefore at the Wilderness level of
civilization.*

*After a few years, the population of her fief grows to 1,033 families. Because
Lady Katrina’s people are primarily dwarves, that fief is now considered to be
Settled rather than Mountains, and therefore becomes Borderlands and can support
a higher population.*

*Another of Lady Katrina’s dominions is in the hills closer to the rest of the
kingdom. It is also not within 144 miles of a city or within 72 miles of a
Civilized fief, but two of the fiefs adjacent to it are within 72 miles of a
Civilized fief.*

*Those two fiefs (which belong to allied barons) are therefore considered to be
Borderland Hills and Lady Katrina’s fief is considered to be Wilderness Hills.*

*After a few years, one of the adjacent Borderlands fiefs reaches 1,014
families. It is now considered to be Settled terrain rather than Hills. This
changes the civilization level of the fief to Civilized.*

*This change in civilization level means that Lady Katrina’s fief is now within
72 miles of a Civilized fief, and its civilization level is now upgraded from
Wilderness to Borderlands accordingly.*

Any fief that loses enough population that it no longer has 1,000 families also
loses its *Settled* type, and reverts back to its normal terrain type. Again,
this may have a knock-on effect on other fiefs; which may no longer be within 72
miles of a *Civilized* fief, and therefore may drop in civilization level
themselves.

Should this cause the maximum population of a fief to drop below its current
population, the population of that fief will reduce by 20% per month until it is
no longer unsupportable.

#### Material Resources

Each fief of the dominion will produce between one and four resources that must
be exploited to generate income for the dominion, determined by rolling a d10
and consulting the following list:

| 1   | 1 resource  |
|-----|-------------|
| 2-7 | 2 resources |
| 8-9 | 3 resources |
| 10  | 4 resources |

Although the actual resources available can be very varied, for game purposes
they are simply split into three categories: Animal, Vegetable and Mineral.

For each resource found, roll 1d10 to see which type it is:

| 1-3  | Animal    |
|------|-----------|
| 4-8  | Vegetable |
| 9-10 | Mineral   |

The Referee or players may wish to go into further detail about exactly what
types of resources these are; for example, a mineral resource could be a gold
seam or a source of strong stone for building or a source of fine clay or any
one of dozens of other types of mineral. This detail may enhance role playing,
particularly if the players like doing trade negotiations, but it does not
affect the dominion rules. In the example above, although gold is far more
expensive than building stone, there will also be far less of it and the
relative income for a gold mine or a quarry in a fief will be similar.

*Example: When Lady Katrina was granted her land and built her castle, the
Referee rolled for resources for the fief. He rolled that the fief had three
resources: two mineral and a vegetable. Jim discussed what those three resources
could be with the Referee, and between them they decided that there was a silver
seam that could be mined, a source of granite that could be quarried,
and—because the mountain fief is in a warm region and on the edge of the
mountain range—olive groves in the valleys and foothills.*

### Ruling a Dominion

In *BX Advanced*, ruling of a dominion takes place in the timescale of months
and years, dropping down to a day-to-day basis only during unusual situations.

To be specific, the population change and the economy (the income and
expenditure for the dominion) are handled on a monthly basis, and the level of
satisfaction—or unrest—of the populace is usually handled on a yearly basis but
may need to be checked in exceptional circumstances.

#### Population Change

Each month, the number of families in each fief of the dominion will change due
to a variety of factors. Rather than try to account for each individual factor,
*BX Advanced* abstracts the whole population change for the month into a single
check.

For each fief, the basic population change is based on the existing population
of the fief:

| Population         | Change |
|--------------------|--------|
| 1-100 families     | \+25%  |
| 101-200 families   | \+20%  |
| 201-300 families   | \+15%  |
| 301-400 families   | \+10%  |
| 401-500 families   | \+5%   |
| 501-750 families   | \+3%   |
| 750-1,000 families | \+2%   |
| 1,001+ families    | \+1%   |

In addition to this percentage increase, each fief with fewer than 250 families
must roll 1d6 and consult the following:

| 1-3 | Lose 1d10 families |
|-----|--------------------|
| 4-6 | Gain 1d10 families |

In the case of more populous fiefs, these small changes are simply assumed to be
irrelevant compared to the normal population growth.

*Example: When Lady Katrina builds her castle, the fief is wilderness.
Therefore, it attracts 1d10x10 families as settlers. Jim rolls a 7, so 70
families settle the fief.*

*After a month, Jim checks the fief for population growth. There are less than
100 families, so there is a 25% increase, making 94 families. Additionally,
because there are less than 250 families in the fief, Jim rolls a d6 to see what
the random fluctuation is. He rolls a 6, which is good news because it means
that there is a further increase in population of 1d10 families, but is
disappointed when he then only rolls a 2 on the 1d10. Two extra families arrive,
making a total of 96 families at the start of month two.*

#### Monthly Economy Check

Each game month, the ruler of the dominion, along with the Referee, needs to
check the economy and tally up the income and expenditure for the month.

##### Income

Monthly income comes from four sources:

**Resources:** Each fief of the dominion will have between 1 and 4 types of
resource in it. These resources provide income for the dominion ruler based on
their resource type:

| Animal    | 2gp/family |
|-----------|------------|
| Vegetable | 1gp/family |
| Mineral   | 3gp/family |

Each family within the fief may work on a single resource within the fief.

The ruler of the dominion may simply let the populace split themselves evenly
between the available resources, or may direct the populace to concentrate on
exploiting a particular resource.

However, doing so is subject to a few limitations.

Firstly, given the infrastructure needed to exploit a particular resource
(animals need breeding, crops need sowing, mines need digging), the ruler of a
dominion can only change the emphasis once per year. The ruler must decide what
their priorities will be at the beginning of each year, and the actual change to
those new priorities will happen at the beginning of the *following* year. When
doing so, it is convenient to assign priorities in terms of percentages of
families rather than in absolute numbers of families, since the total number of
families in the fief will change from month to month.

Secondly, the populace must work all the resources in the fief for the local
economy to thrive and for the populace to be content. In particular, forcing too
much of the population to work in dangerous and unhealthy mines makes the ruler
very unpopular.

In game terms, each resource must be worked by at least 20% of the families in
the fief. For each 1% below that threshold in a year, there is a cumulative –1
penalty to the dominion’s Confidence Rating. Similarly, no more than 50% of the
families in the fief should be made to exploit mineral wealth. For each 1% above
that threshold in a year, there is a cumulative –1 penalty to the dominion’s
Confidence Rating.

Thirdly, any fief that brings in a monthly revenue of 15,000gp or more will
attract corruption, black markets and bandits. Unless that fief contains the
stronghold from which the dominion is ruled, 1d10x10% of the potential resource
income will be lost to such forces.

**Service:** Each family in the dominion brings in the equivalent of income
worth 10gp per month in service, such as building works, growing food, tending
animals, and so forth.

Unlike other sources of income, this is not actually received by the ruler of
the dominion as money. However, it can be used to offset expenses such as
holidays, tithes, salt tax, and the paying of armies (mercenary or otherwise).
Any service income that is not used is wasted and cannot be stored.

**Poll Tax:** Each family in the dominion normally pays 1gp per month in poll
tax. This is actual money-in-the-coffers tax paid in coinage.

The ruler of the dominion can set the tax rate higher or lower if they desire.
For each extra 5sp that is paid per family, there is a –10 penalty to the
dominion’s Confidence Rating per year. For each 5sp less that is paid per
family, there is a +5 bonus to the dominion’s Confidence Rating per year.

Additionally, when the ruler increases the tax rate, this gives an instant –25
penalty to the dominion’s Confidence Rating and forces an immediate confidence
check. Similarly, decreasing the tax rate gives an instant +10 bonus to the
dominion’s Confidence Rating.

**Salt Tax:** If the ruler of the dominion has other nobles who have sworn
fealty to them, they are given 20% of the total income of each lesser noble’s
dominion.

This income is normally paid in the form of services, and therefore doesn’t
actually arrive as coinage. However, like other service income it can be used to
offset expenditure. Like service income, this income cannot be stored, and must
be used or wasted.

*Example: In the fief containing her castle, Lady Katrina has assigned 25% of
the families to work in the silver mine, 25% of the families to work in the
granite quarry, and 50% of the families to work in the olive groves. Since she
has at least 20% of the population working on each resource and she does not
have more than 50% of the population working on mineral resources there is no
effect on her dominion’s confidence level.*

*After a few years of growth, there are 447 families living in the fief.
Splitting these families into the different resources (with some rounding)
gives:*

*447x25% = 112 families mining silver*

*447x25% = 112 families quarrying granite*

*447x50% = 223 families farming olives*

*Therefore, the resource income for the fief in the first month of that year
is:*

*(112x3) + (112x3) + (223x1) = 895gp*

*The service income of the fief is simply ten times the population, which is:*

*(10x447) = 4,470gp*

*Lady Katrina has not set taxes higher or lower than the 1gp/family, so in poll
tax she receives:*

*(1x447) = 447gp*

*Therefore, for this fief, Lady Katrina receives a total of 1,342gp in cash and
4,470gp in services that can offset expenditure.*

*The Referee then instructs Jim to add 920gp of extra service income for the
salt tax paid to Lady Katrina by the baron who looks after her second dominion.*

##### Expenditures

The following expenses must be accounted for:

**Castle Staff and Maintenance:** With the exception of armies, which must be
accounted for, the cost of castle staff and routine maintenance is assumed to
already be covered by the service income of the dominion.

However, extraordinary expenses such as rebuilding works in the wake of a siege
or a monster attack must be paid for out of the ruler’s pocket. Service income
may be used to pay for these expenses.

**Troops:** Whether a full time standing army, a “special forces” unit of
adventurers, or a group of mercenaries; troops must be paid for.

Armies and mercenaries can be paid for with service income, based on their costs
in *Chapter 8: Equipping for Adventure*, but adventurers usually only work for
cold hard cash.

In times of dire need, a peasant militia can be formed from the local populace.

Up to 10% of the families in an area can provide “poor” quality peasant militia
(providing an average of 2.5 troops per family). A further 10% of the families
in an area can provide “untrained” quality peasant militia (providing an average
of 2.5 troops per family).

If either are called up, the families providing militia will not produce income
of any type during the months in which the militia is active.

**Tithes:** One tenth of all gross income (income before any expenditure has
been taken out) must be given in tithes to the various churches and temples that
are worshipped throughout the dominion.

Tithes may be paid with either service income or money, or a combination of the
two.

Failure to provide the full amount of tithes results in the churches (and
possibly Immortals associated with them) being angered, and they make their
anger known to the populace.

The net result of this is that any year in which tithes are not paid in full
gives a –50 penalty to the dominion’s Confidence Rating.

If tithes are short-changed for more than one year in a row, there is a 25%
chance each year that an extra “Disaster” event will happen that year as the
Immortals show their displeasure. If such an event is going to happen, it will
be preceded by omens and prophetic dreams.

**Salt Tax:** In just the same way that the dominion may receive salt tax from
subservient dominions, it must also pay twenty percent of its gross income
(income before any expenditure has been taken out) to the noble or royal that
the ruler of the dominion has sworn fealty to.

Salt tax may be paid with either service income or money, or a combination of
the two.

**Festivals and Holidays:** Some days during the year are declared as festivals
or holidays. These may have been declared by the ruler of the country, or by one
of the major religions of the country, or the ruler of the dominion may declare
their own.

The overall cost of a holiday is 5gp per family. This represents both the
expenditure for celebrations and also the lost income because people are not
working. This cost may be paid with either service income or money, or a
combination of the two.

If the holiday was one declared by the churches, its cost can be recouped from
the tithes paid to the church. Similarly, if the holiday was one declared by the
ruler of the country, its cost can be recouped from the salt tax paid to that
ruler.

However, if the cost of the holiday is too great to be covered by the tithes or
salt tax (or if the holiday was declared by the dominion ruler rather than by a
higher power) the dominion ruler must pay the remaining cost themselves.

Each time a regular holiday or festival that the populace are expecting is
cancelled, a –5 penalty is applied to the dominion’s Confidence Rating, and an
immediate confidence check must be made.

Each time an extraordinary holiday or festival day is announced, a +2 bonus is
applied to the dominion’s Confidence Rating.

**Entertaining Visitors:** Etiquette demands that visiting nobles and royalty
are entertained according to their station.

The following costs apply whenever a noble (and their retinue) are visiting:

| Knight   | No extra cost           |
|----------|-------------------------|
| Baron    | 100gp/day               |
| Viscount | 150gp/day               |
| Count    | 300gp/day               |
| Marquis  | 400gp/day               |
| Duke     | 600gp/day               |
| Archduke | 700gp/day               |
| Prince   | As nobility + 100gp/day |
| King     | 1,000gp/day             |
| Emperor  | 1,500gp/day             |

*Example: Lady Katrina has a total income from her dominion for the month
(including salt tax from her second dominion) of 1,342gp in cash, and 5,390gp
worth of services.*

*Firstly, she takes 30% of that out (20% in salt tax to the queen and 10% in
tithes to the church). She ends up paying 1,346gp to the queen and 673gp to the
church for a total of 2,018gp.*

*The 2,018gp is all paid out of service income, leaving her with:*

*5,390-2,018 = 3,372gp left.*

*There was a religious festival for one day during the month. Since the
population of her dominion is 447 families, this costs her:*

*447x5 = 2,235gp*

*Since this was a religious festival, she can use tithes to help fund it. She
should be paying 673gp in tithes, so that leaves:*

*2,235-673 = 1,562gp to pay.*

*She pays the 1,562gp out of her remaining service income, leaving her with:*

*3,372-1,562 = 1,810gp left*

*Out of this 1,810gp, she pays for her standing army consisting of 300 heavy
dwarven infantry (costing 5gp each per month) and 100 dwarven crossbowmen
(costing 6gp each per month).*

*These troops cost her:*

*(300x5) +(100x6) = 2,100gp*

*She can pay 1,810gp of this wage bill using services, leaving her:*

*2,100-1,810 = 290gp to pay*

*She pays the 290gp out of her 1,342gp cash income, leaving her:*

*1,342-290 = 1,052gp*

*Having balanced her finances for the month, Lady Katrina discovers that she has
managed to pay most of her expenses out of service income, but she considers
cutting back on troop numbers, since she’s having to dip into real cash in order
to pay them.*

*She keeps the 1,052gp of cash and puts it in her coffers.*

##### Experience for Income

When calculating the amount of experience the ruler of a dominion gets from
their monthly income, there are two rules that must be applied.

Firstly, only cash income (i.e., Resources and Poll Tax) provide experience
points. Service income and income from Salt Tax of lesser nobles does not
provide experience points.

Secondly, experience points are derived from the gross income of cash (income
before any expenditure has been taken out). Even if all the income is spent due
to heavy expenditure and the ruler ends up making a net loss, they will still
receive full experience.

*Example: Lady Katrina received 1,342gp of cash and 5,390gp of services this
month. She gets experience for all of the cash even though she had to spend some
of it, but does not get money for the services. Lady Katrina therefore gains
1,342xp this month.*

### Confidence Level

Each dominion has a *Confidence Rating*. This is a number that represents the
general state of content (or discontent!) of the populace.

There is a single confidence rating for the whole dominion—different fiefs do
not have separate ratings.

When a dominion is first established, the initial confidence rating is set to
the sum of the ability scores of the ruler plus 150 plus an additional d100
roll.

In addition to the confidence rating, a dominion also has a *Confidence Level*.
The confidence level is based on the rating, and periodically a “confidence
check” is made. Whenever a confidence check needs to be made, look up the
current confidence rating on the Confidence Level Table and this will indicate
the new confidence level.

**Confidence Level Table**

| Confidence Rating | Confidence Level |
|-------------------|------------------|
| 49 or less        | Turbulent        |
| 50 to 99          | Belligerent      |
| 100 to 149        | Rebellious       |
| 150 to 199        | Defiant          |
| 200 to 229        | Unsteady         |
| 230 to 269        | Average          |
| 270 to 299        | Steady           |
| 300 to 349        | Healthy          |
| 350 to 399        | Prosperous       |
| 400 to 449        | Thriving         |
| 450 or higher     | Ideal            |

It is important to remember that although the confidence rating may change
frequently, the confidence level only changes when a confidence check is
made—even if the rating moves into a different range between checks.

#### Yearly Confidence Check

At the beginning of each year, the Referee checks the current confidence rating
on *table 13-3* in order to determine the confidence level of the dominion.

This confidence check may also be required as a result of certain actions by the
dominion ruler (e.g., when an expected holiday is cancelled) or as a result of a
disaster striking the dominion.

Descriptions of the various confidence levels and their effects on the dominion
are given below:

**Average:** The dominion is running smoothly. There are no special conditions
or effects.

**Belligerent:** In each fief that has fewer troops than one half of the number
of families, half the families will form a peasant militia (providing an average
of 2.5 troops per family).

No poll tax can be collected.

A quarter of normal service income can be collected in areas without a peasant
militia, but none can be collected in areas with a peasant militia.

A quarter of normal resource income can be collected in areas without a peasant
militia, but none can be collected in areas with a peasant militia.

A –10 penalty is applied to the confidence rating.

All trade caravans and travelling officials will be attacked by bandits.

Any of the dominion ruler’s troops that move or deploy within the dominion will
be attacked by peasant militia, deserters, bandits or enemy agents.

There is a 50% chance that an enemy state will provide the peasant militia with
military support.

**Defiant:** In each fief that has fewer troops than one third of the number of
families, half the families will form a peasant militia (providing an average of
2.5 troops per family). However, these militia will not attack unless provoked.

No poll tax can be collected.

A half of normal service income can be collected in areas without a peasant
militia, but only a third can be collected in areas with a peasant militia.

A half of normal resource income can be collected in areas without a peasant
militia, but only a third can be collected in areas with a peasant militia.

**Healthy:** All income is 10% greater than normal.

There is a 25% chance per agent that enemy agents working in the dominion will
be exposed.

**Ideal:** All income is 10% greater than normal.

There is a 75% chance per agent that enemy agents working in the dominion will
be exposed.

If a random check indicates that a disaster will occur during the coming year,
there is a 25% chance that it will not happen.

A +25 bonus is applied to the confidence rating.

The confidence rating cannot drop below 400 before the next confidence check.

**Prosperous:** All income is 10% greater than normal.

There is a 25% chance per agent that enemy agents working in the dominion will
be exposed.

If a random check indicates that a disaster will occur during the coming year,
there is a 25% chance that it will not happen.

**Rebellious:** In each fief that has fewer troops than one third of the number
of families, half the families will form a peasant militia (providing an average
of 2.5 troops per family). However, these militia will not attack unless
provoked.

No poll tax can be collected.

A third of normal service income can be collected in areas without a peasant
militia, but only a quarter can be collected in areas with a peasant militia.

A third of normal resource income can be collected in areas without a peasant
militia, but only a quarter can be collected in areas with a peasant militia.

A –10 penalty is applied to the confidence rating.

**Steady:** There is a 25% chance per agent that enemy agents working in the
dominion will be exposed.

**Thriving:** All income is 10% greater than normal.

There is a 50% chance per agent that enemy agents working in the dominion will
be exposed.

If a random check indicates that a disaster will occur during the coming year,
there is a 25% chance that it will not happen.

**Turbulent:** 95% of families will form a peasant militia (providing an average
of 2.5 troops per family).

No income of any kind may be collected, except by force.

A –10 penalty is applied to the confidence rating.

The confidence rating cannot rise above 100 until the ruler of the dominion is
removed.

All trade caravans and travelling officials will be attacked by bandits.

Any of the dominion ruler’s troops that move or deploy within the dominion will
be attacked by peasant militia, deserters, bandits or enemy agents.

One or more enemy states will provide the peasant militia with military support.

**Unsteady:** There is a 20% chance that a –10 penalty will apply to the
confidence rating.

### Dominion Events

Each year, 1d4 random events will happen in the dominion.

Due to the huge variety of events that can occur, it is not possible to list
them here. However, they can be roughly classified into types of event.

For each event that occurs, roll on *table 13-4* to determine the type of event.

**Dominion Events**

| D100 roll | Event Type           |
|-----------|----------------------|
| 01-05     | Major Positive Event |
| 06-20     | Minor Positive Event |
| 25-40     | Neutral Event        |
| 41-75     | Minor Negative Event |
| 76-95     | Major Negative Event |
| 96-00     | Disaster             |

Although this table is random, the Referee should be fair to the players and
should not let players’ dominions be wiped out by a few bad rolls which indicate
disaster after disaster. If the dice seem to be against the players, then the
Referee should introduce plot elements or potential adventures into the game
that can mitigate the worst situations. Similarly, if the dice are favoring the
players and they are getting bored just raking in the money every month without
challenge, the Referee should introduce plot elements or adventures that can
cause additional problems.

However, in either case the Referee should be careful not to railroad the
players and make them feel that the status quo is being forcibly maintained. The
Referee should make sure that the players’ decisions have a real impact on the
way their dominions prosper or struggle.

Types of event and their effects are listed below:

**Major Positive Event:** A major positive event will benefit the dominion
greatly. It may result in a bonus to the confidence rating of up to +25, up to a
doubling of income for a month, a population increase of up to +25%, or some
combination of the above. Depending on the nature of the event, the ruler may
need to get involved personally in order to get the best results—but there
should be some positive results even if the ruler does nothing.

*Examples: New resource type found, ancient treasure found, An Immortal decides
to become the patron of the dominion, A clan of demi-human refugees joins the
dominion.*

**Minor Positive Event:** A minor positive event will benefit the dominion, or
at the very least not harm it. It may result in a bonus to the confidence rating
of up to +15, up to 50% extra income for a month, a population increase of up to
+15%, or some combination of the above. The ruler may need to get involved
personally in order to get the benefits—but there should be no negative results
even if the ruler does nothing.

*Examples: A new trade route is proposed, a hostile tribe of humanoids moves
away from the dominion, passing adventurers clear out local bandits without
needing to be hired to do so, A druid moves into the area.*

**Neutral Event:** A neutral event may benefit the dominion or harm it,
depending on how it is dealt with. It may result in a change to the confidence
rating of up to +/-10, up to 25% extra or less income for a month, a population
change of up to +/-10%, or some combination of the above. Whether the event
works out positively or negatively should depend on how the ruler handles it.

*Examples: A VIP visitor arrives unexpectedly, Comets or other omens are seen in
the sky, heresy is discovered in a local church, a local tribe of humanoids is
displaced by a different tribe*

**Minor Negative Event:** A minor positive event will harm the dominion, or at
the very least not benefit it. It may result in a penalty to the confidence
rating of up to +15, up to 50% less income for a month, a population decrease of
up to -15%, or some combination of the above. The ruler may need to get involved
personally in order to avoid the harm—but there should be no significant
positive results no matter how well the ruler handles the situation.

*Examples: Bandits start raiding, an official is assassinated, low level
wandering monsters arrive in the area, a disease breaks out.*

**Major Negative Event:** A major negative event will harm the dominion greatly.
It may result in a penalty to the confidence rating of up to -25, up to 75% less
income for a month, a population decrease of up to -25%, or some combination of
the above. Depending on the nature of the event, the ruler may need to get
involved personally in order to get the least bad results—but there should be
some negative results no matter how well the ruler handles the situation.

*Examples: One of the fief’s resources runs out, an epidemic strike, a high
level wandering monster enters the dominion, agitants foment rebellion against
the ruler, a major fire breaks out.*

**Disaster:** A disaster event will harm the dominion greatly in a similar way
to a major negative event. It may result in a penalty to the confidence rating
of up to -25, up to 75% less income for a month, a population decrease of up to
25%, or some combination of the

above. It will also result in an immediate confidence check. Depending on the
nature of the event, the ruler may need to get involved personally in order to
get the least bad results—but there should be seriously negative results no
matter how well the ruler handles the situation.

*Examples: An extremely high level monster attacks the dominion, plague strikes,
a hurricane, tornado or avalanche sweeps the dominion, an earthquake strikes, an
Immortal smites the dominion.*

Mass Combat
-----------

Mass combat may be an important part of the game if the characters have elected
to control and protect a domain. Battles are assumed to be between two armies.
Armies are groups of units. A unit is a group of similarly skilled and armed
individuals working together. A single unit consists of one type of soldier and
cannot be split during battle. During a battle, units from each army maneuver
and fight until one side emerges victorious. In mass combat it is assumed that a
single person can rarely affect the outcome; this is about the clashing of
armies in the old school handful of d6s style.

### Scale

A figure is the smallest level of abstraction for mass combat. One figure
represents a group of ten human-sized creatures, five monsters, or a single solo
creature. Infantry are the creatures that fight on foot and are roughly human
sized; a horde of goblins, a fist of orcs, or a regiment of skeletons. Cavalry
are human-like creatures that fight while mounted, or are innately similar to
mounted humanoids; like a centaur tribe or a group of dire wolves. Monsters
refer to larger than human creatures that would fight in small groups; ogres and
trolls are all considered monsters in mass combat. Solo creatures are so large
or dangerous that they fight alone; a dragon, a heroic champion, or a war wizard
are all solo creatures.

| **Infantry** | **Cavalry** | **Monsters** | **Solo** |
|--------------|-------------|--------------|----------|
| 10:1         | 5:1         | 5:1          | 1:1      |

If you are playing the battle out with miniatures or on a map use a 1 inch to 20
feet scale. At this scale one figure of infantry should take up roughly one
square inch. A figure of cavalry would take up double that, one inch by two
inches, and monsters would take up bases double that of cavalry, two inches by
two inches. Solo creatures or other unique units should take up an amount of
space that the Referee finds reasonable.

### Time & Phases

Time is measured in segments, 10 minute periods, for mass combat. During each
segment both armies will advance through the three phases of the game. Once both
armies have performed all three phases a new segment starts. The three phases
that each army goes through are done in order, with both armies performing one
phase and then going to the next.

*Movement*: Each army moves its units. The distance a unit can move depends on
the type and equipment of the unit. If a unit will perform no other actions on
their turn, they may move at march speed; move double the normal distance.

*Shooting*: Each unit within an army that can shoot may do so during this phase.
Only units with ranged weapons may shoot during this phase. The range of their
weapons is equal to that given in the equipment section.

*Melee*: Each unit that is within 20 feet of an enemy engages in melee combat
with that enemy. Units in melee combat cannot perform any actions except fight
in melee combat unless they fall back.

### Basic Combat

An attack is made by rolling 1d10 and rolling less than or equal to than the
enemy’s AC. For each unit that is making attacks, shooting or melee, you will
roll 1d6 for every figure within it that can reach their enemy. So, a unit with
ten figures will have 10 1d10 attacks. For infantry and cavalry every hit
removes one figure. For monsters and solo creatures, it takes a number of hits
equal to their HD to remove a figure. Melee combat occurs simultaneously, both
sides of the combat roll all of their attacks and then casualties are removed
afterward. Once a unit has lost more than half of its figures it will make a
morale check at the start of the next segment. If it fails it will flee the
battlefield. If it passes it will continue fighting.

#### Starting Mass Combat

Each side rolls 1d6, the side with the higher value may choose to act first or
second during each phase. Once they have chosen the order does not change.

#### Unit Positioning

The figures in a unit are arranged in ranks. A rank can be up to ten figures
wide. A unit can have no more than 5 ranks (so an infantry unit holds, at most,
50 figures or 500 creatures). The number of figures in each rank, and how many
ranks there are can be important during battles.

#### Movement Phase

The distance a unit can move is given in feet and depends on that unit’s
equipment. A unit may move at march speed (double the normal movement distance)
if they do not make attacks or shoot that segment.

| Unit                | Movement                |
|---------------------|-------------------------|
| Cavalry (Armored)   | 100 ft.                 |
| Cavalry (Heavy)     | 140 ft.                 |
| Cavalry (Light)     | 180 ft.                 |
| Infantry (Armored)  | 80 ft.                  |
| Infantry (Heavy)    | 100 ft.                 |
| Infantry (Light)    | 120 ft.                 |
| Monster (Armored)   | 140 ft.                 |
| Monster (Unarmored) | 100 ft.                 |
| Solo Creature       | Referee’s Determination |

Units that are engaged in melee combat that want to move away from that combat
may fall back. When a unit falls back it moves at half its normal speed (if it
chooses to move back at its march speed it will move back its normal speed).

If a unit wants to change its positioning during combat it must spend its entire
movement to do so. If a unit choose to reform at march speed it may reform and
then move a distance equal to its normal movement. If it does so, it cannot make
any attacks during this segment.

A unit may choose to change position into a hedgehog, presenting no flank or
rear for an enemy to attack. This will take the entire movement of the unit.

#### Shooting Phase

A unit with ranged weapons can shoot them at another unit within line of sight
and the range of their weapons. Only figures in the first three ranks of a unit
with ranged weapons can make attacks during the shooting phase. If a unit shoots
during the shooting phase it cannot make melee attacks this segment. If a unit
loses more than a quarter of its total number of figures during one shooting
phase it will immediately make a morale check.

#### Melee Phase

Opposed units within 20 feet of each other will enter melee combat during the
melee phase. Only the first rank of figures can make attacks during melee
combat. Both sides make all of their attacks simultaneously and then remove any
casualties afterward. Once casualties have been removed, any unit that took
casualties in melee combat needs to make a morale check.

A larger unit may wrap around a smaller unit, if there is space to do so, and
inflict the flank attack penalty to the smaller unit’s morale check.

If a unit attacks another unit’s rear, the attacking unit’s attacks will hit
first. Remove the casualties from the defending unit before they make their
return attacks.

### Morale Checks

A unit that makes a moral check rolls a saving throw. If they roll less than or
equal to their saving throw value they will continue fighting, if they roll
higher, they will flee the battle. Units that flee the battle are removed from
the game and are treated as casualties. After the battle they may rejoin the
army.

A unit that is attacked on one or both of its flanks lowers its saving throw
value by one. A unit attacked in the rear lowers its saving throw value by two.
A unit that charged the enemy increases its saving throw value by two. A unit
that outnumbers the enemy increases its saving throw by one. A unit with high
morale has advantage on this saving throw.

### Arms & Armor

The specific weapons that a unit is wielding matters only insofar as their
range. A unit equipped with melee weapons can only fight with one rank in melee
combat but holds shields. A unit equipped with polearms can fight in two ranks
in melee combat. A unit equipped with missile weapons can make missile attacks
at the range described for that weapon.

The armor that a unit is wearing is already decided, but if you want more
variety simply calculate the AC following the normal rules for armor presented
in the Original Edition rules (use descending AC). The only exception to this
rule is that AC cannot exceed a score of 2. Solo creatures use their own AC (\*)
value. AC scores naturally higher than 2 [17] are rare, but if they happen to be
in a battle treat their AC score as 2 [17].

### Hiring Units

A character with enough money may hire mercenaries to go on campaign with them
for the wages listed below (per figure). A character cannot hire monsters or
solo creatures without special Referee permission (\*\*\*). Figures killed in
battle are still paid - their next of kin receive the money instead of
themselves.

| **Figure**                           | **AC** | **HD** | **ST** | **Wages (day)** | **Wages (month)** |
|--------------------------------------|--------|--------|--------|-----------------|-------------------|
| Cavalry (Armored, Melee)             | 2      | 1      | 16     | 15 gp           | 150 gp            |
| Cavalry (Heavy, Melee)               | 3      | 1      | 14     | 10 gp           | 100 gp            |
| Cavalry (Light, Melee)               | 4      | 1      | 12     | 6 gp            | 60 gp             |
| Cavalry (Light, Missile - Shortbow)  | 5      | 1      | 10     | 8 gp            | 80 gp             |
| Infantry (Armored, Melee)            | 3      | 1      | 14     | 8 gp            | 80 gp             |
| Infantry (Armored, Polearm)          | 4      | 1      | 12     | 8 gp            | 80 gp             |
| Infantry (Heavy, Melee)              | 4      | 1      | 12     | 5 gp            | 50 gp             |
| Infantry (Heavy, Missile - Xbow)     | 5      | 1      | 10     | 6 gp            | 60 gp             |
| Infantry (Heavy, Missile - Longbow)  | 5      | 1      | 10     | 8 gp            | 80 gp             |
| Infantry (Heavy, Polearm)            | 5      | 1      | 10     | 5 gp            | 50 gp             |
| Infantry (Light, Melee)              | 7      | 1      | 10     | 3 gp            | 30 gp             |
| Infantry (Light, Missile - Longbow)  | 7      | 1      | 8      | 5 gp            | 50 gp             |
| Infantry (Light, Missile - Shortbow) | 7      | 1      | 8      | 3 gp            | 30 gp             |
| Infantry (Light, Missile - Sling)    | 7      | 1      | 8      | 1 gp            | 10 gp             |
| Infantry (Light, Polearm)            | 7      | 1      | 8      | 1 gp            | 10 gp             |
| Monster (Armored, Melee)             | 3      | 2-4    | 10     | \*\*\*          | \*\*\*            |
| Monster (Unarmored, Melee)           | 6      | 2-4    | 8      | \*\*\*          | \*\*\*            |
| Solo Creature                        | \*     | 5 +    | \*\*   | \*\*\*          | \*\*\*            |

### Special Units

The rules for warfare are optimized for groups of human-like creatures engaging
in battle consisting of infantry and cavalry. Monsters and Solo creatures add
amore fantastic element but require Referee arbitration. It should be easier for
a monster or solo creature to hit infantry or cavalry (a flat bonus to hit) and
they should have more than one attack per figure. The exact bonus or attack
number is left to the Referee to determine.

#### Characters in Mass Combat

A character of level four or less is not powerful enough to make a significant
difference in a battle. Characters of level five or higher function as a solo
creature. Simply use the character’s AC, HD. and saving throws as normal.

### War Magic

Most spells are too small scale to greatly impact a battle. Those spells that
are large enough to affect a mass combat (e.g., fireball) are called war magic.
A magic using solo character can cast one war magic spell (assuming the figure
has any available) during the shooting phase.

<br><br><br>Section III: Monsters
=================================

Mythos Monsters
---------------

### Adversaries

A selection of adversaries from Lovecraft’s fiction for Original Edition games.
All Mythos monsters should be considered to have an alignment of chaos unless
otherwise noted.

#### Cave Beast

*AC:* 7 [12]

*HD:* 2 (7 hp)

*Attacks:* Two claws +2 (1d3)

*Move:* 120 feet

*Morale:* 7

*Special:* Echolocation

Rare creatures that dwell in deep caverns, cave beasts have thin white hair,
sunken black eyes, and long rat-like claws on their hands and feet. They are
blind and rely on **echolocation** to traverse rough passages without hindrance
and locate prey. Conjecture indicates that cave beasts were once humans, but
devolved due to their long residence under the earth.

#### Color Out of Space

*AC:* 4 [15]

*HD:* 5 (18 hp)

*Attacks:* See description

*Move:* 240 feet fly

*Morale:* 10

*Special*: Focus Energy, Non-physical

Descending from the unknown reaches of Outer Space, Colors Out of Space seem to
be a sentient form of radiation. They lack any distinguishable form and appear
in darkness as a vague glow of an unidentifiable color from outside the normal
spectrum. Their spore are born through the cosmos deep inside asteroids and are
released when they crash into a planet’s surface. The spore seeks a wet, dark
den in which to reside, such as a well or lakeside cave. From there, it infects
the immediate area with an unusual “sickness”, drawing energy away from living
things. Plant life is first affected, but as the Color gains power, it preys
upon small animals and larger creatures. Its weird influence causes lifeforms to
be mutated, sometimes doubling in size, before undergoing a miserable agony and
crumbling to dust. By this time, the area exhibits serious decay and
lifelessness. Once it has gained sufficient energy, the Color shoots off into
space to infect other worlds.

Those spending more than 1 hour in an affected area must make a successful
Saving Throw vs. poison or be afflicted by the Color’s influence. Failing the
Save causes the individual to lose 1 point of Constitution and Wisdom and become
lethargic. For each additional day spent in the area, the character loses 1d4
Constitution. The Color cannot make physical attacks, however, if it feels
threatened, it can expend an amount of its stored energy to affect individual
creatures. When a Color focuses energy, the target must make a Saving Throw or
immediately lose 1d4 Constitution and Wisdom. All attribute damage caused by a
Color is permanent. Finally, it is completely immune to physical attacks, but it
may be susceptible to magic or the effects of weird science apparatus.

#### Cthulhu Spawn

*AC:* 3 [16]

*HD:* 10 (35 hp)

*Attacks:* Three tentacles (2d6)

*Move:* 80 feet (120 feet swim,80 feet fly)

*Morale:* 10

*Special*: Psychic Abilities, Regenerate, Spells, Swallow Whole

Eons ago, the strange Cthulhu Spawn descended from the Outer Dark and infested
the Earth. They are almost entirely octopoid or slug-like with a mass of
tentacles where a face might be. Regardless of their shape, they have highly
evolved brains capable of psychic abilities, which may be used in addition to
normal attacks:

-   They can communicate with any creature telepathically.

-   They feed on psychic energy and can drain psyche; victim loses 1d4 Wisdom
    (Save for half).

-   They can attack a character’s psyche with a mind blast (1d4 Intelligence and
    affected as per the confusion spell; a Save negates the confusion effect and
    allows for half Intelligence loss).

-   They can move objects through telekinesis.

-   Finally, they can dominate a victim’s mind, causing him to freeze in place,
    attack his allies, etc., as the spell. The victim is allowed a Saving Throw
    each round to break free.

Additionally, Cthulhu Spawn know 2d6 spells determined by the referee. When
making physical attacks, Cthulhu Spawn will attack with claws, tentacles, or
both, depending on their form. Finally, they regenerate 3 hit points per round.

Cthulhu Spawn are massive and fly via an impossible levitation. Any target
struck by one of their tentacle attacks must make a Saving Throw against
paralysis or be grabbed. Grabbed targets are swallowed whole the following round
and suffer 1d6 damage each round after.

#### Deep One

*AC:* 5 [14]

*HD:* 2+2 (9 hp)

*Attacks:* Two claws (1d6)

*Move:* 240 feet flying

*Morale:* 8

*Special*: Breathe underwater

A fish-like humanoid race unimaginably older than humanity, deep ones live in
undersea cities and worship Dagon and Cthulhu. They have scaled, rubbery skin,
webbed digits, and round, staring eyes. Deep ones are known to cavort with
humans in seaside towns, trading their favors and alien goldwork for service and
worship of Dagon. Deep ones can mate with humans, and the half-breed offspring
are doomed to transform into sea-folk over time, eventually becoming entirely
deep one. The creatures are immortal, dying only to violent causes, and continue
to grow throughout their lives. Deep ones attack with savage claws. Though they
can breathe underwater indefinitely, they can also survive out of water for
several hours.

For every 20 deep ones, there will be a 4 HD leader who knows 1 or 2 spells; and
for every 50, a 6 HD leader is present. All 6 HD deep ones know 1d4+2 random
spells and stand up to 8 feet in height.

#### Elder Thing

*AC:* 4 [15]

*HD:* 5 (18 hp)

*Attacks:* Tentacle slap (1d6+2) or by weapon (+2 melee damage)

*Move:* 60 feet (30 feet swim, 30 feet fly)

*Morale:* 7

*Special*: Psychic Abilities

One of the first advanced races, Elder Things have a singular appearance.
Somewhat barrel-shaped, they stand up to 10 feet in height and have membranous
wings, gills, many-tentacled arms, and yellow, five-pointed starfish-shaped
heads. They walk by means of a starfish-like “foot” and are equally at home
underwater, on land, or flying in the air. The Elder Things once had an advanced
scientific and artistic culture whose remnants might still be uncovered in
hidden places.

They can attack with weapons or with their tentacles. They have psychic
abilities that allow them to dominate others (as the spell), communicate
telepathically, and place themselves into suspended animation. A few may have
access to sorcery.

#### Ghast

*AC:* 5 [14]

*HD:* 3 (11 hp)

*Attacks:* Bite (1d6-1), Hoof kick (1d6+2)

*Move:* 180 feet

*Morale:* 9

*Special*: Sunlight Sensitivity

Strange creatures native to the Dreamlands, ghasts are carnivorous pack hunters
that prey on ghouls, gugs, and other creatures. Ghasts are about the size of a
mule, but stand on kangaroo-like hind legs, have scabrous skin, and a vaguely
human face that is missing both nose and forehead. They attack by biting and
kicking with their sharp hooves. Ghasts are not undead, but have a sunlight
sensitivity, which causes them to take 1d6 damage for each round spent in direct
sunlight. They can tolerate artificial light and the dim light of dusk or dawn.

#### Ghoul, Mythos

*AC:* 7 [12]

*HD:* 1+2 (6 hp)

*Attacks:* Claw (1d6) or by weapon

*Move:* 120 feet

*Morale:* 7

*Special*: Infectious Bite (1d6-1)

Ghouls are carnivorous humanoids that feed on cadavers and dwell predominantly
in the Dreamlands. Ghouls regularly pass into the physical realm, sometimes
keeping underground communities in remote caverns and unused sewer systems,
slipping into graveyards and mausoleums in search of their grisly feasts. Ghouls
are humanoid, with short, canine snouts, hoofed feet, and rubbery skin. They
smell of mildew and mold.

Ghouls attack with claws or with weapons. If a claw attack hits, they may also
bite the victim. Those struck by the ghoul’s **infectious bite** must Save vs.
disease or slowly transform into a ghoul over a period of time. The referee is
free to determine how this transpires.

#### Great Race (Yithian)

*AC:* 7 [12]

*HD:* 4 (14 hp)

*Attacks:* 2 pincers (1d6+1) or lightning gun (5d6)

*Move:* 90 feet

*Morale:* 7

*Special*: Transfer Mind, Neutral Alignment

The Great Race originated on the planet called Yith and came to the campaign
world by transporting their minds into the bodies of the race they now inhabit.
Yithians have a conical form, 10-feet tall, and 10-feet wide at the base. They
have black eyes on their round heads, two claw-like pincers, and a fourth limb
ending in a cluster of weird trumpet-like appendages. They “walk” by means of
expanding and contracting a viscous layer attached to the base of their bodies.

Yithians have the unique transfer mind ability that allows them to send their
minds into the future or past, inhabiting the bodies of the native races of the
era. This is accomplished through a combination of their own powerful minds and
a weird science apparatus. The mind of the inhabited body is sent back to reside
in the Yithian’s own body. By this method, the Great Race has filled its
libraries with an immense amount of scientific, historical, and cultural
knowledge collected from across space and time. They command a bewilderingly
advanced technical science as well. Their lightning gun was developed to fight
off the polypous horrors, which they once waged war with. Some Yithians are
known to practice sorcery.

#### Gug

*AC:* 4 [15]

*HD:* 8 (28 hp)

*Attacks:* Claw (2d6), bite (2d6+2)

*Move:* 120 feet

*Morale:* 10

*Special*: None

Gugs are a weird race of giants that dwell predominantly in the Dreamlands. They
stand in excess of 20 feet high, are covered in black fur, have long talons, and
display a fanged, vertically-opening maw that splits the head longitudinally.
Gugs are mute and communicate via facial expressions. They attack with their
claws and a vicious bite.

#### Hound of Tindalos

*AC:* 5 [14]

*HD:* 4 (14 hp)

*Attacks:* Bite (2d6)

*Move:* 150 feet

*Morale:* 6

*Special*: Travel through angles

Hounds of Tindalos are interdimensional creatures that appear as large hairless,
hyena-like hounds with mottled black and green skin and toothy maws. They are
able to traverse time and dimensions by travelling through angles, entering our
dimension through any physical angle. By this means, they will hunt prey
relentlessly through time and space. Any beings psychically travelling through
time are in great danger of being scented by the Hounds of Tindalos.

#### Human, Witch (Mythos)

*AC:* 7 [12]

*HD:* 3 (11 hp)

*Attacks:* Fist (1d6-1) or weapon (1d6)

*Move:* 120 feet

*Morale:* 10

*Special*: Alchemy, Familiar, Spells

Witches are deceivers and seducers, magicians and alchemists, and have menaced
mankind for millennia. These mistresses of the Old Ones have a supply of 1d4
alchemical potions, typically keep a familiar which will do its master’s
bidding, and can cast charm person, confusion, and 1d6+2 other spells. They are
armed with a knife and a staff.

#### Men of Leng

*AC:* 6 [13]

*HD:* 2 (7 hp)

*Attacks:* by weapon

*Move:* 120 feet

*Morale:* 7

*Special*: None

The strange, almost-human denizens of Leng seem to be akin to the satyrs of
myth, with shaggy manes and a pair of goat’s horns growing from their heads.
They are known to hail from the Plateau of Leng, wherever it may be located, and
are a common sight in the Dreamlands. When travelling, men of Leng disguise
themselves with hoods and voluminous robes. One in our men of Leng has access to
the following spells: charm person, confusion, detect magic, and phantasmal
force.

#### Mi-Go (Fungi from Yuggoth)

*AC:* 5 [14]

*HD:* 2+1 (8 hp)

*Attacks:* Weapon (ray gun, 2d6; sonic club, 1d6+deafened)

*Move:* 120 feet (120 feet fly)

*Morale:* 9

*Special*: None

Mi-go are a race of crustaceous humanoid spacefarers who maintain a base on the
planet Yuggoth at the edge of the solar system. They come to the campaign world
to mine minerals and metals that they cannot find elsewhere and are assisted by
human conspirators. Mi-go are uncanny scientists, capable of creating wondrous
machines and performing impossible biological and chemical operations. They use
brain cylinders to maintain not only brains, but the intelligences attached to
them.

Mi-go are the size of humans, with multiple pairs of wings and insectoid
appendages ending in odd pincers. They may use their forelimbs for locomotion or
for carrying objects. In place of a definable head, Mi-go have a mass of
tentacles which glow in weird lights and seem to be a method of communication.
When speaking to humans, they mimic human voices but with an ever-present
buzzing or vibrating.

Mi-go attack with weapons of their own making, including ray guns and weather
manipulators, and 1 in every 4 mi-go knows 1d6 spells.

#### Moonbeast

*AC:* 8 [11]

*HD:* 2+2 (9 hp)

*Attacks:* Claws (1d6) or weapon

*Move:* 90 feet

*Morale:* 7

*Special*: None

The cruel moonbeasts hail from the dark side of the Dreamlands’ moon and sail
black galleys between their homeland and trade ports of the Dreamlands.
Moonbeasts are mute and have no eyes. Rather, they communicate, see, and smell
by use of the mass of tentacles growing from their snouts. They are sailors and
slavers, pirates and traders, and are loathed by other Dreamlands races,
especially the cats of Ulthar who attack moonbeasts on sight. They arm
themselves with spears, knives, clubs, and axes.

#### Night Beast (Carcosan Flyer)

*AC:* 6 [13]

*HD:* 3+2 (13 hp)

*Attacks:* Beak (1d6+1)

*Move:* 90 feet (180 feet fly)

*Morale:* 8

*Special*: Drain Life, Keen Senses, Space Flight

Interstellar creatures that travel the solar winds on furry, membranous wings,
night-beasts are roughly the size of cows with beaked, bat-like heads and lumpy,
mole-like bodies. Six insectoid appendages act as legs while their necks and
underbellies are bare and scabrous. Wizards and Mythos humanoids summon
night-beasts via sorcery and use them as steeds. Night beasts attack with their
beaks and have keen senses that allow them to see in complete darkness. In
addition to doing normal damage, a night-beast may drain life with a successful
bite, causing the victim to lose 1d3 points of Constitution. Lost Constitution
can be healed at a rate of 1 point per day, but characters die when they reach 0
Constitution. Night-beasts have the uncanny ability to travel through space, via
an incomprehensible solar flight.

#### Night-Gaunt

*AC:* 6 [13]

*HD:* 1+2 (6 hp)

*Attacks:* Claws (1d6) or Tail Lash (1d6+1)

*Move:* 120 feet (180 feet fly)

*Morale:* 8

*Special*: Dreaded Tickle, Hide

Night-gaunts live primarily in the Dreamlands, acting as guardians of gates
between various dimensions. When encountered in the mundane world, night-gaunts
are performing some task or mission. They have rubbery, black skin, long barbed
tails, clawed paws, curving horns, and bat wings. In place of a typical face,
night-gaunts have only an emotionless, unadorned, smooth plane.

Night-gaunts usually attack from the wing, swooping upon their enemies to attack
with their claws or their wickedly-barbed tails. Night-gaunts are known to
employ their barbed tails to perform the dreaded tickle to torture captives,
causing the victims to fall into madness, Save vs. insanity each round. Their
black color allows them to hide in darkness and shadows with such efficacy that
they are detected only with a roll of 6 on 1d6.

#### Polypous Horror

*AC:* 5 [14]

*HD:* 6 (21 hp)

*Attacks:* Bite (2d6) or weapon

*Move:* 90 feet (180 feet fly)

*Morale:* 9

*Special*: Control Wind, Invisibility, Electricity Susceptibility

Polypous horrors are entirely alien to the campaign world. They have a
composition that is only partly material that allows them some amount of
plasticity. They speak in odd whistles, fly via a form of levitation, and lack
eyesight, instead relying on ultramundane senses to perceive the world. They
stand some 10 to 15 feet in height and their form is generally cylindrical, if
amorphous, with insectoid legs ending in five toe-like stalks.

Polypous horrors attack with their bite, or with melee weapons of their own
design, and can control winds to hinder opponents - knocking them prone, slowing
(or speeding) their movement, and the like. Characters targeted by the wind must
make a Saving Throw or suffer the effect chosen by the referee. Finally,
polypous horrors can become invisible once per day.

Polypous horrors are susceptible to electricity, which causes double damage.

At one time, the polyps created great, basalt, tower-cities, but approximately
150 million years ago, the Great Race imprisoned the entire race of polypous
horrors in subterranean vaults and caverns. Few of the creatures remain in the
modern world.

#### Rat-Thing

*AC:* 7 [12]

*HD:* 1+1 (5 hp)

*Attacks:* Bite (1d3)

*Move:* 150 feet

*Morale:* 5

*Special*: None

Small, malignantly intelligent beings that resemble rats with human faces and
hand-like paws, rat-things often serve as witches familiars. As such, some may
have magical abilities or supernatural connections to their masters.

#### Serpent People

*AC:* 4 [15]

*HD:* 3 to 8 (11 hp to 28 hp))

*Attacks:* Bite (1d6 +poison), Tail Slap (1d6), or weapon

*Move:* 120 feet

*Morale:* 8

*Special*: Poison, Shapeshift, Magic

Serpent People are humanoids with scaled skin and snake-like heads. They are an
ancient race that once controlled vast empires, the serpent people were
overthrown by men and driven underground, where they operate weird
techno-sorcery laboratories. Serpent people hate humanity and plot to one day
retake the Earth.

Serpent people attack with a bite that inflicts poison. Any victim of the bite
must Save vs. poison or become paralyzed (2d6 rounds) and lose 1d4 points of
Constitution. They also employ weapons of their own make. All serpent people can
shapeshift into the form of any human they have seen and can maintain the shape
indefinitely. Certain eons old phrases are known to be beyond the speech
capacity of serpent people, and by such means their perfect disguises may be
found out. One of every three serpent people knows some form of sorcery; the
referee should assign 1d6+1 (or more) random spells to such creatures. Most
carry at least one poison or alchemical potion.

#### Shapeless Spawn

*AC:* 5 [14]

*HD:* 6 (21 hp)

*Attacks:* Bite (2d6), pseudopod (1d6+1 or entangle)

*Move:* 90 feet

*Morale:* 11

*Special*: Entangle, Resistances, Swallow

Terrible creatures of the elder world, shapeless spawn were summoned by the
priests of Tsathoggua to protect their deity’s fanes. They appear as greasy
black amorphous blobs, able to take whatever shape best suits the task at hand.
They may lie in wait as dark puddles, flow through small openings, or pursue
victims as multi-legged, serpentine beasts with huge toothless maws. Shapeless
spawn’s resistances grant immunity to extreme temperatures, acid, and damage
caused by normal weapons. They take only half damage from fire, but suffer full
damage from electricity and spells.

Victims struck by the shapeless spawn’s bite attack must make a Saving Throw or
be swallowed whole, suffering 1d6 damage each round until slain or freed by the
shapeless spawn’s demise. Shapeless spawn may create long pseudopods capable of
attacking opponents up to 20 feet away. The creature may choose to entangle
victims struck by a pseudopod, allowing it to automatically do 1d6+1 damage on
following rounds by constriction.

#### Shoggoth

**Common**

*AC:* 4 [15]

*HD:* 9 (32 hp)

*Attacks:* 2 pseudopods (2d6)

*Move:* 80 feet (40 feet swim)

*Morale:* 10

*Special*: Engulf, Regenerate, Resistances

**Greater**

*AC:* 8 [11]

*HD:* 15 (53 hp)

*Attacks:* 4 pseudopods (3d6)

*Move:* 60 feet (30 feet swim)

*Morale:* 11

*Special*: Engulf, Regenerate, Resistances

Shoggoths were created by the Elder Things as a highly adaptable and resilient
slave race, but over time the servants gained some semblance of
self-determination and rebelled. Shoggoths are a globular mass of ever-changing
protoplasm, which continually forms and reforms eyes, mouths, pseudopods, and
other necessary organs. Shoggoths vary in size from the size of a small auto to
that of a train. They can use their sheer bulk to engulf nearby opponents,
completely enveloping them. Engulfed victims suffer 2d6 damage each turn, as
they are slowly crushed and chewed apart by innumerable mouths.

Shoggoths can survive on land as well as in water. Their resistances make them
immune to extreme cold and they take only half damage from fire and electricity.
Physical attacks do minimum damage. They regenerate 2 points of damage each
round. They are masters of mimicry and speak in a mocking semblance of the Elder
Things’ piping language.

#### Underlurker

*AC:* 7 [12]

*HD:* 1 (4 hp)

*Attacks:* Bite (1d6-1) or Claws (1d6)

*Move:* 120 feet

*Morale:* 7

*Special*: Light Sensitivity; Darkvision

Cannibalistic man-eaters that dwell in underground caves which they dig with
their mole-like claws, underlurkers fear the daylight and might be scared off by
the flash of lightning. Darkvision allows them to see in total darkness, but
their light sensitivity imposes a -1 penalty to all die rolls when in bright
light. Possibly cursed or degenerated humans, the carnivorous underlurkers creep
from their burrows to hunt food in the night. They appear as diminutive,
grey-furred gorillas with yellow fangs and one blue eye and one brown eye.

#### Voormis

*AC:* 8 [11]

*HD:* 2 (7 hp)

*Attacks:* Claws (1d6) or weapon

*Move:* 90 feet

*Morale:* 6

*Special*: Savage

Voormis are a primal humanoid race of fur-covered, man-eating Beastmen.

They have sharp claws and fangs, but can use primitive tools and have a
rudimentary language. Voormis are savage, and gain a +1 bonus to attacks and
damage when in a group of three or more. According to legend, they dwelled in
the environs of Mount Voormithadreth, where they hunted at night and worshipped
the god Tsathoggua. Now, Voormis are quite rare indeed.

### Mythos Deities

#### Atlach-Nacha

An Old One that may have come from Cykranosh, Atlach-Nacha takes the form of a
gigantic spider with a fanged human face. The creature lives in a vast
underground chasm and spins webs that connect diverging dimensions. Atlach-
Nacha sometimes makes pacts with sorcerers.

#### Azathoth

Azathoth sits at the center of the universe where multiple dimensions come
together. It is a shapeless mass of pure chaos and is surrounded by a court of
weird servants. Some philosophers posit that Azathoth created the universe.
Cults dedicated to the being are rare.

#### Cthulhu

An ancient alien being who descended upon the world millions of years ago in the
accompaniment of his multitudinous spawn, Cthulhu is huge and roughly humanoid
with bat-like wings and a tentacled, octopoid head. Cthulhu cults are incredibly
old and varied and may be encountered anywhere in the world. Cthulhu’s followers
believe that he lies in the sunken city of R'lyeh, not dead but dreaming, and
that he will awaken to rule the world once again. Cthulhu speaks to his
followers, and sometimes to the uninitiated, through dreams.

#### Dagon

Sometimes called Father Dagon, the creature is the “god” of the deep ones and
himself may serve Cthulhu in some manner. He appears to be a massively grown,
fish-like deep one, and is likely simply the oldest surviving of that aquatic
race. Dagon makes his home deep in the sea but might be summoned with the proper
rituals. Human cults dedicated to Dagon, are sometimes uncovered in coastal
towns where humans make unnatural pacts with deep ones.

#### Nyarlathotep

Nyarlathotep has been worshipped across the world in hundreds of guises and his
true form is only rumored. Witch cults refer to him as the Dark Man and buy his
secrets at a steep price. Nyarlathotep takes great pleasure in dealing with
humanity and causing the tide of chaos to rise, and his cults are frighteningly
common. The shining trapezohedron is an important artifact among his followers.

#### Shub Niggurath

In her natural form, Shub Niggurath is a black, cloud-like entity. Usually
depicted with female characteristics, Shub Niggurath is a fertility deity who
bestows numerous children upon her followers, for a price. She is called the
Black Goat of the Woods and is said to have a thousand young.

#### Tsathoggua

Tsathoggua is a primordial being who came from Cykranosh and experienced
widespread veneration in Hyperborea. He is slothful and has the appearance of an
eternally sleepy, furry bat-toad. Shapeless spawn and voormis are Tsathoggua’s
servants, and his human followers perform bestial, orgiastic rites. The toad-god
is said to reside in the lightless caverns of N'kai.

#### Ubbo Sathla

A quivering mass of primordial slime, Ubbo Sathla is a shapeless deity that once
lived beneath Mount Voormithadreth in Hyperborea, though its current whereabouts
are entirely speculative. It is connected with disease and corruption, but also
with creation - Ubbo Sathla continually births new life forms via fission, but
devours most of these. Though it may be the source of all life, few are the
worshippers of Ubbo Sathla.

#### Wendigo

Known by various names among the people of the northern climes, the Wendigo is a
terrible creature associated with winds. Wendigo appears as a shapeless,
translucent mass that constantly expels vigorous winds, but also appears as a
roughly human, large-footed mammalian who traverses the wilderness and the winds
with equal ease.

#### The Yellow King

Known as the “Faceless God,” for the mask he wears and as the “Unnameable,” due
to the power of his true name, the Yellow King reigns in Carcosa on the shore of
the Lake of Hali, where the giant orange sun, Aldebaran, and nameless black
stars hang in the sky. He is the patron of corruption, decadence, and madness,
and his cultists believe that they will be transported to (or reborn in) Carcosa
to live eternally in the king’s splendor. The play *The King in Yellow* is said
to reveal secrets about the Yellow King and his worship.

#### Yig

The serpent god, Yig, has had many names and appeared in myth cycles for eons.
He is the deity of the serpent people who may be his offspring - and was also
known in latter eras as Set, the patron of wizards. To those who displease him,
Yig sends horrible curses of transformation, and he has control over all
serpents, which will do his bidding without fail.

#### Yog Sothoth

A transdimensional being that appears as a disordered mass of luminescent
spheres, Yog Sothoth has power over time and space and may exist outside both.
In Mythos lore, it is said to be “the gate, the key, and the Guardian of the
gate”, but what this might mean is unknown to the uninitiated. Yog Sothoth is
worshipped by the mi-go and also converses with sorcerers who seek its
patronage.

### Mythos Weird Science

While Mythos creatures seem primitive and monstrous, most are in fact highly
advanced species with technology unfathomable to human concepts. Some of the
weird devices that these creatures created have been lost, discarded, and
forgotten across the globe and may be found by those exploring ancient Mythos
sites.

**Bio-Tech Armor:** Mi-go scientists mastered bio-mechanical cybernetics
millennia ago and learned to merge technology with biological material. One use
of this technology, bio-tech armor is a wearable device that, once activated,
releases a stream of spidery nanobot-like organisms that cover the user’s skin.
The nanobots focus on protecting vital areas and grant a -5 [+5] Armor Class.
Though mi-go suffer no ill-effects from the armor, humans who use the device
suffer 1-3 HP damage when the device is removed and the nanobots detach from his
skin. The bio-tech armor can be used for a total of 24 hours.

**Brain Cylinder:** These metal and glass cylinders stand about 1 foot tall and
display on their surface a number of unusual buttons and ports. They are created
and used by the mi-go to hold and transport living brains. Brains placed within
a brain cylinder are basically immortal and can be placed into other bodies with
the proper apparatus. The ports are used to connect the cylinder to brain
cylinder sensory devices, allowing the brain to speak, see, and hear. When not
connected to sensory devices, the brain is in a state of hibernation.

**Brain Cylinder Sensory Devices:** These weird electronic boxes have cables
running from them which may be plugged into brain cylinders to allow the dormant
brain to sense its environment. Separate devices are needed for speech, vision,
and hearing.

**Dark Lantern:** A black lantern of strangely-wrought metal, the dark lantern
emits an eerie purple light when it is lit. No fuel is necessary and the light
extends to a 20-foot radius. The lantern’s light reveals invisible creatures and
objects as well as creatures disguised by sorcery or shapechanging abilities,
such as a serpent person in human form or a deep one masked by illusion.
According to legend, five of these dark lanterns exist, each manifesting
different colors and additional powers.

**Drug of Liao:** This unusual compound may be found as a pill or in a serum
form. The drug of Liao allows the user to send his mind back in time, reaching
back throughout recorded history and into the ages of evolution and beyond,
depending upon the dosage taken. The user must make a Saving Throw versus
insanity or gain 1d4 Insanity, and he must be mindful to avoid other
time-travelling creatures, such as the Hounds of Tindalos. Though the risks are
great, the user may steer his mind to perceive specific event or allow his mind
to wander into the primordial past to witness the true history of the universe
(which grant 1d6 Mythos Lore).

**Molecular Destabilizer:** These metallic globes burst to release a wave of
energy that nullifies molecular attraction, resulting in a disintegration effect
with a 5-foot radius. Inanimate objects are affected according to their density
– light objects, such as wood or paper are largely obliterated, while heavy
substances, like stone and metal, are only partially affected. Living creatures
caught in the area of effect take 4d6 damage, with a Saving Throw allowing for
half damage. Molecular destabilizers must be “armed” before being thrown and are
destroyed in their use.

**Shining Trapezohedron:** A 4-inch diameter, roughly spherical black gem with
innumerable flat, trapezoid facets, the shining trapezohedron is likely the most
powerful mythos artifact to ever curse the world. It is traditionally kept in a
rune covered box of unearthly, yellowish metal and is activated by staring into
its black depths for one round. After doing so, the user may employ the
following powers:

-   By plunging the shining trapezohedron into darkness immediately after
    activating it, the Haunter of the Dark will soon manifest within the nearest
    area of complete darkness. The Haunter and summoner will share a mental
    link, knowing the location of one another. The Haunter must remain within
    300 feet of the trapezohedron but will seek to possess the summoner’s body
    (as ghost).

-   The shining trapezohedron acts as a window into all time and space. The
    gazer may view any time or place of which he knows, but is unable to
    interact with the environment. The viewing lasts for 1d10+10 rounds. When
    the viewing ends, the gazer must make a Saving Throw or fall unconscious for
    1d6 rounds.

-   Once per month, the shining trapezohedron may be used to commune with
    Nyarlathotep (as spell).

The shining trapezohedron is rumored to have additional power that only manifest
when forgotten rituals are performed with it and/or when the stars are right.
There is only one shining trapezohedron and it is believed to be indestructible.

**Spirit Bottle:** These curious, rune-engraved glass bottles contain a small
piece of lead hanging from a string and have a sinister purpose. When the mouth
of the bottle is pressed against a victim’s chest, it will suck out the
creature’s soul on a failed Save, trapping it inside the bottle. A **spirit
bottle** can hold only one soul. The cork must be immediately replaced and
sealed with wax, lest the spirit escape the bottle. When addressed with the name
it knew in life, the trapped soul can communicate with weird, vibrating
intonations and a swinging of the lead pendulum. The spirit knows only what it
did in life.

**Yithian Lightning Gun:** The Great Race of Yith designed these weapons to be
used in their war against the polypous horrors. These “guns” are camera-like in
shape with one side acting as a handle while the opposite sports a short,
cone-shaped “barrel.” When the firing switch is depressed, a blast of electrical
energy erupts from the barrel causing 5d6 damage with a range of 100 feet. A
Saving Throw is allowed for half damage. The guns are slightly large for human
hands and require both hands for use. When found, lightning guns have 1d6
charges remaining.

Humans, Cultists
----------------

Members of strange, often chaotic cults centered on a minor entity (demigod,
demon, mythos deity, etc.) usually from another plane. The entity grants powers
in exchange for service, sacrifices, and/or worship. Cultists often take have
some sort of aberrant appearance hinting at the entity they serve. The power
level and usefulness of strange cult powers and cult magic items vary with the
power of the cult focus entity and in some cases the size of the cult. Cult
magic items only work properly for members of the cult. Cult priests can cast
spells and their spell cast come from either the Cleric or Magic-User spell list
(or both) as determined by the cult’s patron entity.

#### Cultist

*AC:* 9 [10]

*HD:* 1/2 (2 hp)

*Attacks:* +0, improvised weapon (1d2)

*Move:* 90 feet

*Morale:* 8

*Special:* Cult powers, Fanatic

Competent in background, 6+ on D6 chance of 1 strange cult power beyond the
normal rules usable 1d4 times per day. They are fanatic, which allows them to
reroll failed morale rolls once and gives them a +1 to attack when protecting
their cults, leaders, and temples.

#### Cultist, Guard

*AC:* 7 [12]

*HD:* 1+2 (6 hp)

*Attacks:* +1, weapon (1d6)

*Move:* 120 feet

*Morale:* 9

*Special:* Cult powers, Fanatic

Trained in combat. 5+ on d6 chance of 1 strange cult power beyond the normal
rules usable 1d4 times per day. They are fanatic, which allows them to reroll
failed morale rolls once and gives them a +1 to attack when protecting their
cults, leaders, and temples.

#### Cultist, Guard Sergeant

*AC:* 5 [14]

*HD:* 1+3 (7 hp)

*Attacks:* +2, weapon (1d6+1)

Move 120 feet

*Morale:* 9

*Special:* Cult powers, Fanatic

Trained in combat. 1d2 strange cult powers beyond the normal rules each usable
once per day. 4+ on d6 chance of 1 cult magic item. They are fanatic, which
allows them to reroll failed morale rolls once and gives them a +1 to attack
when protecting their cults, leaders, and temples.

#### Cultist, Guard Leader

*AC:* 3 [16]

*HD:* 1+4 (8 hp)

*Attacks:* +2, weapon (1d6)

*Move:* 120 feet.

*Morale:* 10

*Special:* Cult powers, Fanatic

Trained in Combat. Cult members under his direct leadership in battle are +2
morale. 1d2 strange cult powers beyond the normal rules each usable once per
day, 1d2 cult magic items. They are fanatic, which allows them to reroll failed
morale rolls once and gives them a +1 to attack when protecting their cults,
leaders, and temples.

#### Cultist, Lesser Priest

*AC:* 7 [12]

*HD:* 1+2 (6 hp)

*Attacks:* +1, weapon (1d6)

*Move:* 90 feet

*Morale:* 9

*Special:* Spellcasting, Cult powers, Fanatic

Knows 1d2 first level spells. Has 1d3 strange cult powers beyond the normal
rules. They are fanatic, which allows them to reroll failed morale rolls once
and gives them a +1 to attack when protecting their cults, leaders, and temples.

#### Cultist, Priest

*AC:* 4 [15]

*HD:* 2+2 (9 hp)

*Attacks:* +2, weapon (1d6)

*Move:* 120 feet.

*Morale:* 10

*Special:* Spellcasting, Cult powers, Fanatic

Knows 1d3 first level spells and 1d2 second level spells. Has 1d3+1 strange cult
powers beyond the normal rules and 1d2 cult magic items. They are fanatic, which
allows them to reroll failed morale rolls once and gives them a +1 to attack
when protecting their cults, leaders, and temples.

#### Cultist, High Priest

*AC:* 2 [17]

*HD:* 4 (14 hp)

*Attacks:* +4, weapon (1d6)

*Move:* 150 feet

*Morale:* 11

*Special:* Spellcasting, Cult powers, Fanatic

Knows 1d2+2 first level spells, 1d2+1 second level spells, and 1d2 third level
spells. Has 1d3+2 strange cult powers beyond the normal rules and 1d2+2 cult
magic items. They are fanatic, which allows them to reroll failed morale rolls
once and gives them a +1 to attack when protecting their cults and temples.

NPC Groups
----------

In general, an encounter with NPCs will be with a group of 2d6 individuals of
the same level as the dungeon level they are found on, i.e., first level
characters on the first level of the dungeon, second level characters on the
second level and so on. (For NPC encounters in the wilderness, see below.)

Encounters with NPCs fall into two main categories:

**Same-Class NPC Parties:** All members of the party will be of the same
alignment (roll 1d10: 1-3 = Lawful, 4-5 = Neutral, 6-10 = Chaotic, except for a
party of Thieves who will be 1-4 = Neutral, 5-10 = Chaotic). One member of the
party will be a leader who is one level higher than the other party members.

A same-class party of Fighters is called a party of **Brigands** if they are
Chaotic, **Bravos** if Lawful; Neutral parties may elect either name depending
on whether or not they are acting mostly in accordance with the local law. A
same-class party of Thieves is often referred to as a party of **Bandits**.
Lower-level parties of Clerics may be called **Pilgrims**, but at higher levels
they may prefer to be called a **Mission**. Magic-Users in a group may choose
any of a number of appellations, such as **Coven** or **Cabal**. These names may
or may not apply to non-human parties, of course.

**Adventurer Parties:** This sort of party can be extremely variable in
composition. The referee is encouraged to create such parties personally,
choosing the composition and giving them names and personalities. It will make
for more memorable encounters.

But it will not always be possible to do this, nor necessarily always desirable.
Sometimes, the referee just needs to put such a party together quickly. Consider
the following to be merely guidelines, to be followed or ignored as you wish.

Roll for the general alignment of the party using the same odds as given above,
i.e., roll 1d10: 1-3 = Lawful, 4-5 = Neutral, 6-10 = Chaotic. Remember that
Thieves must be non-Lawful, so in a generally Lawful party any Thieves are
almost certain to be Neutral. Most party members will be the same alignment, but
the referee might wish to place a handful of other alignments in an NPC
adventuring party.

Adventurer parties have an 85% chance of having a Magic-User. If the roll comes
up 35 or less, there are two, where the second is one level lower than the party
level (if possible). Deduct them from the total number.

Of the remainder, assume that as many as 1d4+1 will be Fighters. Divide any who
are left between Clerics and Thieves as you see fit. Most parties will have a
Cleric, so if the die rolls indicate none, you may wish to change one of the
other characters to be one.

The leader of an adventurer party is 50% likely to be one level higher than the
average level for the group (otherwise, he or she will be the same level).

**In either case**, most members of NPC parties will have a number of d6's of
gold pieces equal to their levels on their persons; for example, a 5th level
group of Fighters would all have 5d6 GP, excepting their 6th level leader who
would (obviously) have 6d6 GP. There is a 10% chance that the party will be
carrying a type A1 treasure instead.

NPC parties will be equipped in a reasonable fashion, so excepting those met on
the first level of a dungeon, they should all have the best type of armor
allowed as well as reasonable weapons (swords for Fighters and Thieves, maces or
warhammers for Clerics, etc.) Magic-Users who have access to charm spells may
have charmed characters or monsters of appropriate types as a line of defense in
front of them.

The table below can be used to determine the magic items an NPC party is
equipped with. The percentages given are multiplied by the level of the
character. The referee may wish to roll for each character, or assign them as he
or she sees fit (perhaps using the percentages as a guideline). Items
successfully rolled for should be selected from the Treasure tables, re-rolling
items which may not be used by the character. Also, NPC parties carrying a
treasure will generally make use of any magic items in that hoard if possible.

| Type          | Fighter | Magic-User | Cleric | Thief |
|---------------|---------|------------|--------|-------|
| Weapon        | 10%     | 4%         | 8%     | 8%    |
| Shield        | 5%      | –          | 4%     | –     |
| Armor         | 5%      | –          | 4%     | 4%    |
| Potion        | 3%      | 3%         | 3%     | 3%    |
| Scroll        | –       | 6%         | 5%     | –     |
| Ring          | 2%      | 6%         | 4%     | 2%    |
| Wand or Staff | –       | 12%        | 6%     | –     |
| Miscellaneous | 4%      | 4%         | 4%     | 4%    |

**When encountered in the wilderness**, NPC parties may represent nobles
traveling, merchants transporting goods, and so on. Fighter parties might be
warbands of berserkers, who fight without checking morale until all foes are
dead or have fled beyond the possibility of pursuit. In some parties, there
might be additional non-combatant NPCs (i.e., the children of a nobleman, the
merchant and his scribe, and so on) at the referee's option. NPC parties
encountered in a town or city will likely be similar. Being creative in
describing NPC parties can enhance the experience for the players.

Create your NPC parties for wilderness or city encounters in the same way as for
dungeon encounters. Roll 2d4-1 to determine the "average" level of such a party.

**Non-Human NPC Parties:** Some NPC parties will include non-human members.
Same-class groups will generally consist of members all of the same race, while
adventurer groups may be of the same race or mixed. The referee may wish to use
the following table to decide what races of characters are encountered. Roll
1d20 and read down the column for the dungeon level (that is, the encounter
table above) where the party was encountered:

|              | Dungeon Level |         |         |         |          |
|--------------|---------------|---------|---------|---------|----------|
|              | **1-2**       | **3-4** | **5-6** | **7-8** | **9-10** |
| **Human**    | 1-13          | 1-13    | 1-14    | 1-14    | 1-14     |
| **Elf**      | 14-15         | 14-15   | 15      | 15      | 15       |
| **Half-Elf** | 16            | 16      | 16      | 16      | 17       |
| **Dwarf**    | 17-18         | 17-18   | 17-19   | 17-19   | 16-19    |
| **Halfling** | 19-20         | 19-20   | 20      | 20      | 20       |

If encountered in the wilderness, the referee should choose races for his or her
NPC parties based on the terrain and any nearby kingdoms, i.e., Dwarves in the
mountains, Halflings near their shire, etc. If rolling races for a party of NPC
adventurers met in the wilderness, the dungeon level 3-4 column on the table
above is probably the best choice.

<br><br><br>Section IV:<br>Treasure
===================================

Mundane Treasure
----------------

### Scavenged Items

Poor or low level adventurers may be so desperate for treasure that they
scavenge weapons, armor, or other equipment rotting in dungeons, littering old
battlefields, or equipping slain foes. These items are almost universally in bad
repair. Roll 1d20 on the following tables to determine the condition and value
of any equipment scavenged. Effects are cumulative.

**Bladed Weapons**

| D20   | Category            | Effect         | Value |
|-------|---------------------|----------------|-------|
| 1-2   | Serviceable         | \--            | 100%  |
| 3-6   | Blade dented        | \-1 damage     | \-20% |
| 7-10  | Blade rusty         | \-1 damage     | \-20% |
| 11-14 | Off balance         | \-1 to attacks | \-20% |
| 15-16 | Loose hilt/haft     | \-1 damage     | \-20% |
| 17-18 | Shoddy construction | breaks         | \-20% |
| 19-20 | Roll again twice    | \--            | \--   |

**Blunt Weapons**

| D20   | Category            | Effect         | Value |
|-------|---------------------|----------------|-------|
| 1-2   | Serviceable         | \--            | 100%  |
| 3-6   | Soft head           | \-1 damage     | \-20% |
| 7-10  | Wobbly head         | \-1 damage     | \-20% |
| 11-14 | Off balance         | \-1 to attacks | \-20% |
| 15-16 | Wobbly head         | \-1 to damage  | \-20% |
| 17-18 | Shoddy construction | breaks         | \-20% |
| 19-20 | Roll again twice    | \--            | \--   |

**Armor and Equipment**

| D20   | Category         | Effect                   | Value |
|-------|------------------|--------------------------|-------|
| 1-2   | Serviceable      | \--                      | 100%  |
| 3-6   | Broken straps    | \+1 stone encumbrance    | \-20% |
| 7-10  | Rattles if moved | Cannot move silently     | \-20% |
| 11-14 | Rotting          | \-1 Armor Class / breaks | \-20% |
| 15-16 | Makeshift work   | \-1 Armor Class / breaks | \-20% |
| 17-18 | Torn / ripped    | Breaks                   | \-20% |
| 19-20 | Roll again twice | \--                      | \--   |

Damage penalties cannot reduce weapon damage to less than 1 point. Armor Class
or attack throw penalties cannot be worse than -5. Weapons and equipment
susceptible to breaks will be destroyed if the character rolls a natural 1 when
using the item.

EXAMPLE: Marcus scavenges a sword from an ancient battlefield. He rolls a 19,
and must roll twice more. He rolls a 7 and 15. The sword has a rusty blade and
loose hilt, and imposes penalties of -1 damage and -1 initiative. Its value is
reduced 40%, to 6gp, when he tries to sell it.

### Gems

When gems are found, the Judge will roll to determine their value in gold
pieces. All gems may be assigned the same value, they may be given individual
values, or they may be divided up into groups and given different values. The
average value of gems is 200gp per stone.

EXAMPLE: 10 gems worth 100gp are randomly generated. The Judge could actually
place these as 1 1,000gp gem, 10 100gp gems, 4 250gp gems, 1 500gp gem and 50
10gp gems, or any other combination desired.

**Gem Value**

| D100  | Gem Value (gp) | Type                                                          |
|-------|----------------|---------------------------------------------------------------|
| 01-10 | 10             | Azurite, hematite, malachite, obsidian, quartz                |
| 11-25 | 25             | Agate, lapis lazuli, tiger eye, turquoise                     |
| 26-40 | 50             | Bloodstone, crystal, citrine, jasper, moonstone, onyx         |
| 41-55 | 75             | Carnelian, chalcedony, sardonyx, zircon                       |
| 56-70 | 100            | Amber, amethyst, coral, jade, jet, tourmaline                 |
| 71-80 | 250            | Garnet, pearl, spinel                                         |
| 81-90 | 500            | Aquamarine, alexandrite, topaz                                |
| 91-95 | 750            | Opal, star ruby, star sapphire, sunset amethyst, sunset topaz |
| 96-00 | 1,000          | Black sapphire, diamond, emerald, jacinth, ruby               |

### Jewelry

Jewelry can vary in value in a similar manner to gems. The table below can be
rolled on to determine the value of each individual piece of jewelry. The
average value of jewelry is 1,000gp per piece.

**Jewelry Value**

| D100  | Jewelry Value (gp) | Type                                                |
|-------|--------------------|-----------------------------------------------------|
| 01-20 | 2d10x10            | Glass, shells, or wrought copper, brass, or bronze  |
| 21-45 | 2d4x100            | Fine wood, porcelain, or wrought silver             |
| 46-75 | 3d6x100            | Alabaster, chryselephantine, ivory, or wrought gold |
| 76-95 | 5d6x100            | Carved jade or wrought platinum                     |
| 96-00 | 1d6x1000           | Wrought orichalcum                                  |

### Special Treasures

Not all treasure should be coin, gem, and jewelry. Ancient cities might hold
terracotta pottery or rare dyes and pigments. The tombs of ancient kings might
have trinkets of carved ivory. Goblin raiders might have captured spices, silk,
or rare furs. These items are called special treasures. To include special
treasures in a hoard, first calculate the treasure normally and divide it into
lots: 1 piece of jewelry, 1 gem, or 1,000 coins is a lot. Roll on the table
below for each lot of coin, gems, and jewelry and substitute the special
treasure rolled for that lot of coin, gems, or jewelry. Any leftover coins worth
less than 1,000cp always remain coin.

EXAMPLE: A treasure is rolled consisting of 2,200cp; 1,400sp; 1,100ep; and 4
pieces of jewelry. This yields 2 lots of copper, 1 lot of silver, and 1 lot of
electrum. Rolling for the copper lots, the Judge gets a “9” and a “2”. One
copper lot stays as coin, while the other is replaced by 1d3 barrels of
preserved meat. Rolling for the silver lot, the Judge gets a “7”, and replaces
the lot with 1d3 sacks of loose tea. The electrum remains coin, while 2 pieces
of jewelry become rich fur capes. The Judge makes further sub-rolls, and the
final treasure is 1,200cp; 400sp; 1,100ep; 1 barrel of preserved meat (10gp, 16
stone); 2 sacks of loose tea (75gp, 5 stone each); 2 pieces of jewelry worth
1,100gp each; and 2 rich fur capes worth 700gp and 1,300gp respectively.

**Roll 1d20 per 1,000cp:**

| 1    | 1d3 rugs or tapestries, worth 1d10gp each (2d6 stone each)   |
|------|--------------------------------------------------------------|
| 2    | 1d3 barrels of preserved food, worth 5gp each (8 stone each) |
| 3    | 1d3 cord of hardwoods, worth 5gp each (8 stone each)         |
| 4    | 1d3 barrels of beer, worth 5gp each (4 stone each)           |
| 5    | 1d3 bricks of salt, worth 5gp each (4 stone each)            |
| 6    | 1d3 jars of lamp oil, worth 5gp each (1 stone each)          |
| 7    | 1d3 bundles of common hides, worth 5gp each (1 stone each)   |
| 8    | 1d3 bags of woven textiles, worth 5gp each (1 stone each)    |
| 9-20 | 1,000 copper pieces                                          |

**Roll 1d20 per 1,000sp:**

| 1    | 1d100 animal horns worth 1d10HD x 1d4+1sp/HD each (1 stone per 20HD)                            |
|------|-------------------------------------------------------------------------------------------------|
| 2    | 5d6 animal skins, worth 1d10gp (1 stone)                                                        |
| 3    | 5d10 bottles of fine wine, worth 1d6gp each (1 stone per 1d6 bottles)                           |
| 4    | 1d3 cords of fine wood, worth 1d10x10gp each (16 stone each)                                    |
| 5    | 1d10 jars of dyes and pigments, worth 20gp each (2 stone each)                                  |
| 6    | 1d3 pieces of terra-cotta pottery, worth 50gp each (2 stone each)                               |
| 7    | 1d3 sacks of loose tea, worth 75gp each (5 stone each)                                          |
| 8    | 4d20 typical fur pelts (such as bear, beaver, or fox), worth 1d4gp each (1 stone per 1d6 pelts) |
| 9-20 | 1,000 silver pieces                                                                             |

**Roll 1d10 per 1,000ep:**

| 1    | 1d3 barrels of fine spirits or liquor, worth 200gp each (8 stone each) |
|------|------------------------------------------------------------------------|
| 2    | 1d3 cords of rare wood, worth 2d4x100gp each (16 stone each)           |
| 3    | 1d10 pieces of glassware, worth 80gp each (2 stone each)               |
| 4    | 1d3 rolls of fine linen, worth 1d4x100gp each (5 stone each)           |
| 5-10 | 1,000 electrum pieces                                                  |

**Roll 1d20 per 1,000gp:**

| 1    | 1d3 bundles of rare fur pelts (such as ermine, mink, or sable), worth 500gp each (5 stone each) |
|------|-------------------------------------------------------------------------------------------------|
| 2    | 1d3 jars of spices, worth 500gp each (4 stone each)                                             |
| 3    | 1d10x50 monster feathers, worth 1d6gp per feather (1 stone per 25 feathers)                     |
| 4    | 1d100 monster horns worth, 1d10HD x 1d4+1gp/HD (1 stone per 20HD)                               |
| 5    | 1d6 monster carcasses, worth 1d10HD x 1d10x10gp/HD (1 stone per HD)                             |
| 6    | 1d10 pieces of fine porcelain, worth 200gp each (2 stone each)                                  |
| 7    | 2d20 pieces of ivory, worth 1d100gp per piece (1 stone per 100gp value)                         |
| 8    | 1d3 rolls of silk, worth 2d4x100gp each (5 stone each)                                          |
| 9-20 | 1,000 gold pieces                                                                               |

**Roll 1d10 per 1,000pp:**

| 1    | 5d10 rare books, worth 5d6x10gp (1 stone per 2 books)      |
|------|------------------------------------------------------------|
| 2    | 1d3 jars of rare spices, worth 2,500gp each (4 stone each) |
| 3    | 4d6 typical fur capes, worth 1d6x100gp (1 stone each)      |
| 4    | 2d6 typical fur coats, worth 3d4x100gp (1 stone each)      |
| 5-10 | 1,000 platinum pieces                                      |

**Roll 1d8 per gem:**

| 1   | 1d3 sets of engraved teeth, each worth 2d6x10gp (1 stone per 100 sets)       |
|-----|------------------------------------------------------------------------------|
| 2   | 1d10 sticks of rare incense, each worth 5d6gp (1 stone per 100 sticks)       |
| 3   | d3 vials of rare perfume, each worth 1d6x25gp per vial (stone per 100 vials) |
| 4-8 | 1 gem                                                                        |

**Roll 1d8 per piece of jewelry:**

| 1   | 1 rich fur cape, worth 4d6x100gp (1 stone)                    |
|-----|---------------------------------------------------------------|
| 2   | 1 rich fur coat, worth 1d6x1000gp (1 stone)                   |
| 3   | 1d3 statuettes, worth 1d10x100gp (1 stone per 1d3 statuettes) |
| 4-8 | 1 piece of jewelry                                            |

Magical Treasure
----------------

### Charms

A charm is a magical fetish, amulet or device that is attached to the user’s
clothing, worn around the neck or even strung to a weapon or woven into the hair
(including beards for many dwarves). To function, a charm must be visible.
Activating a charm renders other charms on the user non-functional (although
they can be activated in turn, rendering the first charm non-functional for the
duration, and so on). If a charm-wearer has more than two charms on his person,
it takes a full round to find the specific charm needed before it can be
activated. The vast majority of charms are defensive, but there are some
exceptions.

**Basilisk’s Eye:** Made from exactly what it sounds like, this gruesome charm
provides the wearer a +5 bonus on saving throws against petrification effects.

**Blink Dog Charm:** All teleport type magics and abilities that target someone
within 30 feet of the wearer or that would result in moving to a location within
that zone of effect are resisted by the charm. The caster of the effect (or the
creature originating the effect such as for blink dogs) must make a saving throw
versus spells for the effect to work.

**Blood Charm:** When activated, the wearer immediately takes 10 points of
damage (which can be cured or healed normally). Any time thereafter (while the
charm is still activated), the wearer can regain those hit points from the charm
with a thought. If the charm is deactivated with the hit points still in it,
they are lost.

**Bone Rattle:** Crafted from the skull of an intelligent creature and filled
with teeth and then wrapped in skin, this fetish can be activated once per day,
producing a cause fear spell (the reverse of remove fear).

**Eldritch Charm:** This crystalline charm grants the wearer a +2 bonus on all
saves against magical effects. If the wearer casts a spell, all effects are
calculated as if the wearer were two levels lower.

**Horse Charm:** This charm lends the wearer the ability to run like thunder.
When activated, the character gains a +30’ bonus to his normal (land) movement
rate.

**Jackal Charm:** When activated, this charm grants the wearer 6 additional hit
points (which brings his maximum hit point total up by 6 points also). The
wearer must be careful about deactivating this charm, however, as he loses 6 hit
points when the charm is deactivated – and this may indeed result in his death.

**Manticore Charm:** The wearer of this charm gains a +1 bonus on attack rolls
with bows and crossbows.

**Mighty Charm:** Once activated, the wearer can trigger the charm’s effect upon
successfully striking an opponent in melee combat. The charm grants the wearer a
+1d6 bonus to damage on that attack, and must then be re-activated as normal.

**Monkey Charm:** The wearer of the monkey charm can pick locks, disarm traps,
and pick locks as a level 1 thief, and a character that already has these
abilities can do so as if he were three levels higher.

**Ox Charm:** When activated, this charm grants the wearer 12 additional hit
points (which brings his maximum hit point total up by 12 points also). The
wearer must be careful about deactivating this charm, however, as he loses 12
hit points when the charm is deactivated – and this may indeed result in his
death.

**Phoenix Charm:** The wearer if this charm gains a +1 on all saving throws
against fire. If the wearer is slain, the charm is destroyed in a fiery
explosion (treated as a 5d6 damage fireball) which does not harm the wearer’s
corpse. The wearer is then the target of a **raise dead** spell.

**Pomander:** This desiccated orange charm provides the wearer with a +2 bonus
on saves against poisons and diseases, and grants all those within 10 feet with
a +1 bonus on these same saves.

**Rusty Charm:** This charm has 1d6 charges when found. Whenever the
charm-wearer’s metal equipment would be subject to major damage such as
destruction by a rust monster, or being the target of a disintegration, or
merely broken by bad luck, one charge is expended and the equipment is spared
the effect.

**Sanctified Charm:** When activated, this charm grants the benefits of a bless
spell with all the normal benefits and restrictions. It can be activated twice
per day and the duration is immediately ended if another charm is activated by
the user.

**Stealth Charm:** When activated, the wearer gains the move silent and hide in
shadows ability of a thief of one half his level. If he already has these
abilities, they work as if he were three levels higher.

**Tomb Raider’s Charm:** These black iron charms are engraved with wards against
curses, hexes and the evil eye. The charm provides the wearer a +6 bonus on
saving throws against curses. If the curse wouldn’t allow a save normally, the
wearer gains a saving throw against spells with no bonus from the charm to
negate the curse.

**Unicorn Horn Charm:** Once per day this charm can trigger a cure light wounds
spell on the wearer. If touched to a cursed item, the charm is destroyed, but
the curse is removed.

**Venom Charm:** The charm-wearer gains a +3 bonus on saving throws against
poisons and venoms. If there is not normally a save, then the wearer gains a
save (with no bonus) to negate the effect.

### Implements

*N.B. The magic items in this section will should only be available in the
optional rules needed for them to make sense are being used. E.g., Backgrounds
and Talents for Talent Matrixes, Hit Point Powered Magic for Power Storage and
Power Reduction Matrixes, etc.*

The Implements are items that provide knowledge or magical power. The handmade
wand commonly carried by magic-users is a simple example of an implement – it
allows the magic-user to perform minor magic and cast arcane blasts. There are
more powerful implements: Power Storage Matrixes, Power Reduction Matrixes,
Spell Matrixes, and Talent Matrixes. Unlike most magic items, implements can
come in many forms. For example, the most common form of power storage matrix is
a crystal, but they can be found in many other forms, e.g., metal wands, staves,
rods, headbands, bracelets, rings, etc.

#### Power Storage Matrix

A power storage matrix holds points of magical energy. Any spellcaster touching
a power storage matrix can use its magical energy points instead of their own
hit points/mana to cast a spell. Each power storage crystal has a maximum
capacity and a recharge rate. A power storage matrix may hold a number of energy
points up to maximum capacity. If it is below its maximum capacity, it will gain
a point of magical energy each time its recharge period passes until it reaches
it maximum capacity.

For example, the Eye of Ages is a small eye-shaped blue crystal and is a
relatively weak power storage matrix with a maximum capacity of 8 and a recharge
rate of 1 point per two days. If it were full (8 points of magic energy) and a
magic-user drew 5 points of energy out of it casting a Fireball spell, it would
have 3 points of magic energy left. It would gain another point of magical
energy after two days pass, giving it 4 points. Assuming no energy was taken
from it before it completely recharged, it would take a total of ten days to
recharge to its maximum capacity of 8 points.

To use a power storage matrix, a spellcaster must be touching it with his bare
skin. Only one power storage matrix may be used at a time. If the power storage
matrix does not have enough points of energy to fully power the spell being
cast, the remaining points come from the caster’s hit points (as is normal for a
spell).

Power storage crystals come in many forms. Most are crystals or some item made
of metal or stone. Not all are portable, for example, altars in some temples are
power storage matrixes. Power storage matrixes with a maximum capacity of 40 or
greater are generally so large that they cannot easily be carried or worn. While
most power storage matrixes can be used by any spellcaster, some will only work
for special people or under certain limited conditions. For example, power
storage matrix altars generally can only be used by clerics of the deity the
altar is dedicated to.

Roll on following tables are used to determine the maximum capacity and recharge
rate of a random power storage matrix.

**Power Storage Matrix Maximum Capacity**

| D100  | Maximum Capacity |
|-------|------------------|
| 01-30 | 2d6              |
| 31-50 | 3d6              |
| 51-65 | 4d6              |
| 66-80 | 5d6              |
| 81-90 | 6d6              |
| 91-97 | 5d10             |
| 98-99 | 10d10            |
| 00    | 20d20            |

**Power Storage Matrix Recharge Rate**

| D100  | Recharge Rate         |
|-------|-----------------------|
| 01-05 | 1 point per month     |
| 06-15 | 1 point per 2 weeks   |
| 16-30 | 1 point per week      |
| 31-50 | 1 point per 3 days    |
| 51-70 | 1 point per 2 days    |
| 71-80 | 1 point per day       |
| 81-85 | 1 point per 12 hours  |
| 86-89 | 1 point per 6 hours   |
| 90-92 | 1 point per 3 hours   |
| 93-94 | 1 point per two hours |
| 95    | 1 point per hour      |
| 96-00 | Special               |

A special recharge rate can be anything the Referee desires, but normally means
that there is some special recharge requirement. Examples: a matrix that only
recharges when left in the light of the full moon overnight – but completely
recharges when that condition is met; an altar to a chaotic deity that only
recharges from properly performed human sacrifices to the deity, gaining 50% of
the total hit points of the sacrifice.

#### Power Reduction Matrix

A power reduction matrix reduces the hit point/mana cost to cast a spell (to a
minimum of 1 hit point). A power reduction matrix can come in many forms, the
most common of which are wands, staves, and rings. The spellcaster must be
touching the matrix while casting the spell to benefit from the reduction in hit
point cost. A power reduction matrix in the form of a wand or staff counts as a
handmade wand for those abilities that require the use of a handmade wand. A
power reduction matrix need not be portable. For example, a magic circle formed
of silver inlaid on the floor could be a power reduction matrix benefiting a
caster standing within it. A power reduction matrix has a reduction rating from
1 to 9. It will reduce the hit point/mana cost of any directly cast spell by its
rating. However, the hit point/mana cost to cast a cannot be reduced below one
by a power reduction matrix.

Roll on the following table to determine the Reduction Rating of a power
reduction matrix.

**Power Reduction Matrix Reduction Rating**

| D100  | Reduction Rating                                                                                        |
|-------|---------------------------------------------------------------------------------------------------------|
| 01-60 | 1                                                                                                       |
| 61-85 | 2                                                                                                       |
| 86-95 | 3                                                                                                       |
| 96-99 | 4                                                                                                       |
| 00    | Roll again and add 4 to the reduction rating result. If 100 is rolled again, the reduction rating is 9. |

#### Spell Matrix:

A spell matrix gives a spellcaster the knowledge of a particular spell while the
spellcaster wears it. Spell Matrixes are normally some wearable item like an
amulet, a ring, a brooch, etc. After a spellcaster has worn the spell matrix for
at least one hour (to attune it to his mind), the spellcaster may cast the spell
held within the spell matrix as if it were memorized, but it does not count
against the caster’s memory limit. The caster must be able to cast the spell
(that is, the spell must be found on the spellcaster’s class spell list and must
be of a spell level she is able to directly cast) to be able to actually cast
the spell. The spell matrix only provides knowledge of the spell as if it were
memorized by the wearer, it does not provide the energy to cast the spell. Note
that the caster does not actually know the spell provided by the spell matrix –
she cannot record the spell in her spell books or teach the spell to others.

Use the following table to determine the level and type of spell held by a
random spell matrix. The Referee can then either select a spell from the
appropriate list or determine one randomly.

| Spell Type | Magic-User Spell | Cleric Spell |               |        |               |
|------------|------------------|--------------|---------------|--------|---------------|
| *Roll D6*  | *Type*           | *D100*       | *Spell Level* | *D100* | *Spell Level* |
| 1-3        | Cleric           | 01-25        | 1             | 01-30  | 1             |
| 4-6        | Magic-User       | 26-50        | 2             | 31-55  | 2             |
|            |                  | 51-70        | 3             | 56-75  | 3             |
|            |                  | 71-85        | 4             | 76-90  | 4             |
|            |                  | 86-95        | 5             | 91-00  | 5             |
|            |                  | 96-00        | 6             |        |               |

#### Talent Matrix

A talent matrix gives its wearer knowledge equivalent to a talent. After donning
a talent matrix, it takes one full day for the wearer to attune his mind to the
talent matrix and assimilate the knowledge, thereafter the wearer is treated as
if he has the talent held in the talent matrix until he removes the talent
matrix. Talent matrixes are normally some wearable item like an amulet, a ring,
a brooch, etc. Most talent matrixes provide their knowledge at the “Good at”
level. Some provide their knowledge at the “Expert at” or even the “Master at”
levels. Talents are part of the Extended Rules for Skills. If the campaign does
not use the Extended Rules, the Referee may opt to either not use talent
matrixes in the campaign or to use the talent rules only for talent matrixes. To
determine the knowledge level granted by a talent matrix, roll on the table
below. The Referee will have to assign the particular knowledge the talent
matrix grants as this is very campaign dependent (and isn’t something that can
be put in a table). Optionally, some talent matrixes may give weapon mastery
instead of a normal talent.

**Talent Matrix Knowledge Level**

| Roll D20 | Knowledge Level |
|----------|-----------------|
| 1-15     | Good at         |
| 16-19    | Expert at       |
| 20       | Master at       |

  
**Spell and Talent Matrix Limitation:** A character can only wear a limited
number of spell and talent matrixes. A character can wear up to a total of 2
plus their INT bonus (regardless of modifiers, a character may always wear 1)
spell and/or talent matrixes. Should a character ever wear more than this
number, he will be confused until all spell and talent matrixes are removed and
will remain confused for 2d6 rounds after all are removed.

When a spell or talent matrix is removed, the character loses the knowledge of
the spell or talent provided by the matrix. If he dons the matrix again at a
later time, he will have to attune his mind to the matrix anew before he can
again use the knowledge it provides.

### Potions

**Antidote:** The drinker becomes immune to all poisons of up to a specific
strength for the duration of the potion. Poison from non-creature sources (e.g.,
a Potion of Poison) should be considered to be as if from a 7HD creature. The
strength of the potion should be determined by rolling 1d10: 1-4 = Poison from
3HD creatures, 5-7 = Poison from 7HD creatures, 8-9 = Poison from 15HD
creatures, 10 = All poison.

**Battle:** The user gains a +1 bonus on to hit rolls, damage rolls from melee
and ranged weapon attacks, and a +1 bonus to his armor class.

**Blending:** The drinker may change color to blend in with their surroundings.
When hiding, the drinker will have a 90% chance to go unnoticed unless the
viewer can see invisible creatures.

**Bug Repellent:** Any normal or giant bug (an insect, spider, scorpion,
centipede, or other arthropod) will completely ignore the drinker unless
magically controlled. If the bugs are magically controlled to attack the
drinker, the drinker gets a +4 bonus to any saving throws against the
controlling effect that allow the damage done by the insects to be reduced.

**Celerity:** This potion allows the character who drinks it to move 50% faster
than normal. He gains a +1 bonus on individual initiative (if used) and a +1
bonus to Armor Class.

**Climbing:** The drinker gains the ability to climb sheer surfaces without the
aid of any equipment. A proficiency throw of 2+ on 1d20 is required per 100’ of
climbing, at least once per climb.

**Defense:** This potion only lasts 10 minutes. The drinker gets a bonus to
their armor class based on the power of the potion. To determine the power of
the potion, roll 1d10: 1-3 = +1, 4-5 = +2, 6-7 = +3, 8-9 = +4, 10 = +5.

**Delusion:** This potion is aptly named, for it convinces the drinker that the
potion is of another type. If more than one person tastes this potion, there is
a 90% chance they all will believe the potion to be of the same type. For
example, a potion of clairaudience might convince the drinker there are sounds
in the distance that do not truly exist.

**Dreamspeech:** This potion only lasts for 10 minutes. The drinker can speak to
one paralyzed, petrified or sleeping creature within 30’ (only one creature can
be spoken with per potion) and can hear the responses of the creature via ESP.
The drinker will automatically understand the language of the target, but the
target is under no compulsion to speak the truth (or even respond at all) if
they do not wish to.

**Elasticity:** This potion only lasts for 10 minutes. The drinker may stretch
and deform themselves and their equipment to fit through gaps as small as 1” and
reach as far as 30’. The drinker cannot cast spells or attack while stretched,
and items carried cannot be used or dropped unless they are in normal form.
However, while stretched the drinker only takes half damage from blunt and
bashing attacks.

**Elemental Bane:** These potions are anathema to elementals. Merely having the
potion bottle uncorked within 20 feet of an elemental will inflict 1 point of
damage per round. Shattering the potion (which can be thrown as a flask of oil)
will release a cloud of mist that fills a 20 foot radius and then evaporates
nearly immediately. Elementals caught in the area of the mist when it is
released are dealt 4d8 damage. There are five types of elemental bane potion,
the major elemental bane potion affecting all elementals, and the minor ones
affecting only one type of elemental.

| Roll 1d6 | Elemental Type      |
|----------|---------------------|
| 1        | Air                 |
| 2        | Earth               |
| 3        | Fire                |
| 4        | Water               |
| 5-6      | Greater (All types) |

  
**Elixir of Oracular Vision:** The drinker of this potion is immediately struck
unconscious for 1 hour. At the end of this hour the drinker gains the benefits
of the contact higher plane spell (including the chance of rendering the drinker
insane) – with the plane contacted being determined by rolling 2d4+1.

**Fulminating:** This potion is treated as a potion of poison if imbibed.
However, if thrown as a flask of oil, it will explode dealing 3d6 damage to all
within 10 feet of it, and 1d6 damage to those within a 20 foot radius.

**Freedom:** The drinker is immune to paralysis and to all forms of Hold spell
or effect.

**Hero’s Heartblood:** If Lawful, the user of this potion gains a +2 bonus on
attack and damage rolls, retainer morale goes up by +2, and is immune to fear.
Neutral characters gain half this bonus, and Chaotic characters must make a
saving throw against spells – if successful they gain the full bonuses as they
force the spirit of the hero to help them, otherwise the chaotic character
suffers a -1 penalty on attack and damage rolls for the duration.

**Horseman’s Draught:** The user gains +1 on all attack rolls and saving throws
while mounted, and under his command his mount gains these same bonuses.

**Immunity:** This potent draught renders the imbiber completely immune to all
other magical effects (both harmful and beneficial) for 1d6+1 rounds. This
effect applies to area effects, healing and any spell-like effect, but doesn’t
provide immunity to the damage of magic weapons, nor does it grant the ability
to cross through magical barriers (although any harmful magical effects of such
a barrier would not trigger against the imbiber).

**Luck:** This potion lasts only for 1 hour. The potion makes the drinker
extremely lucky. The player of the drinking character may choose any one roll
that they make on behalf of the drinking character within the duration and
simply place the dice on the result of their choice rather than having to
actually roll them.

**Merging:** This potion allows the drinker to merge other creatures into their
own body. The drinker can merge up to seven other creatures, and both the
drinker and the other creatures must be willing. Creatures simply step “into”
the drinker and disappear along with their items and equipment. While merged
with the drinker, the creatures do not take damage if the drinker is hit, and
they cannot take any actions other than speaking. The merged creatures can step
“out of” the drinker at any time and will automatically step out when the
potion’s effect ends.

**Oil of Sharpness:** This potion resembles the dark oil used to clean arms and
armor. When applied to the blade of an edged or pointed weapon, it temporarily
enhances it to the equivalent of a +1 magic weapon. Weapons that are already
enchanted gain an additional +1 while oiled. If drunk, the oil serves only to
give the imbiber flatulence for several hours.

A single vial contains enough to coat 20 arrows, 2 one-handed weapons, or one
two-handed weapon. The oil will evaporate 8 hours after it is applied.

**Philter of Love:** The imbiber of this potion becomes charmed by the next
creature he lays eyes upon. However, the drinker will actually become charmed
*and* besotted by the creature if it is of the preferred sex and of similar
racial stock. The charm aspect of this potion lasts for 6+1d6 turns, but only
dispel magic will make the drinker cease to be enthralled by a member of a
preferred sex.

**Revival:** This potion will remove any form of paralysis, and also makes the
imbiber immune to sleep-type effects for the next 24 hours.

**Saddle Born’s Draught:** The user gains the benefits of the Horseman’s Draught
(+1 on all attack rolls and saving throws while mounted, and his mount gains
these same bonuses), and also gains the ability to speak with horses,
hippogriffs, griffons and pegasi.

**Satiety:** This potion eliminates the need for food or drink for 1d6 days. The
user feels neither hunger nor thirst but can still eat or drink if he pleases.
At the end of the duration, there are no ill effects from having not eaten or
drunk for the duration.

**Shadows:** After imbibing this potion, the user casts no shadow. Instead, a
Shadow replaces his natural shadow and follows his orders, even to the death. It
can travel up to 240 feet away from the user in pursuit of its orders.

**Sight:** This potion lasts for 10 minutes. While this potion is in effect, the
drinker can temporarily see despite any blindness conditions. Additionally, the
drinker may see invisible things.

**Speech:** The drinker can understand all languages that they hear, and can
respond in those same languages. This potion does not give the drinker the power
to speak a language unless they first hear it spoken.

**Sweet Water:** This sweet-tasting liquid can be used to cleanse water
(including turning saltwater into fresh water) or otherwise transform poisons,
acid, and other non-potables into drinkable liquid. Further, sweet water will
destroy other potions. For most liquids, this potion will affect up to 100,000
feet cubed. However, only 1,000 feet cubed of acid can be neutralized. The
effects of sweet water are permanent, and once treated, liquid will resist
spoilage or contamination for 5d4 rounds. After this time, it can be
contaminated once again.

### Rings

All magical rings are usable by any character class. They must be worn on a
digit of the hands only (fingers or thumb). It is only possible to wear two
magical rings; if more than two are worn all of the rings do not function.

**Assassin’s Ring:** This magical ring also contains a non-magical secret
compartment designed to hold a dose of poison. The magic of the ring, however,
is to produce a tiny handful of dust once per day. This magic powder can conceal
the passage of its possessor and any other. Throwing the dust into the air
causes an area of up to 1,000 square feet to seem untraveled and untouched for
years, possibly a decade. The powder must be used within a turn of being
created, otherwise it loses its magical ability.

**Awareness:** The wearer of this ring is only surprised 1 time in 6 instead of
the normal 2 in 6. If the wearer already has this ability, the ring provides no
benefit.

**Battle Prowess:** When this ring is worn and activated, it increases the
chance that attacks are successful. whenever the character makes an attack while
wearing this ring, roll two dice for each attack, and take the more favorable
result. This power does not enact until it has been worn continuously for at
least 24 hours. A ring of battle prowess can only function twice per day for up
to three rounds per activation.

**Cipher Ring:** This ring is made of two interlocking bands that can be easily
separated into their individual parts. When wearing only one half of the ring,
the wearer’s speech is a nonsensical babble that is only understandable by a
comprehend languages spell, or to the person wearing the other half of the ring.

**Command Animal:** The wearer of this ring may control 1 giant animal or 1d6
normal-sized animals within line of sight. Magical monsters or intelligent
animals are not affected. The effect lasts so long as concentration is
maintained, and the wearer can take no other actions. Once control ends, animals
will not be well disposed to the ring wearer, and any reaction rolls suffer a
penalty of -1. The ring may be used once per turn.

**Command Plant:** The ring wearer can control plants within a 10’ x 10’ area up
to 60’ away. This control extends to plant creatures, and even if the plant is
not normally mobile, this ring grants the ability to make the plants move. The
effect lasts so long as concentration is maintained, and the wearer can take no
other actions.

**Courier’s Band:** When worn, this ring “records” the movements of the wearer’s
hand while writing. The next time the ring is worn, and the wearer attempts to
write something, the ring will immediately “play back” the movements recorded,
making the wearer write exactly what was written when the ring was last worn
(unless the wearer makes a saving throw vs spells, in which case he can write
what he wants instead).

**Ear:** Three times per day this ring can be removed from its wearer’s finger
and placed against any surface. Until the wearer recovers the ring, they will be
able to hear everything that happens around the ring as if their ear were in the
ring’s location.

**Elemental Adaption:** To determine the exact type of ring found, roll 1d100:
01-21 = Air, 22-42 = Earth, 43-63 = Fire, 64-84 = Water, 85-91 = Air and Water,
92-98 = Earth and Fire, 99-00 = All Elements. The wearer of the ring is
protected from environmental hazards in the elemental plane that matches the
elemental alignment of the ring, and is able to breathe in those planes despite
lack of air.

**Everlasting:** If the wearer of this iron ring is slain, he rises as an undead
in one turn, the type of which is determined by the level or hit dice of the
wearer. Most (75%) of everlasting rings also have the abilities of another ring
type – roll again on the ring table to determine the other powers of the ring.

| Wearer’s Level/HD    | Undead Type |
|----------------------|-------------|
| Less than 4 hit dice | Ghoul       |
| 4 to 6 hit dice      | Wight       |
| 7 to 9 hit dice      | Mummy       |
| 10+ hit dice         | Vampire     |

**Fire Drinking:** This brass ring works as a ring of fire protection but only
in regards to nonmagical fires. Also, the wearer can hold fire in his hands and
drink the fire. This act replenishes the body’s fluids, so he never needs water.
The ring must be worn for seven consecutive days before it starts working.

**Frigid Ring:** The wearer of a frigid ring becomes immune to all forms of
cold-based damage, and his own cold-based spells become more potent (all saves
against cold-based spells cast by the wearer are at a -2 penalty). However, the
wearer also suffers double damage from fire.

**Horsemaster’s Ring:** The wearer of this ring (typically made to look like the
head of a horse or a saddle) gains +1 on all attack rolls and saving throws
while mounted, and under his command his mount gains these same bonuses.

**Icebone Knuckle:** The wearer of this ring made of skeletal knuckles bound
together by silver wire may travel at normal speed across snow or even the most
slippery horizontal (or nearly horizontal) ice surface without falling,
slipping, or leaving visible tracks. 25% of icebone knuckles also provide the
benefits of a ring of cold resistance.

**Legacy:** Legacy rings are alignment-specific rings that pass along the might
and experience of one era of champions to the next. Each ring is imbued with the
experience of a single great hero who achieved at least level 9 (or their
maximum class level for classes with less than 9 levels). When worn by someone
of the same class and alignment whose level is below 9, a variety of benefits
are gained. These benefits are lost when the character reaches level 9 (or
maximum level for classes with less than 9 levels). The wearer gains a +1 bonus
to his prime requisite (of the wearer’s choice for classes with multiple prime
requisites) which may also increase his XP bonus. Thieves make all skill checks
as if one level higher. Spellcasters calculate all level-dependent variables for
their spells as if one level higher (but do not gain additional spells per day).
Fighters gain +1 on to hit rolls. Legacy rings are often combined with other
useful types of rings such as rings of protection, spell turning and
invisibility.

**Life Protection***:* This ring will protect its wielder from 1d6 levels worth
of energy drain. If overloaded (for example if it has only a single level of
protection left and the wearer is drained two levels) then it will successfully
protect the caster and then turn to dust. If it is exactly used up without being
overloaded, it will become a Ring of Protection +1 once its levels of protection
have been used up.

**Perpetual Magic:** All spells cast on the wearer of this ring last for twice
as long as normal.

**Potion Ring:** This ring’s stone setting is hinged. When open, a potion can be
poured into the hole behind the stone and is magically absorbed by the ring.
When the setting is closed again, the stone glows gently. The ring can be
activated with a thought at any time, and the wearer gains the benefit of
drinking the potion that was last poured into it. The stone then stops glowing
and the ring is ready to receive another potion.

**Rat:** This ring grants the wearer +4 on all saving throws against disease and
+2 on all saving throws against poison.

**Quickness:** Once per day, the wearer of this ring can move at double speed
and take two actions per combat round for ten minutes.

**Remedies:** Once per day, this ring will duplicate the effect of a Cure
Blindness, Cure Disease, Remove Curse or Neutralize Poison spell as if cast by a
6th level Cleric. The spell can be cast on the wearer or on a target that the
wearer touches.

**Safety***:* This ring acts like a Potion of Luck except that it has 1d4
charges and uses up a charge each time a die is placed instead of rolled. Once
all the charges have been used up, this ring becomes non-magical.

**Seeing:** Once per day this ring enhances the character’s sight for 30
minutes: a polymorphed creature or object will appear as it really is,
superimposed with its present form. When looking at a person one may tell his
alignment, class, level, and general intentions. One may also see invisible,
displaced, ethereal and astral objects. Blindness is temporally “cured” when
this ring is active.

**Skeletal Ring:** This ring is composed of two interlocking bands in the design
of a pair of skeletal hands and arms that grab each other at the elbows. The two
bands can be snapped apart and if one is kept on the wearer and a second placed
upon the finger of a corpse or skeleton, then the corpse will rise as if under
the effects of an animate dead spell, under the control of the wearer of the
matching band.

**Souls:** These rings can only be used by chaotic clerics. There are three
varieties, lesser, normal and greater. While wearing the ring, the cleric can
touch it to the forehead of a dying creature (one that was reduced to zero or
less hit points in the previous round) in order to capture the creature’s life
essence or soul. The creature can make a saving throw to prevent this. A lesser
ring can hold one soul, a normal ring two, and a greater ring can hold three
souls. When making saving throws, if one of the souls within the ring would have
a better saving throw than the wearer, then the wearer gains a +1 bonus on the
saving throw. The wearer can also use the soul trapped within the ring to power
clerical spells. The spell powered by the trapped soul gains +1 on every die
rolled (for damage or healing or random duration), and increases in range and
duration by 50%. The wearer has no control over which soul is used in this way –
it is always the most “powerful” soul within the ring, which is freed from the
ring when used.

| Roll D20 | Ring of Souls Type |
|----------|--------------------|
| 1-12     | Lesser             |
| 13-19    | Normal             |
| 20       | Greater            |

**Stalker:** The wearer of this ring is treated as being invisible to all
creatures more than 40 feet away. Unlike normal invisibility, this effect turns
itself back “on” on the wearer’s next round so if he does something to break the
invisibility (such as casting a spell or attacking), he only becomes visible to
those more than 40 feet away until his next initiative.

**Stones:** These rings come in three varieties (+1, +2 and +3) and are studded
with 3d6 (+1), 2d6 (+2) or 1d6 (+3) small beads or balls around the
circumference. The wearer can fire two balls from the ring per combat round as
if they were sling stones with the indicated enchantment bonus. Once all the
balls have been fired, the ring becomes useless and non-magical.

| Roll 1D20 | Ring of Stones Type |
|-----------|---------------------|
| 1-14      | \+1                 |
| 15-19     | \+2                 |
| 20        | \+3                 |

  
**Stonesafe:** This ring has 3 small pearls set within it. It grants a +2 bonus
to saving throws against being turned to stone by spells or creature’s powers.
Further, if the wearer does fail his save and is turned to stone, one of the
ring’s pearls will turn to stone instead, leaving the wearer unscathed. Once all
three pearls have been turned to stone the ring will no longer function. The
pearls cannot be “reset” by casting stone to flesh on them.

**Succor:** Once the owner of this ring has worn it for 24 hours or longer, all
healing magics applied to the wearer (such as cure spells and potions of
healing) heal one additional hit point per die rolled.

**Survival:** This ring will contain 1d100+100 charges when found. Each charge
spent will allow the wearer to go for 24 hours without food and drink or for 1
hour without breathing. When the ring is down to its last five charges, it will
turn black; and when it runs out of charges it will crumble to dust.

**Truth:** Three times per day, this ring can be activated to telepathically
warn its wearer whether a spoken statement that they have just heard is true in
the opinion of the speaker. Note that there is a difference between the speaker
being untruthful and the speaker merely being honestly wrong about something.

**Truthfulness:** This ring appears to be a Ring of Truth when examined with an
Analyze spell, and will work as a Ring of Truth. However, once worn it cannot be
removed except by a Remove Curse spell cast by a 12th level caster, and it
compels its wearer to always speak the truth. The wearer may not knowingly lie
while wearing the ring (but the ring doesn’t prevent them from accidentally
being wrong).

**Truthlessness:** This ring appears to be a Ring of Truth when examined with an
Analyze spell, and will work as a Ring of Truth. However, once worn it cannot be
removed except by a Remove Curse spell cast by a spellcaster of at least 12th
level, and it compels its wearer to always speak lies. The wearer may not
knowingly make any true statement while wearing the ring (but the ring does not
prevent them from making a statement that is accidentally true if they genuinely
don’t know that it is).

**Weakness:** This is a cursed ring, and once put on it can be removed only with
a remove curse spell. Over the course of 6 rounds, the wearer’s STR drops to 3
and all attacks and damage are rolled with a penalty of -3 (minimum of 1 point
of damage is dealt).

#### Special Types of Magic Rings (Optional)

While most magical rings are made of metal (generally silver, gold or platinum),
there are some made of special materials or of special design that affect how
they operate and what powers they imbue. Here are some suggested types of rings
that can be applied to any existing ring in order to make it different from the
norm. In addition, many of these rings may exist purely on their own, not
combined with a “standard” magic ring (although most are at least fashioned into
rings of protection). Approximately 1 in 20 rings are one of these special
types.

**Biting Ring:** These rings have sharp protrusions of some kind or another, and
are often sculpted to look like a creature’s mouth or head. When worn, the ring
reduces the natural healing of the wearer. Whenever the wearer rests to gain hit
points, he gains 1 less hit point than normal.

**Crystal:** This clear or translucent crystal ring provides a +2 bonus on all
saving throws against mind- affecting attacks and spells. It also provides a +2
bonus to the wearer’s targets if he or she casts any mind-affecting spells.

**Fletcher’s Rings:** These rings are meant to be worn further forward on the
finger, and on the thumb instead of the ring finger. They provide a +1 bonus to
attacks with long and short bows when worn.

**Garnet:** This red ring provides a +2 bonus on all forms of saving throws
against lightning and electricity, and reduces electrical damage received by one
quarter. At the Referee’s option, it may also reduce the damage of any
electrical spells cast by the wearer.

**Ivory:** This ornately carved white ring provides a +2 bonus on all forms of
saving throws against fire, and reduces all fire damage received by one quarter.
At the Referee’s option, it may also reduce the damage of any fire spells cast
by the wearer.

**Jade:** This green stone ring provides a +2 bonus on all forms of saving
throws against cold, and reduces all cold damage received by one quarter. At the
Referee’s option, it may also reduce the damage of any cold spells cast by the
wearer.

**Jet:** This black stone ring provides a +2 bonus on all forms of saving throws
against acid, and reduces all acid damage received by one quarter. At the
Referee’s option, it may also reduce the damage of any acid spells cast by the
wearer.

**Puzzle Rings:** These rings are made up of small, intricate parts that move
when being put on or removed. The process of putting on the ring will always
disturb the puzzle, and the wearer must then solve the puzzle before the ring’s
power will work. The first time this is done it requires 1 turn per check to
figure out how the puzzle works, but once the puzzle has been solved once by the
wearer, then in the future checks can be made once each round. In order to solve
the puzzle, the wearer must roll a 5-6 on a d6. Apply a modifier to the roll
based on the wearer’s Intelligence (-3 for INT 3, -2 for INT 4-5, -1 for INT
6-8, +1 for INT 13-15, +2 for INT 16-17, +3 for INT 18).

**Spellbinder’s Band:** Whenever the wearer of this ring is targeted by a spell,
beneficial or otherwise, the diamond setting on the ring erupts into brilliant
light for one round per level of the spell. This dispels any darkness effects
within 30 feet and is otherwise treated identically to a light spell targeting
the ring.

**Thief Bane:** When this ring is removed from the wearer’s finger by anyone but
the wearer, it triggers a 5d6 damage fireball spell one full turn later,
centered on the ring itself.

### Rods, Staves, and Wands

Rods are generally usable by any class, but a few are restricted to use by
certain classes only. Wands may only be used by magic-users. A staff may be
usable by either Magic-Users or Clerics, depending on the kind of staff. When a
class-restricted item is described, the name of the item will be followed by
either “C” if it is usable by clerics, “M” if it is usable by Magic-Users, and
“CM” if usable by both.

**Rod of Agelessness:** The bearer of the ageless rod cannot age and is immune
to effects that alter time (including slow and haste spells and effects). The
rod’s effects only work as long as the bearer holds the rod, making its
possession something of a curse as well.

**Rod of Air:** This elemental rod grants the bearer a +2 on all saving throws
when flying or otherwise not touching the ground. Once per week it can be used
to summon an 8 HD air elemental for 12 turns that will follow the bearer’s will
as long as he holds the rod. If the rod is released or the bearer is rendered
unconscious before the duration of the summoning is done, then the elemental
becomes hostile and uncontrollable and will attack the wielder and his friends
and companions.

**Rod of Branding:** A rod of branding can magically and permanently mark a
target with a sigil specific to the rod in question. An immobile target can be
marked in a single round, or the rod can be wielded as a +1 mace and will mark
the target if a natural 20 is rolled on an attack roll.

**Rod of Captivation:** With the expenditure of 1 charge, all monsters and
characters within a 20’ radius are *charmed* by the wielder for 1 turn so long
as they are at least minimally intelligent. All charmed beings will hold nothing
but respect and awe for the wielder, and will seek to please him by doing nearly
anything short of harming themselves or violating their alignment.

**Rod of Dueling:** This rod, looking like a rod of office or other similar
implement, can be transformed into a Long Sword +1 on the command of the wielder
(and transformed back into its rod form in the same way).

**Rod of Earth:** This elemental rod grants the bearer a +2 on all saving throws
as long as he is standing on dirt or rock. Once per week it can be used to
summon an 8 HD earth elemental for 12 turns that will follow the bearer’s will
as long as he holds the rod. If the rod is released or the bearer is rendered
unconscious before the duration of the summoning is done, then the elemental
becomes hostile and uncontrollable and will attack the wielder and his friends
and companions.

**Rod of Fire:** This elemental rod grants the bearer a +2 on all saving throws
against cold attacks or effects from creatures that have cold attacks. Once per
week it can be used to summon an 8 HD fire elemental for 12 turns that will
follow the bearer’s will as long as he holds the rod. If the rod is released or
the bearer is rendered unconscious before the duration of the summoning is done,
then the elemental becomes hostile and uncontrollable and will attack the
wielder and his friends and companions.

**Staff of Dark Dreams [M]:** This staff can cast the following spells at the
command of a magic user. Cause Fear (1 charge), Sleep (1 charge), Feeblemind (2
charges).

**Staff of Dispelling [CM]:** When the staff is used and a charge is expended,
it will cast Dispel Magic as if by a 5th level caster, except with a range of
only touch. The staff can be used to dispel magic items. When it is used against
an item and a charge is expended it will automatically destroy any potion or
scroll; and will cause any other magic item to temporarily cease working for 1d4
rounds. Note that magic weapons and armor still work as mundane weapons and
armor even when their magical properties are temporarily suppressed.

**Staff of Undeath [CM]:** This black wrought-iron staff usually has several
bones hanging from the head as noise makers. It can be used by both clerics and
magic users. It can cast the following spells: Animate Skeleton (1 charge),
Animate Zombie (1 charge), Animate Dead (3 charges).

**Wand of Deflection:** This wand will cast a shield spell on any target within
20 feet (including the wielder).

**Wand of Detecting Enemies:** This wand makes any enemies of the wielder that
are within 60’, whether invisible or hidden, become surrounded by a fiery red
aura for up to 6 turns. This effect requires one charge.

**Wand of Device Negation:** The wielder of this wand may choose a wand, rod, or
staff from an opponent, and render it powerless for 1 round. The item is
powerless on the same round the wand of negation is used. Therefore, the action
to use this wand must be announced prior to determining initiative. One charge
is expended per usage.

**Wand of Fire:** A wand of fire produces several spell-like effects, and may
only produce one effect per round. The following effects require the expenditure
of 1 charge: burning hands shoots forth a triangular ray of fire 12’ long with a
10’ wide ending width. Any being within this area of effect suffers 6 hp damage;
pyrotechnics may be produced from the wand, and mimics the spell of the same
name.

The wand of fire may produce the following effects with the expenditure of 2
charges: a fireball may be shot from the wand, performing exactly as the spell
of the same name, as if cast from a 6th level character. It deals 6d6 hp damage
to all within the area of effect (save versus wands for half damage). Any result
of 1 on a damage die is treated as a 2. A wall of fire may be produced, like the
spell of the same name cast from a 6th level character. The wall may be formed
into a 22’ diameter circle surrounding the wand wielder.

**Wand of Ice:** A wand of ice produces several spell-like effects, and may only
produce one effect per round. The following effects require the expenditure of 1
charge: an ice storm (as the magic user spell) wreaks its cold havoc to a
distance of 60’; a wall of ice can be brought into existence. It always has a
thickness of 6 inches, but may have any surface area as commanded by the wand
wielder to a maximum of 600’ (for example, 25’ x 24’ or 10’ x 60’).

The wand of ice may produce a cone of cold with the expenditure of 2 charges.
The cone is 20’ in diameter at its maximum length of 60’. It deals 6d6 hp damage
to all within the area of effect (save versus wands for half damage). Any result
of 1 on a damage die is treated as a 2.

**Wand of Light:** A wand of light produces several spell-like effects, and may
only produce one effect per round. The following effects require the expenditure
of 1 charge: dancing lights as the magic-user spell, and light as the magic-user
spell.

The wielder may spend two charges to create continual light. Finally, by
spending 3 charges, the wielder may create a ray of intense sunlight. The bright
golden-yellow light lasts only a moment, has a range of 120’, and forms a 40’
diameter sphere of light. Any being within the area must save versus wands or be
blinded and stunned for 1 round. The golden sphere of light has a devastating
effect on all undead, dealing 6d6 hp of damage, with no saving throw allowed.

**Wand of Magic Missiles:** This wand fires one or two magic missiles (user’s
choice) per round, as the Magic-User spell of the same name. The missiles
inflict 1d6+1 points of damage each, and always strike. Each individual missile
fired expends one charge.

**Wand of Wonder:** A *wand of wonder* is a strange and unpredictable device
that randomly generates any number of weird effects each time it is used. Each
use costs 1 charge. In some cases, a saving throw is appropriate. The effects
should be considered typical of those possible, but the referee may adjust these
or create new effects, depending on the situation. Typical powers of the wand
include the following:

| D100   | Wondrous Effect                                                                                                                                               |
|--------|---------------------------------------------------------------------------------------------------------------------------------------------------------------|
| 01–05  | *Slow* creature pointed at for 1 turn.                                                                                                                        |
| 06–10  | *Faerie fire* surrounds the target.                                                                                                                           |
| 11–15  | Deludes wielder for 1 round into believing the wand functions as indicated by a second die roll (no save).                                                    |
| 16–20  | *Gust of wind,* but at twice the power.                                                                                                                       |
| 21–25  | Wielder learns target’s surface thoughts (as with *ESP)* for 1d4 rounds.                                                                                      |
| 26–30  | *Stinking cloud* at 30’ range.                                                                                                                                |
| 31–33  | Heavy rain falls for 1 round in 60’ radius centered on wand wielder.                                                                                          |
| 34–36  | *Summon* an animal—a rhino (01–25 on d%), elephant (26–50), or mouse (51–100).                                                                                |
| 37–46  | *Lightning bolt* (70’ long, 5’ wide), 6d6 damage.                                                                                                             |
| 47–49  | Stream of 600 large butterflies pours forth and flutters around for 2 rounds, blinding everyone (including wielder).                                          |
| 50–53  | *Enlarge* victim if within 60’ of wand.                                                                                                                       |
| 54–58  | *Darkness*, 30’ diameter hemisphere, centered 30’ away from wand.                                                                                             |
| 59–62  | Grass grows in 160’ square area before the wand, or grass existing there grows to ten times normal size.                                                      |
| 63–65  | *Vanish* any nonliving object of up to 1,000 lb. mass and up to 30’ cubed in size.                                                                            |
| 66–69  | Reduce wielder to 1/12 height.                                                                                                                                |
| 70–79  | *Fireball*, 6d6 damage, as wand.                                                                                                                              |
| 80–84  | *Invisibility* covers wand wielder.                                                                                                                           |
| 85–87  | Leaves grow from target if within 60’ of wand.                                                                                                                |
| 88–90  | 10–40 gems, value 1 gp each, shoot forth in a 30’ long stream. Each gem deals 1 point of damage to any creature in its path: Roll 5d4 for the number of hits. |
| 91–95  | Shimmering colors dance and play over a 40’ x 30’ area in front of wand. Creatures therein are blinded for 1d6 rounds.                                        |
| 96–97  | Wielder (50% chance) or target (50% chance) turns permanently blue, green, or purple.                                                                         |
| 98-100 | *Flesh to stone* (or *stone to flesh* if target is stone already) if target is within 60’.                                                                    |

### Miscellaneous Magic Items

**Amulet against Possession:** The wearer of this copper amulet is rendered
immune to *magic jar*, *possession*, and other effects of a similar nature,
including demon possession.

**Amulet of the Planes:** This device usually appears to be a black circular
amulet, although any character looking closely at it sees a dark, moving swirl
of color. The amulet allows its wearer to utilize *plane shift*. However, this
is a difficult item to master. There is a 20% chance for the first 1d6 uses that
the wearer is transported to a random plane of existence.

**Amulet of Proof against Detection and Location:** This silver amulet protects
the wearer from scrying and magical location. As a result, the wearer may
neither be located with a crystal ball, nor seen through spells such as ESP,
clairaudience, clairvoyance, or other spells used to predict actions,
intentions, or to reveal alignment.

**Animal Pelt:** These magical pelts include the skins of many normal animals
such as deer, wolves, bears, lions, tigers and so forth. An enchanted animal
skin grants the wearer the ability to *polymorph self* into the type of creature
in question for 1 hour per day or until the wearer wishes the ability to end.

**Anklet of the Harlot:** This finely wrought silver chain is studded with
rubies. Designed to be worn about the ankle, this magic item was made famous by
a woman of high social standing who used it to assist her in robbing men in
their chambers. Once per day, the wearer may trigger a sleep spell centered on
the wearer but that will not affect the wearer.

**Apparatus of the Crab:** This item appears to be a large, sealed iron barrel,
but it has a secret catch that opens a hatch in one end. Anyone who crawls
inside finds ten levers. The device has the following characteristics: hp 200;
Move 30’ forward, 60’ backward; AC -1 [20]; \#AT 2 pinchers; Dmg 2d6. When
attacking with the pinchers, the attack throws required are the same as the
operator’s, and if a hit is scored, there is a chance that both pinchers strike,
for a total of 4d6 points of damage (roll of 1-5 on 1d20).

| Lever | Lever Function                                       |
|-------|------------------------------------------------------|
| 1     | Extend/retract legs and tail                         |
| 2     | Uncover/cover forward porthole                       |
| 3     | Uncover/cover side portholes                         |
| 4     | Extend/retract pincers and feelers                   |
| 5     | Snap pincers                                         |
| 6     | Move forward/backward                                |
| 7     | Turn left/right                                      |
| 8     | Open “eyes” with continual light inside/close “eyes” |
| 9     | Rise/sink in water (levitate)                        |
| 10    | Open/close hatch                                     |

Two characters of human size can fit inside. The device can function in water up
to 900 feet deep. It holds enough air for a crew of two to survive 1d4+1 hours
(twice as long for a single occupant). When activated, the apparatus looks
something like a giant lobster.

**Assassin’s Robe:** Once per day the wearer of this dark robe can make a
backstab attack like a thief. When a thief uses this robe, his backstabs deal
triple damage instead of double.

**Beggar’s Robe:** Wearing this tattered robe causes the wearer’s apparel to
seem shabby, dirty and torn. This illusion doesn’t affect other items in the
wearer’s possession, just his clothing. It further provides a -2 penalty to
Charisma.

**Bell of Turning:** Once per day this bell may be rung to increase the ability
of a cleric to turn undead. The cleric is treated as being one level higher when
consulting the turning undead charts.

**Belt, Snakeskin:** The wearer of this belt gains a +2 bonus on saves versus
poison and the ability to cast the following spells: At will: polymorph self
into a giant python; 2/day: sticks to snakes; 1/day: snake charm.

**Black Cat’s Cloak:** This cloak allows the wearer to cast blight (the reversal
of bless) twice per day, and reduces the damage from all falls by 1d6.

**Boat, Folding:** A folding boat looks like a small wooden box—about 12 inches
long, 6 inches wide, and 6 inches deep. It can be used to store items like any
other box. If a command word is given, however, the box unfolds itself to form a
boat 10 feet long, 4 feet wide, and 2 feet in depth. A second command word
causes it to unfold to a ship 24 feet long, 8 feet wide, and 6 feet deep. Any
objects formerly stored in the box now rest inside the boat or ship. In its
smaller form, the boat has one pair of oars, an anchor, a mast, and a lateen
sail. In its larger form, the boat has a deck, single rowing seats, five sets of
oars, a steering oar, an anchor, a deck cabin, and a mast with a square sail.
The boat can hold four people comfortably, while the ship carries fifteen with
ease. A third word of command causes the boat or ship to fold itself into a box
once again. The necessary command words may be present, either visible or
invisible, etched into the box. Alternatively, the command words may need to be
sought through an NPC or a small quest.

**Book of the Dead:** This book must be held open and read from in order to
work, and thus takes up one hand of the cleric who wishes to use it (typically
being held instead of a shield). Reading from this massive 12 pound tome
provides a +2 bonus on all attempts to turn undead. Once per day a chaotic
cleric can cast animate dead by reading the prayers from the book in a ritual
that takes one full turn.

**Boots of Deception:** The wearer of these fine leather boots can cast
hallucinatory terrain once per day on the ground upon which he is standing.

**Boots of Frost:** These fur boots render wearer is impervious to all forms of
ordinary cold, whether from chill rain to extreme arctic col. Further, the boots
reduce damage from other kinds of cold by –1 per die of damage (minimum of 1 hp
damage per damage die), and provides a +2 bonus to saving throws against such.
Finally, the wearer can walk across still or slowly moving (less than 20 mph)
water as the water freezes beneath the boots with each step.

**Boots of Knocking:** Whenever the wearer kicks a door, gate or similar object,
it will fly open as if affected by a knock spell. These boots are found with
3d10 charges.

**Bracelet of Death:** Once per week, the wearer of this black iron bracelet can
cast death spell on a single target.

**Bracer of Radiant Power:** On command, this bracer surrounds the wearer’s hand
with elemental energy - this allows the wearer’s barehanded punches to deal an
additional 1d6 damage of the elemental type chosen. There are four different
command words, each producing a different elemental effect - fire, cold,
electricity and acid.

**Bracers of Security:** Once per day, the wearer of these finely-tooled leather
bracers can invoke an effect identical to the hold portal spell.

**Bracers of Shattering Silence:** The wearer of these bracers gains the ability
to move silently as a thief of his own level, or if he already has the ability
to move silently it improves it by four levels. Once per day the bracers can be
struck together to create a mighty cacophony. All those within 30 feet of the
wearer must make a saving throw against spells or be treated as if under the
effects of a confusion spell.

**Bracers of Spell Turning:** Like the ring of spell turning, these bracers have
2d6 charges and each charge can prevent a spell from affecting the wearer by
deflecting it back on the caster. However, to work the wearer must first decide
to use the bracers and then make a saving throw against spells. If the save
succeeds, the charge is spent and the spell reflected. If the save fails, the
charge is not spent and the spell strikes as normal – if the spell normally
allows a save, the wearer of the bracers gets to make a save as normal after
failing to activate the bracers.

**Bracers of Thunder:** These metal bracers may be struck together to create a
deafening thunderclap 50 feet long and 25 feet wide at the far end. Victims
within the area take 2d6 points of damage and must save vs. Spells or be
deafened for one turn.

**Brooch of Shielding:** This appears to be a piece of silver or gold jewelry
used to fasten a cloak or cape. In addition to this mundane task, it can absorb
magic missiles of the sort generated by spell or spell-like effect. A brooch can
absorb up to 101 points of damage from magic missiles before it melts and
becomes useless.

**Broom of Cursed Flight:** This magical broom will seem to be a broom of
flying. However, when activated it will fly up to 50’ in the air, or to ceiling
height, whichever is lower, and cease working. The character and broom plummet
to the ground, with the character taking the appropriate falling damage. The
broom loses all enchantment.

**Bugbear Warbeads:** Worn by lesser goblinoids and occasionally by those
attempting to infiltrate goblinoid settlements, this necklace of heavy wooden
beads makes the wearer appear to be a Bugbear (a minor illusion effect) and
grants a +1 bonus to reaction checks with goblinoids. The wearer of the warbeads
can cast cause fear (the reverse of remove fear) three times per day.

**Candle of Discovery:** When lit, this candle burns with a pure white flame,
but casts no visible light. However, any invisible items or creatures within 30
feet are instantly revealed in the mystical light (although their invisibility
is not countered, so if they leave the range or the candle is snuffed, they are
still invisible). Also, the mystical light of the candle shine on magic items
and secret doors although this takes a turn of burning to make all magical items
and secret doors within 30 feet of the candle visible in the candle light. A
newly made candle burns for 12 turns when lit, and may be snuffed and re-lit as
needed. A candle found in a treasure will typically have 2d6 turns of burning
left.

**Candle of Mayhem:** When lit, this black candle burns with a foul smell and a
pale flame. The candle burns for a total of one hour (6 turns) when lit unless
extinguished first. For every turn that it burns it emits a field of confusion
(as the spell) with a radius of 20 feet from the candle. Every turn the radius
increases another 20 feet. The candle will remain lit in winds up to 20 mph, but
can be extinguished instantly with a snuffer. When extinguished, the candle’s
effect ends immediately.

**Chalk of Clairvoyance:** The user of this chalk can draw a circle and then can
see things that occur within that circle whenever he holds the chalk in hand and
concentrates for one turn. The maximum range this can be used at is 360 feet,
and the effect is blocked by two feet of stone or a thin layer of lead or gold.
Only one active circle can be made at a time, and when a new circle is drawn,
the old one ceases to function. The circles drawn with this chalk are not
visible to the eye but can be seen with detect magic. The chalk can be used to
draw 1,000 feet of circles (a 10’ radius circle is 31 feet in circumference, a
100’ radius circle is 310 feet in circumference, and so on).

**Chime of Cannibalism:** This item appears to be a chime of opening. It will
function as this item for the first round of its use (and has 1d4x10 charges for
this purpose). However, on the second chime all beings within 60’ must save
versus spells or become ravenously hungry, attacking the nearest humanoid to
kill him and eat him. A new saving throw is allowed every other round. If no
humanoids are around, affected creatures will attack any other creature present.

**Circlet of Darkness:** This black metal headpiece is designed to be mounted on
a helmet, but can also be worn bare- headed. The wearer gains the ability to
cast darkness (the reverse of light) 3 times per day, and also grants the wearer
the ability to see 30 feet in any form of magical darkness.

**Cloak of Arachnida:** This black garment, embroidered with a weblike pattern
in silk, gives the wearer the ability to climb as if a spider climb spell had
been placed upon him. In addition, the cloak grants immunity to entrapment by
web spells or webs of any sort—he can actually move in webs at half his normal
speed. Once per day, the wearer of this cloak can cast web. In addition, he
gains a +2 bonus on all saves against poison from spiders.

**Cloak of the Cave Bear:** This massive cloak made from the skin of a mighty
cave bear still bears the head of the bear as a hood. The wearer of the cloak
gains the ability to frenzy in combat once per day per 3 levels of the wearer
(rounded down). For the next 1d6+1 combat rounds, the wearer cannot do anything
except scream in rage, close towards opponents, and attack in melee combat.
During this time the wearer gains a +2 bonus to hit and damage in melee combat,
but suffers a -2 penalty to armor class.

**Cloak of the Hunter:** This dark green cloak provides the wearer with the
ability to hide in the outdoors like a halfling (90% chance while immobile) and
grants a +1 bonus to hit with bows.

**Cloak of Pegasus Feathers:** This white-feathered cloak (rarely black versions
have been found) grants the wearer the benefits of a levitate spell at all
times.

**Crown of Eyes:** This twisted hammered iron crown has six points on it. Each
point is decorated with a single hideous eye. Some have had one or more of these
eyes destroyed by whatever means (roll 1d12-7 to determine how many eyes have
been destroyed on an individual crown). Each eye can be removed once per month
to cast Wizard Eye as a level 14 magic-user.

**Crown of Flame:** This golden crown is set with rubies and crafted to resemble
flames. The wearer of the crown is continuously wrapped in thin, ghostly flames
that shed light like a torch. The crown provides the benefits of resist cold
(immunity to regular cold, +2 on saves against magical cold, damage from magical
cold is reduced by 1 point per die) and protection from normal missiles
(complete protection from small, non-magical missiles). When either of these
powers is needed, the flames intensify and in the case of missiles, actually
instantly burn the missiles in mid-air as they fly towards the wearer.

**Cubic Gate:** This item is fashioned from carnelian. Each of the six sides of
the cube is keyed to a plane, one of which is the material plane. The Referee
should choose the planes to which the other five sides are keyed. If a side of
the cubic gate is pressed once, it opens a gate to a random point on the plane
keyed to that side. There is a 10% chance per turn that a being from that plane
(determine randomly) comes through it looking for food, fun, or trouble.
Pressing the side a second time closes the gate. It is impossible to open more
than one gate at a time. If a side is pressed twice in quick succession, the
character so doing is transported to a random point on the other plane, along
with all creatures within a 5’ radius.

**Cube of Frost Resistance:** This cube is activated or deactivated by pressing
one side. When activated, it creates a cube-shaped area 10 feet on a side
centered on the possessor (or on the cube itself, if the item is later placed on
a surface)*.* The temperature within this area is always at least 65°F. The
field absorbs all cold-based attacks. However, if the field is subjected to more
than 50 points of cold damage in 1 turn (from one or multiple attacks), it
collapses into its portable form and cannot be reactivated for 1 hour. If the
field absorbs more than 100 points of cold damage in a turn, the cube is
destroyed.

**Deck of Divination:** This deck of tarot cards (or similar cards depending on
the cosmology and culture of the area) has been enchanted to aid in divination.
Using the deck increases the time to cast the spells by 3 turns, but provides
the following benefits:

-   Commune: allows the caster to ask one additional question

-   Contact Other Plane: reduces the chance of lies by half.

**Drums of Stunning:** These drums resemble *drums of panic*; when both drums
are sounded at the same time, all creatures within 10’ must save versus paralyze
or be stunned for 2d4 rounds. All creatures within 70’ are instantly rendered
deaf.

**Eversmoking Bottle:** This metal urn is identical in appearance to an efreeti
bottle, except that it does nothing but smoke. The amount of smoke is great if
the stopper is pulled out, pouring from the bottle and totally obscuring vision
across a 50,000’ cubed area in 1 round. If the bottle is left unstoppered, the
smoke billows out another 10,000’ cubed per round until it has covered 100,000’
cubed. This area remains smoke-filled until the eversmoking bottle is stoppered.
The bottle must be resealed by a command word.

**Eyes of the Eagle:** These items are made of special crystal and fit over the
eyes of the wearer. These lenses allow the wearer to see 100 times further than
normal. Wearing only one of the pair causes a character to become dizzy and, in
effect, stunned for 1 round. Thereafter, the wearer can use the single lens
without being stunned so long as he covers his other eye.

**Eyes of Magnification:** These crystal lenses are similar to eyes of the eagle
and eyes of petrification. When worn, they allow the user to closely examine
objects no further than 1’ away. Thus, fine details normally invisible to the
naked eye are seen, from small imperfections in gems to hidden cracks in walls,
possibly even impressions left behind from writing. If only one lens is worn,
the user becomes dizzy, effectively stunned, for 1 round. One lens may be worn
if the other eye is closed.

**Feather Token:** Each of these items is a small feather that has a power to
suit a special need. The kinds of tokens are described below. Each token is
usable once. Determine randomly which token is found.

*Anchor:* A token useful to moor a craft in water so as to render it immobile
for up to one day.

*Bird:* This bird stays for one day and can repel other avian attacks or
transport other creatures. It is the size of a giant roc.

*Fan:* A token that forms a huge flapping fan, causing a breeze of sufficient
strength to propel one ship. This wind is not cumulative with existing wind
speed. The token can, however, be used to lessen existing winds, creating an
area of relative calm or lighter winds (but wave size in a storm is not
affected). The fan can be used for up to 8 hours. It does not function on land.

*Swan Boat:* A token that forms a swanlike boat capable of moving on water at
240’ (80’). It can carry eight horses and gear or thirty two human-sized beings
or any equivalent combination. The boat lasts for one day.

*Tree:* A token that causes a great oak to spring into being (5’ diameter trunk,
60’ height, 40’ top diameter).

*Whip:* A token that forms into a huge leather whip and can be wielded against
any opponent desired. It is a +1 weapon, and an opponent must save versus spells
or become entangled for 1d6+1 rounds. The whip lasts no longer than 6 turns.

**Figurines of Wondrous Power:** Each of the several kinds of figurines of
wondrous power appears to be a miniature statuette of a creature an inch or so
high (with one exception). When the figurine is tossed down and the correct
command word spoken, it becomes a living creature of normal size (except when
noted otherwise below). The creature obeys and serves its owner. Unless stated
otherwise, the creature understands common but does not speak.

If a figurine of wondrous power is broken or destroyed in its statuette form, it
is forever ruined. All magic is lost, its power departed. If slain in animal
form, the figurine simply reverts to a statuette that can be used again at a
later time.

*Blue Baboon:* This small lump of well-worn blue stone animates into a
collection of a dozen hideously ugly and loud baboons, each roughly the size of
a large dog. They follow the orders of the user as long as it involves stealing,
fighting or travelling, but are never quiet, nor orderly. The baboons have
typical statistics for a creature of their kind. The blue baboon can be
activated once per day, for up to an hour per use. For each baboon slain while
activated, the blue baboon cannot be activated for an additional 2 days. If all
twelve baboons are slain before the duration expires or the command word is
given, then the figurine is ruined and will not work again. (Baboon – AC:7, HD:
1+1, Att: 1, Dmg: 1d4, Sv: 18, M: 7, Align: Neutral)

*Bronze Griffon:* When animated, a bronze griffon acts in all ways like a normal
griffon under the command of its possessor. The item can be used twice per week
for up to 6 hours per use. When 6 hours have passed or when the command word is
spoken, the bronze griffon once again becomes a tiny statuette.

*Carnelian Lizard:* This red figurine is carved in the form of a long,
heavy-jawed lizard. When animated under the command of its owner, the carnelian
lizard becomes a blood lizard, a deep red scaled 5-foot long lizard (treated as
a monitor lizard). If ordered to attack, the blood lizard will fight until it
has slain a creature, at which point it will cease fighting in order to consume
the flesh from the creature. It will cease this eating only to defend itself.
This takes one turn to consume the flesh of a creature (two turns for giants and
similarly large creatures). After this time, the victim is animated as a
skeleton under the control of the carnelian lizard’s owner, and counting against
his or her normal limit of undead controlled. If the character would normally
not be able to control undead via the animate dead spell (such as a character
with no caster levels), then a single skeleton can be controlled in this manner.
The carnelian lizard can be animated once per week for a period of up to four
hours, but it immediately returns to figurine form once it has animated a
skeleton.

*Ceramic Armadillo:* When animated, this brilliantly-painted little clay
statuette becomes a giant armadillo of immense size with a pagoda built into the
armor of its back. It is treated in this form as an elephant, but with an armor
class of -2 and a single bite attack dealing 2d8 damage. The pagoda can fit a
single large creature or up to four medium or small creatures, providing them
with cover from the elements and attacks (granting +4 to AC). The statuette can
be used twice per month for up to 24 hours at a time.

*Clay Phoenix:* This clay statuette is of a bird with wings spread and no legs.
When animated, the clay phoenix is a huge bird with a 20-foot wingspan and is
treated as a giant eagle, except it always remains in flight (although it can
hover). The clay phoenix attacks at the user’s command but cannot be used as a
mount. On command, the clay phoenix can explode in a blast of hardened clay
shards, dealing 6d6 damage to all targets within a 20 foot burst of its
position. If the clay phoenix is slain, it also explodes in this manner. When it
explodes, all that remains of the phoenix is a single lump of clay in the shape
of an egg that slowly reshapes into the form of the original statuette over a
period of 1 week. Otherwise, the clay phoenix can be animated twice per week for
up to an hour per use. When an hour has passed or when the command word is
spoken, the clay phoenix returns to its statuette form.

*Copper Wolf:* This miniature wolf animates into the form of a red-furred dire
wolf with glowing red eyes. The copper wolf can be used under the command of its
owner twice per week for up to 4 hours per use. When animated, the copper wolf
takes no damage from but is instead healed by lightning attacks. When the 4
hours have passed or the second command word is spoken, the copper wolf returns
to its miniature figurine form.

*Diamond Eagle:* When animated, a diamond eagle is the size of a normal eagle,
with the standard statistics of such, except made of clear crystal, providing an
AC of 2 [17]. The user of the diamond eagle can see through the eyes of the
eagle by concentrating, wherever the eagle is as long as it is on the same plane
of existence. The diamond eagle can be used twice per week for up to 12 hours
per use. When the command word is spoken or the 12 hours have passed, the
diamond eagle again becomes a tiny statuette, and the user can no longer see
through its eyes. If slain, the diamond eagle cannot be used for one month.

*Fulgurite Octopus:* This very light and lumpy statuette looks vaguely like a
multi-tentacled creature with a hollow interior made of a translucent mineral
and sand. About an inch and a half long, when animated, this statuette becomes a
full-sized octopus that crackles with electricity. The fulgurite octopus is
treated as a normal octopus, but it can operate equally well on land as in water
and its attacks also deal 1d8 lightning damage. It can be animated for up to an
hour at a time, but after it has been animated 8 times, it loses all magical
properties.

*Granite Lump:* These lumps of dark grey granite have been worn smooth, as if
having been handled and rubbed for ages. When the command word is spoken, the
granite lump becomes a grey ooze under the command of the owner. The granite
lump can be animated in this way once per week for up to an hour, and reverts to
its figurine form when the command word is given again by the owner or when the
hour is up. Unlike most figurines, if the granite lump is slain in grey ooze
form, it is slain permanently and does not return to figurine form.

*Granite Pegasus:* This pink granite statuette is a very fine reproduction of a
pegasus and is typically found attached to a sword or other weapon hilt by a
fine silver chain. When animated, the statuette looks and acts in all ways like
a normal pegasus with a fine military saddle under the command of its possessor.
The item can be used twice per week for up to 6 hours per use. When 6 hours have
passed or when the command word is spoken, the granite pegasus once again
becomes a tiny statuette, linked to its fine silver chain.

*Hematite Cat:* This tiny hematite charm is intricately carved in the form of a
domestic cat. When activated, it animates into a typical domestic cat that
follows the orders of the user, typically used to attack a target. The first
target attacked by the hematite cat each time it is animated also suffers as if
the target of a blight spell (as the reverse of the bless spell). The hematite
cat can be used twice per day for up to five minutes each time.

*Iron Badger:* This rusty little figurine of a common badger flakes and leaves a
fine residue of rust on the hands of anyone handling it. When activated, the
figurine animates into a badger the size of a large bear, but still made of
iron. The iron badger is treated as a brown bear with an AC of 2 [17] and a 90%
ability to track foes. The iron badger can be sent on the trail of any target,
and will track to the best of its ability, attacking the target if it catches
it. If slain in combat, the iron badger cannot be brought back from statuette
form for a full month. Otherwise, it can be used once per week for 24 hours. It
enlarges and shrinks upon speaking the command word.

*Jade Leviathan:* This large jade figurine, six inches long, depicts a massive
sea creature with a wrecked ship upon its back. When animated within a body of
water at least 100 feet across and deep, the jade leviathan becomes a gargantuan
green baleen whale. When animated, the jade leviathan can be used to harmlessly
transport up to twelve medium sized creatures through a body of water within its
stomach. The figurine can be animated once per month for up to 48 hours at a
time. If anyone is inside the jade leviathan when it transforms back into its
figuring form, they appear beside the figurine, none the worse for wear.

*Malachite Bat:* This diminutive figurine is at most a half-inch in height, and
is adorned by a small hole atop its head where it can be threaded onto a
necklace. Most malachite bats are found attached to necklaces already, typically
in styles that complement the deep green of the figurine itself. The malachite
bat can be animated in two different forms, the first is that of a normal bat
with an Intelligence of 8 that follows the orders of its owner and can speak in
common. In this form, the malachite bat can be used to communicate with others
by sending and retrieving verbal messages, or as a scout, reporting back to the
owner with what it observes. It can be animated into this form for up to 24
hours per week, although this duration does not need to be continuous. The
second form of the malachite bat is that of a massive green dire bat with a
military saddle suited for use as a mount. It can be animated in this form once
per week for 12 hours. In all forms, the bat is still made of malachite, with an
AC of 4 [15].

*Mithral Ape:* This figurine appears initially to be a misshapen lump of silver
or finer metal, attached to a fine silver chain. When animated, the mithral ape
becomes an ape, but retains the silver sheen of mithral, with an Intelligence
and Wisdom of 16 each. The mithral ape also has two predefined areas of
knowledge and are treated as Sages in these fields, typically fields such as
Relics, Ritual Magic, Local Knowledge, the Planes, Ancient Battlefields,
Nobility and Politics and so on. Most are also expert chess players. While
designed to work as an advisor, the ape is a fair combatant as well. The
figurine can be animated up to once per week for up to eight hours at a time,
although it immediately returns to figurine form after any combat.

*Oaken Turtle:* This small wooden idol of a turtle is typically used to deter
pursuit. When animated, the oak turtle becomes a giant turtle with a mighty horn
on its armored beak. It has the same stats as a rhinoceros, but with half the
movement rate. In addition, when animated, a second command word changes the
turtle from its animated form to that of a huge magically hardened wooden wall.
This wall is treated as a wall of stone cast by a level 11 cleric. A third
command word returns the turtle to figurine form from either wall or turtle
form. Otherwise, the turtle can be used once per week for up to a total of eight
hours per use in either form.

*Obsidian Steed:* This figurine appears to be a small, shapeless lump of black
stone. Only careful inspection reveals that it vaguely resembles some form of
quadruped. On command, the near-formless piece of obsidian becomes a nightmare.
The steed allows the person activating the figure to ride it, but if the rider
is of lawful alignment, the steed is 10% likely per use to carry him to the
demon planes of chaos and then return to its statuette form. The statuette can
be used once per week for one continuous period of up to 24 hours. Note that
when an obsidian steed becomes ethereal or plane shifts, its rider and his gear
follow suit. Thus, the user can travel to other planes via this means.

*Onyx Wolf:* When commanded, this statuette changes into a creature with the
same properties as a wolf except that it is endowed with a INT of 8-10, can
communicate in common, and has exceptional olfactory and visual abilities. It
can follow a scent 100% of the time, -10% per hour since the creature tracked
has passed. Note that this ability may not be fooled in any way. It has 90’
infravision, can see invisible 65% of the time, hidden doors and other hidden
things 80% of the time, and phased, ethereal, or similar states 50% of the time.
An onyx wolf can be used once per week for up to 6 hours. It obeys only its
owner.

*Opal Panther:* This black figurine of a panther is specked through with green
and blue specks and glints with reflected light. When animated, the opal panther
becomes a black panther, as dark as night. The opal panther has the same
statistics as a leopard, but with an 85% ability to hide in shadows, 60’
infravision and the ability to see invisibility. An opal panther can be used
once per week for up to four hours.

*Pumice Sheep:* These odd and misshapen sculptures of white sheep animate into
perfectly normal, if somewhat large sheep, well suited to trimming the grass. A
pumice sheep has the same stats as a donkey, but the first target attacked by a
pumice sheep must also make a saving throw versus spells to avoid falling to
sleep as if affected by a sleep spell (regardless of the target’s hit dice). The
pumice sheep can be used once per day for up to an hour at a time.

*Serpentine Owl:* This figurine becomes either a normal-sized horned owl (AC 7
[12], HD 2 hp, movement 240’ (80’, 2 attacks 1d2/1d2 or a giant owl (as a small
roc) according to the command word used. The transformation can take place once
per day, with a maximum duration of 8 continuous hours. However, after three
transformations into giant owl form, the statuette loses all its magical
properties. The owl has 90’ infravision, can move silently (also while flying)
95%, and sees at night (above ground) twice as well as a human does in daylight.
Any time a creature attempts to move silently in proximity to the owl, the
probability can be no greater than 50% to the owl’s senses. The owl communicates
with its owner by telepathic means, informing him of all it sees and hears.

*Slate Gargoyle:* This dark and rough figurine animates to become a black,
winged gargoyle of human size. Unlike most gargoyles, the slate gargoyle is
lawful in alignment, and follows the orders of its owner to the best of its
ability. It also has the ability to see invisibility. The slate gargoyle is
typically used as a guardian and can be animated for up to 72 hours per month,
continuously or in any combination of periods totaling 72 hours.

*Sneaky Monkey:* This little brass figurine is about an inch tall. When
activated, it animates into a friendly and curious little monkey, still made of
brass (AC:4), but with an intelligence of 10 and the abilities to Find Traps,
Move Silently and Hide in Shadows as a level 9 thief. The monkey can speak in
common. It can be animated once per week for four hours and only obeys the
directives of its owner.

*Turquoise Minotaur:* This statuette of a minotaur is crafted of smooth blue
turquoise with horns of a white bone- like material. It can be animated once per
week by the owner, and takes on all the traits of a normal minotaur, albeit
brilliant blue in color. The turquoise minotaur can be ordered to fight, carry
goods, labor, or to guide the owner out of any maze or labyrinth. The turquoise
minotaur has the exceptional ability to always know how to get to the entrance
and exit of any maze or labyrinth that it is in, as long as such an entrance or
exit is within its power to reach. While animated, the turquoise minotaur also
provides its owner with immunity to the maze spell. The turquoise minotaur can
be animated once per week for up to four hours at a time.

**Flask of Curses:** This item looks like an ordinary beaker, bottle, container,
decanter, flask, or jug. It may contain a liquid, or it may emit smoke. When the
flask is first unstoppered, all within 30 feet are cursed as the spell (opposite
of remove curse). After it is used the flask becomes powerless.

**Gauntlets of Fireshield:** When both of these iron gauntlets are worn, they
grant a +1 bonus to the wearer’s AC as well as providing the wearer and all
carried items the benefits of protection from fire.

**Gauntlets of Lightning:** The wearer of these extremely fine silver gauntlets
gains a +2 on all saving throws against electricity and takes half damage from
all electrical damage sources. Once per day, the wearer can create a bolt of
lightning in his hand that can be hurled and is treated exactly as Lightning
Bolt spell cast by a 6th level caster.

**Girdle of the Nereids:** This belt grants the wearer the benefits of water
breathing. In addition, the girdle has 2d10 charges to cast Lower Water and/or
Part Water. Once these charges are exhausted, the girdle loses all magical
abilities and no longer provides the water breathing ability.

**Gloves of Demonhide:** Gloves made of the horned, knobby and often unpleasant
skins of demons (over the objections of the demons themselves) and then
enchanted provide benefits when fighting both the infernal and the celestial.
These gloves provide a +2 bonus to hit and to damage rolls when attacking
demons, devils and their kin, as well as angels, devas and other celestial
creatures.

**Helm of Underwater Action:** The wearer of this helmet can see underwater.
Drawing the small lenses in compartments on either side into position before the
wearer’s eyes activates the visual properties of the helm, allowing him to see
five times farther than water and light conditions would allow for normal human
vision. Weeds, obstructions, and the like block vision in the usual manner. If
the command word is spoken, the helm of underwater action creates a globe of air
around the wearer’s head and maintains it until the command word is spoken
again, enabling him to breathe freely.

**Horseshoes of a Zephyr:** These four iron shoes are affixed like normal
horseshoes. They allow a horse to travel without actually touching the ground.
The horse must still run above (always around 4 inches above) a roughly
horizontal surface. This means that nonsolid or unstable surfaces can be
crossed, and that movement is possible without leaving tracks on any sort of
ground. The horse moves at its normal rate. All four shoes must be worn by the
same animal for the magic to be effective.

**Hot Rock Powder:** A pinch of this red hot powder fills the user with an
uncontrollable rage for 2d4 rounds. He is granted a +2 bonus to hit and damage
in melee combat, and +2 on all saving throws. However, if all his foes are slain
in this time, he will attack allies indiscriminately until the duration expires.
A pouch of hot rock powder normally contains 1d4 doses.

**Incense of Meditation:** This small rectangular block of sweet smelling
incense is visually indistinguishable from nonmagical incense until lit. When it
is burning, the special fragrance and pearly-hued smoke of this special incense
are recognizable by any cleric greater than 4th level. When a cleric lights a
block of incense of meditation and then spends 8 hours praying and meditating
nearby, the incense enables him to cast spells with maximum duration or effect,
such as maximum healing potential. In addition, the probability of failing a
survival roll after being brought back from the dead is halved. Any spell
effects for which a target is allowed a saving throw makes the save with a -1
penalty. Each block of incense burns for 8 hours, and the effects persist for 24
hours. A total of 2d4 blocks of incense are found.

**Incense of Obsession:** These blocks of incense appear to be incense of
meditation. If meditation and prayer are conducted while incense of obsession is
burning nearby, its odor and smoke cause the user to become totally confident
that his spell ability is superior, due to the magic incense. The user is
determined to use his spells at every opportunity, even when not needed or when
useless. The user remains obsessed with his abilities and spells until all have
been used or cast, or until 24 hours have elapsed. A total of 2d4 blocks of
incense are found.

**Instant Fortress:** This metal cube is small, but when activated by speaking a
command word it grows to form a tower 20’ square and 30’ high, with arrow slits
on all sides and a crenellated battlement atop it. The metal walls extend 10’
into the ground, rooting it to the spot and preventing it from being tipped
over. The fortress has a small door that opens only at the command of the owner
of the fortress—even knock spells can’t open the door. The adamantine walls of
instant fortress have 200 hp. The fortress cannot be repaired except by a wish,
which restores 10 points of damage taken. The fortress springs up in just 1
round, with the door facing the device’s owner. The door opens and closes
instantly at his command. People and creatures nearby (except the owner) must be
careful not to be caught by the fortress’s sudden growth. Anyone so caught takes
10d10 points of damage.

**Ioun Stones:** These crystalline stones always float in the air and must be
within 3’ of their owner to be of any use. When a character first acquires a
stone, he must hold it and then release it, whereupon it takes up a circling
orbit 1d3 feet from his head.

Thereafter, a stone must be grasped or netted to separate it from its owner. The
owner may voluntarily seize and stow a stone (to keep it safe while sleeping,
for example), but he loses the benefits of the stone during that time. Ioun
stones have AC -4 [23] and 10 hp. A total of 1d10 stones will be found, to be
determined randomly. There is a 10% chance that any stone found is gray, burned
out, and worthless.

| **Color**                                                                                           | **Shape** | **Effect**                                    |
|-----------------------------------------------------------------------------------------------------|-----------|-----------------------------------------------|
| Clear                                                                                               | Spindle   | Sustains creature without food or water       |
| Dusty rose                                                                                          | Prism     | \-1 bonus to AC                               |
| Deep red                                                                                            | Sphere    | \+1 to DEX                                    |
| Pale blue                                                                                           | Rhomboid  | \+1 to STR                                    |
| Pink and green                                                                                      | Sphere    | \+1 to CHA                                    |
| Scarlet and blue                                                                                    | Sphere    | \+1 to MIND                                   |
| Vibrant purple                                                                                      | Prism     | Stores 1d6 spells, as a ring of spell storing |
| Iridescent                                                                                          | Spindle   | Sustains creature without air                 |
| Pale lavender                                                                                       | Ellipsoid | Absorbs spells of 4th level or lower\*        |
| Pearly white                                                                                        | Spindle   | Regenerate as the ring                        |
| Pale green                                                                                          | Prism     | \+1 character level                           |
| Lavender and green                                                                                  | Ellipsoid | Absorbs spells of 8th level or lower\*\*      |
| \*After absorbing 1d4x10 spell levels, the stone burns out and turns to dull gray, forever useless. |           |                                               |
| \*\*After absorbing 2d4x10 spell levels, the stone burns out and turns dull gray, forever useless.  |           |                                               |

**Key, Entry:** Once per day this key can unlock any (non-magically) locked
door. Any lights (torches, lanterns, etc) in the room, chamber or hall beyond
that door within 30 feet of the door become lit, and an unseen servant is
summoned to butler for the user of the key as long as he remains in that area
for up to one hour.

**Key, Locking:** This heavy iron key will cast Wizard lock on any door, chest,
or portal touched. It has 3d20 charges when found.

**Key, Smuggler’s:** Opens any locked box or coffer that the owner has had in
his or her possession for a day or more, but opens to an alternate storage
dimension instead of the actual contents of the chest. This area is treated as a
bag of holding in all respects. Once closed, the box can be reopened normally to
access the normal contents, or opened with the key to access the
extradimensional space. Each box so treated uses one charge. It has 3d6 charges
when found.

**Marrow Flute:** This flute is carved from a human tibia and is stained with
dried blood. It produces a shallow, haunting tune and summons 1d3+1 ghouls that
follow the user’s commands for 1 turn before disappearing. If the flute is blown
more than once in a week, any subsequent ghouls summoned will appear directly
around the user and will attack the user immediately.

**Marvelous Pigments:** These magic emulsions enable their possessor to create
actual, permanent objects simply by depicting their form in two dimensions. The
pigments are applied by a stick tipped with bristles, hair, or fur. The emulsion
flows from the application to form the desired object as the artist concentrates
on the desired image. One pot of marvelous pigments is sufficient to create a
1,000 cubic foot object by depicting it two-dimensionally over a 100 square foot
surface. Only normal, inanimate objects can be created. Creatures can’t be
created. However, doorways, rooms, pits, holes, and the like can be depicted to
create actual space. The pigments must be applied to a surface. It takes 1 turn
to depict an object with the pigments. Marvelous pigments cannot create magic
items. Objects of value depicted by the pigments—precious metals, gems, jewelry,
ivory, and so on—appear to be valuable but are really made of tin, lead, paste,
brass, bone, and other such inexpensive materials. The user can create normal
weapons, armor, and any other mundane item (including foodstuffs).

**Mask of the Monkey God:** These masks are made of wood or clay and are worn to
bring the wearer into the good graces of the monkey god. It can be invoked once
per day for 1 turn and provides the following effects at will: speak with
animals (monkeys only), charm monster (monkeys only), and the ability to climb
walls as a level 9 thief.

**Necklace of Adaptation:** This necklace is a heavy chain with a platinum
medallion. The magic of the necklace wraps the wearer in a shell of fresh air,
making him immune to all harmful vapors and gases. The bubble can enable the
wearer to survive in an environment without air for 1 week.

**Net of Entanglement:** This 10’ square magical net may be thrown at an
opponent 20’ away to entangle him. The rope is extremely tough, requiring the
equivalent of STR 20 to break free. The net turns away attempts to cut it, so it
must be chopped or hacked, with an effective AC of -9 [28]. Alternatively, the
net can be placed on the ground or hung in the air, and will drop or entangle
with a command word.

**Net of Snaring:** This net can only be used underwater, but functions
otherwise like a net of entrapment. It also springs at an opponent if the
command word is given, to a maximum distance of 30’.

**Obsidian Mirror:** This polished oval of obsidian weighs nearly 60 pounds.
Once per month it can be used to cast contact other plane with a command word
and with the chance of insanity reduced by half.

**Ointment of Healing:** This pungent ointment comes in small jars of 5 doses
each. When applied to a wound, it heals 1d4+8 hp damage. In addition, it
neutralizes poison and cures disease. A total of 1d4 jars are found.

**Pearl of Power:** This seemingly normal pearl of average size and luster is a
potent aid to magic-users. Once per day on command, a pearl of power enables the
possessor to recall any one spell that he had memorized and then cast. The spell
is then available to cast again, just as if it had not been cast earlier. The
spell must be of a particular level, depending on the pearl. Different pearls
exist for recalling one spell per day of each level from 1st through 9th and for
the recall of two spells per day (each of a different level, 6th or lower).
Determine the type or pearl randomly. Note that there is a 5% chance the pearl
is cursed to have the opposite effect of making the magic-user forget a spell
each day. These pearls may not be discarded unless a wish or exorcism is cast.

| D100  | Spell Level                                    |
|-------|------------------------------------------------|
| 01-25 | 1st                                            |
| 26-50 | 2nd                                            |
| 51-70 | 3rd                                            |
| 71-85 | 4th                                            |
| 86-93 | 5th                                            |
| 84-99 | 6th                                            |
| 00    | Roll 1d6 for spell level, can recall 2 spells. |

  
**Pearl of Wisdom:** This magical pearl will grant +1 to WIS to any cleric who
keeps it on his person for 4 weeks. After that time, the pearl must be carried
always else the bonus goes away. There is a 5% chance the pearl is cursed for
opposite effect; however, at the end of 4 weeks the pearl becomes powerless,
therefore making the deduction permanent by anything short of a wish.

**Periapt of Foul Rotting:** This engraved gem appears to be of little value. If
any character keeps the periapt in his possession for more than 1 day, he
contracts a terrible rotting affliction that permanently drains 1 point of DEX,
CON, and CHA every week. The periapt (and the affliction) can be removed only by
application of a remove curse spell followed by a cure disease and then a heal,
limited wish, or wish spell. The rotting can also be countered by crushing a
periapt of health and sprinkling its dust upon the afflicted character,
whereupon the periapt of foul rotting likewise crumbles to dust.

**Periapt of Health:** This gem looks much like the periapt of foul rotting, but
grants immunity to all disease, including supernatural diseases.

**Periapt of Proof against Poison:** This item is a brilliant-cut black gem on a
delicate silver chain. The wearer is 30% immune to poison, taken into account
before -- or if -- a saving throw is allowed from exposure to poison.

**Periapt of Wound Closure:** This stone is bright red and dangles on a gold
chain. The periapt doubles the wearer’s normal rate of healing or allows normal
healing of wounds that would not do so normally. Hit point damage that involves
bleeding is negated for the wearer of the periapt.

**Phylactery of Faithfulness:** This item is a small box containing religious
scripture affixed to a leather cord. There is no mundane way to determine what
function this religious item performs until it is worn. The wearer of a
phylactery of faithfulness is aware of any action or item that could adversely
affect his alignment and his standing with his deity, including magical effects.
He acquires this information prior to performing such an action or becoming
associated with such an item if he takes a moment to contemplate the act.

**Phylactery of Undead Turning:** This item allows a cleric to turn undead as if
his class level were two levels higher than it actually is.

**Phylactery of Youth:** This small metal tube is attached to a cord and worn
around the neck. While the item is worn, the character ages at only 75% the
normal rate, even when considering magical aging effects.

**Priest’s Tabard:** This tabard is worn by a cleric over his armor. It improves
healing magic, increasing the healing by 1 point from any cure wounds spell. It
also grants the cleric a +1 bonus to AC, and when dealing with clerics of the
same alignment, it provides a +2 bonus to Charisma.

**Robe of the Archmagi:** This normal-appearing garment can be yellow (01–45 on
d00, lawful alignment), gray (46–75, neutral alignment), or black (76–00,
chaotic alignment). It may only be worn by a magic-user or illusionist. Its
wearer gains the following powers:

-   It grants a base AC of 5 [14].

-   It grants +2 to saves versus spells or spell-like devices.

-   It grants +1 to all other saving throws.

-   Creatures save at -2 against any charm, hold, polymorph, suggestion, or
    similar spells directed from the wearer.

If a yellow robe is donned by a chaotic character, he immediately suffers 5d10
damage and loses 1d4x10,000 XP. The reverse is true with respect to a black robe
donned by a lawful character. An evil or good character who puts on a gray robe,
or a neutral character who dons either a yellow or black robe, suffers 5d4
damage and loses 3d6x10,000 XP. In addition, in these latter cases the
character’s alignment shifts to match the robe’s.

**Robe of Scintillating Colors:** The wearer of this robe can cause the garment
to display a shifting pattern of incredible hues, color after color cascading
from the upper part of the robe to the hem in sparkling rainbows of dazzling
light. The colors daze those near the wearer, conceal the wearer, and illuminate
the surroundings. It takes 1 full round after the wearer speaks the command word
for the colors to start flowing on the robe. The colors are effective to a 40’
range. Those who look at the wearer stand mesmerized for 1d4+1 rounds (saving
throw versus spells negates, then after the allotted time a new save must be
made each round in order to attack). Every round of continuous scintillation of
the robe gives the wearer better concealment. Attacks against the wearer start
at -1 and increases by -1 each round until it reaches -5. The robe illuminates a
40’ radius continuously. Two rounds after the robe is activated, the wearer may
cast spells, attack, and otherwise act so long as he does not move further than
10’ from his original spot.

**Robe of Sorcery**: Robes of Sorcery come in a variety of colors, but the
lining is either white (1-3 in 6, of lawful alignment) or black (4-6 in 6, of
chaotic alignment). If worn by a magic-user of the appropriate alignment, the
robe grants the following:

-   \+2 bonus to AC

-   \+4 on saves versus spells

-   All saves against the wearer's spells are at -1

-   White robes: hold person 1/day

-   Black robes: mirror image 1/day

**Robe of Useful Items:** This appears to be an unremarkable robe, but a
character who dons it notes that it is adorned with small cloth patches of
various shapes. Only the wearer of the robe can see these patches, recognize
them for what items they become, and detach them. One patch can be detached each
round.

Detaching a patch causes it to become an actual item, as indicated below. A
newly created *robe of useful items* always has two each of the following
patches:

-   Dagger

-   Lantern (filled and lit)

-   Mirror (a highly polished 2’ x 4’ steel mirror)

-   Pole (10’ length)

-   Hempen rope (50’ coil)

-   Sack, large

In addition, the robe has several other patches. Roll 4d4 for the number of
other patches and then roll for each patch on the table below to determine its
nature. Multiple items of the same kind are permissible. Once removed, a patch
cannot be replaced.

| d00   | Result                                                                                                             |
|-------|--------------------------------------------------------------------------------------------------------------------|
| 01–08 | Bag of 100 gold pieces                                                                                             |
| 09–15 | Coffer, silver (6” x 6” x 1’), 500 gp value                                                                        |
| 16–22 | Door, iron (up to 10’ wide and 10’ high and barred on one side—must be placed upright, attaches and hinges itself) |
| 23–30 | Gems, 10 (100 gp value each)                                                                                       |
| 31–44 | Ladder, wooden (24’ long)                                                                                          |
| 45–51 | Mule (with saddle bags)                                                                                            |
| 52–59 | Pit, open (10 cubic feet)                                                                                          |
| 60–68 | *Potion of extra healing*                                                                                          |
| 69–75 | Rowboat (12’ long)                                                                                                 |
| 76–83 | Scroll of one randomly determined spell                                                                            |
| 84–90 | War dogs, pair                                                                                                     |
| 91–96 | Window (2’ x 4’, up to 2’ deep)                                                                                    |
| 97–00 | Roll for one extra patch                                                                                           |

  
**Slippers of Spider Climbing:** When worn, a pair of these slippers enables
movement on vertical surfaces or even upside down along ceilings, leaving the
wearer’s hands free. Movement is 60’ (20’). Severely slippery surfaces—icy,
oiled, or greased surfaces—make these slippers useless. The slippers can be used
for 5 turns per day, split up as the wearer chooses.

**Spell-Eating Crystal:** These volatile crystals are usually found crafted into
amulets, crows and diadems. They come in several sizes from a half-inch across
to 4 inches in diameter. Any spell cast within 30 feet of the crystal is
consumed by the item, preventing the spell from having any effect. Each crystal
has a rating, generally linked to its size (rated from 1 to 12), indicating how
many spell levels of spells it can consume per day. If the total number of spell
levels consumed in a day exceeds the rating of the crystal, it explodes in a
fireball-like effect of pure magical force dealing 2d6 damage +1d6 per rating of
the crystal (so a rating 6 crystal will explode in an 8d6 damage explosion).

**Two-Way Pouch:** These two normal-sized pouches share the same contents.
Anything placed into one pouch can be removed from either one. Items must fit
entirely within the pouch.

**Ward Crystal:** There are a variety of types of ward crystals - ruby (fire),
emerald (acid), diamond (lightning) and sapphire (cold). Each has 2d20 charges
when found. Ward crystals can only be used by magic-users. Activating the ward
crystal takes one minute and involves drawing a complex magical sigil, either on
a surface or in mid-air. The sigil disappears when it is completed, and remains
there, invisible, for 7 days. When the sigil is drawn, the wielder determines
the conditions that will trigger it (such as someone approaching within a
specified distance, or a command word being spoken, the surface the sigil is on
being touched, broken or opened, etc). When the sigil is triggered, it explodes
doing 6D6 damage of the appropriate type (explosion area is the same as a 6d6
fireball).

**Well of Many Worlds:** This strange, interdimensional device looks just like a
portable hole. Anything placed within it is immediately cast to another world—a
parallel world, another planet, or a different plane (chosen randomly). If the
well is moved, the random factor again comes into play. It can be picked up,
folded, or rolled, just as a portable hole can be. Objects from the world the
well touches can come through the opening just as easily as from the initiating
place.

**Whistle of the Grim Wolf:** This whistle is carved out of ash and looks like a
howling dog. It produces a mournful howl when blown, and summons 1d3+1 dire
wolves that follow the user’s commands for 1 turn before disappearing. It can be
blown once per week. If the user drenches the whistle in the fresh hot blood of
a wolf or dire wolf it can be triggered a second time in a week, but this
destroys the whistle.

<br><br>Section V:<br>Environmental and Terrain Hazards
=======================================================

#### Air, Still

Still air is an unusual natural event in which a bizarre magical phenomenon
releases air from the Elemental Plane of Air into a small area of a Material
Plane world. Within the affected area – which may be any size from an area not
more than five feet in diameter to a vast region covering hundreds of miles –
the air is perfectly still. Animals in the affected area, unnerved by these
strange conditions, become frightened and refuse to remain in the area until the
phenomenon ends.

A pocket of still air typically lasts for 3d6 hours though ancient reports seem
to indicate that the conjunction of elemental and material planes sometimes
lasts for years at a time. One bardic tale tells of a small farming community
that was completely abandoned when a pocket of still air persisted in the region
for over a decade. According to the tale the community still stands, run down
and abandoned, the haunt of monsters and bandits. There is no known power strong
enough to dispel a pocket of still air.

#### Air, Necromantic

The most foul and dreaded of necromancers, with their blasphemous knowledge, can
fill the very air around them with dark, almost tangible evil power when a great
number of spirits are forced into undeath as the necromancer’s slaves. An evil
cleric (7th-level or higher, and with the proper training or possession of
certain evil librams) may – by willingly suffering the temporary loss of a point
of Constitution (duration 1d6 days) when casting *animate dead* – fill the air
with this unspeakably vile necromantic power. The necromantic air fills a sphere
with a radius equal to twice the cleric’s level in feet, and lasts for a number
of days equal to half the cleric’s wisdom score. The air remains affected by
this unholy talent for a number of days equal to one-half the caster’s Wisdom
(round down).

Good-aligned characters and creatures that enter an area of necromantic air
automatically suffer d6 points of damage every round that they remain in the
affected area – no save allowed. Undead creatures that enter the affected area
gain a + bonus to all attack and damage rolls for a number of rounds equal to
the necromancer’s level.

A paladin or cleric who enters the area and successfully turns undead (as a
vampire) can dispel the effect.

#### Bridgeweed

This thick, vine-like plant grows in subterranean caverns and deep, damp caves.
While bridgeweed grows anywhere underground, it earns its name because it is
most frequently encountered growing across chasms and deep pits where it looks
more like a bridge than a plant. A typical patch of bridgeweed is rooted into a
roughly circular area 10 feet in diameter on either side of a deep chasm, the
two root-growths connected by a length of ropy strands 5-feet wide.

Bridgeweed is brownish-green in color and completely harmless – until someone
attempts to cross the naturally-growing bridge. The plant is strong enough to
support up to two characters at once but the instant that anyone reaches the
exact center of the “bridge” the plant reacts violently to the intrusion. As a
self-defense, the individual vines separate so that the “bridge” no longer
exists, becoming a mass of flailing vines. A saving throw against breath weapons
is required as soon as the plant begins to separate in order for a victim of the
hazard to grab one of the vines. On a failed save the victim is taken by
surprise and falls from the “bridge.”

The plant will reform 3d6+ minutes after it separates. Characters (such as
druids) that correctly identify a bridgeweed will know that as long as they do
not touch the exact center of the “bridge” it will not separate. If characters
are to jump across the center, the Referee may apply whatever rules to determine
the success of the jump that he feels apply to the situation. In general, the
attempt is not difficult, and either a 1 in 6 chance of failure or a d0 roll
under dexterity would be appropriate determinations.

#### Cave Ducks

Cave ducks are adapted to underground life, often kept as domestic poultry by
enterprising dwellers of the subterranean realms. How else might dwarves eat
roast duck with their ale? Cave duck eyes glitter from their enhanced
darkvision, but these are basically normal ducks. Ducks are not, of course, a
hazard. However, convincing a party of adventurers that the glittery-eyed
ducklings swimming happily in the pool ahead aren’t dangerous? Not likely.
Obviously, the whole situation must be an elaborate plot by the Referee! Torches
will burn low, and wandering monster checks will accumulate as the party makes
plans to deal with the obvious peril. Time itself is a hazard in the dungeon
environment, and a pool of ducklings may occupy considerable time and possibly
even precious resources. A party that fireballs a pond of ducklings will never
live it down.

#### Chasm

Chasms are normal dungeon fare, of course, but it’s always worthwhile to take an
old favorite and spice it up with some sort of additional or unexpected risk to
challenge the players. Consider a few ways of spicing up one of these deep holes
in the ground. The edge of the chasm might be slippery (from running water,
perhaps, by growths of slippery algae, by means of magic, or even from bear fat
spread by humanoids). The chasm’s location might be displaced, seeming to be in
one location when it is actually a few feet closer. The illusory chasm is, of
course, always good for player-nervousness, and so is the chasm with a magical
bridge of force that seems to be blinking in and out of existence. Perhaps the
chasm vents a constant waft of poisonous gas, or some unusual type of fog (many
fogs are listed below); and these might only be thick enough to be dangerous in
the middle of the chasm. A chasm with crumbling edges, where the players have to
decide how close their characters should approach, can cause interesting
situations, and so can chasms that generate abnormal temperatures.

#### Collapsing Chamber

Either through natural causes (such as an earthquake) or artificial causes (such
as a room rigged to collapse), adventurers sometimes find themselves forced to
move through or flee a cavern chamber or dungeon room as it is collapsing around
them.

There are, of course, a myriad of different ways for the Referee to handle such
risks, but one method is outlined below:

A collapsing room will rain down rock and debris for a period of time equal to
about one segment per square foot before it collapses, killing anyone within.

When moving through a collapsing chamber, the character has a 1 in 6 chance of
being struck by falling stones or masonry (the Referee might alternatively allow
a dexterity check rather than a flat 1 in 6 chance). Falling masonry inflicts
1d6 points of damage and has a 5% chance to knock down and pin the unlucky
character. Escaping from beneath a piece of fallen rubble without assistance is
as difficult as bending bars or lifting gates. Fortunately, an unpinned
character may shift the heavy stone simply by rolling under his strength on a
d0.

*Example: A 10-ft. by 10-ft. room, if collapsing, will continue to be treated as
a collapsing chamber obstacle for 100 segments (10 rounds).*

It is the game referee’s call as to whether or not the chamber has collapsed
completely and is now no longer in existence or whether a treacherous pathway
still remains through the collapsed interior. A truly terrifying encounter could
end with the collapse of a dungeon, leaving the characters running toward the
surface as the entire complex comes down around them. Any stairs they encounter
on the way out could be treated as crumbling stairs.

#### Crumbling Stairs

In the older dungeons, and in natural caverns, stairs are not always properly
maintained and over time they begin to show signs of age, cracking and shifting
under the weight of anyone using them.

The Referee may rule that any character moving up or down a flight of crumbling
stairs must make a Dexterity check each turn to successfully negotiate the
hazardous ascent or descent – on a failed check the character has lost his
balance and falls, tumbling down the stairs until he either encounters another
figure (see below) or hits the bottom. The character suffers normal falling
damage.

If a character tumbling down a flight of crumbling stairs encounters another
figure he stops moving, but the next character must, in turn, make a dexterity
check to avoid stumbling and falling like the next domino in the line.

Obviously, the condition of a staircase can vary greatly, and a truly
deteriorated stair might be more akin to a climb than a walk. In this case, the
Referee might assign a flat 25-50% chance of falling.

Regardless of the method used, if the members of the party are roped together
the chance of actually falling would not be reduced. However, the characters
above might have a chance to hold the falling character in place. Add the
strength scores of the characters above, and treat this as the percentage chance
for them to prevent a fall.

#### Crystal, Harmonic

These beautiful but fragile crystals are often found near underground sources of
magic; they are especially prevalent near the lands of the dark elves.

Harmonic crystals are very sensitive to noise and any loud noises (yelling,
battle, even elevated talking or running) produce enough sonic energy to cause
the crystals to shatter. The referee can decide whether or not the sounds in the
area are loud enough to cause the crystals to shatter.

A small patch of harmonic crystals that shatters deals 1d6 points of damage as
needle-like shards puncture everything within a 10-foot radius. Larger patches
act as though they were made up of numerous small patches.

#### Dangerously Hot Floors

In the deepest levels of dungeons and caverns there sometimes exist vast pools
of boiling, superheated lava. These lava pools, while dangerous in their own
right, also heat the levels directly above, sometimes pushing stone floors to a
point at which they are red hot and dangerous to touch.

This terrain hazard affects any characters that walk over the glowing hot
floors. Characters passing over a floor affected by extreme heat below them
suffer 1d points of damage per ten feet traversed, and falling onto the heated
stone inflicts 2d4 points of damage.

#### Destroyed Floor

If a chamber collapses (see above), we can only deduce that somewhere above, a
floor is affected. The adventurers might, indeed, precipitate a floor’s collapse
if they are not careful. More likely, they may encounter an area where the floor
has already collapsed, posing a potentially dangerous obstacle.

As the floor collapses, falling away beneath the adventurers’ feet, a character
must make a Dexterity check each round or be swept up in the collapse of the
floor, falling to whatever room or chamber lies below. A falling character will
take 1d6 points of damage from rocks per ten feet fallen, in addition to falling
damage. Additionally, there is a 10% chance that the character will be buried
and a 5% chance that the character will be pinned beneath a large piece of
rubble. A buried character cannot escape without assistance, and it will take d
rounds to dig him out (a perilous undertaking when the ceiling is in the process
of collapsing). As in the case of a collapsing chamber (see above) a pinned
character can escape by making a successful roll equivalent to bending bars or
lifting gates, and may be freed by another character who successfully rolls
under his strength on a d0.

A stone floor takes as many segments to collapse as the floor has square feet
(e.g., a 10ft by 10ft room takes 100 segments, or 10 rounds, to fully break
away). During this time, treat the area beneath the floor, where fallen
characters and their rescuers may end up, as a collapsing chamber (see above).

After the destruction has ended, the room’s floor either no longer exists (in
which case it is an obstacle and not a hazard) or it is nothing more than a few
randomly-placed flagstones held together by a weak, soon-to-collapse framework
of badly damaged supports (usually timbers). Moving through a room with a
destroyed floor requires a Dexterity check each turn; on a failed check the
character slips and falls to the level below, taking whatever falling damage is
applicable.

Truly cruel referees will take note of the fact that more than one level might
be involved in a major architectural failure (or trap). In this case, the
hapless characters may be trapped under a collapsing ceiling that is also
smashing away the floor beneath them. Unspeakable cruel referees might use this
scenario in connection with a portcullis trap closing off the exits.

#### Dry Haze

This thick, heavy cloud of sand drifts slowly across the lands of the desert
during the early mornings, a typical cloud rarely extending more than six feet
above the ground. Characters caught within a patch of dry haze – a typical patch
appears as a cloud 0ft in diameter – run the risk of suffocation:

each character must make a successful Constitution check each round; on a failed
check the character suffers 1d8 points of damage.

A patch of dry haze can be dissipated harmlessly with *gust of wind* or a
similar spell.

#### Falling Trees

Some storms, lightning strikes, and dangerous floods can topple trees, leaving
behind a mass of shattered branches and thick, twisted roots. During a storm or
flood there is a 1% chance that a tree near the players’ characters will be
uprooted, sending the tree crashing to the ground in a random direction. Any
characters or creatures in the path of the falling tree must make a Dexterity
check to avoid being crushed – on a failed check the unfortunate victim suffers
5d6 points of damage +1d6 for each ten feet of the fallen tree’s height. The
fallen tree will also pin the hapless victim to the ground, but a successful
strength check allows the character to force his way out in 1d rounds.

#### Floodfalls

Some dungeon and cavern complexes descend so deep beneath the surface world that
their excavation stops alongside massive, subterranean pools of water. In most
instances this is little more than a nuisance to the powerful wizards and horrid
monsters that carve out dungeons, and most adventurers never need give these
nearby underground reservoirs of water a second thought. Unfortunately, there
are some instances in which, completely through the wonder and power of nature,
these pools find entrance into an otherwise dry dungeon. A leak of this kind may
be exploited for food by one common denizen of the subterranean world, the green
slime, giving rise to a truly bizarre and dangerous symbiosis known as a
floodfall. The players may never have a chance to figure out how it worked.

A quick explanation of the formation of a floodfall follows, for those Referees
who enjoy dungeon ecology. When a reservoir begins to seep through dungeon
walls, it creates a nutrient-rich source of water, attractive to slimes (usually
green slimes). The slime will likely remain motionless over the water source
even as the fissures widen and the water pressure begins to build. Over a period
of years the slime ceases to attempt to drop down on passing by creatures and
remains more and more deeply embedded in the growing cracks in the wall, content
to feed on the gifts that continue to wash up against it.

#### Arcane Floodfalls

While it is true that most floodfalls are created when green slime prevents an
underground pool of water from escaping through a crack it is also not at all
unusual for other types of slimes to act in similar fashion, including arcane
slimes (see p. 6) and spell slimes (see p. 9).

An arcane floodfall behaves exactly like a normal floodfall except that any
spellcasters caught in the rush of water must make a successful roll on a d0
against his Wisdom score each round or lose 1 point of Intelligence. Any magic
items that come into contact with the water are drained of all magical ability
for d6+6 rounds.

After a decade the slime comes to resemble a thick, gel-like substance – almost
like a gelatinous cube – more than it does any form of slime; additionally, the
slime is no longer treated as green slime. During this time the breach in the
wall has continued to grow but the slime has continued to expand, completely
sealing the crack and preventing the waters from rushing into the dungeon.

After many, many years the pressure may become greater than the slime can easily
contain, and if nearby adventurers put the slime-dam under stress the crack rips
apart, throwing rock, gel, and water outward into the dungeon and causing a
sudden, violent flood. Any characters adjacent to the breach when the flood
suddenly gives way must roll a d0 under their strength score each round or be
thrown to the ground. The water rushes in for 6d6 rounds – dealing 1d6 points of
damage each round to anyone on the ground in the affected area. If the water has
no outlet, it will rapidly fill the chamber. During this time the current is
powerful, reducing movement speed against the current and increasing movement
speed when moving with the current.

After 6d6 rounds the slime still remaining on the wall and ceiling may manage to
seal the breach, halting the rush of water. There is, however, a 5% chance that
the slime will be washed away and unable to seal the crack. If this happens the
water will continue to rush in, flooding the chamber until its depth equalizes
across the complex.

A floodfall can be made to break by the actions of the party, by a monster, or
even by a trap set to collapse it. A successful missile attack against the
sealed crack (AC 5 [14]) that inflicts 10 or more points of damage will tear
through the slime, releasing the avalanche of water, stone, and gel.

#### Mistaking a Floodfall for Green Slime

A green slime that has been changed over the years into a floodfall still
resembles a normal green slime in appearance, but experienced players may notice
the differences. A floodfall is a much lighter green in color than a normal
green slime, and it usually seems to have a great, bulbous swelling in its
center (actually the bulge caused by water pressure).

If the floodfall is mistaken for green slime there is a very good chance that a
party of adventurers will attempt to destroy it with fire. Any fire damage
inflicted on a floodfall will automatically cause it to break, releasing the
water behind it (as described above).

#### Fog, Abyssal

Abyssal Fog is a nasty trick to play on a party that blithely destroys an evil
altar or tries to sanctify a place imbued with the attentions of a powerful
demon, demigod, etc. Such places are not lightly tampered with, and an encounter
with Abyssal Fog can issue a stark reminder to the players that powerful forces
lurk just beyond the thin fabric of the material plane. In fact, the party’s
interaction with the Abyssal Fog may be only the beginning of a new set of
problems and opportunities (if it doesn’t kill them first).

Sometimes created when an evil altar is destroyed, when places of evil are
assaulted by zealous adventurers, or even occasionally when a demigod’s favored
demon or devil is slain, retribution or mindless wrath may result in the
creation of Abyssal Fog. This dark red, dangerous fog is similar to crimson fog
(see p. 16) but far, far more deadly.

When an encounter calls for Abyssal Fog, there is generally a lull of d6 rounds,
during which a preternatural rumbling may be heard. Experienced adventurers,
will, of course, flee immediately. The abyssal fog manifests with a tremendous
explosion, inflicting a number of points of damage appropriate to the nature of
the item or demon destroyed; 6d6 is an appropriate range of damage. The radius
of the explosion is up to the Referee, but for most evil items and places the
radius would be approximately 30 feet. A successful saving throw against spells
reduces the damage by one-half. Instantly following the explosion, a dark red
fog billows forth from the area of the demigod’s wrath, expanding outward at a
rate of 10 feet each round until it reaches a maximum size of 0-90 feet in
radius (d6+3 x 10).

The abyssal fog is devilishly hot – any characters that enter the fog or any
adjacent area suffer d6 points of damage each round. Unfortunately, the intense
heat is not the only danger of an abyssal fog.

Once each day following the formation of an abyssal fog, unless the fog is
destroyed (see below) there is a 15% chance that a gate will open, connecting to
the appropriate plane or demiplane of existence. Once this gate forms, it will
remain for a period of ten years and a day.

An abyssal fog cannot be dispersed through normal means (the fog is too heavy to
be affected by winds, magical or natural) and can only be destroyed by a paladin
or good-aligned cleric who spends four hours in prayer and supplication while
kneeling within the fog. If anything disrupts this prayer the entire process
must be repeated. Obviously, anyone planning to spend four hours within Abyssal
Fog must be magically protected against heat, but the well-intentioned would-be
hero will discover another challenge within the fog, one not so apparent as the
explosion and the heat. Any prayers to a good aligned deity spoken within the
fog require a saving throw every hour against spells; failure instantly kills
the one who had the temerity to oppose the evil power’s will. There are, of
course, items and protections that will be effective against the fog’s
death-effect, and the intelligent party will seek these out before meddling in
matters of such supernatural power.

#### Fog, Acidic

Acidic fog is normally found as a component of a magical trap, though it can be
naturally occurring, found attached to a green dragon or other acid resistant
creature.

When acidic fog is released, it streams out like poisonous gas, and most
adventurers will treat it as such. However, this magical fog does not remain in
place. It follows whatever living creature it first detects within 100ft, moving
slowly but inexorably toward that target until it catches up. The fog’s movement
rate is only 0ft per round, but its ability to follow its target is flawless. A
rapid escape might lead to the fog’s appearance in a tavern weeks later. The fog
inflicts 2d6 points of damage per round when it finally makes contact (no saving
throw applies), but it will be neutralized once its acid has eaten away 30 hit
points. Green dragons and other creatures immune to acid may carry these fogs
around with them, for the fog never gives up but never does any damage that
would neutralize it. Once the acid resistant creature is killed, of course, the
fog will look for another target; likely one of the characters that just killed
the acid-resistance creature. Acidic fogs are also occasionally found in potion
bottles, which would normally inflict a nasty surprise; but as long as the
potion remains stoppered it could also be used as a deadly missile weapon – if
the party somehow figures out what’s inside.

#### Fog, Crimson

This bright red fog, found in environments heavily covered by scarlet mold (see
below), is a thick, noxious gas that inflicts those breathing it with a mild
form of the same disease spread by scarlet mold. Crimson fog is simply the red
smoke issuing from a patch of scarlet mold as it burns. Breathing the burning
mold can cause a disease known as the Plague of the Red Ancients, well-known to
sages and historians, but rarely encountered except by adventurers who delve
deep beneath the surface in their search for treasure and fame. At some point in
forgotten history, burial tombs were often trapped with complex arrangements of
tubes and fire pits designed to blow Crimson Fog into trap rooms. The
civilization that created these burial chambers is now remembered only for these
unusual tomb-traps and the plague they inflict, and is called by sages the
civilization of the “Red Ancients.”

Crimson fog normally issues forth in a cloud, or a jet of smoke if it is
projected by a tube or vent apparatus. Any character breathing the smoke must
immediately make a saving throw vs. poison (with a bonus of + to the roll). If
the saving throw fails, the character will become infected with the Plague of
the Red Ancients (see box). A patch of crimson fog can be dissipated harmlessly
with *gust of wind* or a similar spell.

#### Plague of the Red Ancients

The Plague of the Red Ancients is a disease propagated by a plant known as
scarlet mold. It is highly contagious, spreading through inhalation, contact, or
by introduction into the bloodstream by an envenomed weapon. Any person who
comes into contact with the disease must make a saving throw versus poison or
become infected. After failing the saving throw, the victim begins to turn into
a viscous red puddle of highly infectious slime. Each hour, the victim must make
a saving throw vs. poison or lose 1d points of constitution. If constitution is
reduced to 0, the victim has finally died a horrible death and cannot be raised
from the dead (being, at that point, a virulent and contagious puddle). If the
Plague of the Red Ancients is cured by magical means, the lost points of
constitution will return at a rate of one per day.

#### Fog, Draconic

Draconic fog is a highly flammable mist occurring naturally in some underground
locations. It smells very much like beer, which may provide parties with some
warning of its presence.

The most dangerous attribute of Draconic fog is its attraction to flame. Some
sages have theorized that the fog is formed by an imbalance of the elements, and
that its natural tendency is to remedy the imbalance, just as water always seeks
its lowest level. The precise explanation is of little comfort, unfortunately,
to adventurers fleeing pell-mell through the corridors of a dangerous
underground complex in flight from a cloud of Draconic Fog.

Whenever a flame comes within 100ft of the leading edge of a draconic fog, the
entire mass of the cloud begins moving toward the flame at a movement rate of
90ft. If the fog makes contact with the fire, it will flare in a brilliant
explosion causing 4d10 points of damage (save vs breath weapon for half damage)
to anyone in a 60ft radius of the point where the mist made contact with the
open flame. Draconic Mist can be dispersed with a *gust of wind* spell.

#### Fog, Dragon’s Breath

Hot gases are a familiar hazard for veteran adventurers, often found naturally
occurring where cracks in the earth reach down into the depths where water is
heated to steam by the earth’s heat. Dragon’s Breath Fog is an entirely
different variety of superheated gas, formed by magical, rather than natural
forces. In some cases, Dragon’s Breath Fog may result from connections between
the elemental planes of fire and water. In some cases, as described below, it
may form in consequence of a dragon’s decomposition. Whatever the cause of the
phenomenon, what makes it dangerous is the fact that it shows no physical signs
of its intense heat. The air around it does not waver with heat, and the fog
itself gives off no heat until it touches a living substance. When a living
being enters the fog, however, the sudden heat generated will cause d6 points of
damage, and there is a small chance for items to ignite (+5 on item saving
throws against magical fire).

A patch of dragon’s breath may appear over a location in which an evil dragon
has been buried. The dragon’s slowly-decomposing body expands with the gas that
eventually bursts forth from the surface – a single dead dragon produces the
cloud constantly, for a number of days equal to the number of hit points the
dragon possessed before it was slain. After this time has passed, the corpse no
longer produces the deadly cloud of Dragons Breath fog.

A patch of dragon’s breath can be temporarily dissipated with a *gust of wind*
or similar spell, but the cloud will reform within 1 turn.

In the case of Dragons Breath fog caused by a dragon’s decomposition, the only
way to completely stop the generation of the gas would be to unearth the dragon
corpse festering beneath the ground. If the fog is generated by some other
magical means, the Referee will have to determine how (and whether) the source
can be destroyed at all.

#### Fog, Efreet’s

Existing where a rift has opened (deliberately or not) to the elemental plane of
fire, efreet’s fog is a dark gray cloud of superheated steam that randomly
unleashes blasts of fire. Normal *gate* spells, of course, are protected from
the emergence of efreet’s fog, but an improperly prepared or miscast spell might
inadvertently result in this sort of magical disaster. The size of the planar
gate or natural rift determines the size of the fog, though the largest patch
ever encountered covered a 50-foot square area. A character or creature standing
inside a patch of efreet’s fog at any time suffers 1d4 points of fire damage
each round.

Each round that a character or creature is within 10feet of a patch of efreet’s
fog there is a 0% chance that the fog will erupt, spreading great bursts of
flame. Anyone within 10-feet of – or directly in a patch of – the efreet’s fog
when this occurs suffers 8d6 points of fire damage; a saving throw vs. breath
weapons reduces the damage to half.

#### Fog, Frigid

This white, thick fog is made of the very essence of cold. It appears like a
slowly churning blizzard of frost and snow and is usually found only on
cold-based planes and demiplanes. Occasionally, however, frigid fog can be found
in very cold places on the Material Plane. In such cases its presence is
invariably the result of a gate or fissure connecting the Material Plane to a
cold-based plane or demiplane from which the fog spreads.

The area covered by frigid fog is usually in direct correlation to the size of
the gate or fissure. A small fissure will only allow a small amount of the fog
to circulate (1d+1 x 10 feet) while a full gate may allow the fog to simply pour
forth (1d+1 x 100 feet or more); according to legend entire lands and continents
have fallen under a blanket of frigid fog. Frigid fog is extremely cold (below
–0° F) and deals 1 point of temporary Constitution loss per round (no saving
throw) to unprotected characters. Heavy winter clothing allows a saving throw
each round. Regardless of how much clothing a character wears, the non-material
plane nature of the fog’s extreme cold takes its toll on all living creatures,
acting as a *slow* spell (no saving throw) to any creature that is not immune to
the effects of magical cold.

The fog obscures all sight, including darkvision, beyond 5 feet.

Frigid fog is heavier than air: a severe wind (31+ mph) will disperse small
amounts of the fog in rounds; a windstorm (51+ mph) will disperse large volumes
in 1 round.

#### Fog, Magnetic

Magnetic fog, sometimes also called “lode-mist,” is a thin, silvery-colored mist
found in underground mines and caverns that contain (or once contained) rich
deposits of copper, iron, mithril, or silver. The fog is an irritation to miners
and a positive hazard to adventurers, for it is highly magnetic and interferes
with the use of metal tools and weapons.

A typical deposit of magnetic fog fills an area roughly 0x0x0ft. Characters
attempting to use metallic tools or weapons within a cloud of magnetic fog
suffer a –6 penalty on all attack rolls. Damage rolls are not affected by the
fog. Any characters wearing metallic armor suffer a 50% reduction to their
movement rates while within the fog. The area outside the fog, to a distance of
five feet from the edge, is also magnetically charged, but not as powerfully as
within the cloud itself; attack rolls in this area are subjected to a – penalty
and movement is reduced by 5%. Any metal-wielding character within five feet of
the cloud runs the risk of being pulled into the cloud by the magnetic
attraction the cloud exerts upon the metal. The player must roll a d0 if the
character is wearing metal armor, an additional 1d if the character is carrying
a metal shield, plus a second 1d if the character wields a metal weapon. The
result of these dice are totaled, and if the result is higher than the
character’s strength the character is pulled from his feet and slides into the
middle of the fog.

*Gust of wind* or a similar spell will dissipate a magnetic fog, but the
affected patch will reform within d rounds at the end of the spell’s duration.
Magnetic fog tends to be a permanent feature in the places where it appears; it
cannot be permanently destroyed.

#### Fog, Necromantic

This dark gray fog is found in some ancient cemeteries and burial chambers, a
foul and blasphemous phenomenon greatly feared by tomb robbers. The fog drifts
among the graves and sarcophagi, sometimes curling around the bodies of the dead
but always seeping back upward to prowl mindlessly within its charnel-house
domain. The origins of this vile, undead substance are not known. Any living
creatures that happen through a region of necromantic fog are in deadly peril,
for the foul mist will enter the pores of living skin and eat away at the souls
of those foolish or ignorant enough to pass through it.

Necromantic fog is heavier than air, appearing more as a mist than a fog,
clinging to the ground or the floor and rising to a height of not more than
three feet or so. A typical cloud will occupy 00 to 00 square feet in this
manner.

On the first – and each subsequent – round that a character remains within the
patch of fog then the necromantic fog deals 1d6+1 points of damage to its
victim. Any victim that suffers 10 points of cumulative damage from any number
of patches of necromantic fog within one-hour of time automatically loses one
level of experience, but may make a saving throw versus poison (at +6) to
determine whether the level loss is permanent or temporary. A temporary loss of
level persists for hours.

Necromantic fog can be completely destroyed by a successful turn undead check –
the fog is treated as a wraith for these purposes. *Gust of wind* or a similar
spell dissipates a necromantic fog but the affected patch reforms within d
rounds.

Anyone reduced to 0 hit points or 0-level by necromantic fog will collapse and
die, rising 1d+ rounds later as a zombie.

Necromantic fog restores 1d6 hit points each round to any undead creature
standing within it.

**Note:** Necromantic fog is so close to being a monster that it makes sense to
assign an experience point value for its destruction. A Referee who desires to
assign an experience point value to necromantic fog may choose either to assign
hit points and an armor class to the fog (it should likely only be hit by silver
weapon or magical weapons), or to assign a source to the fog that can be
destroyed with weapons. Such a source might include an evil idol, an ancient
censer, or even another undead creature whose experience point value could
include that of the fog it creates and/or sustains.

#### Fog, Putrid

Many of the things that can be encountered by an adventurer might cause nausea,
of course, but in some cases the nauseating power can be considerably stronger
than normal. Sources of putrid fog can include unusual fungi, magical herbs set
to burn in a brazier, unusual chemical reactions in an alchemist’s lab. Mundane
sources would include the smell of rot. Traps, of course, might involve gases
specifically designed to induce nausea. The normal way of handling nausea is to
allow the character a saving throw (perhaps with a bonus in the case of milder
smells) and if the character fails the saving throw, the effect is normally to
render the character helpless for a particular number of rounds.

Putrid fog, however, is a trick that can be more flexible in the hands of the
Referee than the simple combination of a saving throw and helplessness.
Consider: the check to see if a character is affected might be a flat percentage
chance, rolled either with percentage dice or on a d6. The Referee might invent
a smell that does not affect dwarves, or is only nauseating to elves. In terms
of the effects of nausea, there is even more variation in terms of the Referee’s
ability to create interesting tactical problems for the players. Nausea might
create a long-lasting penalty to die rolls; it might or might not affect
spell-casting ability; it might come and go at random intervals; it might weaken
characters rather than incapacitating them. Nausea is a much more flexible tool
for the Referee than simply a saving throw to avoid a few rounds of
incapacitation.

#### Ghost’s Grave

Looking like nothing more than a common, lonely grave, ghost’s grave is a
residual connection between the ethereal plane and the material world. These
minor hazards sometimes come into existence when a ghost is destroyed or
otherwise forced from a Material Plane world.

As the ghost vanishes from the world it seeps slowly into the ground and, only
seconds after it is gone, a perfectly formed grave stands exactly where the
ghost was last seen. Any animal coming within 30ft of a ghost’s grave becomes
terrified and attempts to flee the area.

At random intervals (5% chance per round) during the night of a full moon a
ghost’s grave unleashes a horrific, spine-tingling moan.

At midnight on the night of a full moon a ghost’s grave rips open, forming a
deep and unnatural pit connecting directly to the Ethereal Plane. This gateway
remains open for exactly one minute, during which characters or creatures may
enter the Ethereal Plane, but the opening cannot be used to return.

Attempting to unearth whatever is buried within a ghost’s grave is impossible;
the grave instantly refills with earth no matter how quickly a shovel is worked
against it. A ghost’s grave cannot be destroyed by any means short of divine
intervention.

#### Lichen, Blood

This bright red lichen, a symbiotic joining of algae and fungi, hangs from cave
and dungeon ceilings and grows slowly down surrounding walls and stalactites
and, in rare cases, reach the floor where it begins to slowly spread outward.
Blood lichen is thick and slimy and slightly resembles fresh blood. When
disturbed, a 5-foot diameter patch of blood lichen spatters bits of red fungus
out to a distance of 0ft, staining anyone in the area with what resembles a
spattering of blood (this may be avoided with a successful save vs. breath
weapon). The algae causes an intolerable itching sensation, so intense that
anyone splattered with it will begin scratching (dropping any items held) and
will run in a random direction for d6 turns

#### Lichen, Harmonic

This white growth hangs from cave and dungeon ceilings and grows slowly down
surrounding walls and stalactites and, in rare cases, reaches the floor where it
begins to slowly spread outward.

A patch of harmonic lichen is, by itself, harmless. The lichen picks up sounds
from one direction and amplifies the sound in another direction; in some cases,
the lichen bounces amplified sound back toward the source. In some cases, the
effect can actually be damaging to the ear if the original sound was
particularly loud or shrill. When harmonic lichen grows near a patch of harmonic
mushrooms or other creatures that may cause damage with sound, the damage is
usually increased by 50%. Sounds that enchant or have some magical function (not
verbal components) such as a harpy’s song, may be strengthened, with saving
throws against the effect being penalized by –1.

In addition to the lichen’s potentially damaging properties, they can create
strange deceptions by carrying distant sounds to the party’s ears. A string of
harmonic lichen patches can even serve as a warning alarm, possibly reaching
very far into a dungeon, and allowing monsters to eavesdrop upon a party’s
discussions.

#### Mold, Arcanebleed 

This dark green mold, created when yellow mold grows over a magic item and is
left undisturbed for a great length of time, radiates faint light in even the
darkest of conditions. Arcanebleed mold completely drains the magic item it has
overgrown and, if disturbed, a 5-foot diameter patch of this mold explodes in a
blast of arcane energy. All within 10 feet of the mold suffer d6 points of
damage (save vs. spell for half damage).

#### Mold, Coffin

This black, thick growth is found coating ancient graves, sarcophagi, and
tombstones. It may be found on the top of a grave, buried and coating the
outside of these containers, and may also be found growing on the inside of a
sarcophagus, coating the inside of the casket and growing thick upon the bodily
remains within. If coffin mold is disturbed, it wafts forth a cloud of
disease-carrying spores. Anyone within 15 feet of the mold must make a saving
throw vs. poison at + or catch a disease of the respiratory system. This disease
causes the sufferer to break into a hacking, convulsive laughter every 1d10
turns, with the loud gasps and barks lasting the full duration of that turn. The
afflicted character does not laugh while asleep, but has a 1% chance of dying
(not cumulative) per eight hours of sleep. Fire destroys coffin mold.

#### Mold, Dark

This sickly, black fuzzy mold grows on the damp floors of subterranean areas
near cave mouths, feeding on the decaying seeds and vegetation dropped by
transient cave dwelling animals. A prolific reproducer, dark mold constantly
spews its infectious microscopic spores into the surrounding air, creating a
hazy cloud that is difficult to see; any character approaching an area of dark
mold spores has a 1 in 6 chance to notice the cloud.

Living characters or creatures that pass through a patch of dark mold, or areas
adjacent to the patch, suffer no immediate adverse effects. The microscopic
spores are inhaled and lie dormant within the victim’s lungs for 1d6 days, after
which the victim must make a saving throw vs. poison at +1 or fall victim to the
dark mold disease (see box).

Fire or intense cold of any type, magical or natural, completely destroys a
patch of dark mold. When the mold is destroyed, it gives off a particularly
intense exhalation of spores with the smoke (no bonus to saving throws). The
spores dissipate after 6 turns, but if the party attempts to move through the
area near the burned-off mold, saving throws will be necessary.

**New Disease: Dark Mold:** A character or creature that falls victim to this
brutal disease spends most of his time coughing and suffers a – penalty on all
die rolls. Dark mold is also known as thief’s doom (reduces the chance of
success on all thieving rolls by 50%) or mage silencer, the latter because
spellcasters suffering from the sickness have a 50% chance of miscasting any
spell with a verbal component. The disease cures naturally, with a cumulative %
chance per day that the disease will have run its course. Until the disease has
either been cured or the sufferer recovers naturally, the victim of Dark Mold
disease’s constitution is effectively reduced by 1d points.

#### Mold, Scarlet

Scarlet mold is, as its name suggests, a bright red mold, normally found growing
in subterranean environments.

If disturbed, a patch of this bright red mold (normally 5 to 10 feet in
diameter) bursts forth a thick cloud of gas that lingers over the mold and the
adjacent area (a 15-foot diameter area) for d+3 rounds. All within this cloud
must make a saving throw vs. poison at + or become infected with the Plague of
the Red Ancients (see crimson fog, above) and immediately lose 1d6 hit points.
Scarlet mold is flammable, and a growth of it will be destroyed within 1d rounds
by fire of any kind. A *gust of wind or* a similar spell can be used to
dissipate a released cloud of gas. Note that a patch of scarlet mold destroyed
by fire turns into an equal-sized patch of crimson fog 1d3 rounds later.

#### Mold, Wilting

This sickly-looking patch of green mold is found in areas in which stagnant
water has remained undisturbed for weeks at a time. The mold floats on the water
and grows up walls and obstacles and, if disturbed, releases a cloud of spores
that drains moisture from all living creatures in a 0-foot radius. All affected
creatures suffer 3d6 points of damage (water and plants suffer 3d8 points of
damage) – a successful saving throw vs. poison reduces this damage to half. The
cloud remains over the affected area for d rounds and continues to deliver
damage each round until it settles back to the earth or is dissipated by *gust
of wind* or a similar spell. A typical patch of wilting mold is 10ft in diameter
and can be destroyed by fire, cold, or acid.

#### Monolith, Spark

This single stone, typically 20ft tall and five feet square, can be either an
unworked rock standing unnaturally upright or a sculpted rock that has been
obviously placed. Also known as an obelisk or column, monoliths dot the
landscape surrounding mountainous regions and many have religious, if not actual
magical, significance to those living in the area.

Spark monoliths are apparently the remnants of some ancient civilization,
baroque technology, or forgotten deity. It is not known whether they served as
religious objects or deadly guardians of important sites, treasures, or
boundaries. Whatever their forgotten purpose, Spark Monoliths can be a
significant hazard. These magical stones are charged with a mystical electric
force that targets magical power of any kind. Any source of magical energy that
comes within 50ft of the monolith will be attacked by bolts of lightning
erupting from the ancient stone. If a spellcaster, or any individual carrying a
magic item enters the spark monolith’s area of effect they must make a
successful saving throw against aimed magical items (such as a rod, staff, or
wand) against the crackling blue lightning bolts hurled against them. On a
failed saving throw the character suffers 3d6 points of electricity damage. A
spark monolith can attack up to 30 different targets per minute, but it can only
discharge the bolts once every other round.

A spark monolith that suffers 100 points of damage is destroyed.

#### Moss, Door

This dark brown and gray moss that grows up a wall appears – from a distance –
as a common wooden doorway. Rangers and druids have a 50% chance to notice that
the door is actually made of plant matter; characters of other classes are quite
likely to be deceived, with only a 1 in 10 chance to notice that anything is
awry).

Door moss has no destructive capabilities of its own. Instead, cruel dungeon
designers place patches of door moss at the end of long, twisted corridors in an
attempt to lure intruders into a mechanical or magical trap, usually hidden
behind the moss with a trigger set about 15-feet out. Fire damage of any type
completely destroys a patch of door moss.

#### Moss, Shadow

This gray-colored moss, typically 1-3-ft. in diameter, grows only on the
northern side of a large tree. Shadow moss is vaguely luminescent and casts a
pale light even at night (treat as a candle with a permanent duration as long as
the moss exists).

Any creatures passing with ten feet of a patch of shadow moss must make a saving
throw vs. breath weapon. On a failed save, bits of the moss cling to the
affected character or creature, making the target faintly luminescent (treat as
a candle) until the moss is cleaned off or wears out (the moss will remain
luminescent for only thirty minutes after it clings to a character or creature).
Washing off the shadow moss requires one minute and a gallon of water.

A patch of shadow moss is easily destroyed by fire, cold, or acid damage, if the
party should be paranoid enough to do so.

#### Moss, Sleep

This soft, moist, slightly luminescent blue lichen (gives off light equivalent
to a candle) is often cultivated by druids and underground races who use it to
both decorate and guard their areas.

Any living creature that comes within 5 feet of a sizable patch of sleep moss
must roll a d0 and add 3 to the roll. If the result is greater than the
character’s Wisdom score, the character falls asleep for 1d6 hours. This is
treated as a mental attack for purposes of wisdom bonuses, although the bonus
must obviously be subtracted, rather than added, to the d0 roll.

Sleeping creatures are helpless. Slapping or wounding awakens an affected
creature, but normal noise does not. Awakening a creature takes a full round.

With time, individuals can build up an immunity to sleep moss. As a result,
monsters and NPCs living near such moss tend to be immune to its effects,
allowing them to safely tend to the lichen and use it to gain a tactical
advantage against intruders or enemies.

There are rumors of certain groups of thieves and assassins that use sleep moss
in capturing live victims; a handful of sleep moss thrust over a creature’s
mouth or nose has the same effect as a patch of moss.

#### Mushrooms, Green Draco

Green Draco mushrooms are dark green mushrooms with white spots, each one about
8 to 10 inches in height. They grow in patches of 6-1 mushrooms and are only
found in dark, underground areas. A typical patch of Green Draco mushrooms,
usually covering a 5-foot diameter area, releases a cloud of acidic gas when any
warm-blooded creature comes within 10 ft. of a patch of the mushrooms. All
characters and creatures within the affected area suffer 3d6 points of acid
damage (a successful saving throw vs. breath weapons reduces the damage to
half). There is a 50% chance that any character failing the saving throw will
also be incapacitated for d6 rounds by pain.

The acid cloud remains suspended in the air for d rounds (during which time
anyone in the affected area must check for damage as described above) after
which it settles to the ground and is harmless. The cloud may be dissipated by a
*gust of wind* or similar spell. The mushrooms require d6 days before they may
once again release an acidic cloud.

A patch of Green Draco mushrooms is destroyed if it suffers any amount of fire
or cold damage.

#### Mushrooms, Harmonic

These large, white mushrooms grow in damp, dark places. Roll 1d6 each round, an
even roll indicates that the harmonic mushroom patch releases a destructive
burst of sound that disrupts flesh and bone. All characters and creatures within
a 0-foot radius must make a saving throw vs. aimed magic weapons (rods, staves,
etc) or suffer d6 points of damage. A patch of harmonic mushrooms is instantly
destroyed by extreme heat or cold, and bright light – natural or magical in
nature – puts the patch into a dormant phase during which time the harmonic
feature is inactive.

The area within range of a harmonic mushroom patch’s destructive sonic effect
exhibits signs of damage: rocks are cracked, any other hazards are completely
nonexistent, and creatures avoid the area. Harmonic mushrooms can be rather
deadly when coupled with Harmonic Lichen, and the two growths are often found in
the same areas.

#### Mushrooms, Pit

These gray, stone-colored mushrooms are quite large, many growing to fill a
20-ft. or even 30-ft. diameter circle, all of which – excluding the mushroom’s
flat top – is buried deep beneath the ground. A pit mushroom grows to suit its
surroundings, changing color and texture to match the surrounding cavern or
dungeon. An underground pit mushroom can only be detected on a roll of 1 in 6 by
a non-dwarf; dwarves have a 2 in 6 chance of detecting the danger.

Any character or creature that enters any square in which a pit mushroom exists
has a 3 in 6 chance of falling into the mushroom, as the center of the top
collapses inward, dropping the character into the interior of the huge stem. Due
to the spongy, soft nature of the pit mushroom, the fall inflicts only
one-quarter falling damage but for every round a character or creature is inside
the pit mushroom it suffers 1d points of damage as the mushroom’s internal acids
eat away at the victim, rapidly consuming flesh. 10 points of damage per 5 feet
of the pit mushroom’s diameter (the body is AC 9 [10]) are required to
completely destroy the mushroom and cause it to stop secreting acid.

Less dangerous pit mushrooms, virtually identical to those described above but
without the acid attack, have been encountered. These may simply be younger
versions of the same plant. Due to the monster-like nature of these plants, the
Referee may choose to assign an experience point value for killing them.

#### Mushrooms, Planar

Growing in patches of thousands, planar mushrooms are small, silver-colored
growths that completely dominate the corner of a dungeon or cavern room in which
they grow. A typical patch of planar mushrooms covers a 10-foot square area.

Unlike most hazards, planar mushrooms do not cause direct damage to any
characters or creatures that come within the mushroom’s area of influence.
Instead, there is a 15% chance that anyone coming within 10-feet of a patch of
planar mushrooms will be automatically transported to a random plane or
demiplane – planar mushrooms are a natural, chaotic type of planar gate.
Standing in a patch of the mushrooms increases the chance of being transported
away to 5%.

Fire destroys a patch of planar mushrooms

#### Pool, Boiling

Various factors, including steam vents, geothermal heat, or magic can heat
natural pools of water to a slow, rolling boil. Any character or creature
walking through one of these boiling pools suffers 1d6 points of damage each
round – if the character or creature is submerged in one of these pools the
damage is increased to 10d6 points of damage each round. A boiling pool
adversely affects any carried potions, canteens, or foodstuffs – there is a 5%
chance such items will be completely worthless after submersion in a boiling
pool.

Most boiling pools are, obviously, shrouded in a thick cloud of steam that may
affect visibility, increasing the risk of stumbling into the water.

#### Pool, Lava

While a boiling pool can be dangerous to adventurers it is nothing compared to a
pool of flaming lava. Red dragons – with their natural immunity to fire –
sometimes make their lairs inside lava-filled chambers where the task of
claiming the dragon’s treasure is made more difficult for the adventurers. (Of
course, unless the treasure is magically protected from intense heat it will be
destroyed. Most dragons that live in caverns filled with lava frequently have a
concealed treasure chamber somewhere just beyond the lava-filled areas.)

Any character walking through a lava pool suffers 10d6 points of damage each
round – if the character is submerged in one of these pools the damage is
increased to 100d6 points of fire damage each round.

Truly subtle dragons might construct a fragile stone bridge over a conveniently
placed lava pool and then lie in wait for intruders. The stone bridges are
usually constructed so that they can be toppled with a single swipe of the
dragon’s powerful tail. Generally, only older dragons for whom flying is an
effort, or dragons grown too large to escape the narrow tunnels of their own
lairs will resort to such ambush tactics – dragons prefer their food raw, and
prey normally emerges from a lava pool in an irritatingly cooked condition.

#### Pool, Profane

A profane pool is created when a pool of holy water is befouled by dark, unholy
magic, corrupting a pool of holy water into an unspeakable thing of vileness.
This dark, black-colored pool of stagnant water smells awful, the stench so
powerful that any characters or creatures approaching within 0ft. of it must
make a saving throw against paralysis or suffer a -6 penalty on all die rolls
for d6 rounds. Even on a successful saving throw the smell is so powerful that
the victim suffers a -3 penalty on all die rolls for 1d rounds.

A profane pool slowly consumes the land around it – for each year of the pool’s
existence a vile corruption spreads to contaminate the very earth in a 5ft
distance from the pool. Any good-aligned characters or creatures walking upon
this corrupted ground suffer a - penalty on all die rolls for as long as they
remain in the affected area and must make a successful saving throw against
paralysis each round or suffer 1d6 points of damage (a wisdom bonus against
mental attacks applies).

A profane pool is created by the influence of evil deities, their power called
into service by rituals performed by their mortal followers. According to the
blasphemous writings of necromancers, any number of rituals may convert a holy
water pool into a profane pool but the most common include:

-   An evil necromantic priest or wizard bathes in the pool, chanting certain
    best-forgotten invocations. This act deals 3d6 points of damage to the
    necromancer but there is a % chance that the necromancer’s dark god will
    smile on the act and reward the necromancer by poisoning the pool with evil.

-   A paladin or other noble, honest soul is sacrificed in the pool, the
    victim’s blood allowed to turn the pool’s waters a bright red.

-   A unicorn is led into the pool and then slaughtered, its head lopped from
    its body and left to float in the pool.

-   An evil, intelligent magic item is brought into contact with the pool.

Regardless of the ritual demanded by the evil deity, considerable expenditures
in gold and other materials are required to successfully create the abomination.

Once a profane pool comes into existence it can never be destroyed by mortal
hands.

#### Red Button

All players know that their characters shouldn’t press big red buttons or pull
unlabeled levers. Nevertheless, it is inevitable that someone will eventually
push the button or pull the lever. The wise game referee will occasionally
(about one every three times) make the button do something helpful, like opening
an otherwise undetectable secret door or opening a treasure chute. By giving the
party an occasional good result, the Referee can ensure many enjoyable moments
of frantic attempts by the party to prevent the dwarf from pulling the unmarked
lever.

#### Rocky Ground

In some areas, numerous rocks of various sizes jut out of the ground, slowing
movement and threatening to trip any adventurer foolish enough to run through
the area. Any character or creature running through an area of rocky ground must
make a successful Dexterity check at the start of his move or trip, falling to
the ground and losing the ability to act further in that round.

#### Spell Towers

These massive stone towers, commonly known as brochs, are constructed entirely
of stones that are carefully fitted together without the use of mortar (this
type of rock construction is commonly referred to as drystone). Mundane brochs,
many of which are used as defensive structures or homes, are common to the
northern plains and mountains.

Spell towers are a special type of broch that radiate an overwhelming magical
aura if *detect magic* is cast. These structures can withstand any natural or
magical storm and cannot be destroyed by any power except that of a deity.

Any spellcaster that sleeps overnight inside a spell tower must make a
successful saving throw versus spells or permanently lose one randomly
determined spell slot. However, if the save is successful then the spellcaster
automatically gains one bonus 1st-level spell slot. A lost spell slot may only
be regained by means of a *wish*. A spell slot gained by sleeping in a Spell
Tower may be dispelled by *dispel magic,* being treated as a magic item of 1th
level for this purpose. The broch will only test an individual once in this
manner.

A spell tower’s true hazardous nature only manifests during a full moon, at
which point all characters and creatures that enter the area within 10 miles of
the structure must roll a d0 against their wisdom score each turn or suffer a -6
penalty on all die rolls for 3d6 rounds. A character or creature that fails this
Wisdom check 10 times in a single night permanently loses 1 point of
Constitution. Whenever the Spell Tower drains a point of Constitution there is a
5% chance that a gateway between planes will be torn open in or near the broch.
This portal will remain open until sunrise, linking the material plane with a
plane or demiplane of the Referee’s choosing.

#### Stone Egg

This unusual rock formation – formed by the same process as a stalagmite – is
created as water drips down from the roof of a cavern and lands on an abandoned
dragon egg. If the egg does not hatch the calcium deposits from the dripping
water slowly build up until the egg is completely covered in a rocky substance.

Most stone eggs that are encountered in a dragon’s lair are harmless rock
formations. In some cases, though, the egg happens to sit near some form of
magical nexus, or may be exposed to sort of unknown eldritch force. Regardless
of the cause, in some cases such eggs can cause the unborn dragon within to be
slowly transformed into a terrible, unnatural force waiting to be released. In
such instances there is a 10% chance that, if disturbed in any way, the stone
egg will shatter, releasing a wave of arcane fury that inflicts 4d6 points of
damage to any characters within 0-feet of the stone egg. The wave appears as a
ghostly dragon of blue flame.

A stone egg is completely destroyed when it unleashes its built up arcane power.
A stone egg can be destroyed from a distance by inflicting 10 or more points of
damage.

#### Slickstone

This porous, cool, gray-colored rock naturally secretes an oily substance that
makes the rock treacherously slick. Anyone moving across an area of slickstone
at any speed faster than 30ft/round must make a Dexterity check by rolling a d0
under his dexterity score or else slip on the slickstone, falling down and
losing the ability to move, attack, or cast spells for a number of rounds by
which the check failed.

Slickstone has also been found on vertical surfaces. Slickstone can be used in
the construction of anything that can be built from ordinary stone or rock. Due
to the difficulty of working with the slippery rock any object created from
slickstone requires twice the normal construction time.

Slickstone is only found in the natural caverns that exist deep beneath mountain
ranges, and even then it is rare to find more than 20 cubic feet of the material
in a single location.

#### Stunspray

Resembling short, shattered stalactites – each one slowly dripping a thick slime
– hanging from the roof of a natural cavern, a stunspray patch is typically of a
10ft diameter in size and difficult to identify as anything other than a
harmless collection of stalactites. Stunsprays are formed when a stun jelly
migrates from a wall to a ceiling where the twisted ooze dies naturally and then
slowly, over a period of centuries, stalactites form naturally over the deceased
ooze. Stunsprays are extremely rare.

If a stunspray patch is left undisturbed it is typically harmless. Characters
may walk beneath the stalactites without fear of danger and as long as they’re
careful to avoid the dripping slime the hazard is little more than a nuisance.
If any of the dripping slime comes into contact with a character a saving throw
must be made or else the victim is paralyzed for 1d3 rounds.

A stunspray patch becomes a major threat when it is damaged (perhaps by a trap
or a hiding opponent). 5 or more points of damage dealt to a stunspray patch
(treated as AC 9 [10] for purposes of attacking the patch) destroys the
stalactite-skin and rains down a torrent of the thick, anesthetizing slime. Any
characters or creatures caught in the sudden rain of slime must make a
successful saving throw against paralysis or else be drenched in the slime and
paralyzed for 3d6 rounds.

For d8 rounds after a stunspray patch is destroyed, the area in a radius of ten
feet below it is covered in a hazardous slime. Any characters or creatures
walking through the affected areas have a 1 in 6 chance per round of slipping in
the slime, falling down and (if failing a saving throw against paralysis) being
paralyzed for 1d6 rounds. The slime dries quickly and once dry no longer poses a
threat.

Once unleashed a stunspray patch is completely destroyed and will not reform.

#### Terror Stones

Stone circles and individual standing stones are a common sight in some forests
and druid groves, the rocks marking holy sites and places of power. In many
instances, the standing stones have been in a single location for so long that
any knowledge of their creators or original purpose has been long forgotten. For
the most part, standing stones pose no threat to adventurers *but*, as with
everything in a fantasy landscape, there are always exceptions.

Terror stones, almost identical in appearance to common stone circles or
standing stones, are sometimes created when powerful undead are destroyed
nearby. Some echo of the creature’s malevolence is somehow trapped within the
stone itself, transforming it from a common rock into a standing stone of
terror.

Skeletal patterns – etched into the standing stone when it is transformed – are
the only visual clue that a terror stone is not a common stone. Anyone within
0ft that views a terror stone carefully for 1d6 rounds will suddenly perceive
that the patterns resemble bones and strange skeletal shapes. If the character
has reason to be familiar with terror stones, the eerie tracings will be a sure
clue to the true nature of the stone.

A terror stone constantly radiates a 0-foot radius fear aura. Any characters
within the radius of the terror stone’s fear aura will be affected as though by
a *fear* spell. A character that successfully saves cannot be affected again by
the same terror stone’s aura for one day.

Terror stones can be destroyed by a good-aligned cleric’s turn undead ability.
The terror stone is treated as a vampire for these purposes and a successful
attempt instantly reduces the stone to a harmless pile of rubble.

Terror stones are also referred to as standing stones of terror.

#### Thorn Patch

In some forests the undergrowth becomes thick and tangled with thorny vines. In
such areas simply moving becomes a slow, dangerous task as the thorns tear at
the clothes and flesh of any adventurers foolish enough to move through the
area. A thorn patch is a static hazard that takes no action. A thorn patch can
be as large as the referee desires.

For each five feet of a thorn patch moved through, a character or creature
suffers points of damage from the sharp thorns. Additionally, a character’s
speed is reduced by 50% when moving through a square filled with a thorn patch.

Each square of a thorn patch can be destroyed with fire, and can be chopped
through by inflicting 10 or more points of damage with a sword or other large
blade. Some thorn patches may be poisonous, especially in the tropical jungle.

#### Treasure-Covered Floor

One overlooked hazard in a dragon’s lair is the treasure itself! The coins,
gems, and other assorted baubles strewn about the chamber can create a serious
nuisance by cutting movement rates in half for those characters who want to
avoid tripping over pewter urns or tangling their feet in ancient necklaces.
Thieves trying to move silently, in particular, must pay careful attention to
scattered and potentially noisy valuables (not that thieves often fail to pay
attention to valuables, of course). If the treasure lies deep enough around, or
if the treasure contains many larger items like statuettes, it is perfectly
reasonable to reduce the party’s movement rates by 50%. If a character moves
into an area that can legitimately be called a pile of coins, the Referee might
even require a d0 roll under the character’s dexterity to remain standing.

In some rare instances a dragon’s lair will be devoid of treasure. Obviously in
such cases this hazard will not be encountered, and if the party scouts in
advance they will likely choose not to fight a poverty-stricken dragon anyway.

#### Vent, Poison

Similar in function and appearance to steam vents, a poison vent is a series of
stalagmites sitting atop underground pockets of poisonous gas. Like a steam
vent, the pressure eventually grows so great that the tops of the stalagmites
shatter, unleashing clouds of poisonous gas that are harmful to any characters
or creatures that enter the affected area. Poison vents are rarely encountered
individually but, rather, in groups of six or more, each about 5 ft apart. The
cloud from a poison vent expands out to fill an area ten feet in radius.

Anyone entering a cloud-filled area must make a saving throw against poison each
round or suffer 1d points of damage and a - to all die rolls for a full turn
(more virulent poisons, including lethal ones, have also been reported).

A poison vent can be capped, though if it is the gas pocket’s only release the
cap will be blown off within 1d6+1 days. Capping a poison vent requires a heavy
rock or other object that can be wedged into the opening. Capping a vent takes a
full round.

Some subterranean regions contain poisonous geysers that boil over with lethal
gas at regular intervals.

#### Vent, Steam

Natural stalagmites sitting atop underground pools of boiling water can form
steam vents when the pressure beneath grows so powerful that it blasts through
the natural rock above. When this happens clouds of billowing, heated steam
shoot forth from the newly-formed steam vent. Steam vents are rarely encountered
individually but, rather, in groups of six or more, each about 5 feet apart. The
cloud from a steam vent expands out to fill an area approximately 15ft in
diameter.

Anyone entering a cloud-filled square suffers 3d6 points of damage per round
from the intense heat of the steam.

A steam vent can be capped, though if it is the underground pool’s only release
the cap will be blown off again within d hours. Capping a steam vent requires a
heavy rock or other object that can be wedged into the opening. Capping a vent
requires a full round.

<br><br><br>Section VI:<br>Mutations
====================================

Introduction
------------

Traditionally, mutations are used in after the (nuclear) holocaust RPGs.
However, mutations could be used in other games by rethinking the cause. For
example, instead of being caused by exposure to high levels of radiation,
mutations in a campaign could be caused by exposure to high levels of “chaos” or
to extreme levels of magic (perhaps areas where strong ley lines cross or larger
amounts of magic were once used (e.g., the creation of a true artifact). The
rules for mutations are the same no matter how they are caused.

Radiation
---------

No matter what radiation actually is in the campaign (nuclear fallout, strong
areas of chaos, strong areas of magic, etc.), areas of radiation do horrible
damage and can cause mutations in those affected. Merely being in an area of
radiation causes damage unless a save vs death is made. A new save must be made
every hour. Radiation does both Hit Point damage equal to the damage rolled (And
Wound Point damage equal to the number of dice rolled if the optional Hit Points
and Wound Points rules are in use; however, those affected by Radiation are
allowed a second save vs death save to avoid the Wound Point damage).

Those who take radiation damage during a day must roll their mutation chance
using the highest level of radiation they were took damage from that day by
rolling a d20 against the mutation chance for the level of radiation, a roll
over the listed “Mutation Chance” means that the being will develop a random
mutation or defect in 1d20 days.

| Radiation Level | Effects                                           |
|-----------------|---------------------------------------------------|
| Low Level       | Save Modifier: 0 Damage: 3d6 Mutation Chance: 19  |
| Medium Level    | Save Modifier: -4 Damage: 5d6 Mutation Chance: 18 |
| High Level      | Save Modifier: -8 Damage: 8d6 Mutation Chance: 17 |

Mutations can be handled in two ways. The basic method is short and simple. The
Advanced method has much more detail. One method isn’t better than the other.
Which method to use depends on the importance of mutations in your campaign. In
some settings it might even make sense to both methods. For example, the Basic
Mutation rules might be used for PCs and NPCs who suffer mutation from radiation
while the Advanced Mutation rules are used to create mutated animal and monster
species that generally breed true.

Mutations (Basic)
-----------------

**Mutations:** The following random tables can be used to determine mutations of
beings mutated by radiation or can be applied to animals and monsters to create
radiation mutated species. Roll 1d20. A roll of 1-4 means a defect; any other
roll is a regular mutation. Some mutations have to be activated each time they
are used. Activation costs 5 HP.

**Random Mutation Table**

| d10 | Mutation Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
|-----|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| 1   | Amazing Stat - +1d6 to one stat: 1: STR, 2: CON, 3: DEX. 4: INT 5: WIS, 6: CHA                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| 2   | Amazing Defense - +1d6 to AC                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| 3   | Tougher - +2 Hit Points per level                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| 4   | Immunity - Takes no damage from: 1: Fire, 2: Cold, 3: Acid, 4: Poison, 5: Radiation, 6: Electricity, 7: Sonic, 8 Psionic                                                                                                                                                                                                                                                                                                                                                                                                             |
| 5   | Better Senses - One sense is vastly superior 1: Sight, 2: Hearing, 3: Smell, 4: Low light (30’), 5 Thermal: (30’), 6: Blindsense (30’)                                                                                                                                                                                                                                                                                                                                                                                               |
| 6   | Melee Weapon - Natural melee weapon that inflicts 1d8+STR mod; alternatively, player may opt to take this as an activated touch based healing ability instead (1d6 + WIS mod)                                                                                                                                                                                                                                                                                                                                                        |
| 7   | Ranged Weapon - Natural ranged attack that inflicts 1d8 damage up to 30’; source: 1: Fire, 2: Cold, 3: Acid, 4-6: Normal physical damage. Activation required.                                                                                                                                                                                                                                                                                                                                                                       |
| 8   | Psionic Attack - Mental attack that inflicts 1d6+INT bonus up to 30’; source: 1: Fire vs. AC, 2: Cold vs. AC, 3: Sonic vs. AC, 4: Elec. vs. AC, 5: Psionic vs. MD, 6: Empathy (no damage, read & manipulate emotions, 7: Telepathy (no damage, read thoughts/mental communication), 8: Illusion (no damage, audio and visual illusions only the target can see). Activation required.                                                                                                                                                |
| 9   | Special Mutation – 1: Extra Arms (hold extra weapons or shields), 2: Bigger (use med. Weapons as light and 2-hnd as med.), 3: Prescient (+1 surprise, +4 initiative, 4: Aquatic (gills & webbed digits), 5: Psychic Shield (A) (entire party may use mutant’s MD for defense), 6: Regeneration (heals 1 hp/minute as long as alive), 7: Faster (+1 Action Point), 8: Telekinesis (A) (lift 100 lbs. +100 lbs./ Mind bonus), 9: Special Move (A) 60’ (teleport, fly, jump, etc.), 10: Player’s choice. (A) means Activation required. |
| 10  | Player’s Choice - Player may choose specific mutation subject to Referee approval (i.e., Immunity to Fire).                                                                                                                                                                                                                                                                                                                                                                                                                          |

**Random Defect Table**

| d10 | Defect Description                                                                                                                                                                                                                                                                                                                                                                                                   |
|-----|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| 1   | Terrible Stat -1d6 to one stat: 1: STR, 2: CON, 3: DEX. 4: INT 5: WIS, 6: CHA                                                                                                                                                                                                                                                                                                                                        |
| 2   | Poor Defense -1d6 to AC                                                                                                                                                                                                                                                                                                                                                                                              |
| 3   | Weaker -1 HP per level (min 1hp/level)                                                                                                                                                                                                                                                                                                                                                                               |
| 4   | Vulnerability - Take x2 damage from: 1: Fire, 2: Cold, 3: Acid, 4: Poison, 5: Radiation, 6: Electricity, 7: Sonic, 8: Psionic, 9: Stun, 10: Player’s choice subject to Referee approval.                                                                                                                                                                                                                             |
| 5   | Diminished Sense - One sense is much poorer: 1-2: Vision, 3-4: Hearing, 5-6: Smell, 7: Taste, 8: Touch                                                                                                                                                                                                                                                                                                               |
| 6   | Clumsy -1 to all tests and initiative                                                                                                                                                                                                                                                                                                                                                                                |
| 7   | Slower -1d6 to Strike Speed and movement                                                                                                                                                                                                                                                                                                                                                                             |
| 8   | Allergic - Mutant suffers -2 on all tests when in contact with: 1: Ferrous Metal, 2: Non-ferrous Mental, 3: Certain Animals, 4: Sunlight, 5: Insect bites, 6: Alcohol, 7: Chemical, 8: Player’s choice                                                                                                                                                                                                               |
| 9   | Special Defect – 1: Hemophilia (-1 hp/round after taking combat damage), 2: Narcolepsy (falls asleep at very inconvenient times), 3: Phobia (intense fear of specific creature, condition or environment), 4: Poor Respiration (cumulative -1 on attack, damage and initiative rolls after 1st round of combat), 5: Smaller (cannot apply STR bonus to melee damage rolls; penalties still apply); 6 Player’s choice |
| 10  | Player’s Choice - Player may choose specific Defect subject to Referee approval (i.e., Vulnerability to Sonics, or)                                                                                                                                                                                                                                                                                                  |

Mutations (Advanced)
--------------------

Mutations are divided broadly into Human/Animal Mutations and Plant Mutations.
Human/Animal Mutations are further divided into Physical Mutations and Mental
Mutations. These categories are subdivided into Beneficial Mutations and
Mutation Drawbacks. Unless otherwise noted, most mental mutations, when used in
an offensive capacity, require a successful attack roll.

### Random Mutation Determination

Mutant characters of human or animal stock will have a random number of physical
and mental mutations. Roll 1d4 for each category, and this is the number of
Physical Mutations and Mental Mutations the character has (up to 8 total).
Mutant Plant characters have 2 plant mutations and 1d6 human/animal mutations.
All androids have any 3 mutations.

At the Referee’s discretion, a player may choose to have fewer mutations than
the number rolled or may even be allowed to choose mutations. For some games,
the Referee might decide that some mutations are off limits, and will provide a
selection of mutations that can differ from the ones presented here.

This system assumes a character that has his or her mutations out of a random
fluke. However, there can be “breeds” of mutant humans, animals, or plants that
have specific mutations that are passed on, so that a character is a
representative of a “race” rather than a unique individual. These “races” may be
created with the Referee, or the Referee may already have races designed that
are appropriate for his or her game. These mutations may also be used to create
or modify mutant monsters.

#### Human/Animal Mutations 

**Physical Mutations**

| D100  | Physical Mutation               |
|-------|---------------------------------|
|       | **Beneficial Mutations**        |
| 01-02 | Aberrant Form                   |
| 03-04 | Chameleon Epidermis             |
| 05-06 | Complete Wing Development       |
| 07    | Density Alteration (Self)       |
| 08-09 | Dermal Poison Slime             |
| 10-11 | Dual Headed                     |
| 12-13 | Dwarfism                        |
| 14-16 | Echolocation                    |
| 17-18 | Energy Ray                      |
| 19    | Energy Retaining Cell Structure |
| 20-21 | Epidermal Photosynthesis        |
| 22-23 | Fragrance Development           |
| 24-25 | Gigantism                       |
| 26-27 | Increased Balance               |
| 28-29 | Increased Physical Attribute    |
| 30-31 | Increased Sense                 |
| 32-33 | Metamorph                       |
| 34    | Natural Armor                   |
| 35-36 | Night Vision                    |
| 37-38 | Optic Emissions                 |
| 39    | Parasitic Control               |
| 40-41 | Prehensile Tail                 |
| 42-43 | Quickness                       |
| 44-45 | Reflective Epidermis            |
| 46    | Regenerative Capability         |
| 47-48 | Shriek                          |
| 49-50 | Spiny Growth                    |
| 51-53 | Thermal Vision                  |
| 54    | Toxic Weapon                    |
| 55-56 | Ultraviolet Vision              |
| 57    | Unique Sense                    |
|       | **Drawbacks**                   |
| 58-59 | Albinism                        |
| 60-61 | Bizarre Appearance              |
| 62-63 | Epidermal Susceptibility        |
| 64-65 | Frailty                         |
| 66-67 | Hemophilia                      |
| 68-69 | Increased Caloric Needs         |
| 70-71 | Obese                           |
| 72-73 | Pain Insensitivity              |
| 74-75 | Pain Sensitivity                |
| 76-79 | Pituitary Deformation           |
| 80-83 | Poison Susceptibility           |
| 84-86 | Prey Scent                      |
| 87-88 | Reduced Immune System           |
| 89-90 | Reduced Oxygen Efficiency       |
| 91-93 | Sensory Deficiency              |
| 94-95 | Simian Deformity                |
| 96-98 | Slow Mutant                     |
| 99-00 | Vision Impairment               |

**Mental Mutations**

| D100  | Mental Mutation             |
|-------|-----------------------------|
|       | **Beneficial Mutations**    |
| 01-03 | Ability Boost               |
| 04-05 | Accumulated Resistance      |
| 06-08 | Acute Hyper Healing         |
| 09-10 | Ancestral Form              |
| 11-13 | Body Adjustment             |
| 14-15 | Combat Empathy              |
| 16-18 | Control Light Waves         |
| 19-20 | Control Weather             |
| 21-23 | Damage Turning              |
| 24-25 | Density Alteration (Others) |
| 26-27 | Disintegration              |
| 28-30 | Dual Cerebellum             |
| 31-33 | Empathy                     |
| 34-35 | Flight, Psionic             |
| 36-38 | Force Screen                |
| 39-40 | Force Screen, Greater       |
| 41-42 | Increased Willpower         |
| 43-45 | Intellectual Affinity       |
| 46-47 | Killing Sphere              |
| 48-50 | Know Direction              |
| 51-53 | Mental Barrier              |
| 54-56 | Mental Phantasm             |
| 57-59 | Metaconcert                 |
| 60-61 | Mind Thrust                 |
| 62-63 | Neural Telekinesis          |
| 64-66 | Neural Telepathy            |
| 67-68 | Plane Shift                 |
| 69-70 | Possession                  |
| 71-72 | Precognition                |
| 73-75 | Mind Reflection             |
| 76-78 | Quick Mind                  |
| 79-80 | Teleport                    |
| 81-82 | Temperature Control         |
| 83-85 | Vampiric Field              |
|       | **Drawbacks**               |
| 86-87 | Atrophied Cerebellum        |
| 88-89 | Dual Cerebellum (Defective) |
| 90-92 | Mind Reflection (Defective) |
| 91-93 | Negative Empathy            |
| 94-95 | Phantasmal Damage           |
| 96-98 | Phobia                      |
| 99-00 | Weak Will                   |

#### Plant Mutations 

Note that plant mutations, like other mutations, may be used by the Referee to
construct monsters. These mutations are written with NPCs, monsters, and PCs in
mind. As a result, they will have slightly different guidelines depending on how
they are used.

| D100  | Plant Mutation                 |
|-------|--------------------------------|
|       | Beneficial Mutation            |
| 01-04 | Abnormal Size\*                |
| 05-07 | Accumulated Resistance         |
| 08-10 | Animal Limbs or Organs         |
| 11-13 | Animate Seeds\*                |
| 14-16 | Carnivore                      |
| 17-19 | Chameleon Metamorph            |
| 20-23 | Dermal Acid Sap                |
| 24-27 | Dermal Poison Sap              |
| 28-30 | Electric Charge Generation     |
| 31-33 | Flight                         |
| 34-36 | Fragrance Development (Plants) |
| 37-39 | Free Movement\*                |
| 40-42 | Full Senses\*                  |
| 43-45 | Grenade-like Fruit             |
| 46-48 | Injected Poison Sap            |
| 49-51 | Natural Armor (Plant)          |
| 52-54 | Natural Vegetal Weapons        |
| 55-57 | Poisonous Spores               |
| 58-60 | Prehensile Tendrils            |
| 61-63 | Projectile Thorns              |
| 64-67 | Radioactive Emissions          |
| 68-70 | Reflective Cellular Structure  |
| 71-73 | Shriek (Plant)                 |
| 74-77 | Thermal Emissions              |
| 78-80 | Tripping Tendrils\*            |
| 81-83 | Vegetal Parasite               |
|       | Drawbacks                      |
| 84-86 | Nocturnal                      |
| 87-90 | Prey Scent                     |
| 91-94 | Reduced Fertility\*            |
| 95-00 | Thermal Sensitivity            |

\*These mutations are either inappropriate to PC/NPC plants, or are assumed to
already be present on all PC/NPC plants.

### Physical Beneficial Mutations

#### Aberrant Form 

This mutation covers a wide array of effects over the entire bodily structure of
the mutant. Roll 1d8 to determine the nature of the mutation.

1-2 *Enlarged Parts:* Some aspect of the mutant’s body has grown to an
abnormally large size and, as a result, has increased functionality. Because
this is a benefit all limbs and organs are assumed to be affected in concert
(i.e., both arms, both legs, etc.). For example, this mutation could manifest as
a +1, +2, or +3 to damage if arms are larger than normal, or +60 to movement for
longer or larger legs.

3-4 *Xenomorphism:* The character gains a unique organ/limb with a new function,
such as an extra pair of eyes on stalks, a prehensile proboscis, a limb or body
part from another species, or a set of tentacles that act as extra arms. An
extra body part from another species may (50%) be equipped with a *natural
weapon*.

5-6 *Extra Parts:* Any organ or limb that is normally present may be multiplied.
An extra normal organ (extra heart, extra set of lungs) may be acquired, which
could increase CON by +1. To generate a random number of a given body part roll
1d4+1 and multiply by that number, or a number may be selected. The brain and/or
head cannot be duplicated by this mutation.

*7-8 Natural Weapon:* The mutant is equipped with a natural weapon, such as
horns, teeth, or claws (select at character creation). These will inflict damage
as determined by rolling 1d6; 1-2 1d3, 3-4: 1d6, 5-6: 2d6. The character may
only attack once per round with a *natural weapon*, unless he possesses more
than one attack per round. A *natural weapon* may (25%) be equipped with a
*toxic weapon*, such as poison.

#### Chameleon Epidermis 

The mutant’s outer cellular structure has been mutated, allowing the cells to
actually alter their lucidness, appearance, and color. In effect, this allows
the mutant to subtly change colors on a cellular level. The being may hide, if
stationary, almost as if invisible. The color change takes place immediately,
and requires no concentration by the mutant. The Referee should assign a
percentage chance, based on the situation, that the mutant will not be noticed
when using this camouflage. In complete darkness or thick cover, the percentage
could be 95%, while in daylight if the character is unmoving it might be 50%.

Characters wearing heavy armor or are fully garbed receive no benefit from
Chameleon Epidermis.

#### Complete Wing Development 

The form of fleshy membranes, feathery wings, bat-like extremities, or even
scaly or insect-like versions. With these wings the character can fly with a
movement of 120’. The mutant may fly while carrying only 25% of his body weight.
Creatures over 150 pounds cannot use these wings for flight, but they leap to a
distance of 120’, with a maximum height of 80’.

#### Density Alteration

This mutation grants the ability to instantly alter body density, thus shrinking
or enlarging, with maximum enlargement up to twice the natural body size, and
maximum shrinkage to 1/8 original body size. Each fraction of a body size change
is accompanied by an equal fraction increase or decrease to armor class and
speed. For example, reduction of size by 1/4 also reduces (improves) armor class
and reduces movement by 1/4. Becoming twice as large increases armor class by a
multiple of two (to a maximum of 2) and doubles movement. Note that reduction of
body density to 1/8 makes a character impervious to damage from sharp
implements.

#### Dermal Poison Slime 

The mutant is covered in a thick gooey slime (like a frog) that is poisonous to
those who touch or attempt to ingest the mutant. The Referee will decide the
effect of the poison in the slime. Successful bare-hand attacks and bite attacks
against the mutant require the attacker to attempt a saving throw versus poison.
Bare-hand attacks made by the mutant have the same effect.

#### Dual Headed 

The mutant has developed a second head next to the first. He can only be
surprised on a roll of 1 on 1d6. Roll one die for each head whenever using
senses (listening, looking for traps), choosing the best result.

#### Dwarfism

Mutated genes have altered the mutant’s physical size, an effect either related
to a pituitary defect or a change in the genetic program during the years of
body growth and development. With this mutation, the mutant is a dwarf, a mutant
with substantially decreased size and body weight.

To figure out the character’s size, start with a base of 6 feet. Roll 1d4+1 and
subtract the result from 6 to get the height of the character in feet. This will
give a range from 1 and 4 feet.

The character’s diminutive size makes it harder to damage opponents, but also
makes it more difficult for opponents to land successful blows on the mutant,
since he presents such a small target. A dwarf mutant has a +1 to hit targets of
human sized or larger with a non-powered hand weapon. He does -1 to damage for
every 1’ shorter than he is from 3 feet, with an equal reduction (improvement)
of AC for each foot he is shorter than 3’.

#### Echolocation 

The mutant has the ability to gather information on his surroundings by using a
type of natural sonar. The mutant must emit a noise (some kind of clicking or
speech will do), which then reverberates off of the surface of any surrounding
objects or creatures, is picked up by an external sense organ and translated
into a rough, colorless picture of all objects in the mutant’s surroundings.
This allows the character to interact with the surroundings as if he has sight,
even if he does not have eyes or regular sight is obscured. This does not allow
the mutant to see through objects, nor will it allow him to read text or see
pictures. This works for a range of 90 feet, or 270 feet if the character also
has the *increased hearing* mutation. Mutants with this ability will have a
better chance of striking an opponent, receiving a +2 to hit in combat.

#### Energy Ray

Every 3 rounds, this mutation grants the ability to emit a blast of energy (roll
1d6; 1-2 heat, 3-4 cold, 5 radiation, 6 electricity) from the hands (or other
upper appendages) that inflicts 4d6 hit points of damage to a distance of 50
feet. The type of energy must be chosen when the mutation is acquired.

#### Energy-Retaining Cell Structure 

The mutant’s body has a higher than normal level of electrical energy coursing
through his body, energy which he can focus into a shock capable of damaging
opponents who touch him. This electrical shock does 3d6 hp damage.

#### Epidermal Photosynthesis

Characters with this mutation get energy from the sun, processing it through
their bodies as though it were food. If they spend long periods of inactivity in
direct sunlight, they will be able to heal wounds more quickly (4x) than the
regular healing rate. When they are out of the sun (i.e., at night or in a dark
cave) they are forced to move more slowly in order to conserve their rapidly
depleting energy. This reduces their movement to 50% of the normal rate. Such
characters are also more susceptible to cold and heat, and they suffer a –2
penalty to saving throws versus cold or heat based energy attacks.

#### Fragrance Development 

The mutant has the ability to produce a subtle yet hypnotic fragrance. The
fragrance is generally derived from mutated pheromones/hormones (that are
emitted at the mutant’s will), but could come in another form-spores, for
instance. Once per day the mutant can emit a scent that forces up to 8 HD of
creatures, or any single creature with less than 13 HD within 15 feet to save
versus poison or fall into a hypnotic trance for 2d4 rounds. Victims may be
ordered to commit any act that is not suicidal, up to and including attacking
friends.

#### Gigantism

Mutated genes have altered the mutant’s physical size, an effect either related
to a pituitary defect or a change in the genetic program during the years of
body growth and development. While this serves to increase strength and size
potential substantially, the mutant is nonetheless noticeably different than
others of his species.

The original size is based on a 6 foot height. Roll 3d6, adding that many feet
to the size of the mutant, achieving sizes between 9 and 24 feet. The mutant
gets a bonus to damage, based on his height. Note that all mutants with
gigantism suffer a -1 penalty to hit creatures 3’ tall or smaller.

**Gigantism Modifiers**

| Height           | 9 foot | 12 foot | 18 foot | 24 foot |
|------------------|--------|---------|---------|---------|
| Damage Die Bonus | \+1    | \+2     | \+3     | \+4     |

\*The Damage Dice Bonus is only applicable to non-powered hand weapons.

#### Increased Balance 

The character will never fall or stumble, and can climb almost any surface
without being in danger of losing balance.

#### Increased Physical Attribute

One or more physical attributes is increased. Roll 1d6 to determine the specific
effects.

1-2 *Increased Strength:* The character can summon bursts of great strength,
dealing an extra 3d6 when damaging an opponent with a hand-to-hand weapon.

3-4 *Increased Dexterity:* The character’s AC is adjusted by -2. This bonus is
cumulative with any other DEX bonuses.

5-6 *Increased Constitution:* The character receives Constitution x2 in extra
hit points, and receives +2 to all saving throws versus poison.

#### Increased Sense

One or more senses is very acute, allowing the mutant to sense things others may
not. Roll 1d10 to determine the sense.

1-2 *Increased Vision:* This allows the mutant to see things as far as 3 miles
away if there is a clear line of sight. This mutation comes with the benefit of
*ultraviolet vision* and *night vision*.

3-4 *Increased Hearing:* A character may distinguish even the quietest sounds at
a range of 180 feet. This also allows the mutant to pick out sounds from a
jumble of noises. Mutants with *increased hearing* cannot be surprised because
they will always hear any movement in their vicinity, and they can listen at a
door with success on a roll of 1-5 on 1d6.

5-6 *Increased Smell:* A mutant with this mutation can pick up scents at 180
feet and tell the difference between various smells even if some seem
overwhelming to others. Creatures that are upwind can never surprise this
character.

7-8 *Increased Touch:* This increased sense grants +2 to saves to use advanced
technology.

9-10 *Increased Taste:* This ability does not have a range, but it ensures that
a character cannot be poisoned and will always be able to tell by tasting
whether something is capable of being eaten for nourishment.

#### Metamorph 

The character can choose (when the mutation is acquired) another creature that
he or she can transform into. The character does not gain the mutations of the
creature, just the physical appearance and natural abilities (such as claws or
sharp teeth). This physical change (in either direction) takes 2 full rounds of
inactivity before it is complete.

#### Natural Armor 

This mutation indicates that the character has grown a natural defense mechanism
over the entire body. It can be thick fur, scales, a shell, or even rubbery
skin. This armor is moderate (1-3 on 1d6) or extreme (4-6 on 1d6). Moderate
armor grants an AC of 6 [13], while extreme natural armor grants an AC of 4
[15], but reduces movement to 75% of its regular rate.

#### Night Vision

Individuals with this mutation can see in complete darkness to a range of 60
feet by utilizing minute amounts of available light. Vision is in black and
white only, and does not function in utter darkness underground, since some
small light must be present (starlight, moonlight), even if it is so dim normal
sight does not perceive it.

#### Optic Emissions

This mutation takes two forms. Roll 1d6, and on a roll of 1-3 the mutant
character receives the ability to project a flash of very bright light from the
eyes (*bright eyes*), blinding an opponent within 30’ for 1d4 rounds. This
blindness causes the opponent a penalty of -4 to attack rolls and increases his
armor class by 4. This ability is useful regardless of daytime or nighttime. On
a roll of 4-6, the character has the ability to discharge a burst of radiation
from the eyes (*gamma eyes*), that can reach 30’for 3d6 damage.

#### Parasitic Control 

If the character can attack and latch onto another creature for 3 rounds, he or
she will maintain control over the creature as long as the two are in physical
contact.

#### Prehensile Tail

The mutant has developed a special tail. The tail is not necessarily a balancing
tool, but more of an “additional limb”.

The tail can grapple objects like a hand (much like a new world monkey’s tail),
allowing the mutant to hang from tree limbs, for instance, leaving the arms and
legs free to perform other actions of a more complex and agile nature. Some
typical bonuses granted by the mutation might be a +2 bonus to Dexterity checks
when climbing or balancing (+4 if climbing trees), etc. The tail can also be
used in more mundane ways, such as holding a light source, so the character can
employ both hands to fight. The tail cannot use weapons or hold a shield,
however, as it is not quite that dexterous.

#### Quickness 

This mutation makes the mutant much quicker in all respects. Movement speed is
doubled, mental tasks take half as long to accomplish, and the character may
attack two times per round in physical combat (not mental combat).

#### Reflective Epidermis

The character’s skin is essentially impenetrable to a particular form of energy.
When this mutation is acquired, roll 1d8. A roll result of 1-2 is electricity,
3-4 is heat, 5-6 is cold, and 7-8 is radiation. The mutant will never suffer
damage from this energy source.

#### Regenerative Capability

When provided with proper rest and food, this mutation allows the character to
recuperate from injury at a staggering rate. Given time, mutants may re-grow
severed limbs.

The character heals 10 extra hit points per day. If he should be so unfortunate
as to lose a limb or extremity (and survive), the lost body part will regenerate
over a period of 1d4+2 weeks. A head may never be regrown, and characters do not
regenerate from death.

#### Shriek

The mutant’s vocal cords are substantially altered, allowing him to produce
sounds both above and below the normal human auditory range. The culmination of
this ability seems to be a focused shout, using the sonic vibrations on everyone
in the immediate vicinity of the mutant.

Once per day, the mutant can let out a horrible shriek that affects everyone
within a 10’ radius of him. Targets in the area of effect must save versus stun
attacks or take 1d6 points of sonic damage and be deafened for 1d6+4 rounds.
Those who successfully save are unaffected. Mutants with the mutation
*echolocation* suffer a -2 penalty to save.

#### Spiny Growth

Parts of the mutant’s body are covered with prickly spines, which may be small,
medium, or large. Roll 1d6 at character generation to determine the size. Small
spines (1-2) inflict 1d3 damage, medium spines (3-4) inflict 1d6, and large
spines (5-6) are capable of inflicting 1d6+2 damage. Any type can be removed and
thrown as a dagger. With a little effort, the small spines are capable of being
hidden beneath normal clothing, but the medium and large spines are virtually
impossible to conceal because of their size.

#### Thermal Vision 

The character can see the heat generated by living beings, heat-emitting
weapons, or other natural heat sources. This vision functions to a distance of
60’ if the mutant has ordinary vision as well, or to 90’ if thermal vision is
the only form of sight the mutant possesses (the eyes emit infrared radiation to
boost the distance). If a mutant has ordinary vision and thermal vision, the
thermal vision is only usable in darkness, and it takes 1 round to transition
between them. Immense flashes of heat or those coming from close proximity to
the character can be overwhelming, blinding the character for 2d4 rounds.

#### Toxic Weapon 

The character is endowed with a weapon that is toxic to those affected by it.
This could be in the form of a gas that affects everyone in a specific radius, a
spray that can affect a specific target, or a bite/sting that affects a target
at a range of touch. Some common types of toxic weapons are paralyzing venoms,
blinding gasses or sprays, and acidic bodily fluids. The range or radius of the
attack is up to 30’. The Referee will determine the effects of the attack when
the mutation is acquired. In general, no attack should exceed 10d6 in damage
(with the exception of poisons that may inflict death).

#### Ultraviolet Vision 

The character can see the UV spectrum and will be able to see objects that emit
this type of energy. This spectrum includes gamma radiation, x-rays, and other
high intensity radiation. As a result, a character with this vision can see if
areas have a high level of background radiation. At night, this vision allows a
character to see to a distance of 300’. Since this vision relies on heavy
background radiation, it is not useful underground unless there is a source of
radiation for illumination. If a mutant has ordinary vision and *ultraviolet
vision*, the *ultraviolet vision* is only usable in darkness, and it takes 1
round to transition between each form.

#### Unique Sense 

The mutant with a unique sense may detect certain kinds of phenomenon that are
not detectable by the usual senses. These might include the ability to “feel”
radiation to a distance of 60’, “smell” water within a mile, or sense when
certain kinds of weather are imminent. The player and Referee may devise an
appropriate sense, and what its range will be. Some senses may have
corresponding new organs.

### Physical Mutation Drawbacks

#### Albinism

This mutation prevents the formation of melanin. The mutant’s hair and skin are
bone white, and his eyes have light pink irises. Due to the lack of pigment in
the eyes, the being is highly sensitive to light, and suffers a -2 penalty to
hit when in daylight.

#### Bizarre Appearance 

This mutation can take a number of forms. The character’s hair color, eye color,
skin color (or any combination) can be a color not normally found in
humans/animals. Odd hair colors might be light red, unusually fair blond, white,
platinum, or silvery gray. Skin hues might include extensive freckling, melanin
blotches, irregularly livid tones, etc. Eye colors could be red, pink, white,
unusual flecked combinations etc. Other mutations are possible, such as scales
instead of skin, general cosmetic deformity, or general animal-like deformity.
Whatever the abnormal condition, it is clear that the mutant is not a normal
human or animal.

#### Epidermal Susceptibility

The epidermis of the mutant becomes defective in some way, either causing 1d6 hp
of damage for coming into contact with usually harmless substances (such as
water), or adding +1 per die of damage caused by specific injury, such as by
fire, radiation, slashing weapons, or penetrating weapons.

The mutation can also be something that constantly creates a serious
inconvenience for the mutant, such as glowing skin, uncontrollable pigment
shifting, or skin that always attracts certain kinds of vermin or larger
creatures.

#### Frailty

This is a highly variable mutation, and can be used to create any number of body
weaknesses. Examples include brittle bones or susceptibility to bruising. These
would increase damage by falls or other blunt force trauma by a degree decided
on by the Referee. However, damage should usually be increased no more than by
+3 per die of damage.

#### Hemophilia

The mutant’s white blood cells are diminished in count, preventing him from
healing as quickly as a normal specimen of his kind. This mutant may only
naturally heal every other day. Once the character is injured, he begins to
bleed profusely, losing 2 hit points per round until the wounds can be properly
bandaged.

#### Increased Caloric Needs

This drawback requires the character to eat twice the normal amount of food
daily. During times of vigorous activity, this need becomes more acute. For
every 5 rounds of vigorous activity, the character must eat for 1 round or lose
2 hit points and 1 point of STR each melee round until he eats again or until
the activity stops. All losses will be regained at an equal rate for each round
that food is consumed, until all loss of hit points and STR is regained.

#### Obese 

The character suffers from obesity, and his weight is twice that of an average
individual of his species. The Referee may apply encumbrance or combat modifiers
when it seems as though the character’s size would interfere with his abilities
in any way. It is also possible to choose one body location and declare that the
fat accumulates there, giving one or more limbs a grotesque, bloated shape
compared to that of the rest of the body.

#### Pain Insensitivity 

The character lacks the awareness that living creatures normally possess with
regard to their bodies and immediate surroundings. The character does not feel
pain when injured, even if a weapon has penetrated his body. The character will
not be able to tell how much damage he has sustained without making a visual
checkup of his entire body. The Referee should keep track of the mutant
character’s hit points and only give the information to the player when they
make said visual check.

#### Pain Sensitivity

The character’s nervous system is very susceptible to injury, resulting in all
damage to the character being doubled.

#### Pituitary Deformation 

This defect indicates the pituitary gland of the mutant has been deformed by
mutation, causing unnatural aging.

A character with this defect appears much older than he really is, generally two
to three times his actual age. Lifespan is also hindered by this deformation,
resulting in a maximum natural lifespan of 40-50 years.

#### Poison Susceptibility

This mutation makes all poisons much more dangerous to the character. All saving
throws versus poison are made with a penalty of -4.

#### Prey Scent

The mutant’s body sends out waves of scent that will attract predators. The
Referee may increase the occurrence of wandering monsters, at his discretion.

#### Reduced Immune System

Whenever the character falls ill, whether it is from infection caused by
combat/misadventure, or airborne infectious diseases, the character suffers an
extra 10 hp of damage per day. If using the optional Disease rules characters
with this mutation suffer a -4 saving throw adjustment against diseases, and the
duration is doubled.

#### Reduced Oxygen Efficiency

This mutation makes it harder for the character to get oxygen into the
circulatory system. This means that, after any amount of extended physical
activity (including combat) lasting more than 5 rounds, the character must rest
or fall unconscious for 3d6 rounds. Further, when exploring ruins these
characters need to rest for 1 turn after 3 turns of exploration. See “Rest” in
the Adventuring Rules section.

#### Sensory Deficiency

This mutation indicates that the character suffers from either blindness or
deafness (50%).

#### Simian Deformity

A mutant who suffers from this mutation has an altered appearance that mimics
that of the great apes (such as gorillas and chimpanzees) - shorter legs,
quadrupedal, and elongated arms that permit the knuckles to touch the ground and
aid in movement.

The character’s shortened legs reduce his base speed to 2/3 normal. However, if
all 4 limbs are used to move (arms and legs), his speed is normal. A character
using his arms to assist movement cannot be wielding a weapon or carrying items
in his hands.

#### Slow Mutant

This mutation makes the mutant much slower in all respects. Movement speed is
halved, mental tasks take twice as long to accomplish, and the character may
attack once every other round.

#### Vision Impairment

This mutation covers all visual impairments that fall short of total blindness,
including macular degeneration, myopia, severe light sensitivity, cataracts,
etc. This condition makes it extremely difficult for the mutant to discern
objects more than 50 feet away. Characters with this mutation have a -2 to hit
in combat.

### Mental Beneficial Mutations

#### Ability Boost

Once per day the mutant is capable of concentrating his mental energy to such a
degree that one of his abilities is doubled for 1d10 consecutive rounds, or he
gains +1 to attack rolls for 1d10 rounds. The character may choose either of
these options each time the mutation is used.

#### Accumulated Resistance

Through years of exposure to a certain substance (chemicals or radiation, for
instance), or concentrated form of energy (such as heat, cold, or light) in the
mutant’s environment, a resistance against said source has been accumulated,
allowing the mutant to take more damage from one of these sources.

This mutation gives the mutant a hit point reserve equal to his total hit
points. This hit point reserve is used to take damage from the substance he is
resistant to before it begins to affect his regular pool of hit points. This
separate pool heals in the same manner and at the same time as the character’s
hit point pool, even if that rate is changed by other mutations such as *acute
hyper healing* or *body adjustment*.

#### Acute Hyper Healing 

The character may concentrate his mental energies to allow him to heal 4x the
normal rate. He will also be free from physical pain and fatigue for up to 24
hours. This power may be used once per week.

#### Ancestral Form

This mental mutation can reduce an opponent’s mutational capabilities,
eventually removing all forms of mutation and returning it to its original,
unadulterated form. On each round after a successful mental attack with this
mutation, the target has one mutation removed permanently (randomly determined),
until none are left. Rarely (5%), this power allows a powerful mutant to regress
a pure specimen further down the evolutionary line, to a previous stage of its
evolution. For example, a pure human might become a dimmer-witted *Homo
erectus*, and onward. This attack may only be attempted for the duration of one
encounter, whether it succeeds or not, and cannot be used again for 1 week.

#### Body Adjustment

The character can heal all of his hit points once every 24 hours. In addition,
if the character is in a life or death situation, this mutation can double his
physical attributes (Strength, Dexterity, movement) for 3d10 rounds.

This power may only be used 1d4 times per week (roll at character creation).

#### Combat Empathy

The character is so attuned to the minute body language of others that he can
tell what they are going to do before they do it. This gives him a +1 to hit in
combat, and +3 hp damage per damage die rolled in a successful attack.

#### Control Light Waves

The character can control light, creating a number of interesting effects. He
can bend light around himself, becoming invisible, or he may remove all light
from a small area (10’ radius) at a range of 30 feet. He may also completely
dissipate laser fire anywhere within this 30’ range. All of these effects
require concentration, such that the mutant may move at full speed but not
attack when concentrating on using this mutation.

#### Control Weather

The mutant can change the weather in the local area. It takes 1 round to use the
mutation and an additional 1d4 rounds for the effects to manifest. The mutant
calls forth weather appropriate to the climate and season of the area.

| Season      | Possible Weather                                     |
|-------------|------------------------------------------------------|
| Spring      | Tornado, thunderstorm, sleet storm, or hot weather   |
| Summer      | Torrential rain, heat wave, or hailstorm             |
| Autumn      | Hot or cold weather, fog, or sleet                   |
| Winter      | Frigid cold, blizzard, or thaw                       |
| Late winter | Hurricane-force winds or early spring (coastal area) |

The mutant controls the general tendencies of the weather, such as the direction
and intensity of the wind, but cannot control specific applications of the
weather-where lightning strikes, for example, or the exact path of a tornado.
Contradictory weather conditions are not possible simultaneously. Control
weather can do away with atmospheric phenomena (naturally occurring or
otherwise) as well as create them.

#### Damage Turning

This mutation allows the character to return any incoming damage to the origin
of the attack. For this power to work the mutant must use every bit of his
concentration, taking no other actions. Any movement of more than one or two
small steps will cause this power to fail.

The power gradually builds up, allowing 3d6 hp worth of damage to be turned the
first round. This increases by 1d6 per round up to a maximum of 20d6 hp worth of
damage. The mutant only takes damage that is above his current hp level of
damage turning. For instance, in the first round the character rolls 3d6, with a
result of 14. He may turn up to 14 hp of damage the first round. The next round
he adds 1d6 to the current running total of 14. He can keep the power working as
long as he remains still and concentrating, and he may maintain concentration
when he receives damage. The mutant cannot turn attacks that cause no damage. If
such powers are successful, they can interfere with this ability if they break
the mutant’s concentration.

#### Density Alteration (Others)

This mutation grants the ability to instantly alter the body density of a
target, thus shrinking or enlarging, with maximum enlargement up to twice the
natural body size. Each fraction of a body size change is accompanied by an
equal fraction increase or decrease to armor class and speed. For example,
reduction of size by 1/4 also reduces (improves) armor class and movement by
1/4. Becoming twice as large increases armor class by a multiple of two (to a
maximum of 10) and divides movement in half as well. Note that reduction of body
density to 1/8 makes a character impervious to damage from sharp implements.

This mutation has a range of 90 feet, a duration of 1d4 turns, and cannot be
used on the mutant who wields it.

#### Disintegration

With this powerful mutation, the mutant can completely destroy matter on a
molecular level. Doing so requires so much energy expenditure, however, that the
mutant is instantly rendered unconscious, with 1 hp left. The total weight that
may be disintegrated is INTx10 pounds and the range is 90 feet.

It is more difficult to disintegrate dense materials. Multiply the mutant’s INT
by 3 to find the percentage chance of disintegrating metals and stone, or by 5
to figure out the percentage chance of disintegrating wood or living material.

Once the mutant has used this power, the Referee must determine, via a secret
1d6 roll, how many days it will be before the power may be used another time.

#### Dual Cerebellum

The character has 2 fully functional brains that work in concert. The mutant
receives a bonus of +2 to saves to use advanced technology, and the character
receives one extra random mental mutation that belongs to the extra brain. Both
brains have identical INT and WIS. Having two brains also helps to protect the
mutant from mental attacks. Whenever the character is the subject of a mental
attack, the attacker must successfully attack each brain.

Note that a character with two brains may or may not have two heads. One brain
may be located in an unexpected part of the body, or as part of a small, sickly
or undeveloped conjoined twin.

#### Empathy

The character can attune himself to the emotions of other beings and is capable
of instilling emotions in creatures who are successfully attacked with this
mutation. This mutation has a range of 90 feet.

#### Flight, Psionic

The character may fly through the air with a movement of up to INT x 10. Any
encumbrance will hinder the movement by reducing the speed at a level set by the
Referee.

#### Force Screen

This mutation allows the character to create an invisible field of energy that
is difficult to penetrate. The force screen is close to the mutant’s body,
extending only a few inches from his skin. It is capable of taking 5d6 hp worth
of damage (the Referee determines this secretly each time the power is used)
before it collapses, leaving the mutant unprotected. The power may only be used
once per day.

#### Force Screen, Greater

This force screen can be used at a range of 4’, and is capable of enclosing
other creatures. It can take 5d6 hp worth of damage before it collapses (the
Referee determines this secretly each time the power is used), and can be used
once per day. It can also be employed in the same manner as the regular force
screen.

#### Increased Willpower 

The mutant gains 4 points to his INT, and gains a bonus of +2 to saves to use
advanced technology.

#### Intellectual Affinity

Thanks to advanced thinking capabilities, the mutant gains one of the following
abilities (roll 1d6):

1-2 *Martial Affinity:* +4 to hit in combat and +1d6 damage.

3-4 *Tinkerer Affinity:* Bonus of +4 to saves to use advanced technology. The
character may also make weapons that do extra damage, up to +4. These weapons
take an extra-long time to build.

5-6 *Bartering Affinity:* +3 Charisma when trying to sell an object, and any
object sold will yield up to a multiple of 1d4+1 in profits if the person being
bartered with can afford it.

#### Killing Sphere 

This powerful mutation allows the mutant to generate a 25’ radius sphere of
deadly mental energy centered on the mutant. Within this sphere of energy all
creatures except the mutant (friend or foe!) have their hit points reduced to 1
point, and must save versus stun attacks or be knocked unconscious for 1d10
rounds. After using this mutation, the mutant is exhausted from the force of the
mental exertion and may move at full rate but not attack for 2d10 rounds.

#### Know Direction

The character is incapable of being lost, even if all other senses are somehow
nullified. He will always be able to find a location where he has been
previously, and will know its relation to any location in which he currently
resides.

#### Mental Barrier 

Any mental attacks against this mutant receive a -4 penalty to their attack
roll. A character with this mutation gains the ability to sense other creatures
that have mental mutations at a range of 90 feet. This secondary ability does
not require a roll.

#### Mental Phantasm

With this power, the mutant is capable of creating a realistic, illusory
environment in the mind of another conscious creature. These visions are
realistic to all senses but touch. Once the target tries to make physical
contact with any element of the phantasm it dissolves into reality.

#### Metaconcert 

This ability allows the mutant to link its mind with other mutants of a similar
type or those who have the same mental mutation. These include those with the
Metaconcert mutation, or other mental mutations that facilitate control between
the minds of two beings. The mutant may combine his INT with the INT of other
mutants for conducting a mental attack, or some other joint purpose.

#### Mind Reflection

The mutant may reflect any mental attack he experiences back at the attacker,
but he still suffers the effects of the attack. He may only reflect a power that
he has been successfully stricken by, and only as many times as he has been
stricken by it. The reflected power strikes the mind of the attacker, and it can
never target any other creature.

#### Mind Thrust 

The mutant is capable of firing a bolt of pure mental energy into the mind of
another creature, doing 3d6 hp damage at up to 50 feet. This ability takes time
to recharge, and can only be used every second round.

#### Neural Telekinesis 

With this mutation the character can lift or move INTx10 pounds using only the
power of his mind. This ability does not extend to lifting the mutant, however.
To the mutant, using this power feels like lifting the object with his strength,
and so requires some concentration. This ability has a range of 50 feet, and can
only be used to hold things for 5 rounds before the mutant becomes tired and
must set the objects down. The mutant must rest for 5 rounds before using the
power again.

Any use of this mutation on another creature, or objects carried by another
creature, is considered a mental attack and must be handled accordingly.

#### Neural Telepathy

Using this ability, the mutant can connect his mind with another creature’s mind
and communicate directly, even if the two creatures speak completely different
languages or are of different species. The range of this ability is 30 feet.

#### Plane Shift 

This mutation grants the power to visit realities in other dimensions. These
dimensions are accessed through temporary doors which the mutant creates using
the power of his mind. These doors appear as large portals 10’x10’ in size, and
will last for 6 rounds or until the mutant closes them intentionally. Once
entered, they cannot be exited without a mutant with this ability opening
another door. The mutant can only choose to open doors to worlds he has visited
before. Otherwise, the doorway leads to a random world of the Referee’s choice
and design. This ability only works once per week.

#### Possession 

The mutant may wrest control over another creature’s body, subjecting himself to
all of the sensations the possessed creature experiences. If the creature dies
while possessed, the mutant dies as well. During the time he possesses another
body, the body of the mutant is unconscious and vulnerable to attack. He may
relinquish control of the body at any time, and will return instantly to his own
body.

This power works at a range of 50 feet, but once inside another body the
possessor can travel any distance with no ill effects.

#### Precognition 

The mutant is capable of seeing up to 3 minutes into the future, but only with
respect to dangerous things that will affect him. If the future indicates that
he is going to suffer some form of damage, he immediately suffers 1d6 hp damage.
If he is confronted with a vision of his death or of suffering a grievous wound
that would take more than ½ of his hit points, he suffers 2d6 hp damage and
immediately enters a comatose state lasting 1 turn.

#### Quick Mind

The mutant is capable of learning how to use technology at a much higher rate of
speed than other characters (in 1/3 the time), and receives a bonus of +6 to
saves to use advanced technology. When confronted with a mental attack, an
attacker must roll to attack three times, succeeding each time (roll three times
for the one attack). Because of his incredible leaps of logic, a mutant with
this ability has a 100% chance of figuring out whether someone is telling the
truth.

#### Teleport 

This ability allows the mutant to disappear from one location and appear in a
location up to 20 miles distant without physically crossing the intervening
space. If the mutant has never been to the location he is teleporting to or is
only slightly familiar with it (Referee’s discretion) he has a 25% chance of
suffering 6d6 damage upon arrival as he teleports into a space occupied by
another object, or misjudges some aspect of the location. If he is intimately
familiar with his destination or has spent 2d4 hours conjuring an image of the
location in his mind he can teleport safely.

#### Temperature Control

With this mutation, the character can raise or lower the temperature of a
visible object within a range of 90 feet. The specific form of the power must be
determined when this mutation is acquired (50% heat, 50% cold). The mental
nature of this mutation requires concentration, and the effect is a graduated
level of damage equaling 1d6 per round. The maximum amount of damage that can be
dealt is 10d6 per round. The Referee will decide when an object or being
combusts or freezes completely.

#### Vampiric Field

This mutation grants the mutant the ability to absorb the life essence (hit
points) from all creatures (friend or foe) within a foot radius equal to 30+WIL.
This power absorbs 2d4 hp per round from all creatures in the radius, and these
absorbed points go into a separate reserve for the mutant. All damage to the
mutant is taken from these reserved points until they are gone; after this point
the mutant’s regular hp begin to be affected. Stored hp will disappear after 24
hours.

### Mental Mutation Drawbacks

#### Atrophied Cerebellum

The mutant’s brain has atrophied in certain areas due to a genetic birth defect.
As a result of this mutation, the mutant suffers a one-time –2 reduction of INT
and DEX, due to deterioration in mental capacity and coordination.

#### Dual Cerebellum (Defective)

The character has a second brain that hinders his thought processes. This brain
has 1d4 mental mutations of its own (half of which should be defects, round up),
which should be kept secret from the player until an opportunity to discover
them comes about during play. This second brain may have an entirely different
personality and motives than the character, and may try to foil the character’s
actions at inconvenient times. This is up to the Referee’s discretion. This
“Hyde” brain may attempt to take over the mutant’s body, as the mutation
*possession*, once per month for a duration of 24 hours.

#### Mind Reflection (Defective)

This defect creates a chance that mental attacks attempted by the mutant
backfire, causing injury to him instead of his enemy. The chance of this
occurring is 25%.

In the case of powers that inflict no damage, the Referee should find some way
to make the power backfire or become an inconvenience to the character.

#### Negative Empathy 

The mutant sends out waves of negative mental energy, causing *anyone* with less
than 17 Intelligence within a 90’ radius to have a 15% probability of attacking
the mutant. Only one check is necessary per person until they leave the field
and reenter it.

#### Phantasmal Damage

When the mutant is damaged, his mind radiates waves of negative energy in a
feedback loop through his nervous system that causes the effective damage from
an attack to be doubled.

#### Phobia

The mutant has an irrational fear of some creature or object. Whenever he comes
face to face with the object of his fear, he flees immediately, throwing
anything in his hands at the feared object/creature in an effort to distract or
harm it. He will flee in the opposite direction at full movement for 1d4 rounds.

Roll 1d6 to find out what category his fear falls into. The Referee will flesh
out the specifics.

| D6 | Phobia Type                            |
|----|----------------------------------------|
| 1  | Other technological (robots, vehicles) |
| 2  | Weaponry (energy weapons, other)       |
| 3  | Animal                                 |
| 4  | Plant                                  |
| 5  | Ordinary object                        |
| 6  | Insect                                 |

#### Weak Will 

The mutant’s willpower is weak. The mutant must save every hour to continue to
perform long-term tasks unless those tasks are exciting.

### Plant Beneficial Mutations

#### Abnormal Size

The plant is either much larger than normal or much smaller than the average
specimen. Roll 1d20 and multiply or divide the plant’s normal size by that
number to arrive at the new abnormal size. See *dwarfism* and *gigantism* for
potential size effects on combat.

#### Accumulated Resistance 

With this mutation, the plant has learned to change its structure to gain
complete immunity to any energy-based attack that it has experienced in the
past, including heat, cold, electricity, radiation, or energy weapons.

#### Animal Limbs or Organs

This mutation gives the plant any kind of organs or limbs normally found in
humans or animals. The player and Referee will determine the exact nature of the
new limbs or organs.

#### Animate Seeds

This mutation allows the seeds of a plant to maneuver once away from the plant.
The seeds can have their own plant mutations, but will grow up to have the same
mutations as the adult plant that spawned them.

#### Carnivore

The plant has mouths that are capable of inflicting 1d8 damage with a bite. Roll
1d12 to determine how many mouths are on the plant.

#### Chameleon Metamorph

The plant can change color or shape in order to look like any other kind of
plant, but the mass of the plant is unchanged. If the plant has a level of
intelligence it can alter the color to benefit it in other ways as well (see
*chameleon epidermis*).

#### Dermal Acid Sap

The plant’s sap is a concentrated acid that will inflict 3d6 hp damage every
round to creatures that come in contact with it.

#### Dermal Poison Sap

The sap of the plant is poisonous to creatures that come in contact with it or
ingest it. The poison effects should be determined with a roll on the poison
table.

#### Electric Charge Generation

The plant can use some of the excess energy not converted to food into a stored
electrical charge capable of damaging creatures that come in contact with it.
This electrical weapon does 4d6 hp damage, and must be recharged. The plant will
be fully charged again after four rounds, and may deliver smaller shocks
(non-damaging, but uncomfortable) every round if under constant harassment by
predators or opponents.

#### Flight

The plant has developed some way of coasting on strong winds and, if the plant
is intelligent, it may have actual winged flight. The method of flight is up to
the ML. Perhaps the plant has grown special cupped leaves or a series of light
tubules that make it structurally capable of flight. For winged flight by
modified leaves, see *complete wing development* for movement. Otherwise, the
plant’s movement rate will be heavily dependent on wind speeds.

#### Fragrance Development (Plants)

The plant can send out a scent that is enticing to all living creatures. This
scent can be smelled for a range of up to 5 miles in windy conditions, or 90
feet in regular conditions.

The enticing scent overwhelms any creature that fails a saving throw versus
poison. Every creature so enticed will stay as close to the plant as possible
and try to protect it, even to the point of fighting other creatures that draw
near. Every 5 rounds anyone enticed by the plant’s fragrance may make another
saving throw. Until the victim is successful, he will stay near the plant until
he dies from severe dehydration or starvation.

The scent itself deals no damage, but the plant may have other mutations capable
of doing so.

#### Free Movement

The plant is capable of maneuvering on its own at standard movement. This may be
through the use of leglike protrusions or by pulling itself along the ground
with vines or other branches.

#### Full Senses

The plant is capable of utilizing one or more human senses, or other senses such
as *sonar*, *thermal vision* or other unusual senses. It is up to the player and
Referee to determine how the plant uses them. If this mutation is rolled more
than once, one or more of the acquired senses may become increased as per the
*increased senses* physical mutation.

#### Grenade-Like Fruit

Plants with this mutation have pods that are explosive and deal 2d6 hp damage to
creatures within 10’. Upon exploding, the pod may also release radiation (50%)
of a randomly determined class. The range for this mutation varies based on the
size of the plant, and whether or not it is capable of moving under its own
power. If the plant is incapable of movement, the pods simply drop near the
base. If the plant is small (1’-2’), there is a 25% chance a dropped pod will
explode. If it is a medium sized plant (3’5’) there is a 45% chance, and if it
is a tree-sized plant (6 ft. or beyond), there is an 80% chance of detonation
when dropped. Extremely tall plants may have a 100% chance, or the Referee may
declare that any size plant has a higher chance because of the chemical makeup
of the pods.

Plants that are capable of movement can throw their own pods at a range
determined by multiplying the plant’s height x 10 feet.

#### Injected Poison Sap

The plant has a toxic sap that is injected when the plant’s branches or vines
are stepped on or otherwise blundered into. An intelligent plant with this
mutation may use this as an attack each round. The class of the poison is
determined randomly.

#### Natural Armor (Plant)

The plant has developed a thicker skin or shell that provides armor against
physical attacks. In all other ways this mutation resembles *natural armor* from
the human/animal mutations list.

#### Natural Vegetal Weapons

This mutation covers all types of aspects of a plant that could generally be
considered “natural”. This includes things like large thorns (up to 12 inches),
or sharp leaves capable of cutting into flesh or clothing. While dangerous on
their own, these will generally only affect characters that blunder into the
plant unaware of its danger. When such weapons are attached to plants that are
capable of attacking or moving their vines or limbs about, however, they become
very dangerous indeed.

The types of weapons covered by Natural Vegetal Weapons can do 1d3, 1d6, or
1d6+2 damage. Determine randomly by rolling 1d6; 1-2 1d3; 3-4 1d6; 5-6 1d6+2.
These weapons may have other effects decided by the ML. They may be passive, or
attached to mobile vines.

#### Poisonous Spores

Whenever the plant is disturbed, it will emit a cloud of spores. These spores
can cause any effect the player and Referee wishes. The most basic type of
poisonous spore simply has a random class of poison, but others may be
hallucinogenic, paralytic, or allergy inducing. All will allow a saving throw
versus poison.

#### Prehensile Tendrils

These plant growths are capable of movement and a rudimentary sense of touch.
Prehensile tendrils come in two forms, Simple and Constrictive. Roll 1d6:

1-3 *Simple tendrils:* These have a randomly determined (3d6) DEX and are
capable of wielding weapons, but are not strong enough to do damage on their
own. Higher DEX scores are due to aspects of the plant that make it more
dexterous, like sticky fibers and clingy cilia.

4-6 *Constrictive Tendrils:* These tendrils can do 2d6 damage through
constriction and are capable of rapid movement. A successful attack roll
achieves constriction, and the victim will suffer damage on each consecutive
round.

Because the growth pattern of such plants dictates that the tendrils grow to
full size quickly, even small plants with this mutation are considered to have
tendrils at least 10’ long, and are capable of growing their tendrils to any
length the Referee desires. To randomly determine the length of the tendrils,
simply multiply the base of 10’ by a roll of: 1d6 for small plants, 2d6 for
medium sized plants, or 1d20 for large or tree sized plants.

#### Projectile Thorns

The plant is endowed with a substantial number of thorns. These thorns are
capable of being thrown if the plant has mobility and any level of intelligence.
The throwing range of these thorns is like a dagger, and they deal 1d4 hp damage
if they strike a creature. Some plants (50%) grow thorns that are covered with
toxins. Determine the class of the poison randomly.

#### Radioactive Emissions

The plant has become irradiated through mutation, and is capable of giving off a
randomly determined class of radiation at a range of 150’. A good sized patch of
these plants is capable of clearing a large area of animals and other radiation
sensitive creatures, and will often become a safe haven for creatures that are
immune to the effects of radiation.

#### Reflective Cellular Structure

The plant’s skin is essentially impenetrable to a randomly determined form of
energy. Roll 1d8; 1-2 electricity; 3-4 heat; 5-6 cold; 7-8 radiation.

#### Shriek (Plant)

Whenever a plant with this mutation is damaged, it gives off a piercing shriek
that is capable of damaging everyone within a 30’ radius. This strange attack
does not harm other similar plants. The shriek causes 3d6 damage (save versus
stun attacks for half), and may be used every 4 rounds until the plant is
killed. Mutants with the *echolocation* mutation suffer a -2 penalty to save. If
a large patch of these plants is injured all at once, such as when they are
trampled by large creatures or vehicles roll 3d10 for damage instead of 3d6. An
intelligent plant may use this ability every 4 rounds at will.

#### Thermal Emissions

The plant is capable of generating a ray of heat or cold (50%) capable of doing
4d6 damage to those it comes in contact with. Depending on the size of the
plant, it may have 1d3 heat or cold emitting flowers or branches. The range of
this attack is 50 feet. The Referee may determine if there is a difference
between intelligent plants and other plants with regard to this power. A
suggested difference is a -2 attack adjustment for plants with no higher order
mental functions.

#### Tripping Tendrils

These tendrils have a very low strength (1d6-1), and are capable of only very
slow movement. Given enough time, however, they can crush a small or weakened
creature in their grasp. Once in position, without resistance, they may inflict
1d6 hp damage per round. The plant usually grows a large patch (2d10 feet in
diameter) of these vines to trip victims. Victims who fall unconscious on vines
such as these are not likely to waken.

#### Vegetal Parasite

If the plant can attack and latch onto another creature for 3 rounds (one
successful attack roll for three consecutive rounds), it will maintain control
over the creature as long as the two are in physical contact. Plants will
usually use these controlled bodies for protection or food, and a plant may
control as many creatures as it has limbs to touch them.

### Plant Mutation Drawbacks

#### Nocturnal

The plant is completely motionless during daylight hours. As soon as the sun
dips below the horizon or the plant is in full shadow for 1d6 rounds, however,
it will begin to move or otherwise act if it is able.

#### Prey Scent

The plant sends out waves of scent that attracts predators. In the case of a
mobile, intelligent PC plant, the Referee may increase the chances of
encountering some types of monsters.

#### Reduced Fertility 

Very few of these plants will exist in one localized area. With human
intervention, this trait can be bred out of a plant type in a number of
generations through the application of advanced horticulture practices.

#### Thermal Sensitivity

The plant is susceptible to heat or cold (50%). Such energy based attacks deal 2
extra points per die of damage in addition to the regular damage inflicted.

<br><br><br>Section VII:<br>Superpowers
=======================================

### Introduction

This section contains guidelines for characters with “comic book” style
superpowers. These superpowers are considerably less powerful than many you will
find in comic books today. They have more of a “golden age” feel. While the
Referee could use them to run a lower-powered comic book superhero game with the
Original Edition rules, their primary purpose is for gonzo play. For example,
Original Edition characters visit an alternate dimension that has superpowered
characters or a mad sorcerer opens a gate to hell to summon some demons and
opens a gate to a superhero world and their summons brings a supervillain or two
instead of the demons they wanted.

These guidelines allow the Referee to create superpowered characters that are
compatible with Original Edition rules. To do so, just pick the powers the NPC
super needs at the Power Levels that best model the character. Most such NPCs
should have 2 to 4 powers. If you are trying to create an NPC with abilities
similar to a particular character from a comic book, TV show, or film, just
select powers that the comic book hero uses often. Most comic book heroes
accumulate so many powers over the years that trying to duplicate them all would
make them overpowered. Guidelines are provided below for which powers are often
associated with the various types of superpowered characters in comic books.
They will make it easier to quickly create comic book-like NPCs with
superpowers.

Of course, it is possible to use these powers to run a campaign where the
characters have superpowers, and simple guidelines are provided later for
Referees that want to try this, however, they are not play tested to any real
extent.

### Character Types

Comic book supers tend to fall into one of the following basic types. The powers
listed for each type of super are just the most common powers associated with
that type, others are possible just less common.

#### The Brick

The Brick is a muscular character capable of great feats of might and/or
resilience. Base such characters on the Fighter class. At first level, give them
two powers from the list below. They receive an additional power at level 3,
level 5, level 7, and level 9.

Common Brick Powers:

-   Fast Healing

-   Growth

-   Indestructibility

-   Natural Weapon

-   Super Constitution

-   Super Leap

-   Super Strength

-   Super Weapon\*

-   Tunneling

#### The Daredevil

The Daredevil is a figure in the shadows, an expert in stealth, agility and
acrobatic feats. Base such characters on the Thief class. At first level, give
them two powers from the list below. They receive an additional power at level
3, level 5, level 7, and level 9.

Common Daredevil Powers:

-   Danger Sense

-   Meta Senses

-   Phase

-   Super Constitution

-   Super Dexterity

-   Super Leap

-   Super Wisdom

-   Super Senses

-   Super Speed

-   Tunneling

#### The Elementalist

The Elementalist is a pugilist, weaponeer or expert in kung fu that relies on
his or her martial training. Base such characters on the Specialist class. At
first level, give them two powers from the list below. They receive an
additional power at level 3, level 5, level 7, and level 9.

Common Elementalist Powers:

-   Absorption

-   Darkness

-   Elemental Form

-   Energy Blast

-   Flight

-   Force Field

-   Life Support\*

-   Phase

-   Super Constitution

-   Super Wisdom

-   Tunneling

-   Weather Control

#### The Gadgeteer

The Gadgeteer is character who designs and creates weird scientific devices
including battlesuits and weapons. Base such characters on the Specialist class.
Many of their powers may be in the form of gadgets. Choose any two Powers from
the Powers list at levels 1, 3, 5, and 7.

Common Gadgeteer Powers

-   Gadgeteers have a choice of any of the Powers. These are built into an item,
    device, gizmo or other piece of equipment. Some devices have several Powers
    built into them (often a Battlesuit, maybe with Flight, Indestructibility
    and Energy Blast) and others just have the one power. Devices can be removed
    from the Gadgeteer, so sometimes it’s preferable not to “put all your eggs
    in one basket”.

#### The Martial Artist

The Martial Artist is a being who has power over the elements of earth, air,
fire or water. Base such characters on the Fighter class. At first level, give
them two powers from the list below. They receive an additional power at level
3, level 5, level 7, and level 9.

Common Martial Artist Powers:

-   Danger Sense

-   Meta Senses

-   Natural Weapon

-   Super Constitution

-   Super Dexterity

-   Super Leap

-   Super Senses

-   Super Strength

-   Super Weapon

-   Super Wisdom

#### The Metamorph

The Metamorph is a character who has control over his own body shape and form.
Base such characters on the Fighter class. At first level, give them two powers
from the list below. They receive an additional power at level 3, level 5, level
7, and level 9.

Common Metamorph Powers:

-   Absorption

-   Aquatic Adaptation\*

-   Duplication\*

-   Elasticity

-   Fast Healing

-   Growth

-   Heal Others\*

-   Life Support\*

-   Phase

-   Power Mimic\*

-   Shape Change

-   Shrink

-   Super Constitution

-   Teleport

-   Tunneling

#### The Mystic

The Mystic is a mysterious student of arcane powers. Base such characters on the
Magic-User class. At first level, give them one power from the list below. They
receive an additional power at level 3, and level 5. In addition, they can use
magic just like a magic-user.

Common Mystic Powers:

-   Heal Others\*

-   Meta Senses\*

-   Super Charisma

-   Super Intelligence

-   Super Wisdom

#### The Psychic 

The Psychic is a strong-willed individual with powers of the mind. Base such
characters on the Thief class. At first level, give them two powers from the
list below. They receive an additional power at level 3, level 5, level 7, and
level 9

Common Physic Powers:

-   Danger Sense

-   Darkness\*

-   Heal Others\*

-   Meta Senses

-   Mental Blast

-   Mind Control

-   Phase

-   Super Charisma

-   Super Intelligence

-   Super Wisdom

-   Super Senses

-   Telekinesis

-   Telepathy

-   Teleport

### Powers

This is a list and explanation of available superpowers. The list and the sorts
of effects of the superpowers are not exhaustive. If the players invent other
uses for a power that seem reasonable then go with it. A power’s Power Level is
equal to the number of levels a character has possessed the power – not the
character’s level. Powers selected at a character level other than 1st, start
out with a Power Level of 1. Where a Power has a set duration, the Power cannot
be used again until the character has waited at least the same duration between
uses. Powers that require activation are only “on” when the super specifically
activates them.

#### Absorption

Character’s body absorbs energy and energy attacks of a specific type (fire,
electricity, radiation etc.) chosen when character first gain the power.

*Range*: Self *Activation*: No *Duration*: Continuous

**Power Level 1**: Character can absorb 2d4 damage received from an energy
attack.

**Power Level 2**: Character can absorb 2d6 damage received from an energy
attack.

**Power Level 3**: Character can absorb 2d8 damage received from an energy
attack.

**Power Level 4:** whatever damage character absorbed can now be used to recover
lost HP.

**Power Level 5**: Character can choose another energy type to absorb.

**Power Level 6**: Character can choose a third energy type *or* character can
absorb 3d6 damage received from an energy attack.

#### Aquatic Adaptation

Character is perfectly suited for aquatic life. Character’s body can draw oxygen
from water as easily as it can from air (although character does not lose the
ability to breathe air), and it has external changes that make swimming easier,
such as streamlining and webbed digits.

*Range*: Self *Activation*: No *Duration*: Continuous

**Power Level 1**: Character can breathe water (maybe with gills, if character
wish), and swim at 12 yards per round and out of combat their swim speed is 24
mph.

**Power Level 2**: Character can swim at 24 yards per round and out of combat
their swim speed is 48 mph.

**Power Level 3**: Character is unaffected by water pressure and the coldness of
the depths.

**Power Level 4**: Character can emit high-frequency sound and translate the
echoes that return to character into a three- dimensional mental picture of
their surroundings (sonar).

**Power Level 5**: Character can swim at 36 yards per round and out of combat
their swim speed is 72 mph.

**Power Level 6**: Character can swim at 48 yards per round and out of combat
their swim speed is 96 mph. Character can also communicate with fish and other
aquatic creatures.

#### Danger Sense

Warning alarms go off in character’s head when threats to their well-being are
nearby.

*Range*: Self *Activation*: No *Duration*: Continuous

**Power Level 1**: Character gets a prickly sensation that something is wrong
when danger is present.

**Power Level 2**: Character cannot be surprised even if the rest of character’s
team are.

**Power Level 3**: Character can tell something more about the threat – how much
is determined by the Referee.

**Power Level 4**: Character gets a prickly sensation when one of character’s
team is in danger – even if they are miles away

**Power Level 5**: Character gets an indistinct picture in character’s head of
the approximate nature of the threat

**Power Level 6**: Character gets a clear picture in character’s head of the
exact nature of the threat

#### Darkness

This Power causes darkness in an area defined by character that is within
character’s ability. Sonar and similar powers will work in this area.

*Range*: 10 yards per PL *Activation*: Yes *Duration*: 2 turns per PL

**Power Level 1**: Character can create an area of 10 x 10 yards of darkness
that mundane folk are unable to see in, but creatures with night-vision (like
cats) or super senses (sight) can see in. Character gain dark vision that allows
character to see in their own created darkness (but not in other darkness).

**Power Level 2**: Character can create a larger area of darkness (30 x 30
yards) as above or a 10 x 10 yards area of darkness that even those with night
vision or super-senses (sight) cannot see in. Super senses like infra-red vision
and sonar still work. Character gains their choice of infra-red vision or sonar
(that only works in the darkness character create).

**Power Level 3**: Character can create a larger area of darkness – 50 x 50
yards as above or a 20 x 20 yard area that those with night sight cannot see in.

**Power Level 4**: Character can create a larger area of darkness – 100 x 100
yards as above or a 30 x 30 yard area that those with night sight cannot see in.

**Power Level 5**: Character can merge their body with the darkness that
character has created and move in it at their normal move rate within it.

**Power Level 6**: Character can merge with the darkness character create and
instantly re-appear anywhere within it (similar to teleport).

#### Duplication

Character can create one or more perfect duplicates of themself. Each duplicate
is exactly like the character, possessing all of their abilities and Powers
except for Duplication. If character is wounded, the duplicates will also be
wounded.

*Range*: 50 yards per PL. *Activation*: Yes *Duration*: 1 turn per PL

**Power Level 1**: Character can create one duplicate of themself. Character has
a “link” to their duplicate so it will do as character will it.

**Power Level 2**: Character can create two duplicates of themself.

**Power Level 3**: Character can create three duplicates of themself.

**Power Level 4**: Character can create four duplicates of themself.

**Power Level 5**: Character can create five duplicates of themself.

**Power Level 6**: Character can create six duplicates of themself.

#### Elasticity

Character’s body can stretch and twist without damaging bones or internal
organs. This gives character incredible reach and flexibility of motion. As the
power improves, character can even mold their body into special shapes (for
example, character could mold their finger into the shape of a keyhole).

*Range*: Self *Activation*: No *Duration*: Continuous

**Power Level 1**: Character’s arms/legs can stretch up to triple normal length.
Reach of melee attacks is 4 yards. Character gains a +4 bonus to c*limb and
escape from bonds* checks and can move at +2 yards.

**Power Level 2**: Character’s limbs and neck can stretch and twist, and their
hands and fingers even can be molded into different shapes. Character’s reach
for melee attacks is 8 yards. Character gains a +6 bonus to *climb* and *escape
from bonds* checks and can move at +3 yards. Their body is so elastic that
damage received from weapons (except sharp/edged weapons) is reduced by 1.

**Power Level 3**: Character’s whole body can stretch and twist and even can be
molded into different shapes. Reach of melee attacks is 12 yards. Character
gains a +8 bonus to *climb* and *escape from bonds* checks and can move at +4
yards. Their body is so elastic that damage received from weapons (except
sharp/edged weapons) is reduced by 2.

**Power Level 4**: Character can make the area between character’s arms and body
into “wing-like” membranes so that character can glide for short distances of up
to 20 yards. Also, range of melee attacks can now be extended to 16 yards and
character can move at +5 yards.

**Power Level 5**: Character can glide for 40 yards. Character’s body is so
rubbery as to reduce damage caused by non-edged weapons by 3 points. Character
can automatically escape from bonds within a minute. Character can move at +6
yards.

**Power Level 6**: Character can effectively “melt” their body so that it
becomes like a viscous liquid. Their body is so elastic that damage received
from weapons (except sharp/edged weapons) is reduced by 4.

#### Elemental Form

Character can convert their whole body (or parts of their body) and their
personal equipment into one type of elemental energy. As the power improves,
character can transform more quickly and more often. Character must specify the
form (air, earth, electricity, fire, ice or shadow) when the power is acquired.

*Range*: Self *Activation*: Yes *Duration*: 2 turns per PL

**Air**: Character may fly at 60 yards per round but out of combat character can
fly at 120 mph. Character can be invisible or character can resemble a
mini-tornado. Missile weapons (arrows, thrown spears and knives) are blown away
from you, giving character an effective AC of 5 [14] (4 [15] at 5th PL, and 3
[16] at 6th PL. At 4th PL plus character can fly at 80 yards per round but out
of combat character can fly at 200 mph.). Character may merge with the natural
air. Character cannot be damaged by normal weapons as they just go through you.
Character can manipulate the air around character – blowing out candles, blowing
wind into ship’s sails and so on. Generally, it cannot be used to attack for
damage but it can be used in interesting ways, subject to Referee approval.

**Earth**: Character receives AC 5 [14] (4 [15] at 4th PL) and damage is reduced
by 1 per PL on a hit due to character’s rock-like body. Their fists do 1d6
damage on a hit. Their STR is increased by +1 at first PL, +2 at 2nd PL and +3
at 3rd PL, +4 at 4th PL, +5 at 5th PL and +6 at 6th PL. Character move at half
normal speed. Character can merge with the earth and move through it at 4 yards
per round (5 yards at 5th PL and 6 yards at 6th PL). Character can manipulate
the earth around character – forming earthworks and pits in the ground and so
on. Generally, it cannot be used to attack for damage but it can be used in
interesting ways, subject to Referee approval.

**Electricity**: Character may fly at speed 40 yards per round but can “bolt” at
200 yards in a straight line. Character takes half damage from electrical shock.

Character’s melee attacks cause + 1d4 damage from electric shock. This increases
to 1d6 at 2nd PL and 1d8 at 3rd PL. Character can short out electronic equipment
by touch. Water or rain causes character to deactivate. At 4th PL plus,
character may fly at speed 50 yards per round but can “bolt” at 300 yards in a
straight line. Character can merge with natural electricity or in machinery.
Character can manipulate electricity around character – redirecting it and so
on. Generally, it cannot be used to attack for damage but it can be used in
interesting ways, subject to Referee approval.

**Fire**: Character take half damage from heat and fire damage, but are
vulnerable to cold (x2 damage). Character gets+1d4 to their melee attacks from
fire damage. This increases to +1d6 at 2nd PL and +1d8 at 3rd PL. Additionally,
character can set ablaze adjacent vegetation and combustible objects (not
people) by touch. At 4th PL plus, character can merge with any fire and move
within it at 6 yards per round (9 at 5th PL and 12 at 6th PL). Character can
melt ice up to 20 yards away, in a 3 yard x 3 yard area per round. Character can
manipulate fires that are already there – increasing or reducing their intensity
and so on. Generally, it cannot be used to attack for damage but it can be used
in interesting ways, subject to Referee approval.

**Ice**: Character has 5 [14] AC due to ice-hard body. Character takes half
damage from cold damage, but vulnerable to fire (x2 damage). Character gets+1d4
cold damage to all their melee attacks due to cold. Character can extinguish
flames or freeze liquids in a 10x10- foot area by touch as a standard action. At
4th PL plus, character can merge with any ice and move within it at 6 yards per
round (9 at 5th PL and 12 at 6th PL). Character can manipulate ice around
character into chutes and slides to increase their movement speed, create ice
walls and so on. Generally, it cannot be used to attack for damage but it can be
used in interesting ways, subject to Referee approval.

**Shadow**: Character can see perfectly in darkness. Character receives a +6
bonus on *Hide in Shadows Task Checks* in low light or in darkness. Character
cannot be damaged by normal weapons as they just go through you. By a partial
change, character can play with shadows across their face to mask their
features. At 4th PL, plus character can merge with any shadows and character can
also manipulate their own or other people’s shadows. Generally, it cannot be
used to attack for damage but it can be used in interesting ways, subject to
Referee approval.

#### Energy Blast

Character can shoot a beam of one kind of energy (cold, electricity, fire,
force, radiation, or sonic damage) from their eyes or hand (character must
specify the type of energy and how the beam is fired when the power is first
acquired). Character has to make a “To Hit” roll to affect their target.
*Character can split the damage dice between targets if character wish (so at
1st PL character could attack 2 targets at 1d4 damage each).*

*Range*: 50 ft per PL *Activation*: Yes *Duration*: Immediate

**Power Level 1**: Character’s blast does 2d4 damage on a hit.

**Power Level 2**: Character’s blast does 2d6 damage on a hit.

**Power Level 3**: Character’s blast does 2d8 damage on a hit.

**Power Level 4**: Character gets+2 “To Hit” their target(s).

**Power Level 5**: Character’s blast does 3d8 damage on a hit.

**Power Level 6**: Character’s blast does 4d8 damage on a hit *or* character can
have an additional +3 “To Hit”.

#### Fast Healing

Character possesses accelerated natural healing. Wounds close up and body parts
regenerate all on their own.

*Range*: Self *Activation*: No *Duration*: Continuous

**Power Level 1**: Character automatically recovers 1HP per round. Character
receives a +1 bonus to their *Saving Throws* vs. death.

**Power Level 2**: Character automatically recovers 2HP per round. Character
receives a +2 bonus to their *Saving Throws* vs. death.

**Power Level 3**: Character automatically recovers 3HP per round. Character
receives a +3 bonus to their *Saving Throws* vs. death.

**Power Level 4**: Character automatically recovers 4HP per round. Character
receives a +1 bonus to their *Saving Throws* vs. poisons or other illnesses.

**Power Level 5**: Character automatically recovers 5HP per round and receives a
+2 bonus to their *Saving Throws* vs. poisons or other illnesses.

**Power Level 6**: Character automatically recovers 6HP per round. Character
receives a +4 bonus to their *Saving Throws* vs. death.

#### Flight

Character can fly through the air. Perhaps their spirit energy powers the
flight. Possibly character can create an anti-gravity body field. As a
limitation, character might actually need to sprout physical wings to fly.

*Range*: Self *Activation*: No *Duration*: Continuous (but see below)

**Power Level 1**: Character can fly at 60 yards per round. Out of combat,
character fly at 60 mph.

**Power Level 2**: Character can fly at 120 yards per round. Out of combat,
character fly at 120 mph.

**Power Level 3**: Character can fly at 240 yards per round. Out of combat,
character fly at 240 mph.

**Power Level 4**: Character can switch to Hyper Flight for up to an hour. This
means out of combat character can multiply their speed by x5 mph.

**Power Level 5**: Character can switch to Hyper Flight for up to 2 hours. This
means out of combat character can multiply their speed by x10 mph.

**Power Level 6**: Character can switch to Hyper Flight for up to 3 hours. This
means out of combat character can multiply their speed by x20 mph.

#### Force Field

Character can generate a protective barrier of force (visible like faintly
colored glass) that deflects attacks and absorbs physical damage. As the power
improves, character can even extend the field to protect others nearby.
Character may keep concentrating on the *Force Field* and it will stay up as
long as character concentrate. Once you’ve stopped concentrating it lasts 1
minute per PL.

*Range*: 2 yards per PL *Activation*: Yes *Duration*: 1 minute per PL\*.

**Power Level 1**: Character’s AC is 5 [14] and the force field absorbs 1 damage
received from hits.

**Power Level 2**: Character’s AC is 4 [15] and the force field absorbs 2 damage
received from hits.

**Power Level 3**: Character’s AC is 3 [16] and the force field absorbs 3 damage
from hits.

**Power Level 4**: Character can make their force field into a battering ram to
shove things away from you. It has the equivalent of a 21 STR and can be forced
away from character pushing anything behind it at a rate of 6 yards per round.

**Power Level 5**: Character’s AC is 2 [17] and the force field absorbs 4 damage
from hits.

**Power Level 6**: Character’s AC is 1 [18] and the force field absorbs 5 damage
from hits.

#### Growth

Character can greatly increase their height and mass. As character grow
increasingly larger, their physical might and toughness are magnified. Character
can attack enemies at a greater distance from character with their increased
reach.

*Range*: Self *Activation*: Yes *Duration*: 2 turns per PL

**Power Level 1**: Character can grow to 12 ft tall. Character gain +2 Strength
and +4 HP. Character can also move an extra 2 yards.

**Power Level 2**: Character can grow to 24 ft tall. Character gain +4 STR and
+8 HP. Character can also move an extra 4 yards.

**Power Level 3**: Character can grow to 36 ft tall. Character gain +6 STR and
+12 HP. Character can also move an extra 6 yards.

**Power Level 4**: Character can grow to 48 ft tall. Character gain +7 Strength
and +14 HP. Character can also move an extra 8 yards.

**Power Level 5**: Character can grow to 60 ft tall. Character gain +8 STR and
+16 HP. Character can also move an extra 10 yards.

**Power Level 6**: Character can grow to 72 ft tall. Character gain +9 STR and
+18 HP. Character can also move an extra 12 yards.

#### Heal Others

By laying their hand on a living creature, character channel positive energy
that cures damage and illnesses.

*Range*: Touch\* *Activation*: Yes *Duration*: Immediate

*At each level character attain, character can add one of these options
(character may only use each once per adventure but character can choose each
option more than once)*:

Character can heal 2d4+1 points of damage.

Character can neutralize poison in an affected person.

Character can cure any disease a person might be suffering from.

Character can restore a person affected by paralysis

Character can restore a person affected by environmental conditions (heat, cold,
radiation etc.)

Character’s Power can be used at a range of 10 yards (if character choose this
again, the range is doubled)

#### Indestructibility

The resilience of character’s body and/or spirit provides a bonus to their AC.
As the power improves, character grow especially resistant to damage from lethal
weapons. The power is a part of their being and does not normally have to be
specially activated.

*Range*: Self *Activation*: No *Duration*: Continuous

**Power Level 1**: Character gets 5 [14] AC and their body absorbs 1 point of
damage received from hits.

**Power Level 2**: Character gets 4 [15] AC and their body absorbs 2 points of
damage received from hits.

**Power Level 3**: Character gets 3 [16] AC and their body absorbs 3 points of
damage received from hits.

**Power Level 4**: Character gets 2 [17] AC and their body absorbs 4 point of
damage received from hits.

**Power Level 5**: Character gets 1 [18] AC and their body absorbs 5 points of
damage received from hits.

**Power Level 6**: Character gets 0 [19] AC and their body absorbs 6 points of
damage received from hits.

#### Life Support

Character can survive under conditions that would be hazardous to most living
creatures and/or ignore some biological needs.

*Range*: Variable *Activation*: No *Duration*: continuous

*At each PL character attain, character can add one of these options*:

Character need not breathe. Character has no need for oxygen. Since character
does not breathe, character is immune to gaseous attacks that affect
respiration.

Character need not eat or drink. Character either do not require food and water,
or character draw enough out of their environment for their needs.

Character need not sleep. Character does not sleep and, thus, have a lot more
free time on their hands.

Character is disease resistant. Character is completely immune to diseases

Character is poison resistant. Character is completely immune to poisons

Character is pressure resistant. Character is immune to natural low- and
high-pressure extremes. If character does not breathe, character can function in
space without a suit (though temperature extremes and radiation can still be a
problem).

Character is radiation resistant: Character is immune to natural ambient
radiation and radiation-based attacks.

Character is temperature resistant: Character is immune to low and high
temperatures (cold/heat).

#### Mental Blast

With the power of their mind character can send a pulse of pure mental force to
batter their enemies. Targets get a *Saving Throw*. Success means they take half
damage. *Character can split the damage dice between targets if character wish
(so at 1st level character could attack 2 targets at 1d4 damage each).*

*Range*: 20 yards per PL *Activation*: Yes *Duration*: Immediate

**Power Level 1**: Character’s blast does 2d4 damage on a hit.

**Power Level 2**: Character’s blast does 2d6 damage on a hit.

**Power Level 3**: Character’s blast does 2d8 damage on a hit.

**Power Level 4**: Character’s target(s) get -2 on their *saving throw*.

**Power Level 5**: Character’s blast does 3d8 damage on a hit.

**Power Level 6**: Character’s blast does 4d8 damage on a hit *or* their targets
get -2 on their *saving throw* (-4 in total).

#### Meta Senses

Character has senses that are not normally found in human beings. Each level
character attain in this power character may choose one Meta Sense. Most of the
meta-senses automatically switch between normal senses and meta sense as
required.

*Range*: Variable *Activation*: No, but see below *Duration*: Continuous

**Extra-Dimensional Vision**: Character can see into alternate dimensions as if
character were standing in the same spot in that dimension (which overlaps with
our own world). This is an activated power.

**Extra**-**Dimensional Hearing**: Character can listen in on sounds in
alternate dimensions as if character were standing in the same spot in that
alternate world. This is an activated power.

**Infrared Vision**: Character can see heat the way most people see light. This
allows character to see in the dark but only to perceive creatures and objects
that are not at room temperature (cold objects appear dark, while warm objects
appear bright).

**Radar**: Character can emit radio waves and translate the echoes that return
to character into a three-dimensional mental picture of their surroundings. In
effect, character can “see” in total darkness and cannot be blinded as long as
their radar sense is operating normally.

**Radio Hearing**: Character can tune into radio waves (AM, FM and police band)
to listen to broadcasts. Character can also detect the presence of radio waves
created by radar.

**Sonar**: Character can emit high-frequency sound and translate the echoes that
return to character into a three-dimensional mental picture of their
surroundings. In effect, character can “see” in total darkness and cannot be
blinded as long as their sense of hearing is operating normally.

**X-Ray Vision**: By taking one action to refocus their eyes, character can see
through most materials, as if they were not there (they appear to be only filmy,
translucent shadows).

**360-degree Vision**: Character’s peripheral vision is total – character can
see in every direction, without turning their head.

#### Mind Control

Character can dominate people with their psychic strength of will.

*Range*: 10 yards per PL *Activation*: Yes *Duration*: 1 turn per PL

**Power Level 1**: Character can dominate up to 2d4 NPCs (citizens, thugs,
henchmen etc.), subjecting them to their control. A *Saving Throw* is allowed if
character attempt to make them perform an action that is against their normal
nature or morals.

**Power Level 2**: Character can now exert domination against another
superhero/villain or up to 3d4 normal NPCs.

**Power Level 3**: Character can now exert domination against two
superheroes/villains or up to 4d4 normal NPCs.

**Power Level 4**: Character’s mundane target(s) receive -2 to their saving
throws against domination.

**Power Level 5**: Character can dominate up to 4d6 NPCs.

**Power Level 6**: Character’s mundane target(s) receive another -2 to their
saving throws against domination. Superhero target(s) receive -2 against
domination.

#### Natural Weapon

Character’s body generates or contains a natural melee weapon. Fists could be
augmented by a magnetic field. Bone spikes or metallic claws could spring from a
hand or arm. Spirit power could create an energy blade. Character must specific
the exact nature of the weapon (bone, metal, or force/energy; bludgeoning,
slashing, or piercing) when the power is acquired. The weapon cannot be broken
or (very rarely, if ever) taken from you.

*Range*: Melee (2 yards) *Activation*: Yes *Duration*: Continuous until
deactivated

**Power Level 1:** the weapon does 2d4 damage on a hit. Character’s “To Hit”
roll is made at +1

**Power Level 2:** the weapon does 2d6 damage on a hit. Character’s “To Hit”
roll is made at +2

**Power Level 3:** the weapon does 2d8 damage on a hit. Character’s “To Hit”
roll is made at +3

**Power Level 4**: Character gain another +2 “to hit” with the weapon

**Power Level 5:** the weapon does 3d8 damage on a hit.

**Power Level 6**: Character gain another +2 “to hit” with the weapon.

#### Phase

Character can shift their body partly into another dimension. Enemy attacks can
pass through the displaced image of their body. As the power improves, character
can pass through walls.

*Range*: Self *Activation*: Yes *Duration*: 1 turn per PL

**Power Level 1**: Character can either turn invisible *or* turn incorporeal.
Invisibility means that character cannot be seen if staying still, but some
trace of their movement might be detected with a *Notice* check. Incorporeal
means character can walk through walls, cannot be harmed by mundane weapons but
character also cannot affect physical things themself.

**Power Level 2**: Character can add invisibility or incorporeality (whichever
character didn’t choose at 1st level).

**Power Level 3**: Character can “flicker” between incorporeality and
non-incorporeality. This means character can affect physical things on their
action but are incorporeal when attacked.

**Power Level 4**: Character can make an object or other person invisible *or*
incorporeal as long as character is touching them.

**Power Level 5**: Character can make an object or other person invisible *or*
incorporeal (whichever character didn’t choose at 5th level).

**Power Level 6**: Character can make everything or everyone in a 5 yard area
around character invisible.

#### Power Mimic

Character can copy the Powers of others so that character can use them themself.

*Range*: Variable *Activation*: Yes *Duration*: 1 turn per PL\*

**Power Level 1**: Character can mimic the power of someone character has
recently seen using the power, but character must also touch them. Character can
mimic the power at the lowest of their level in Mimic or the target’s level in
their Power.

**Power Level 2**: Character can mimic the power of someone character has seen
using the power within the last 6 turns. Character no longer needs to touch
their target but character must still be able to see them (they don’t need to be
using their power at the time).

**Power Level 3**: Character can mimic the power of someone you’ve seen using
the power within the last 12 turns. Character no longer needs to see the person
to recall how they used the power.

**Power Level 4**: Character may mimic a power character has seen used within
the last day.

**Power Level 5**: Character may mimic a power character has seen used within
the last week.

**Power Level 6**: Character can use the power at their own level, even if the
target’s power is at a lower level.

#### Shape Change

Character can assume the form of another living creature. The range of forms
character can take is based on their level. Character gains all of the
creature’s natural (non-magical, non-Powered) abilities; for example, character
can fly, if character is a bird; breathe water, if character is a fish.
Character keeps their own Powers, as long as they do not require a different
physique, e.g., winged flight would be lost, if character turn into a dog.
Character’s physical attributes are the same as those of the creature in
question but their mental attributes and hit points are their own. Their
clothing does not usually alter with you.

*Range*: Self *Activation*: Yes *Duration*: 2 turns per PL

**Power Level 1**: Character can assume the form of any single natural creature.

**Power Level 2**: Character can choose several different forms drawn from a
general type (e.g., birds, reptiles, fish, and land mammals).

**Power Level 3**: Character can assume the form of any creature character has
actually seen (it needn’t be a “natural” creature but must be living.

**Power Level 4**: Character can assume the form of any single object or piece
of machinery.

**Power Level 5**: Character can change into the likeness of someone character
knows or have seen.

**Power Level 6**: Character can assume the form of any creature character wish.

#### Shrink

Character can greatly decrease their height and mass. Character become
increasingly harder to find and hit, and character can squeeze through ever
tinier spaces. However, smaller bodies are slower-moving, weaker, and have
shorter reach.

*Range*: Self (and see below) *Activation*: Yes *Duration*: 2 turns per PL

**Power Level 1**: Character can shrink to 2 ft tall. Character gain +2 AC and
+2 on *Move Silently* and *Hide in Shadows* checks. Their STR is reduced by -2.

**Power Level 2**: Character can shrink to 6 inches. Character gain +4 AC and +4
on *Move Silently* and *Hide in Shadows* checks. Their STR is reduced by -4.

**Power Level 3**: Character can shrink to 1 inch. Character gain +6 AC and +6
on *Move Silently* and *Hide in Shadows* checks. Their STR is reduced by -6.

**Power Level 4**: Character can shrink to about a fraction of an inch. At this
scale character cannot really be seen by anyone without super sight. Character
also cannot attack for melee damage although if character has energy blasts and
so on, character can still use these. Character has only 1 HP.

**Power Level 5**: Character can shrink to about the size of an atom. At this
level character follow the laws of atomic physics.

**Power Level 6**: Character can shrink to the level of a sub-atomic particle.
At this level character follow the laws of quantum physics.

#### Super Charisma

Character possesses incredible presence, making character hard to ignore and
attractive to just about everyone.

*Range*: Self *Activation*: No *Duration*: Continuous

**Power Level 1:** increase character’s Cha to 18. If it is already 18 roll 1d4
and add it to their Cha.

**Power Level 2**: Character’s Cha is increased by +1d4 and once per adventure
character can “charm” someone (no roll needed except other superheroes/villains,
who get a *Saving Throw* at -2) to give character information, give character
access to restricted areas or give character something else that character need.

**Power Level 3**: Character’s Cha is increased by +1d4 and character gets the
1st level *Mind Control* ability. Their version is more gently persuasive rather
than dominating though.

At each level beyond 3rd, roll 1d4 and add it to their Cha.

#### Super Constitution

Character possesses incredible vitality and resilience.

*Range*: Self *Activation*: No *Duration*: Continuous

**Power Level 1:** increase character’s Con to 18. If it is already 18 roll 1d4
and add it to their Con.

**Power Level 2**: Character’s Con is increased by +1d4 and once per adventure
character may re-roll a failed saving throw vs. death, poison, radiation,
heat/cold or pressure.

**Power Level 3**: Character’s Con is increased by +1d4 and once per adventure
character can automatically succeed a *Saving Throw* vs. any of the above
effects. At each level beyond 3rd, roll 1d4 and add it to character’s Con.

#### Super Dexterity

Character possesses incredible dexterity, making character remarkably deft at
feats of coordination and agility.

*Range*: Self *Activation*: No *Duration*: Continuous

**Power Level 1:** increase character’s Dex to 18. If it is already 18 roll 1d4
and add it to character’s Dex.

**Power Level 2**: Character’s Dex is increased by +1d4 and character gets +1 to
Task Throws where Dex is key (jumping, climbing etc.)

**Power Level 3**: Character’s Dex is increased by +1d4 and character gets +2 to
Task rolls where Dex is key. At each level beyond 3rd, roll 1d4 and add it to
their Dex.

#### Super Intelligence

Character possesses incredible brainpower and acumen.

*Range*: Self *Activation*: No *Duration*: Continuous

**Power Level 1:** increase character’s Int to 18. If it is already 18 roll 1d4
and add it to their Int. Character can perform complex mathematical calculations
in a fraction of the time it takes a scientist or mathematician to do so.

**Power Level 2**: Character’s Int is increased by +1d4. Character can work out
exactly what an unusual man-made device or gizmo is for and how to operate it
just by studying it for a few minutes or so.

**Power Level 3**: Character’s Int is increased by +1d4. Character can work out
exactly what an unusual man-made device or gizmo is for and how to operate it
just by looking at it. Character can work out exactly what a piece of Alien
technology is for and how to work it by studying it for an hour or so.

At each level beyond 3rd, roll 1d4 and add it to character’s Int.

#### Super Leap

Character can jump really high and far.

*Range*: Self *Activation*: No *Duration*: Continuous

**Power Level 1:** from standing, character can leap up 3 yards and 12 yards
distance.

**Power Level 2:** from standing, character can leap up 6 yards and 24 yards
distance.

**Power Level 3:** from standing, character can leap up 12 yards and 48 yards
distance.

**Power Level 4:** from standing, character can leap up 18 yards and 64 yards
distance. If character attacks as they land character receives +1d4 melee
damage.

**Power Level 5:** from standing, character can leap up 24 yards and 96 yards
distance. If character attacks as they land character receives +1d6 melee
damage.

**Power Level 6:** from standing, character can leap up 30 yards and 120 yards
distance. If character attacks as they land character receives +1d8 melee
damage.

#### Super Senses

Character is incredibly perceptive. Character’s acute senses make character hard
to surprise and deft at avoiding harm.

*Range*: Self *Activation*: No *Duration*: Continuous\*

**Power Level 1**: Character add +4 to their *Notice* checks. Also choose a
sense from – *Hearing*, *Smell*, *Taste*, *Touch or Sight.* Choosing one of
these means character can *Notice* things much further away from character than
a normal person would (minor sounds within several city blocks). Character might
have to concentrate for 3 minutes to filter out other distractions.

**Power Level 2**: Character add +6 to their *Notice* checks. Character can
either choose another sense *or* character can *Notice* things anywhere within
up to half a city away. Character might have to concentrate for 2 minutes to
filter out other distractions.

**Power Level 3**: Character add +8 to their *Notice* checks. Character can
either choose another sense *or* character can *Notice* things anywhere within
the city. Character might have to concentrate for 1 minute to filter out other
distraction

**Power Level 4:** can choose another sense.

**Power Level 5**: Character need only one round to filter out any distractions.

**Power Level 6**: Character can choose another sense.

#### Super Speed

*Range*: Self *Activation*: No *Duration*: 3 turns per PL Character possesses
incredible celerity. This swiftness makes character especially fast-moving and
hard to hit.

**Power Level 1**: Character’s movement rate is x2. Character also receives a
+1AC. Out of combat character can run at 200 mph.

**Power Level 2**: Character’s movement rate is x4. Character also receive +2AC.
Out of combat character can run at 400 mph.

**Power Level 3**: Character’s movement rate is x6. Character also receive +3AC.
Out of combat character can run at 600 mph.

**Power Level 4**: Character’s movement rate is x8. Character also receive +1d4
bonus to melee damage. Out of combat character can run at 1,000 mph.

**Power Level 5**: Character’s movement rate is x10. Character also receive
+4AC. Out of combat character can run at 1,500 mph.

**Power Level 6**: Character’s movement rate is x12. Character also receive +1d6
bonus to melee damage. Out of combat character can run at 2,000 mph.

#### Super Strength

Character possesses incredible physical might, letting character bend bars,
smash walls, and crack skulls.

*Range*: Self *Activation*: No *Duration*: Continuous

**Power Level 1:** increase character’s STR to 18. If it is already 18 roll 1d4
and add it to their Str. Their fists do 1d6 damage on a hit

**Power Level 2**: Character’s STR is increased by +1d4 and their fists do 1d8
damage on a hit.

**Power Level 3**: Character’s STR is increased by +1d4 and their fists do 1d1o
damage on a hit.

At each Power Level beyond 3rd, roll 1d4 and add it to character’s Str.

#### Super Weapon

Character owns a weapon that is specific to character and probably can’t be used
by anyone else. It could be a magic, scientific, mystical, mythological or weird
science type weapon. It could be a melee or ranged weapon. The weapon cannot be
broken or (very rarely, if ever) taken from you. Character can split their
damage **dice** between targets if character wish.

*Range*: Melee (2 yards) or ranged (50 yards per PL) *Activation*: Yes
*Duration*: Continuous

**Power Level 1:** the weapon does 2d4 damage on a hit. A non-ranged Super
Weapon gives character +1 to hit.

**Power Level 2:** the weapon does 2d6 damage on a hit.

**Power Level 3:** the weapon does 2d8 damage on a hit.

**Power Level 4**: Character receive a +2 bonus “to hit” *or* character can
double the range of a ranged weapon.

**Power Level 5:** the weapon does another 1d8 damage.

**Power Level 6:** does another 1d8 damage *or* character receive another +2
bonus “to hit”.

#### Super Wisdom

Character possesses incredible determination and insight.

*Range*: Self *Activation*: No *Duration*: Continuous

**Power Level 1:** increase character’s Wis to 18. If it is already 18 roll 1d4
and add it to their Wis.

**Power Level 2**: Character’s Wis is increased by +1d4 and once per adventure
character can re-roll one *Saving Throw*.

**Power Level 3**: Character’s Wis is increased by +1d4 and character has great
insight; once per adventure character may ask the Referee a yes/no question to
do with the world which he will answer truthfully.

At each level beyond 3rd, roll 1d4 and add it to character’s Wis.

#### Telekinesis

Character possesses the ability to exert mind over matter, moving or
manipulating objects through the power of their thoughts.

*Range*: 15 yards per PL *Activation*: Yes *Duration*: Concentration

**Power Level 1**: Character can lift and move objects up to the size of a car
or a small plane.

**Power Level 2**: Character can lift and move objects up to the size of a bus
or a military helicopter.

**Power Level 3**: Character can lift and move objects up to the size of a large
truck or a battle tank.

**Power Level 4**: Character can lift and move objects up to the size of a
passenger plane or naval cruiser.

**Power Level 5**: Character can lift and move objects up to the size of a
freight train or passenger ship.

**Power Level 3**: Character can lift and move objects up to the size of a large
tanker or aircraft carrier.

#### Telepathy

Character can communicate with others across distances with the power of their
mind. Through their thoughts, character can perceive over distances (via their
targets), through barriers, and even what is normally unseen.

*Range*: See below *Activation*: Yes *Duration*: Concentration

**Power Level 1**: Character can send messages by thought to any person
character can see in the vicinity. If it’s someone character already know,
character can send thoughts to them if they are within the neighborhood.
Character can read the mind of anyone character can touch (*Saving Throw*
allowed if resisted).

**Power Level 2**: Character can send thoughts to up to 3d4 people character can
see in the vicinity. Character can also send thoughts to anyone character knows
within the city. Character can read the mind of anyone character can get eye
contact with (*Saving Throw* allowed if resisted). Character can also read the
mind of anyone character knows if they are within the neighborhood (*Saving
Throw* needed to resist).

**Power Level 3**: Character can send thoughts to up to 6d4+2 people character
can see in the vicinity. Character can send thoughts to anyone character can see
or hear, even if they are on radio or TV. If it’s someone character already
know, character can send thoughts to them if they are in the country. Character
can read the mind of anyone character can see (*Saving Throw* allowed if
resisted). Character can read the mind of anyone character knows in the city
(*Saving Throw* allowed if resisted).

**Power Level 4**: Character can send thoughts to up to 6d4+12 people character
can see in the vicinity. If it’s someone character already know, character can
send thoughts to them if they are on the Earth. Character can read the mind of
anyone character knows in the country (*Saving Throw* allowed if resisted).

**Power Level 5**: Character can send thoughts to 6d6+24 people character can
see in the vicinity. Character can read the mind of anyone character knows in
the country (*Saving Throw* allowed if resisted). Character can broadcast to up
to 6d4+2 random people in the vicinity even if character can’t see them.

**Power Level 6**: Character can send thoughts to 6d6+36 people character can
see in the vicinity and broadcast to 6d4+12 random people within the city.

#### Teleportation

Character possesses the ability to dematerialize in one place and reappear in
another. As the power improves, the distance character can travel increases and
eventually character can even teleport objects by touch.

*Range*: Self (but see below) *Activation*: Yes *Duration*: Immediate

**Power Level 1**: Character can instantly transfer themself from their current
location to any other spot that character can see directly.

**Power Level 2:** instantly transfer themself from character’s current location
to any other spot up to 25 miles away that character knows. Character always
arrives at exactly the spot desired—whether by simply visualizing the area. At
this level character can also bring along another person or an object of
equivalent mass.

**Power Level 3**: Character can rematerialize in a designated destination up to
250 miles away. Character can bring along up to two other people or objects of
equivalent mass. Character can also touch a person or an object and teleport
that away from character up to their maximum range. Unwilling targets get a
*Saving Throw*.

**Power Level 4**: Character can teleport up to 500 miles if character knows
where character is aiming for. Otherwise, character can teleport up to 25 miles
to somewhere character don’t know but that someone’s given character details of.
Character can now teleport with up to 4 other people.

**Power Level 5**: Character instantly transfer themself from their current
location to any other spot up to 1,000 miles away that character knows. If
character has had a location described to you, character can teleport up to 100
miles. Character can also open a gate to allow others to step through. It is
only one way. It will stay up for a turn unless character close it sooner.

**Power Level 6**: Character can teleport up to 5,000 miles to a place character
knows, or 250 miles to a place that has been described to you. Their gate is now
a two-way portal. It will stay up for a 3turns unless character close it sooner.

#### Tunneling

Character is able to dig through relatively dense non-living substances at a
phenomenal rate. In effect, character has a new form of movement, similar to
burrowing.

*Range*: Self *Activation*: No *Duration*: Continuous

**Power Level 1**: Character can tunnel through soft earth at 6 yards per round
and hard earth at 3 yards per round. Character also has dark vision.

**Power Level 2**: Character can tunnel through soft earth at 12 yards per
round, hard earth at 6 yards per round and rock at 3 yards per round. Character
can add radar *or* sonar, *or* character can choose to fill in the tunnel behind
character with no reduction in speed.

**Power Level 3**: Character can tunnel through hard earth at 12 yards per round
and rock at 6 yards per round. Character can add doesn’t need to breathe (as the
Life Support power option) *or* character can choose one of the options the
character didn’t take at 2nd level.

**Power Level 4**: Character can tunnel through rock at 9 yards per round.
Character may add one of the options the character didn’t take above.

**Power Level 5**: Character can tunnel through rock at 12 yards per round.
Character also gets tremor sense; while character is in contact with the earth,
character can automatically sense the location of anything else within 20 yards
that is also touching the ground, as long as the target is moving or making any
sound louder than a whisper. Under these circumstances, character is virtually
impossible to surprise. Character cannot automatically identify the target –
character simply know that it is there, roughly how large it is, and how quickly
it is moving.

**Power Level 6**: Character can tunnel through steel at 3 yards per round.
Character can also choose one of the options from above that character haven’t
yet taken.

#### Weather Control

Character can change the weather in the area around character simply by willing
it. Character can make substantial changes to the weather that last only a short
while, but as the power improves character can create massive weather effects
that persist for an hour or so (until natural forces reassert the normal weather
pattern of the surrounding area). There are three categories of weather, each
consisting of four steps:

*Wind*: Calm (around 0 mph) / Breezy (10-20 mph) / Gale (30-60 mph) / Windstorm
(over 70 mph) *Temperature*: Hot (over 85° F) / Mild (around 70° F) / Cold
(around 30° F) / Frigid (around 0° F) *Condition*: Clear (Sunny) / Humid
(Cloudy) / Light Precipitation (Showers) / Heavy Precipitation (Storms)

*Range*: 200 yards around character per PL *Activation*: Yes *Duration*:
Concentration

**Power Level 1**: Character can alter the weather by 1 step as a persistent
change or 2 steps as a temporary change (lasting 1 minute). Character must wait
at least 1 hour before attempting to control the weather again.

**Power Level 2**: Character can alter the weather 2 steps as a persistent
change or 3 steps as a temporary change (lasting 2 minutes). Character must wait
at least 30 minutes before attempting to control the weather again.

**Power Level 3**: Character can alter the weather 3 steps as a persistent
change or 4 steps as a temporary change (lasting 3 minutes). Character must wait
at least 10 minutes before attempting to control the weather again.

**Power Level 4**: Character can alter the weather by 4 steps as a persistent
change or 5 steps as a temporary change (lasting 1 minute). Character must wait
at least 5 minutes before attempting to control the weather again.

**Power Level 5**: Character can alter the weather 5 steps as a persistent
change or 6 steps as a temporary change (lasting 2 minutes). Character must wait
at least 1 minute before attempting to control the weather again.

**Power Level 6**: Character can alter the weather 6 steps as a persistent
change or 7 steps as a temporary change (lasting 3 minutes). Character must wait
at least 1 round before attempting to control the weather again.

*Example: It is a Calm, Mild and Humid day. Stormlord is 3rd level, so he could
whistle up a Windstorm (3 steps) which would stay as long as he concentrates on
it. Or he could change the Temperature to Frigid (2 steps) and bring up Heavy
Snow (another 2 steps). He can keep this up for 3 minutes (but still has to
concentrate during that time).*

### Player Character Supers

These are some very basic guidelines for player characters with superpowers.
These guidelines have not been play-tested to any useful extent and are only
here for Referees who want to experiment. Note that these powers were not
designed to provide balanced power levels between characters.

#### Characters Acquire a Superpower During Play

If a character somehow acquires superpowers during play (bitten by a radioactive
giant mosquito, subject to an experiment by a mad wizard, etc.), just give the
character a superpower or two at Power Level 1. Note that the character will
probably need to learn to control their superpower(s) before they are actually
useful.

#### Characters Start with Superpowers

If the Referee wants to run a comic book superhero campaign with Original
Edition rules, have the players select a character type from the section above,
roll up a character for the base class of that character type, then select
superpowers as listed for a first level character of that character type. The
character will gain additional powers as the character gains levels as listed in
the description of that character type. As Referee, you will want to check
player power selections to ensure that the characters they create are neither
overpowered nor underpowered for your campaign.

<br><br><br>Section VIII:<br>Firearms
=====================================

While not for everyone, pistols, rifles and other guns have been an essential
part of some fantasy stories. The pulp-era stories of Solomon Kane and Stephen
King’s The Dark Tower series all feature elements of Six guns and Sorcery.
Firearms in fantasy obviously have an appeal, but are they right for a fantasy
campaign?

It is really up to the Referee to decide. If the Referee decides to add some
form of firearms to the game, they have to decide how realistic or powerful they
should be. Guns can easily change the nature of the game, turning it into a gun
show, instead of the traditional display of swords and spells. One way to keep
that from happening is to make these weapons more trouble than they are worth.
Bullets can be unstable but plentiful, or they can be dangerous but extremely
rare. If guns are a regular feature of the game, maybe a little bit of both.
Regardless, elements of Fantasy mixed with the Weird Wild West can make for an
interesting world of adventure.

#### Powerful or Mundane?

If they’re powerful, they should be extremely rare. They should be treated like
artifacts, and there should be dangerous rivals or factions trying to take them
away from the adventurers. Imagine if the bad guys had the guns instead. With
the tables turned, guns can make or break the game by annihilating a party. But
if they are a staple of the campaign, it’s probably best to make them pretty
mundane and not much different than any other missile weapon. But if that is the
case, why have them at all? Consider limiting the weapons to only black powder,
or non-automatic revolvers and bolt-action or lever-action long guns.

If the Referee decides to make firearms powerful, they will probably want to use
at least some of the optional rules found in this section.

Basic Firearm Rules
-------------------

It is important to remember that combat in Swords & Wizardry is abstract. Each
attack roll represents a series of attacks, maneuvers, dodges and parries.

So, though a character may have been hit by an attack, it does not always
represent a bullet breaking skin. Normally, when hit by a high velocity slug, it
would almost always cause devastating damage. But instead, hits should be
described as near-misses and flesh wounds until down to that last hit die of hit
points.

#### Initiative and Order of Battle

Surprise and initiative work like normal. Firearms follow the same attack rules
as missile fire; they are fired during the Movement and Missiles Phase.

#### Damage

Each firearm has its own damage die; typically, d8 for handguns and d10 or more
for long arms. For a standard attack, a hit does 1 die of damage. Damage is
treated just like any other missile or melee attack, and can be healed as
normal.

Aiming Gives a +2 Bonus to Hit and Does 2 Dice of Damage

The shooter may take a round to aim to increase the attack roll by 2 and hits
will increase the damage by an additional die. But the shooter is vulnerable to
normal attacks (including surprise attacks and critical hits, see below) while
aiming.

#### Taking Cover

Taking cover is key to surviving a gun fight, especially if the guns are really
dangerous. The Referee should decide whether to make gun battles realistic and
gritty, like a World War 2 movie, or to make them cinematic and showy, like The
Matrix. In realistic gun battles, half the time the combatants are ducked and
covered. While in more gun-fu style movies, gunplay is out in the open. If guns
are mundane and common, the abstract nature of Original Edition combat is
sufficient enough to assume cover. But if the more dangerous optional rules are
used, cover is essential. For simplicity, if a target is actively hiding behind
hard cover, no attacks can be made. If the target is firing back from behind
some hard cover, the cover provides an additional 4 points (-4 [+4]) to AC.
Firing from a firing port, murder hole or arrow slit can provide up to 8
(-8[+8]) points of AC, at the referee’s discretion.

#### Duels Are Deadly

High-noon on the dusty road, in the middle of town; this is the typical setting
of a one on one battle between two rival gunmen. It is usually resolved with a
single shot from the fastest gun. If two gunmen agree to a duel, hit points are
practically off the table and the winner is determined by who hits whom first.

Initiative is determined between the two duelists, using a d20, the roll is
modified by the character’s level (and any other circumstantial modifiers, see
below). The highest roll shoots first, and an attack roll is made as normal. If
the attack hits, the damage is the number of damage dice equal to the PC’s level
or a creature’s Challenge Level. For example, a typical handgun does d8 damage,
so a 5th-level fighter that hits during a duel does 5d8 damage to his target.
This represents an automatic critical hit and the inability to dodge (maneuver,
parry, etc.). Let’s face it, duels are deadly against experienced adventurers.
If the target survives, he can attempt to shoot back applying the same damage
rules. If both duelists survive, combat rounds continue as normal combat. At
that point damage is normal (typically one die), initiative is handled normally,
and others may join the combat if they wish.

Optional Firearm Rules
----------------------

The following are rules to make guns more dangerous and gritty. The following
rules may supplement, replace or be replaced by existing house rules, such as
Critical Hits and Fumbles.

#### Surprise Attacks

Firearm attacks during a surprise round, or the target is otherwise unaware of
the attack, will increase the chance of a critical hit by 2. That is, if the
attack roll is a natural 18+ and the attack hits, the attack should be
considered a critical hit (see below). All other surprise rules still apply.
This rule does not apply to automatic fire.

#### Critical Hits and Misfires

On a natural 20, an attack with a firearm should be considered a critical hit. A
critical hit does damage equal to the attacker’s level or in damage dice. For
example, a succubus with a pistol can do 9d8 damage on a critical hit!

A natural 1 may represent a misfire. There is a 1% chance the weapon may be
permanently damaged and a 10% chance the shooter may also be injured by the
misfire. The shooter taking 2 dice damage (die type depending on ammunition
used), save for half.

#### Firearms Are Complicated

If firearms are added to the campaign later, such as through time-travel or
discovery of ancient technology, the referee will have to determine whether a
particular character class is permitted to use firearms. It also makes sense
that there should be some learning curve before being proficient with a firearm.

**Firearm Proficiency:** First time users get a -4 to attacks with a firearm.
This penalty exists until either the character gains a level or 500 XP is earned
since acquiring and using the weapon.

Firearms will have a Rate of Fire (RoF) rating, reload time and weapon speed.
These are not so important if guns are mundane, treat them as any other missile
weapon. But as a way to make firearms inconvenient, especially if they’re
extremely powerful, these factors may help keep them in check.

**Rate of Fire:** A firearm with multiple RoFs may only fire once during the
surprise round, but the chance of a critical hit should increase as per the
Surprise Attack rule above. Automatic weapons are indicated by an (A).

**Reload:** Reloading a firearm manually can take up to a minute. During combat,
reloading takes place during the Movement and Missiles Phase. If quick loaders
or magazines are available, reloading takes one round. Black powder weapons can
take up to 3 rounds to reload. Reloading is akin to casting spells, it can’t be
done in melee.

**Weapon Speed:** Weapon Speed is only a factor for individual initiative rolls,
such as duels (see above). This value is added to the initiative roll or, if
using Alternate Combat Sequence Method No. 3, the value is negative.

#### Automatic Weapons

Weapons with a RoF that indicates an (A), instead of making separate attacks,
automatic weapons can affect multiple targets in a 10-foot square area. An
automatic fire attack uses 10 rounds of ammunition. The attacker makes a single
attack roll that’s compared to the AC of each target in the area. A hit causes 3
dice worth of damage, save for half. A critical hit (natural 20) does 6 dice of
damage, save for half.

#### Wound Point Damage

If the optional Hit Points and Wound Points rules are in use, any hit from a
firearm causes1 Wound Point by die of damage rolled. This is usually 1 wound
point. If the Automatic Weapons and/or the Critical Hits and Misfires optional
rules from this section are in use, many wound points may be lost from one hit
in the appropriate circumstances. If these rules are in use but the general
critical hit rules are, then a critical hit under the general critical rules
causes double the normal number of wound points.

Firearms by Era
---------------

For game purposes, firearms come from four different eras, from primitive to
future. The Referee determines which eras, if any, are in use in their campaign.

Weapon cost assumes firearms are mundane in the campaign setting. If firearms
are particularly rare or powerful, treat them as unique or powerful magic items
and adjust the prices appropriately.

#### Era I

Black powder firearms represent the earliest forms, from the arquebus to the
musket. For the centuries, all firearms were basically muzzle loaded weapons
that were manually ignited. They were made practical with the invention of
matchlocks, a hundred years later wheel locks appeared then finally another 100
years went by before flintlocks were developed. A black powder firearm is loaded
with black powder, wadding and a metal ball.

|                      | **Dmg Die** |         |         |           |          |         |          |
| **Weapon**           |             | **RoF** | **Spd** | **Rge\*** | **Ammo** | **Wgt** | **Cost** |
|----------------------|-------------|---------|---------|-----------|----------|---------|----------|
| Pistol, black powder | d8          | 1/3\*\* | \-3     | 50ft      | 1        | 4lb     | 100gp    |
| Rifle, black powder  | d10         | 1/3\*\* | \-3     | 80ft      | 1        | 15lb    | 250gp    |

\*Shooting beyond this range is -2 up to twice this range indoors and three
times this range outdoors.

\*\*Loading will take 3 uninterrupted rounds. Black powder weapons can take up
to 3 rounds to reload. Reloading is akin to casting spells; it can’t be done in
melee.

#### Era II

These firearms represent the early modern firearms that featured breech-loaded
percussion-cap cartridges, or bullets. Loading time, reliability and production
greatly improved. The classic derringer and revolver to shotguns and long-rifles
are of this time period. The first practical machine gun, the Gatling gun, makes
its appearance.

|                     | **Dmg Die** |         |         |           |          |         |          |
| **Weapon**          |             | **RoF** | **Spd** | **Rge\*** | **Ammo** | **Wgt** | **Cost** |
|---------------------|-------------|---------|---------|-----------|----------|---------|----------|
| Pistol, compact     | d6          | 1       | 0       | 40ft      | 2        | 2lb     | 200gp    |
| Pistol, revolver    | d8          | 1       | \-1     | 60ft      | 6        | 4lb     | 150gp    |
| Rifle, lever-action | d10         | 1       | \-2     | 120ft     | 5        | 15lb    | 350gp    |
| Shotgun             | d10         | 1       | \-1     | 50ft      | 2        | 12lb    | 300gp    |
| Gatling Gun         | d10         | 5(A)    | \-2     | 120ft     | \*\*     | 300lb   | 1000gp   |

\*Shooting beyond this range is -2 up to twice this range indoors and three
times this range outdoors.

\*\*The Gatling gun uses a gravity fed box of ammo that could be reloaded on the
fly.

#### Era III

The weapons of this era represent the large variety of weapons available in the
modern world.

|                    | **Dmg Die** |         |         |           |          |         |          |
| **Weapon**         |             | **RoF** | **Spd** | **Rge\*** | **Ammo** | **Wgt** | **Cost** |
|--------------------|-------------|---------|---------|-----------|----------|---------|----------|
| Pistol, compact    | d6          | 1       | 0       | 40ft      | 2        | 2lb     | 200gp    |
| Pistol, revolver   | d8          | 1       | \-      | 60ft      | 6        | 4lb     | 150gp    |
| Pistol, semi-auto  | d8          | 2       | 0       | 60ft      | 10       | 4lb     | 250gp    |
| Rifle, assault     | d10         | 3(A)    | \-1     | 100ft     | 30       | 12lb    | 500gp    |
| Rifle, bolt-action | d10         | 1       | \-2     | 120ft     | 5        | 15lb    | 350gp    |
| Shotgun            | d10         | 1       | \-1     | 50ft      | 2        | 12lb    | 300gp    |
| Shotgun, combat    | d10         | 2       | \-1     | 50ft      | 10       | 15lb    | 400gp    |
| Submachine Gun     | d8          | 3(A)    | \-1     | 60ft      | 30       | 10lb    | 400gp    |
| Machine Gun        | d12         | 5(A)    | \-2     | 120ft     | 100      | 30lb    | 800gp    |

\*Shooting beyond this range is -2 up to twice this range indoors and three
times this range outdoors.

#### Era IV

These are the futuristic and/or alien weapons of science fiction.

|                 | **Dmg Die** |         |         |           |          |         |              |
| **Weapon**      |             | **RoF** | **Spd** | **Rge\*** | **Ammo** | **Wgt** | **Cost\*\*** |
|-----------------|-------------|---------|---------|-----------|----------|---------|--------------|
| Pistol, Laser   | d8          | 1       | \-1     | 80ft      | 40       | 2lb     | 400gp        |
| Pistol, Blaster | d10         | 1       | \-1     | 50ft      | 20       | 3lb     | 500gp        |
| Rifle, Raygun   | d10         | 3(A)    | \-2     | 200ft     | 50       | 6lb     | 1200gp       |
| Rifle, Plasma   | d12         | 1       | \-3     | 150ft     | 25       | 7lb     | 1450gp       |

\*Shooting beyond this range is -2 up to twice this range indoors and three
times this range outdoors.

#### Ammunition Costs

For simplicity, the cost of rounds is dependent on how much damage they do. For
black powder weapons, the costs include the necessary black powder.

| **Damage** | **Cost\*** | **Weight** |
|------------|------------|------------|
| d6 or d8   | 5sp        | 0.1 lb     |
| d10 or d12 | 1gp        | 0.1 lb     |

\*Costs are for 10 rounds where firearms are mundane. In campaigns where
firearms are rare, costs are for a single round.

Magazines and quick-loaders cost 1 gp for each if firearms are mundane or 1 gp
per round they carry in campaigns where firearms are rare.

<br><br><br><br>Section IX:<br>Random Tables
============================================

The following tables are useful examples of the random tables that can help the
Referee create adventure material. These tables are useful as they are, but may
need changes to suit the Referee’s campaign.

Adventure Hooks
---------------

There are many times when the Referee needs to come up with several “rumors” of
possible adventures. It can be easy to fall into a runt. Rolling on the
following table (or one like it that you create) can help avoid boring
predictability.

| D100 | Adventure Hook                                                                             |
|------|--------------------------------------------------------------------------------------------|
| 1    | Test the fidelity of a noble’s suitor.                                                     |
| 2    | Collect several pieces of an ancient treasure map.                                         |
| 3    | Map an abandoned sewer system.                                                             |
| 4    | Sink a pirate ship that has been raiding a local village.                                  |
| 5    | Retake a castle from some bandits, without damaging it too badly.                          |
| 6    | Free a group of lost children from a Medusa.                                               |
| 7    | Compete in a jousting tournament.                                                          |
| 8    | Compete in a fighting tournament.                                                          |
| 9    | Infiltrate a thieves’ guild for information.                                               |
| 10   | Completely clear a dungeon of all monsters & traps.                                        |
| 11   | Join a naval fleet on maneuvers.                                                           |
| 12   | Escort a group through a haunted forest.                                                   |
| 13   | Clear a cemetery of a zombie infestation.                                                  |
| 14   | Sink a rival village’s merchant/fishing fleet.                                             |
| 15   | Save a kidnapped noble’s child.                                                            |
| 16   | Steal a noble’s/merchant’s treasury.                                                       |
| 17   | Dispose of someone’s unwanted thrash.                                                      |
| 18   | Exonerate a party member of a crime.                                                       |
| 19   | Frame an enemy for a crime.                                                                |
| 20   | Defend a caravan through a desert.                                                         |
| 21   | Break a friend out of jail.                                                                |
| 22   | Capture a rare animal.                                                                     |
| 23   | Stop a human sacrifice.                                                                    |
| 24   | Find an ancient library.                                                                   |
| 25   | Climb a wizard’s tower.                                                                    |
| 26   | Locate a lost relic.                                                                       |
| 27   | Poison, or purify, a well.                                                                 |
| 28   | Free a group of slaves.                                                                    |
| 29   | Recapture some runaway slaves.                                                             |
| 30   | Protect a rich merchant at a masquerade ball.                                              |
| 31   | Search a castle for its Vampire master.                                                    |
| 32   | Gather some important information about a foe.                                             |
| 33   | Spook a family away from their farm/home/business.                                         |
| 34   | Destroy, or repair, a dam.                                                                 |
| 35   | Compete in a race to a location against other parties.                                     |
| 36   | Usurp a diabolical warlord.                                                                |
| 37   | Retrieve some plants for a rich alchemist.                                                 |
| 38   | Hunt down a serial killer.                                                                 |
| 39   | Explore a lost monastery atop a high mountain.                                             |
| 40   | Disrupt a cult’s ritual.                                                                   |
| 41   | Help exorcise a demon from a village.                                                      |
| 42   | Pose as pirates to frame them for wrong doings.                                            |
| 43   | Discover who, or what, is poisoning the river.                                             |
| 44   | Discover who, or what, is stealing the town’s lobster traps.                               |
| 45   | Help arm a local village for an uprising.                                                  |
| 46   | Negotiate a truce between rivals.                                                          |
| 47   | A half-eaten villager is discovered in the sewers.                                         |
| 48   | Assassinate a local politician.                                                            |
| 49   | Discover a noble’s lost pet.                                                               |
| 50   | Guard a jail from an angry mob.                                                            |
| 51   | Something is killing a farmer’s livestock.                                                 |
| 52   | Map out a huge forest.                                                                     |
| 53   | Return a chunk of still frozen ice from the tallest mountain.                              |
| 54   | Several dire beasts have taken a local forest.                                             |
| 55   | Burn a rival port’s dock.                                                                  |
| 56   | Delve deep into a cavern to find a long-lost artifact.                                     |
| 57   | Deliver a cargo safely through a bandit/pirate infested zone.                              |
| 58   | Liberate a village from bandits.                                                           |
| 59   | Discover a sunken ship and recover an item from it.                                        |
| 60   | A portal to another realm has opened in the forest.                                        |
| 61   | Fulfill a prophecy.                                                                        |
| 62   | Restore an ancient artifact one piece at a time.                                           |
| 63   | Avenge a local prostitute after she was harmed by some townsfolk.                          |
| 64   | Quickly take supplies to an isolated village.                                              |
| 65   | Steal something important from a local, but without them discovering.                      |
| 66   | Investigate some recently discovered catacombs.                                            |
| 67   | Find a cure to a deadly plague.                                                            |
| 68   | Discover a lost map from a pirate, then find the treasure.                                 |
| 69   | Track down an evil Mystic.                                                                 |
| 70   | Discover the recipe to ancient potion.                                                     |
| 71   | Locate some rare metal for a blacksmith to forge an armor.                                 |
| 72   | Cure a local of lycanthropy.                                                               |
| 73   | You are hired to deliver grain to a village, but discover it has been tainted.             |
| 74   | Investigate a town overrun with Madness.                                                   |
| 75   | Steal bodies for a local Necromancer.                                                      |
| 76   | Clear and destroy a toll road to the north.                                                |
| 77   | A noble receives a death threat and wishes for you to investigate.                         |
| 78   | You are hired by a Warlord to retrieve tribute from a small village.                       |
| 79   | Clear the hillside of the influence of a pair of Giants or Ogres.                          |
| 80   | Find a way off of a deserted island.                                                       |
| 81   | Find a lost child in the town’s sewer system.                                              |
| 82   | Escort a group of virgin maidens to convent.                                               |
| 83   | Aid a scholar in an excavation.                                                            |
| 84   | A new island has arisen in a local lake.                                                   |
| 85   | Aid a clergyman in opening a new church.                                                   |
| 86   | Aid an escape from a prison camp.                                                          |
| 87   | Traverse some wilderness looking for a lost traveling party.                               |
| 88   | Join a local leader at their side in a major battle.                                       |
| 89   | Clear an orchard of giant insects.                                                         |
| 90   | Get rid of a cursed item.                                                                  |
| 91   | Acquire a specific slave from a market, and return them home.                              |
| 92   | An earthquake unearths a lost cavern, you are hired to explore it.                         |
| 93   | Convince or force a group of fairies to leave the forest.                                  |
| 94   | Destroy a Flesh Golem and bury it in consecrated ground.                                   |
| 95   | Capture an exotic bird and return it safely.                                               |
| 96   | Farms are failing to an unknown blight. Seek out its source and kill it.                   |
| 97   | VIP is chained in a ship among dozens of slaves. Rescue them.                              |
| 98   | You are dispatched to a mine, where several miners are being attacked by unknown monsters. |
| 99   | Help replant several plants or crops after amid a bandit raid.                             |
| 100  | Trick a small town into believing that you are gods.                                       |

Dungeons on the Fly
-------------------

No matter how prepared a Referee is, there will be times that material has to be
created on the fly determine a game. The following optional tables may help.
Even if you don’t like the result as written, the result may give you an idea
for something else. These tables have been deliberately kept simple and general,
so they will require Referee interpretation.

“Monster Rating” is used in some of these tables. A monster’s Monster Rating is
equal to its hit dice plus one for each special ability it has.

### Random Dungeon Generation I

If you do not have time to prepare a dungeon in advance, use the following
procedure:

1.  Get a sheet of graph paper. (Non-graph paper will do in a pinch.)

2.  Grab a handful of d6s.

3.  Roll the dice all at once and let them land where they will on the paper.
    (It may help to have a box to keep the dice constrained to the paper.)

4.  Everywhere a d6 lands is a room. (Assign room dimensions to taste.) The
    number of exits from that room is based on the value of the d6:  
    1-2: 1 exit  
    3-4: 2 exits  
    5-6: 3 exits

5.  Add hallways connecting the rooms to taste.

6.  In order to determine what to fill a room with, roll a d8:  
    1-3: Empty  
    4: Empty save for treasure  
    5: Monster  
    6: Monster and treasure  
    7: Trap  
    8: Referee Special (or roll again)

### Quick Random Treasure Generation

Generating treasure from the standard tables can be a time-consuming procedure
that can require many different rolls. The following system is much faster. It
can be used to generate the treasure belonging to a large group of monsters or a
single powerful monster. Note that no magic items are generated in these tables.
If you believe a magic item or magic items would be in the treasure, add them.

First, determine the type of treasure hoard by rolling 1d6 (or by selecting the
most appropriate type) on the following table:

**Quick Treasure**

| D6 Roll | Hoard Type  | Contents                        |
|---------|-------------|---------------------------------|
| 1       | Sentimental | 75gp, 1 piece of art            |
| 2       | Dilettante  | 75gp, 5 gems, 3 pieces of art   |
| 3       | Traveler    | 100gp, 20 gems                  |
| 4       | Collector   | 100gp, 12 pieces of art         |
| 5       | Banker      | 500gp                           |
| 6       | Old Hoarder | 300gp, 15 gems, 6 pieces of art |

Second, make adjustments to the hoard based on the owner as described below:

**Monsters with a Monster Rating of 4 or less, commoner families, and simple
merchants:**

-   Gems are worth 10 gold (Blue Quartz, Malachite, Tiger eye)

-   Art Items are worth 25 gold (bone dice, gold bracelet, small mirror)

**Monsters with a Monster Rating of 5 to 10, nobles, and popular businesses:**

-   Multiply gold by 10

-   Gems are worth 100 gold (Amber, Coral, Jade)

-   Art Items are worth 250 gold (box of turquoise animal figurines, silk robe,
    silver necklace)

**Monsters with a Monster Rating of 11 to 16, royalty, great wizards, great
merchant houses:**

-   Multiply gold by 100

-   Gems are worth 1000 gold (Emerald, Opal, Sapphire)

-   Art Items are worth 2500 gold (gold music box, old painting, eyepatch with
    mock sapphire eye)

**Monsters with a Monster Rating of 17+, liches, and old dragons**

-   Multiply gold by 1000

-   Double the number of gems, and each one is worth 5000 gold (Diamond,
    Jacinth, Ruby)

-   Triple the number of art items, and each one is worth 7500 gold (gold
    child-sized sarcophagus, jade and gold dragon chess set, jeweled gold crown)

### Random Magic Items

To quickly make magic items, decide between a spell item which reproduces a
spell from the spell lists, or a bonus item which provides a +1 to +3 bonus to
attack and damage rolls (weapons), or AC (armor and shields.)

There are three kinds of spell items:

-   Consumables: Single use items such as potions or scrolls.

-   Renewable use: Either 2d20 charge or 1d2 charges that renew daily.

-   Constant use: Provides a continuous effect.

Use the following guidelines when distributing items or estimating their price
should the party try to sell them:

**Quick Magic Items**

| Rarity    | Monster Rating | Wholesale Value † | Spell Levels | Armor Bonus | Weapon Bonus |
|-----------|----------------|-------------------|--------------|-------------|--------------|
| Common    | 1-4            | 100gp             | Minor Magic  | \-          | \-           |
| Uncommon  | 2-6            | 500gp             | 1st          | \-          | \+1          |
| Rare      | 4-10           | 5000gp            | 2nd-3rd      | \+1         | \+2          |
| Very Rare | 8-16           | 20,000gp          | 4th-5th      | \+2         | \+3          |
| Legendary | 17+            | 100,000gp         | 6th          | \+3         | \-           |

† Divide by 2 for renewable use and by 10 for consumables

Random NPC Personality Attributes
---------------------------------

NPCs created on the fly often seem similar. Use the following tables as needed
to create more random NPCs. Note that common sense should always override random
rolls.

**Base Personality (roll 1d8):**

1: Cranky  
2: Jock  
3: Lazy  
4: Peppy  
5: Smug  
6: Snooty  
7: Sweet  
8: Roll twice.

**Area of Expertise (roll 1d6):**

1: Communication  
2-3: Subterfuge  
3: Knowledge  
5-6: Physical

**Social role (roll 1d6):**

1-3: Productivity  
4-5: Military  
6: Sovereignty

**Motivation (roll 1d8):**

1: Love  
2: Hate  
3: Greed  
4: Ambition  
5: Fear  
6: Need  
7: Idealism  
8: Cynicism

Dungeon Furnishings
-------------------

Dungeon design is addressed thoroughly in the core rules. However, the following
tables may be useful for fleshing out special areas or adding odds and ends to
underground areas.

### Random Traps

Use this table for designing traps. Some creativity will need to be employed to
make the traps appropriate for the situation and abilities of the PCs.

**Random Trap Determination**

| D100  | Trap Type           | D100  | Trap Type                 |
|-------|---------------------|-------|---------------------------|
| 01-06 | Arrow trap1         | 41-43 | Lightning bolt            |
| 07-08 | Collapsing ceiling5 | 44-53 | Pit (10’ deep)2           |
| 09-10 | Compacting ceiling  | 54-63 | Pit (locks shut)2         |
| 11-12 | Compacting walls    | 64-67 | Portcullis trap5          |
| 13-14 | Dropping ceiling    | 68-72 | Room6                     |
| 15-19 | False door3         | 73-78 | Scything blade            |
| 20-23 | Falling stones      | 79-83 | Sliding pit2              |
| 24-25 | Flooding passage    | 84-88 | Sliding pit (locks shut)2 |
| 26-27 | Flooding room       | 89-94 | Spear trap1               |
| 28-30 | Fire ball           | 95-98 | Swinging ball/block       |
| 31-40 | Gas4                | 99-00 | Teleporter                |

1Poisoned on a roll of 1 on d10  
2Roll d10; poison spikes, 1; spikes, 2-3; flooding, 4  
3Roll d10; pit trap, 1-2; poisoned needle, 3  
4Roll d10; blinding, 1-2; confusion, 3-4; fear, 5; poisonous, 6; sleep, 7-8;
slowing, 9-10;  
5Roll d6; blocks passage ahead 1-3; blocks passage behind 4-6  
6Roll d10; flooding, 1-2; elevator, 3-4; collapsing, 5-6; spiked, 7-8;
compacting, 9-10

### Atmospheric Details

The following tables can be used to add atmosphere to otherwise bare or
uninteresting areas. These atmospheric details need not be explained in any way,
or if they inspire the imagination they could lead to additional unique
encounters or mysteries. Roll once or more times on the table below for any
given area. Different dice rolls should be used for rolling for odors or tactile
atmospheric details.

**Random Atmospheric Details**

| d12 | Odors     | Tactile            | Visibility (d6)        |
|-----|-----------|--------------------|------------------------|
| 1   | Damp      | Breeze, cold       | Dusty                  |
| 2   | Decay     | Breeze, dry        | Foggy                  |
| 3   | Earth     | Breeze, humid      | Misty                  |
| 4   | Excrement | Breeze, warm       | Obscured (gnats, etc.) |
| 5   | Ferrous   | Breeze, wet        | Smokey                 |
| 6   | Leather   | Downdraft          | Steamy                 |
| 7   | Mold      | Numbing wind       |                        |
| 8   | Musky     | Prickly draft      |                        |
| 9   | Ozone     | Side draft         |                        |
| 10  | Sea Air   | Static charged air |                        |
| 11  | Smoke     | Unnaturally still  |                        |
| 12  | Sulphur   | Updraft            |                        |

**Random Sounds**

| D100  | Sound                | D100  | Sound                   |
|-------|----------------------|-------|-------------------------|
| 01    | Barking              | 53-54 | Panting                 |
| 02    | Bell chiming         | 55    | Paper crinkling         |
| 03-04 | Buzzing              | 56    | Pounding                |
| 05-06 | Cackling             | 57-58 | Rattling                |
| 07    | Chains rattling      | 59-60 | Ripping                 |
| 08-09 | Choking              | 61-62 | Scratching              |
| 10-12 | Chuckling            | 63    | Sizzling                |
| 13-14 | Coughing             | 64    | Slapping                |
| 15-16 | Creaking             | 65-67 | Slithering              |
| 17-19 | Door breaking        | 68-69 | Snapping                |
| 20-21 | Door shutting        | 70    | Sneezing                |
| 22-23 | Door slamming        | 71    | Snorting                |
| 24-25 | Dragging             | 72-73 | Sobbing                 |
| 26    | Farm animal (random) | 74    | Spitting                |
| 27-28 | Fire crackling       | 75-76 | Stone sliding           |
| 29-30 | Footsteps, walking   | 77-78 | Talking (indiscernible) |
| 31-32 | Footsteps, running   | 79-80 | Tapping                 |
| 33    | Giggling             | 81    | Thunder                 |
| 34    | Glass breaking       | 82    | Wailing                 |
| 35    | Gong pounding        | 83-84 | Water bubbling          |
| 36-37 | Grating              | 85-86 | Water dripping          |
| 38-39 | Gurgling             | 87-88 | Water flowing           |
| 40-41 | Hissing              | 89    | Water splashing         |
| 42    | Hooves clopping      | 90-91 | Water trickling         |
| 43-45 | Laughing             | 92-94 | Whispering              |
| 46    | Leaves rustling      | 95    | Whistling               |
| 47-48 | Moaning              | 96-97 | Wind whistling          |
| 49    | Musical instrument   | 98-99 | Wood splintering        |
| 50-52 | Name spoken          | 00    | Yelling (indiscernible) |

11111

**Miscellaneous room contents**

| D100  | Contents               | D100  | Contents                  |
|-------|------------------------|-------|---------------------------|
| 01    | Ashes                  | 53-54 | Potion bottle, empty      |
| 02    | Axe, bloody            | 55    | Rope, hemp, rotten        |
| 03-04 | Bandages, bloody       | 56    | Sack, large, rotten       |
| 05-06 | Blood, dried           | 57-58 | Shield, cracked           |
| 07-08 | Blood, puddle          | 59-60 | Shirt, stained            |
| 09-10 | Blood, wet smear       | 61-62 | Skeletal part (random)    |
| 11-12 | Bones, broken          | 63    | Skeleton, animal          |
| 13-14 | Boot, chewed           | 64-65 | Skeleton, human           |
| 15-16 | Candles, partly burned | 66-67 | Skin, furred, dry         |
| 17-19 | Cart, broken           | 68-69 | Skin, tattooed, dry       |
| 20-21 | Cobwebs                | 70    | Skull, animal             |
| 22-23 | Dagger hilt            | 71    | Skull, human              |
| 24    | Desiccated corpse      | 72-73 | Skull, humanoid           |
| 25-26 | Excrement              | 74    | Slimy ceiling             |
| 27-28 | Figurine, small wood   | 75-76 | Slimy floor               |
| 29-30 | Firewood               | 77-78 | Slimy wall                |
| 31    | Grappling hook, rusty  | 79    | Spikes, iron, rusty       |
| 32-33 | Grave marker           | 80-81 | Stain, indiscernible      |
| 34    | Helmet, cleaved        | 82    | Stain, water              |
| 35    | Holy symbol, ruined    | 83-84 | Stones, large             |
| 36-37 | Incense and burner     | 85-86 | Stones, small             |
| 38-39 | Key                    | 87-88 | Sword, long, broken       |
| 40-41 | Lantern, broken        | 89    | Tooth, large sharp        |
| 42-43 | Manacles, rusty        | 90-91 | Torch, partially burned   |
| 44-45 | Map, illegible         | 92-93 | Warning (chalk on a wall) |
| 46    | Mirror, small, broken  | 94-95 | Water, puddle             |
| 47-48 | Mold                   | 96-97 | Water, droplets on wall   |
| 49-50 | Moss                   | 98-99 | Waterskin, empty, rotten  |
| 51-52 | Mushrooms (in offal)   | 00    | Withered flowers or herbs |

### Special Encounters

When designing a dungeon, there are areas that contain unique encounters or
areas. The following tables can be rolled on or chosen from to help design these
unique places or objects. Care must be taken to create objects or areas that
cannot be abused by the players, and in some cases, effects associated with
these encounters should be temporary or limited in use. Roll or choose from the
Random Features Table first, then roll or choose on the Random Characteristics
Table. If rolling randomly, not all results will make sense, so the referee will
have to roll again or alter the interpretation of the results. Specific details
of the effects are left to the design of the referee, such as duration, damage
dealt (if appropriate), trigger mechanisms, etc.

**Random Features Table**

| D100  | Result                     | D100  | Result               |
|-------|----------------------------|-------|----------------------|
| 01-03 | Alcove                     | 51-53 | Painting             |
| 04-05 | Altar, large               | 54-56 | Passage              |
| 06-07 | Altar, small               | 57-59 | Pedestal             |
| 08-10 | Archway                    | 60-61 | Pillar/column        |
| 11-12 | Barrier, invisible         | 62-65 | Pit                  |
| 13-14 | Basin, stone               | 66-67 | Platform, stone      |
| 15-17 | Bust sculpture             | 68-70 | Pool, artificial     |
| 18-20 | Ceiling                    | 71-72 | Pool, natural        |
| 21-22 | Ceiling, domed             | 73-74 | Portcullis           |
| 23-25 | Chest, wooden              | 75-76 | Room                 |
| 26-28 | Container (jar, pot, etc.) | 77-78 | Rug                  |
| 29-31 | Door (50% secret)          | 79-80 | Shelf, inset to wall |
| 32-33 | Fireplace                  | 81-82 | Sphere, glass        |
| 34-36 | Floor                      | 83-84 | Stairway             |
| 37-38 | Fountain                   | 85-87 | Statue               |
| 39-40 | Fungus                     | 88-89 | Tapestry             |
| 41-42 | Gate, iron                 | 90-92 | Vault                |
| 43-45 | Idol                       | 93-94 | Vegetation           |
| 46-48 | Mirror, large              | 95-97 | Wall                 |
| 49-50 | Monster                    | 98-00 | Well                 |

**Random Characteristics Table**

| D100                                                                                                                                                                                                                                                                                                                                                                                               | Characteristic        | D100  | Characteristic      |
|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-----------------------|-------|---------------------|
| 01-02                                                                                                                                                                                                                                                                                                                                                                                              | Ages (25% decreases)  | 51    | Illusionary         |
| 03-04                                                                                                                                                                                                                                                                                                                                                                                              | Alters alignment      | 52    | Increases ability4  |
| 05-06                                                                                                                                                                                                                                                                                                                                                                                              | Animates an object    | 53    | Increases gravity   |
| 07-08                                                                                                                                                                                                                                                                                                                                                                                              | Attracts              | 54-55 | Invisible           |
| 09-10                                                                                                                                                                                                                                                                                                                                                                                              | Attacks               | 56-57 | Levitates           |
| 11-12                                                                                                                                                                                                                                                                                                                                                                                              | Bestows a curse       | 58-59 | Moves               |
| 13-14                                                                                                                                                                                                                                                                                                                                                                                              | Burns                 | 60    | Nullifies magic     |
| 15-16                                                                                                                                                                                                                                                                                                                                                                                              | Causes fear           | 61-62 | Pivots              |
| 17-18                                                                                                                                                                                                                                                                                                                                                                                              | Causes geas           | 63    | Points              |
| 19-20                                                                                                                                                                                                                                                                                                                                                                                              | Changes3              | 64    | Poisons             |
| 21-22                                                                                                                                                                                                                                                                                                                                                                                              | Collapses             | 65    | Polymorphs          |
| 23-24                                                                                                                                                                                                                                                                                                                                                                                              | Condenses             | 66-67 | Produces an object2 |
| 25-26                                                                                                                                                                                                                                                                                                                                                                                              | Consumes              | 68-69 | Reduces             |
| 27-28                                                                                                                                                                                                                                                                                                                                                                                              | Decreases ability4    | 70-71 | Replaces            |
| 29-30                                                                                                                                                                                                                                                                                                                                                                                              | Decreases gravity     | 72-73 | Repulses            |
| 31                                                                                                                                                                                                                                                                                                                                                                                                 | Disintegrates         | 74-75 | Reveals lies        |
| 32-33                                                                                                                                                                                                                                                                                                                                                                                              | Duplicates object     | 76-77 | Reverses gravity    |
| 34                                                                                                                                                                                                                                                                                                                                                                                                 | Duplicates person     | 78-79 | Sinks               |
| 35-36                                                                                                                                                                                                                                                                                                                                                                                              | Emits a gas           | 80-81 | Sliding             |
| 37-38                                                                                                                                                                                                                                                                                                                                                                                              | Emits a slime or ooze | 82-83 | Slopes (up or down) |
| 39                                                                                                                                                                                                                                                                                                                                                                                                 | Enlarges              | 84-85 | Speaks1             |
| 40-41                                                                                                                                                                                                                                                                                                                                                                                              | Fake                  | 86-87 | Spins               |
| 42                                                                                                                                                                                                                                                                                                                                                                                                 | Flesh to stone        | 88-89 | Steals              |
| 43-44                                                                                                                                                                                                                                                                                                                                                                                              | Freezes               | 90-91 | Stone to flesh      |
| 45                                                                                                                                                                                                                                                                                                                                                                                                 | Grants a language     | 92-93 | Stretches           |
| 46                                                                                                                                                                                                                                                                                                                                                                                                 | Grants opposite wish  | 94    | Suspends animation  |
| 47                                                                                                                                                                                                                                                                                                                                                                                                 | Grants a wish         | 95-96 | Teleports           |
| 48                                                                                                                                                                                                                                                                                                                                                                                                 | Heals                 | 97-98 | Twists              |
| 49-50                                                                                                                                                                                                                                                                                                                                                                                              | Heats                 | 99-00 | Withers a body part |
| 1Roll d4; with intelligence, 1; a preprogrammed message, 2; tries to convince the party to take an action, 3; tries to lead the party into a trap, 4 2Roll d8; gold coins, 1; fool’s gold, 2; magic item, 3; food, 4; gems, 5; water, 6; wine, 7; oil, 8 3Roll d6; skin color, 1; eye color, 2; hair color, 3; race, 4; sex, 5; height, 6 4Roll d6; STR, 1; DEX, 2; CON, 3; INT, 4; WIS, 5; CHA, 6 |                       |       |                     |

### Specialty Room Furnishings

The following tables can flesh out the contents of alchemy or magic-user labs.

**Alchemy or Magic-User Furnishings**

| D100  | Item               | D100  | Item                   |
|-------|--------------------|-------|------------------------|
| 01-02 | Alembic            | 51-52 | Jars, glass            |
| 03    | Aludel             | 53    | Manacles, wall mounted |
| 04    | Anthanor           | 54-55 | Molds, Casting         |
| 05-06 | Beakers, glass     | 56-57 | Mortar and pestle      |
| 07-08 | Bellows            | 58-59 | Oil lamp               |
| 09-10 | Bottles, glass     | 60-61 | Parchment/Paper        |
| 11-12 | Bowls, glass       | 62    | Pelicans               |
| 13    | Bowls, wooden      | 63    | Pentagram              |
| 14-15 | Brazier            | 64    | Philosopher’s Stone    |
| 16    | Calcinary furnace  | 65-66 | Pipettes               |
| 17-18 | Cage, large        | 67    | Pots, ceramic          |
| 19-20 | Cage, small        | 68-69 | Pots, copper           |
| 21-22 | Candles            | 70    | Pots, iron             |
| 23-24 | Cauldron           | 71-72 | Prism                  |
| 25    | Circle, protection | 73-74 | Quills                 |
| 26    | Circle, summoning  | 75    | Retort                 |
| 27-28 | Coal               | 76-77 | Rods, iron stirring    |
| 29-30 | Crucible           | 78    | Sand bath              |
| 31    | Crystals, quartz   | 79    | Scale, balance weight  |
| 32-33 | Cucurbit           | 80-81 | Spatula                |
| 34    | Cupel              | 82-83 | Spoons, measuring      |
| 35-36 | Cups, measuring    | 84-85 | Stands (for hot glass) |
| 37    | Cylinders, glass   | 86    | Still, glass           |
| 38-39 | Dishes, glass      | 87-88 | Stoppers               |
| 40    | Dissolving furnace | 89-90 | Tar, sealing           |
| 41-42 | Flasks, glass      | 91-92 | Tongs                  |
| 43    | Funnels, glass     | 93-94 | Tripod                 |
| 44    | Furnace            | 95    | Tubing, glass          |
| 45-46 | Hourglass          | 96-97 | Tweezers               |
| 47-48 | Incense            | 98-99 | Vials, glass           |
| 49-50 | Ink, vials         | 00    | Water clock            |

Use the table below for randomly determining the contents of jars, pots, or
other vessels in a lab.

**Random Container Contents**

| D100  | Contents             | D100  | Contents            |
|-------|----------------------|-------|---------------------|
| 01-03 | Amber                | 51-53 | Leaves              |
| 04-06 | Ashes                | 54-56 | Locusts             |
| 07-09 | Bark                 | 57-60 | Minerals, powdered  |
| 10-12 | Blood, powdered      | 61-64 | Oil, essential      |
| 13-15 | Bone, chips/hunks    | 65-67 | Powder              |
| 16-18 | Bones, small animal  | 68-70 | Mummy, small animal |
| 19-21 | Charcoal             | 71-73 | Needles, bone       |
| 22-24 | Cloth, cotton        | 74-76 | Sap/resin           |
| 25-27 | Eggs, exotic pickled | 77-79 | Salt, crystals      |
| 28-31 | Entrails, pickled    | 80-82 | Seeds               |
| 32-35 | Eyes, dried          | 83-85 | Sinew               |
| 36-38 | Fat/grease           | 86-88 | Skin, dried         |
| 39-41 | Fingers/toes, dried  | 89-91 | Slime               |
| 42-44 | Flower petals, dried | 92-94 | Teeth               |
| 45-47 | Fluid, putrid        | 95-97 | Tongue, pickled     |
| 48-50 | Hair, humanoid       | 98-00 | Urine               |

The following table can be used for determining which torture devices are
present in a torture room or some other location.

**Torture Chamber Furnishings**

| D20 | Devices          | D20 | Implements        |
|-----|------------------|-----|-------------------|
| 1   | Breaking Wheel   | 1   | Brazier           |
| 2   | Cauldron, large  | 2   | Cage, large       |
| 3   | Chair, spiked    | 3   | Chains            |
| 4   | Copper Boot      | 4   | Clamps            |
| 5   | Crocodile Shears | 5   | Cleaver           |
| 6   | Crocodile Tube   | 6   | Garrotes          |
| 7   | Guillotine       | 7   | Hooks, iron       |
| 8   | Head crusher     | 8   | Iron, branding    |
| 9   | Heretics Fork    | 9   | Balls, large iron |
| 10  | Iron coffin      | 10  | Knives, various   |
| 11  | Iron Maiden      | 11  | Manacles          |
| 12  | Judas Cradle     | 12  | Nails             |
| 13  | Knee Splitter    | 13  | Oil, barrel       |
| 14  | Lead Sprinkler   | 14  | Pliers            |
| 15  | Pear of Anguish  | 15  | Rope              |
| 16  | Pendulum         | 16  | Saw, large        |
| 17  | Rack             | 17  | Spikes, iron      |
| 18  | Spanish Tickler  | 18  | Wedges, iron      |
| 19  | Thumb Screws     | 19  | Wedges, wood      |
| 20  | Tongue Tearer    | 20  | Whips             |

Random Tavern Patrons
---------------------

It is a law of gaming nature that at some point players ask about what sorts of
people are in a tavern. The following tables can be used to jumpstart the
creative juices so that this question can be answered on the fly in a colorful
way. This is meant to be a mental springboard, and the referee should flesh out
tavern patrons to whatever degree is necessary based on the situation.

**Tavern Patrons**

| D20   | Race     | D100  | Class       | D4  | Sex    |
|-------|----------|-------|-------------|-----|--------|
| 1-2   | Dwarf    | 01    | Assassin    | 1-2 | Male   |
| 3-4   | Elf      | 02-11 | Cleric      | 3-4 | Female |
| 5     | Gnome    | 12-26 | Fighter     |     |        |
| 6     | Half-Elf | 27-28 | Illusionist |     |        |
| 7     | Half-Orc | 29-37 | Magic-User  |     |        |
| 8-10  | Halfling | 38    | Monk        |     |        |
| 11-20 | Human    | 39-81 | None1       |     |        |
|       |          | 82-85 | Paladin     |     |        |
|       |          | 86-90 | Ranger      |     |        |
|       |          | 91-00 | Thief       |     |        |

1Roll for a profession.

**Random Professions**

| D100  | Profession      | D100  | Profession       |
|-------|-----------------|-------|------------------|
| 01-03 | Animal Trainer  | 56-59 | Huntsman         |
| 04-05 | Armorer         | 60-62 | Lapidary/Jeweler |
| 06-09 | Baker           | 63-66 | Lorimer          |
| 10-12 | Blacksmith      | 67    | Mapmaker         |
| 13    | Bookbinder      | 68-69 | Mason            |
| 14-16 | Bowyer/Fletcher | 70-73 | Miner            |
| 17-20 | Brewer          | 74-76 | Potter           |
| 21-23 | Butcher         | 77-78 | Roper            |
| 24-26 | Carpenter       | 79-81 | Seafarer         |
| 27-28 | Chandler        | 82-84 | Shipwright       |
| 29-33 | Cooper          | 85-87 | Spy              |
| 34-35 | Coppersmith     | 88-90 | Tailor           |
| 36-46 | Farmer          | 91-93 | Tanner           |
| 47-50 | Fisher          | 94-96 | Thatcher/Roofer  |
| 51-54 | Furrier         | 97-98 | Woodcutter       |
| 55    | Glassblower     | 99-00 | Vintner          |

The following table may be rolled or chosen from more than once for an
individual, and should be used as inspiration when describing or role-playing an
NPC’s personality and/or motives.

**Random Tavern Patron Traits**

| D100 | Trait         | D100 | Trait         |
|------|---------------|------|---------------|
| 01   | Agreeable     | 51   | Narcissistic  |
| 02   | Aloof         | 52   | Naughty       |
| 03   | Angry         | 53   | Noisy         |
| 04   | Apologetic    | 54   | Nosy          |
| 05   | Armless       | 55   | Neutral       |
| 06   | Arrogant      | 56   | Oafish        |
| 07   | Bald          | 57   | Old           |
| 08   | Beautiful     | 58   | Optimistic    |
| 09   | Boisterous    | 59   | Ornery        |
| 10   | Brawny        | 60   | Pathetic      |
| 11   | Callous       | 61   | Pessimistic   |
| 12   | Chaotic       | 62   | Picky         |
| 13   | Childish      | 63   | Pious         |
| 14   | Cold          | 64   | Polite        |
| 15   | Cranky        | 65   | Porcine       |
| 16   | Crazy         | 66   | Predatory     |
| 17   | Crippled      | 67   | Pretty        |
| 18   | Dark          | 68   | Private       |
| 19   | Dastardly     | 69   | Proud         |
| 20   | Despicable    | 70   | Quarrelsome   |
| 21   | Dour          | 71   | Quiet         |
| 22   | Drunken       | 72   | Quick         |
| 23   | Elegant       | 73   | Quirky        |
| 24   | Evil          | 74   | Ragged        |
| 25   | False         | 75   | Regal         |
| 26   | Flattering    | 76   | Rich          |
| 27   | Flatulent     | 77   | Righteous     |
| 28   | Friendly      | 78   | Riotous       |
| 29   | Frightened    | 79   | Ruthless      |
| 30   | Good          | 80   | Secretive     |
| 31   | Gross         | 81   | Sick          |
| 32   | Hairless      | 82   | Silent        |
| 33   | Hairy         | 83   | Simple        |
| 34   | Haggard       | 84   | Stern         |
| 35   | Haughty       | 85   | Stupid        |
| 36   | Helpless      | 86   | Surly         |
| 37   | Injured       | 87   | Timid         |
| 38   | Jesting       | 88   | Tired         |
| 39   | Joyous        | 89   | Treacherous   |
| 40   | Knowledgeable | 90   | Trustworthy   |
| 41   | Large         | 91   | Twisted       |
| 42   | Laughing      | 92   | Untrustworthy |
| 43   | Lecherous     | 93   | Unwell        |
| 44   | Legless       | 94   | Uppity        |
| 45   | Little        | 95   | Ugly          |
| 46   | Loud          | 96   | Vain          |
| 47   | Middle-aged   | 97   | Venerable     |
| 48   | Miserly       | 98   | Wasted        |
| 49   | Mousey        | 99   | Weak          |
| 50   | Murderer      | 00   | Willful       |

Random Prophecies 
------------------

Fill in the blanks in the prophecy with a word from the appropriate column of
the word table below.

| D12 | Prophecy                                                                                                                                   |           |             |            |           |            |
|-----|--------------------------------------------------------------------------------------------------------------------------------------------|-----------|-------------|------------|-----------|------------|
| 1   | Upon the day of (Event) & (Event), the (Adj.) shall bring forth a rise of the (Person).                                                    |           |             |            |           |            |
| 2   | When the (Person) comes, the world will (Action), the (Adj.) (Person) shall cause the fall of (Location).                                  |           |             |            |           |            |
| 3   | The day (Location) is celebrated, the (Adj.) shall mark the destruction of (Thing) and (Person).                                           |           |             |            |           |            |
| 4   | It shall be on the day that the (Adj.) (Person), a (Event) shall bring forth a time of (Action or Person).                                 |           |             |            |           |            |
| 5   | On the day that (Thing) becomes (Thing), a (Adj.) (Event) shall usher forth a rise in (Event or Thing) and a decrease in (Event or Thing). |           |             |            |           |            |
| 6   | When the (Location) (Action) the (Thing), a (Event) shall bring an age of (Person).                                                        |           |             |            |           |            |
| 7   | Once (Event) turns to (Event), a (Adj.) (Person) shall mark a rise of a (Adj.) (Thing).                                                    |           |             |            |           |            |
| 8   | At the end of (Event), the (Location) will (Action) until saved by (Person).                                                               |           |             |            |           |            |
| 9   | The (Thing) will devour the (Location) when the (Event) (Action).                                                                          |           |             |            |           |            |
| 10  | The day (Persons) clash, a (Thing) shall mark the rise of (Location or Person).                                                            |           |             |            |           |            |
| 11  | Once (Thing) rains from the sky, a (Adj.) woman shall bring forth an age of (Thing) vis (Event).                                           |           |             |            |           |            |
| 12  | The (Adj.) (Location) will succumb to the (Event) on the last day of the (Adj.) (Thing).                                                   |           |             |            |           |            |
| D20 | Event                                                                                                                                      | Adjective | Person      | Location   | Thing     | Action     |
| 1   | Death                                                                                                                                      | Poor      | King        | Plains     | Time      | Run        |
| 2   | War                                                                                                                                        | Rich      | Queen       | Mountain   | Sword     | Swim       |
| 3   | Famine                                                                                                                                     | Wise      | Prince      | Lake       | Fire      | Fly        |
| 4   | Pestilence                                                                                                                                 | Feeble    | Princess    | River      | Shield    | Die        |
| 5   | Eruption                                                                                                                                   | Strong    | Child       | Island     | Crown     | Live       |
| 6   | Flood                                                                                                                                      | Lost      | Warrior     | Keep       | Throne    | Cry        |
| 7   | Marriage                                                                                                                                   | Unborn    | Wizard      | Swamp      | Eagle     | Sink       |
| 8   | Coronation                                                                                                                                 | Immortal  | Thief       | Castle     | Dragon    | Rise       |
| 9   | Birth                                                                                                                                      | Holy      | Jester      | Wasteland  | Vampire   | Drown      |
| 10  | Funeral                                                                                                                                    | Black     | Bard        | Underwater | Truth     | Win        |
| 11  | Winter                                                                                                                                     | Red       | Priest      | Space      | Dog       | Lose       |
| 12  | Spring                                                                                                                                     | Green     | Zealot      | Sun        | Faith     | Forfeit    |
| 13  | Summer                                                                                                                                     | Blue      | Assassin    | Moon       | Cat       | Grow       |
| 14  | Autumn                                                                                                                                     | Yellow    | Squire      | Village    | Myth      | Shrink     |
| 15  | Equinox                                                                                                                                    | Frozen    | Knight      | Shore      | Love      | Lie        |
| 16  | Victory                                                                                                                                    | Giant     | Bowman      | Graveyard  | Treasure  | Ascend     |
| 17  | Defeat                                                                                                                                     | Little    | Fool        | Catacombs  | Hate      | Crush      |
| 18  | Invasion                                                                                                                                   | Invisible | Philosopher | Kingdom    | Anarchy   | Defend     |
| 19  | Catastrophe                                                                                                                                | Unholy    | Liar        | Sky        | Lightning | Obliterate |
| 20  | Armageddon                                                                                                                                 | Heroic    | Hero        | Road       | Ice       | Resurrect  |

<br><br><br><br>Legal Information
=================================

Open Game License
-----------------

OPEN GAME LICENSE Version 1.0a

The following text is the property of Wizards of the Coast, Inc. and is
Copyright 2000 Wizards of the Coast, Inc ("Wizards"). All Rights Reserved.

1. Definitions: (a)"Contributors" means the copyright and/or trademark owners
who have contributed Open Game Content; (b)"Derivative Material" means
copyrighted material including derivative works and translations (including into
other computer languages), potation, modification, correction, addition,
extension, upgrade, improvement, compilation, abridgment or other form in which
an existing work may be recast, transformed or adapted; (c) "Distribute" means
to reproduce, license, rent, lease, sell, broadcast, publicly display, transmit
or otherwise distribute; (d)"Open Game Content" means the game mechanic and
includes the methods, procedures, processes and routines to the extent such
content does not embody the Product Identity and is an enhancement over the
prior art and any additional content clearly identified as Open Game Content by
the Contributor, and means any work covered by this License, including
translations and derivative works under copyright law, but specifically excludes
Product Identity. (e) "Product Identity" means product and product line names,
logos and identifying marks including trade dress; artifacts; creatures
characters; stories, storylines, plots, thematic elements, dialogue, incidents,
language, artwork, symbols, designs, depictions, likenesses, formats, poses,
concepts, themes and graphic, photographic and other visual or audio
representations; names and descriptions of characters, spells, enchantments,
personalities, teams, personas, likenesses and special abilities; places,
locations, environments, creatures, equipment, magical or supernatural abilities
or effects, logos, symbols, or graphic designs; and any other trademark or
registered trademark clearly identified as Product identity by the owner of the
Product Identity, and which specifically excludes the Open Game Content; (f)
"Trademark" means the logos, names, mark, sign, motto, designs that are used by
a Contributor to identify itself or its products or the associated products
contributed to the Open Game License by the Contributor (g) "Use", "Used" or
"Using" means to use, Distribute, copy, edit, format, modify, translate and
otherwise create Derivative Material of Open Game Content. (h) "You" or "Your"
means the licensee in terms of this agreement.

2. The License: This License applies to any Open Game Content that contains a
notice indicating that the Open Game Content may only be Used under and in terms
of this License. You must affix such a notice to any Open Game Content that you
Use. No terms may be added to or subtracted from this License except as
described by the License itself. No other terms or conditions may be applied to
any Open Game Content distributed using this License.

3.Offer and Acceptance: By Using the Open Game Content You indicate Your
acceptance of the terms of this License.

4. Grant and Consideration: In consideration for agreeing to use this License,
the Contributors grant You a perpetual, worldwide, royalty-free, non-exclusive
license with the exact terms of this License to Use, the Open Game Content.

5.Representation of Authority to Contribute: If You are contributing original
material as Open Game Content, You represent that Your Contributions are Your
original creation and/or You have sufficient rights to grant the rights conveyed
by this License.

6.Notice of License Copyright: You must update the COPYRIGHT NOTICE portion of
this License to include the exact text of the COPYRIGHT NOTICE of any Open Game
Content You are copying, modifying or distributing, and You must add the title,
the copyright date, and the copyright holder's name to the COPYRIGHT NOTICE of
any original Open Game Content you Distribute.

7. Use of Product Identity: You agree not to Use any Product Identity, including
as an indication as to compatibility, except as expressly licensed in another,
independent Agreement with the owner of each element of that Product Identity.
You agree not to indicate compatibility or co-adaptability with any Trademark or
Registered Trademark in conjunction with a work containing Open Game Content
except as expressly licensed in another, independent Agreement with the owner of
such Trademark or Registered Trademark. The use of any Product Identity in Open
Game Content does not constitute a challenge to the ownership of that Product
Identity. The owner of any Product Identity used in Open Game Content shall
retain all rights, title and interest in and to that Product Identity.

8. Identification: If you distribute Open Game Content You must clearly indicate
which portions of the work that you are distributing are Open Game Content.

9. Updating the License: Wizards or its designated Agents may publish updated
versions of this License. You may use any authorized version of this License to
copy, modify and distribute any Open Game Content originally distributed under
any version of this License.

10 Copy of this License: You MUST include a copy of this License with every copy
of the Open Game Content You Distribute.

11. Use of Contributor Credits: You may not market or advertise the Open Game
Content using the name of any Contributor unless You have written permission
from the Contributor to do so.

12 Inability to Comply: If it is impossible for You to comply with any of the
terms of this License with respect to some or all of the Open Game Content due
to statute, judicial order, or governmental regulation then You may not Use any
Open Game Material so affected.

13 Termination: This License will terminate automatically if You fail to comply
with all terms herein and fail to cure such breach within 30 days of becoming
aware of the breach. All sublicenses shall survive the termination of this
License.

14 Reformation: If any provision of this License is held to be unenforceable,
such provision shall be reformed only to the extent necessary to make it
enforceable.

15 COPYRIGHT NOTICE

Open Game License v 1.0 Copyright 2000, Wizards of the Coast, Inc.

System Reference Document Copyright 2000, Wizards of the Coast, Inc.; Authors
Jonathan Tweet, Monte Cook, Skip Williams, based on material by E. Gary Gygax
and Dave Arneson.

Delving Deeper Reference Rules v2 Volume 1: The Adventurer's Handbook Copyright
2012, Cameron Dubeers and Simon J. Bull. Delving Deeper Reference Rules v2
Volume 2: The Referee's Guide Copyright 2012, Cameron Dubeers and Simon J. Bull.
Delving Deeper Reference Rules v2 Volume 3: The Monster & Treasure Reference
Copyright 2012, Cameron Dubeers and Simon J. Bull.

Delving Deeper Reference Rules v3 Volume 1: Heroes & Magic Copyright 2014, Simon
J. Bull. Delving Deeper Reference Rules v3 Volume 2: Delving & Exploration
Copyright 2014, Simon J. Bull. Delving Deeper Reference Rules v3 Volume 3:
Monsters & Treasures Copyright 2014, Simon J. Bull.

Adventurer Conqueror King System Copyright 2011, Autarch; Authors Alexander
Macris, Tavis Allison, Greg Tito, and Ryan Browning.

ACKS Barbarian Conquerors of Kanahu Copyright 2017 Autarch; Author Omer Joel &
Alexander Macris

Delving Deeper Reference Rules Hypertext Copyright 2014, Simon J. Bull.

Basic Fantasy Role-Playing Game Copyright © 2006-2016 Chris Gonnerman.

Swords & Wizardry Core Rules, Copyright 2008, Matthew J. Finch

Swords & Wizardry Complete Rules, Copyright 2010, Matthew J. Finch

Swords & Wizardry Light Rules, Copyright 2016 Erik Stiene

Swords & Wizardry Continual Light Rules, Copyright 2016, Erik Stiene

Fiends & Falchions, Copyright 2017, David Eynon

OSRIC Chapter I copyright 2006-08 by Stuart Marshall. OSRIC Chapter II copyright
2006-08 by Stuart Marshall. OSRIC Chapter III copyright 2006-08 by Stuart
Marshall, Trent Foster, James Boney and Vincent Fruge.

Mutant Future Copyright 2008, Daniel Proctor and Ryan Denison. Authors Daniel
Proctor and Ryan Denison

First Edition Fantasy: Sourcebook \#1, Dungeon Hazards, Copyright 006, Ronin
Arts, Authors Matthew J. Finch and Philip Reed

Lamentations of the Flame Princess: Weird Fantasy Role-Playing Grindhouse
Edition, Copyright 2011, LotFP, Author James Edward Raggi IV

Survive This!! Fantasy, Copyright 2020 Bloat Games; Author Eric Bloat & Josh
Palmer

Sharp Swords & Sinister Spells Addendum, Copyright ©2017 Diogo Nogueira.

Superheroes X!, Copyright 2018, Simon Washbourne, Beyond Belief Games

Hack! No. 1: Firearms!, Copyright 2013, Rev. Dak J . Ultimak.

Zero-Level Characters for Swords & Wizardry Continual Light, by Fr. Dave
(bloodofprokopius.blogspot.com)

Crown, Copyright 2020, Mason Waaler.

Microlite74 Ultimate Edition, Copyright 2017, Randall Stukey

Microlite81 Advanced Expanded Tablet/Digest Edition © 2018 Randall S Stukey

BX Advanced Gold Edition © 2018, Randall S. Stukey

Tarnhelm’s Terrible Tome © 2013, Randall S. Stukey

White Box Compendium © 2016 James Spahn.

The Black Hack © 2016, David Black

The BoL Hack: © 2016, Beyond Belief Games; Author: Simon Washbourne.

Solo Heroes © 2014 Kevin Crawford

Dungeon Delving Undying Light © 2018, Randall S. Stukey

Dungeon Delving Brown Box Edition SRD © 2021, Randall Stukey

Tarnhelm’s Tome of Wonder © 2021, Randall Stukey

Tarnhelm’s Tome of Wonder SRD © 2021, Randall Stukey

16. DESIGNATION OF PRODUCT IDENTITY

The names "Tarnhelm’s Tome of Wonder", "Tarnhelm’s Terrible Tome", and all
proper nouns, plots, story lines, locations, characters, art, and trade dress
are designated as Product Identity.

17. DESIGNATION OF OPEN GAME CONTENT

All text and tables in this document, with the exception of all material
specifically excluded in the declaration of product identity, are designated as
Open Game Content.
